<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Sistem_config extends CI_Model {

	function get_list_pt($idpt=NULL){
		try {
			if(!empty($idpt)){
				$this->db->where('id',$idpt);
			}
			$this->db->order_by("nama", "ASC"); 
			return $this->db->get('pengadilan_tinggi');
		} catch (Exception $e) {
			
		}
	}

	function get_list_pn($idpt=NULL){
		try {
			if(!empty($idpt)){
				$this->db->where('pt_id',$idpt);
			}
			$this->db->order_by("nama", "ASC"); 
			return $this->db->get('pengadilan_negeri');
		} catch (Exception $e) {
		}
	}

	function get_info_pn(){
		try {
			$this->db->select('id, value'); 
			$this->db->where('id >=',61);
			return $this->db->get('sys_config');
		} catch (Exception $e) {
			
		}
	}

	function get_id_pt($id_pn){
		try {
			$this->db->select('pt_id');
			$this->db->where('id',$id_pn);
			return $this->db->get('pengadilan_negeri');
		} catch (Exception $e) {
			
		}
	}

	function get_pn_name($idpn){
		try {
			if(empty($idpn)){
				return FALSE;
			}
			$this->db->where('kode',$idpn);
			$this->db->order_by("nama", "ASC"); 
			$query = $this->db->get('pengadilan_negeri');
			if($query->num_rows>0){
				return $query->row()->nama;
			}else{
				return "Belum Di-Setting";
			}
		} catch (Exception $e) {
		}
	}

	function get_nama_pt($id_pn){
		try {
			$this->db->select('pengadilan_tinggi.nama');
			$this->db->from('pengadilan_tinggi');
			$this->db->join('pengadilan_negeri', 'pengadilan_negeri.pt_id=pengadilan_tinggi.id');
			$this->db->where('pengadilan_negeri.id',$id_pn);
			return $this->db->get();
		} catch (Exception $e) {
			
		}
	}
	
	function fetch_description($title,$data){
		$descrip = '<br><table style="vertical-align:top" cellspacing="0" cellpadding="1" border="1">';
		$descrip .= '<tr><th>Nama Kolom</th><th>Nilai</th></tr>';
		foreach ($data as $key => $value) {
			$descrip .= '<tr>';
			$descrip .= '<td>'.$key.'</td>';
			$descrip .= '<td>'.$value.'</td>';
			$descrip .= '</tr>';
		}
		$descrip .= '</table>';
		return $descrip;
	}

	function add_audittrail($action,$title,$descrip){
		try {
			$data = array(
				'datetime' => date("Y-m-d H:i:s"),
				'ipaddress' => $this->input->ip_address(),
				'username' => $this->session->userdata('username'),
				'tablename' => 'sys_users',
				'formname' => 'Data User',
				'action' => $action,
				'title' => $title,
				'description' => $descrip
			);
			$this->db->insert('sys_audittrail', $data);
		} catch (Exception $e) {
			
		}
	}

	function update_data($datas,$activemenu,$nonactive,$groupUser){
		try {
			foreach ($datas as $data) {
				$this->db->where('id', $data['id']);
				$this->db->set($data['col_name'],$data['value']);
				$this->db->update('sys_config'); 
			}
			$this->db->query("UPDATE sys_groups SET enable=0;");
			$this->db->query("UPDATE sys_groups SET enable=1 WHERE groupid IN (".$groupUser.");");
			$this->db->query("UPDATE sys_menus SET published=0 WHERE id IN (".$nonactive.");");
			$this->db->query("UPDATE sys_menus SET published=1 WHERE id IN (".$activemenu.");");
			$title = "EDIT SYSTEM CONFIGURATION";
			$descrip = 'DATA ALREADY THERE';
			$this->add_audittrail("UPDATE",$title,$descrip);
			return TRUE;
		} catch (Exception $e) {
			return $e;
		}
	}
}