<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Report_prapid extends CI_Model{
	
	function get_info_pn(){
		try {
			$this->db->select('*');
			$this->db->where('id >=', 61); 
			return $this->db->get('sys_config');
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}
	function getJenisPerkara($idalurperkara){
		if(empty($idalurperkara)) return '';
		try {
			$this->db->where('id',$idalurperkara);
			return $this->db->get('alur_perkara')->row()->nama;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function get_tahun($idalurperkara){
		try {
			return $this->db->query('SELECT YEAR(min(tanggal_pendaftaran)) AS years FROM perkara WHERE alur_perkara_id IN ('.$idalurperkara.');');
		} catch (Exception $e) {
			
		}
	}

	function get_rekap($idalurperkara,$tahun){
		try {
			return $this->db->query("SELECT b.id,b.name_id 
					,(SELECT COUNT(p.perkara_id)
					FROM `v_perkara` AS p WHERE p.alur_perkara_id IN (".$idalurperkara.") 
					AND LEFT(p.tanggal_pendaftaran,7) < CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2)) 
					AND (p.tanggal_putusan IS NULL OR LEFT(p.tanggal_putusan,7) >= CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2))) 
					AND CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2)) <= CONCAT(YEAR(CURRENT_DATE),'-', RIGHT(CONCAT('0',CAST(MONTH(CURRENT_DATE) AS CHAR(2))),2))
					) AS BelumPutusBulanLalu
					,(SELECT COUNT(p.perkara_id)
					FROM `v_perkara` AS p WHERE p.alur_perkara_id IN (".$idalurperkara.") 
					AND LEFT(p.tanggal_pendaftaran,7) < CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2)) 
					AND (LEFT(p.tanggal_putusan,7) < CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2))) 
					AND (p.tanggal_minutasi IS NULL OR LEFT(p.tanggal_minutasi,7) >= CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2))) 
					AND CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2)) <= CONCAT(YEAR(CURRENT_DATE),'-', RIGHT(CONCAT('0',CAST(MONTH(CURRENT_DATE) AS CHAR(2))),2))
					) AS BelumMinutasiBulanLalu
					,(SELECT COUNT(p.perkara_id)
					FROM `v_perkara` AS p WHERE p.alur_perkara_id IN (".$idalurperkara.") 
					AND LEFT(p.tanggal_pendaftaran,7) = CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2)) 
					AND CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2)) <= CONCAT(YEAR(CURRENT_DATE),'-', RIGHT(CONCAT('0',CAST(MONTH(CURRENT_DATE) AS CHAR(2))),2))
					) AS MasukBulanIni
					,(SELECT COUNT(p.perkara_id)
					FROM `v_perkara` AS p WHERE p.alur_perkara_id IN (".$idalurperkara.") 
					AND LEFT(p.tanggal_pendaftaran,7) <= CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2)) 
					AND (LEFT(p.tanggal_putusan,7) = CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2))) 
					AND CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2)) <= CONCAT(YEAR(CURRENT_DATE),'-', RIGHT(CONCAT('0',CAST(MONTH(CURRENT_DATE) AS CHAR(2))),2))
					) AS PutusBulanIni
					,(SELECT COUNT(p.perkara_id)
						FROM `v_perkara` AS p WHERE p.alur_perkara_id IN (".$idalurperkara.") 
						AND LEFT(p.tanggal_pendaftaran,7) <= CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2)) 
						AND (p.penetapan_majelis_hakim IS NULL OR LEFT(p.penetapan_majelis_hakim,7) > CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2))) 
						AND CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2)) <= CONCAT(YEAR(CURRENT_DATE),'-', RIGHT(CONCAT('0',CAST(MONTH(CURRENT_DATE) AS CHAR(2))),2))
					) AS BelumPenetapan
					,(SELECT COUNT(p.perkara_id)
					FROM `v_perkara` AS p WHERE p.alur_perkara_id IN (".$idalurperkara.") 
					AND LEFT(p.tanggal_pendaftaran,7) <= CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2)) 
					AND (LEFT(p.tanggal_putusan,7) <= CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2))) 
					AND (LEFT(p.tanggal_minutasi,7) = CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2))) 
					AND CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2)) <= CONCAT(YEAR(CURRENT_DATE),'-', RIGHT(CONCAT('0',CAST(MONTH(CURRENT_DATE) AS CHAR(2))),2))
					) AS MinutasiBulanIni

					,(SELECT COUNT(ph.`id`)
					FROM perkara_pihak2 AS ph
					LEFT OUTER JOIN perkara_putusan_terdakwa AS pt ON ph.id = pt.pihak2_id 
					LEFT OUTER JOIN v_perkara AS pe ON ph.perkara_id = pe.perkara_id
					WHERE pe.alur_perkara_id IN (".$idalurperkara.") 
					AND CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2)) <= CONCAT(YEAR(CURRENT_DATE),'-', RIGHT(CONCAT('0',CAST(MONTH(CURRENT_DATE) AS CHAR(2))),2))
					AND 
					((LEFT(pe.tanggal_pendaftaran,7) < CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2)) 
						AND ((pe.tanggal_putusan IS NULL OR LEFT(pe.tanggal_putusan,7)>= CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2))) 
					    	OR 
					    	(pe.tanggal_putusan IS NOT NULL AND LEFT(pe.tanggal_putusan,7)< CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2)) 
					    	AND (pe.tanggal_minutasi IS NULL OR LEFT(pe.tanggal_minutasi,7)>= CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2))) 
					   		))) 
						OR(LEFT(pe.tanggal_pendaftaran,7) = CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2))))
					) AS JumlahTerdakwa
					,(SELECT COUNT(ph.`id`)
					FROM perkara_pihak2 AS ph
					LEFT OUTER JOIN perkara_putusan_terdakwa AS pt ON ph.id = pt.pihak2_id 
					LEFT OUTER JOIN v_perkara AS pe ON ph.perkara_id = pe.perkara_id
					WHERE pe.alur_perkara_id IN (".$idalurperkara.") 
					AND CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2)) <= CONCAT(YEAR(CURRENT_DATE),'-', RIGHT(CONCAT('0',CAST(MONTH(CURRENT_DATE) AS CHAR(2))),2))
					AND pt.status_putusan_id>=11 AND pt.status_putusan_id<=17
					AND 
					(( LEFT(pe.tanggal_pendaftaran,7) < CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2)) 
						AND ((pe.tanggal_putusan IS NULL OR LEFT(pe.tanggal_putusan,7)>= CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2))) 
					    	OR 
					    	(pe.tanggal_putusan IS NOT NULL AND LEFT(pe.tanggal_putusan,7)< CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2)) 
					    	AND (pe.tanggal_minutasi IS NULL OR LEFT(pe.tanggal_minutasi,7)>= CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2))) 
					   		))) 
						OR(LEFT(pe.tanggal_pendaftaran,7) = CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2))))
					) AS JumlahTerpidana
					FROM `sys_month_name` AS b
					ORDER BY b.id");
		} catch (Exception $e) {
			
		}
	}

	function get_stat_perkara($period,$idalurperkara){
		try {
			return $this->db->query("
				SELECT alur_perkara_id,alur_perkara_nama,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NULL OR LEFT(tanggal_putusan,7)>='".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' THEN 1
						ELSE 0
						END
					) AS sisa,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)<'".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') THEN 1
						ELSE 0
						END
					) AS putus_blm_minut,
				SUM(
					CASE 
						WHEN (keputusan_mediasi IS NOT NULL AND LEFT(keputusan_mediasi,7)<'".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') AND hasil_mediasi='Y' THEN 1
						ELSE 0
						END
					) AS med_blm_minut,
				SUM(
					CASE 
						WHEN LEFT(tanggal_pendaftaran,7) = '".$period."' THEN 1
						ELSE 0
						END
					) AS masuk,
				SUM(
					CASE 
						WHEN (penetapan_majelis_hakim IS NULL OR LEFT(penetapan_majelis_hakim,7)>'".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS blm_majelis,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS putus,
				SUM(
					CASE 
						WHEN (tanggal_minutasi IS NOT NULL AND LEFT(tanggal_minutasi,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS minut,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)<='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>'".$period."') THEN 1
						WHEN (LEFT(mediasi_berhasil,7)<='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') THEN 1
						ELSE 0
						END
					) AS blm_minut,
				(SELECT COUNT(ph.`id`)
					FROM perkara_pihak2 AS ph
					LEFT OUTER JOIN perkara_putusan_terdakwa AS pt ON ph.id = pt.pihak2_id 
					LEFT OUTER JOIN v_perkara AS pe ON ph.perkara_id = pe.perkara_id
					WHERE pe.alur_perkara_id=".$idalurperkara." AND 
					(( LEFT(pe.tanggal_pendaftaran,7) < '".$period."' 
						AND ((pe.tanggal_putusan IS NULL OR LEFT(pe.tanggal_putusan,7)>='".$period."') 
						OR 
						(pe.tanggal_putusan IS NOT NULL AND LEFT(pe.tanggal_putusan,7)<'".$period."' 
						AND (pe.tanggal_minutasi IS NULL OR LEFT(pe.tanggal_minutasi,7)>='".$period."') 
							))) 
						OR(LEFT(pe.tanggal_pendaftaran,7) = '".$period."'))

					) AS terdakwa,
				(SELECT COUNT(ph.`id`)
					FROM perkara_pihak2 AS ph
					LEFT OUTER JOIN perkara_putusan_terdakwa AS pt ON ph.id = pt.pihak2_id 
					LEFT OUTER JOIN v_perkara AS pe ON ph.perkara_id = pe.perkara_id
					WHERE pe.alur_perkara_id=".$idalurperkara." AND pt.status_putusan_id>=11 AND pt.status_putusan_id<=17
					AND 
					(( LEFT(pe.tanggal_pendaftaran,7) < '".$period."' 
						AND ((pe.tanggal_putusan IS NULL OR LEFT(pe.tanggal_putusan,7)>='".$period."') 
						OR 
						(pe.tanggal_putusan IS NOT NULL AND LEFT(pe.tanggal_putusan,7)<'".$period."' 
						AND (pe.tanggal_minutasi IS NULL OR LEFT(pe.tanggal_minutasi,7)>='".$period."') 
							))) 
						OR(LEFT(pe.tanggal_pendaftaran,7) = '".$period."'))
								
				) AS terpidana
				FROM v_perkara
				WHERE alur_perkara_id IN (".$idalurperkara.")
				AND LEFT(tanggal_pendaftaran,7) <='".$period."';
				");
		} catch (Exception $e) {
			
		}
	}

	function get_stat_perkara_bln($period,$idalurperkara){
		try {
			if($idalurperkara==8){
				return $this->db->query("SELECT 
					p.id AS idJenisPerkara,
					j.alur_perkara_id, 
					j.jenis_perkara_id AS id,
					p.nama AS nama,
					p.nama_lengkap AS namaLengkap,
					(SELECT COUNT(*) FROM perkara WHERE LEFT(tanggal_pendaftaran,7)<='".$period."' AND jenis_perkara_id=p.id AND alur_perkara_id='".$idalurperkara."' AND tahapan_terakhir_id < '10') AS sisaLalu,
					(SELECT COUNT(*) FROM perkara WHERE LEFT(tanggal_pendaftaran,7)='".$period."' AND jenis_perkara_id=p.id AND alur_perkara_id='".$idalurperkara."') AS jumlahMasuk,
					(SELECT COUNT(*) FROM perkara WHERE LEFT(tanggal_pendaftaran,7)<='".$period."' AND jenis_perkara_id=p.id AND alur_perkara_id='".$idalurperkara."' AND tahapan_terakhir_id = '10') AS jumlahPutus
					FROM jenis_alur_perkara AS j, jenis_perkara AS p
					WHERE j.jenis_perkara_id = p.id AND j.alur_perkara_id='".$idalurperkara."'
					ORDER BY p.nama ASC");
			} else {
				echo "
					SELECT jenis_perkara_id,jenis_perkara_nama,
					SUM(
						CASE 
							WHEN (tanggal_putusan IS NULL OR LEFT(tanggal_putusan,7)>='".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' THEN 1
							ELSE 0
							END
						) AS sisa,
					SUM(
						CASE 
							WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)<'".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' AND 
									(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') THEN 1
							ELSE 0
							END
						) AS putus_blm_minut,
					SUM(
						CASE 
							WHEN (keputusan_mediasi IS NOT NULL AND LEFT(keputusan_mediasi,7)<'".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' AND 
									(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') AND hasil_mediasi='Y' THEN 1
							ELSE 0
							END
						) AS med_blm_minut,
					SUM(
						CASE 
							WHEN LEFT(tanggal_pendaftaran,7) = '".$period."' THEN 1
							ELSE 0
							END
						) AS masuk,
					SUM(
						CASE 
							WHEN (penetapan_majelis_hakim IS NULL OR LEFT(penetapan_majelis_hakim,7)>'".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
							ELSE 0
							END
						) AS blm_majelis,
					SUM(
						CASE 
							WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
							ELSE 0
							END
						) AS putus,
					SUM(
						CASE 
							WHEN (tanggal_minutasi IS NOT NULL AND LEFT(tanggal_minutasi,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
							ELSE 0
							END
						) AS minut,
					SUM(
						CASE 
							WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)<='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' AND 
									(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>'".$period."') THEN 1
							WHEN (LEFT(mediasi_berhasil,7)<='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' AND 
									(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') THEN 1
							ELSE 0
							END
						) AS blm_minut,
					SUM(
						CASE 
							WHEN (tanggal_cabut IS NOT NULL AND LEFT(tanggal_cabut,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
							ELSE 0
							END
						) AS cabut,
					SUM(
						CASE 
							WHEN (tanggal_gugur IS NOT NULL AND LEFT(tanggal_gugur,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
							ELSE 0
							END
						) AS gugur,
					SUM(
						CASE 
							WHEN LEFT(tanggal_pendaftaran,7) <= '".$period."' AND hasil_mediasi='Y' AND LEFT(mediasi_berhasil,7) = '".$period."'  THEN 1
							ELSE 0
							END
						) AS mediasi_berhasil,
						SUM(
						CASE 
							WHEN LEFT(tanggal_pendaftaran,7) <= '".$period."' AND hasil_mediasi='N' AND LEFT(mediasi_berhasil,7) = '".$period."'  THEN 1
							ELSE 0
							END
						) AS mediasi_gagal
					FROM v_perkara
					WHERE alur_perkara_id IN (".$idalurperkara.")
					AND LEFT(tanggal_pendaftaran,7) <='".$period."'
					GROUP BY jenis_perkara_id;";
				return $this->db->query("
					SELECT jenis_perkara_id,jenis_perkara_nama,
					SUM(
						CASE 
							WHEN (tanggal_putusan IS NULL OR LEFT(tanggal_putusan,7)>='".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' THEN 1
							ELSE 0
							END
						) AS sisa,
					SUM(
						CASE 
							WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)<'".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' AND 
									(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') THEN 1
							ELSE 0
							END
						) AS putus_blm_minut,
					SUM(
						CASE 
							WHEN (keputusan_mediasi IS NOT NULL AND LEFT(keputusan_mediasi,7)<'".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' AND 
									(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') AND hasil_mediasi='Y' THEN 1
							ELSE 0
							END
						) AS med_blm_minut,
					SUM(
						CASE 
							WHEN LEFT(tanggal_pendaftaran,7) = '".$period."' THEN 1
							ELSE 0
							END
						) AS masuk,
					SUM(
						CASE 
							WHEN (penetapan_majelis_hakim IS NULL OR LEFT(penetapan_majelis_hakim,7)>'".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
							ELSE 0
							END
						) AS blm_majelis,
					SUM(
						CASE 
							WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
							ELSE 0
							END
						) AS putus,
					SUM(
						CASE 
							WHEN (tanggal_minutasi IS NOT NULL AND LEFT(tanggal_minutasi,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
							ELSE 0
							END
						) AS minut,
					SUM(
						CASE 
							WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)<='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' AND 
									(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>'".$period."') THEN 1
							WHEN (LEFT(mediasi_berhasil,7)<='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' AND 
									(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') THEN 1
							ELSE 0
							END
						) AS blm_minut,
					SUM(
						CASE 
							WHEN (tanggal_cabut IS NOT NULL AND LEFT(tanggal_cabut,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
							ELSE 0
							END
						) AS cabut,
					SUM(
						CASE 
							WHEN (tanggal_gugur IS NOT NULL AND LEFT(tanggal_gugur,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
							ELSE 0
							END
						) AS gugur,
					SUM(
						CASE 
							WHEN LEFT(tanggal_pendaftaran,7) <= '".$period."' AND hasil_mediasi='Y' AND LEFT(mediasi_berhasil,7) = '".$period."'  THEN 1
							ELSE 0
							END
						) AS mediasi_berhasil,
						SUM(
						CASE 
							WHEN LEFT(tanggal_pendaftaran,7) <= '".$period."' AND hasil_mediasi='N' AND LEFT(mediasi_berhasil,7) = '".$period."'  THEN 1
							ELSE 0
							END
						) AS mediasi_gagal
					FROM v_perkara
					WHERE alur_perkara_id IN (".$idalurperkara.")
					AND LEFT(tanggal_pendaftaran,7) <='".$period."'
					GROUP BY jenis_perkara_id;");
				}
		} catch (Exception $e) {
			
		}
	}
	function get_lap_perkara($period,$idalurperkara){
		try {
			return $this->db->query("SELECT nomor_urut_register, nomor_perkara, 
				majelis_hakim_nama AS majelis_hakim,panitera_pengganti_text,
				jenis_perkara_nama AS jenis_perkara_kode,
				pihak1_text,pihak2_text,tanggal_pendaftaran,penetapan_majelis_hakim,
				sidang_pertama,tanggal_putusan,tanggal_minutasi,
				pemberitahuan_putusan AS tanggal_pemberitahuan_putusan,
				IF(status_putusan_id=30,amar_putusan,'-') AS diterima,
				IF(status_putusan_id=32,amar_putusan,'-') AS ditolak
				FROM v_perkara
				WHERE alur_perkara_id = 119
				AND LEFT(tanggal_pendaftaran,7) <= '2016-03' 
				AND (tanggal_minutasi IS NULL OR tanggal_minutasi ='' OR LEFT(tanggal_minutasi,7) >= '".$period."');");
		} catch (Exception $e) {
		}
	}
}