<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Report_pidmil_keadaan_perkara_tahunan extends CI_Model{
	
	function get_info_pn(){
		try {
			$this->db->select('*');
			$this->db->where('id >=', 61); 
			return $this->db->get('sys_config');
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}
	function getJenisPerkara($idalurperkara){
		if(empty($idalurperkara)) return '';
		try {
			$this->db->where('id',$idalurperkara);
			return $this->db->get('alur_perkara')->row()->nama;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function get_tahun($idalurperkara){
		try {
			return $this->db->query('SELECT YEAR(min(tanggal_pendaftaran)) AS years FROM perkara WHERE alur_perkara_id IN ('.$idalurperkara.');');
		} catch (Exception $e) {
			
		}
	}

	function get_rekap($idalurperkara,$tahun){
		try {
			return $this->db->query("SELECT
								'Jumlah Perkara' 		AS uraian
								,SUM(IF(LEFT(tanggal_pendaftaran,7)<CONCAT('".$tahun."','-','01') AND (tanggal_putusan IS NULL OR LEFT(tanggal_putusan,7)>=CONCAT('".$tahun."','-','01')),1,0))  AS sisa_bln_lalu_01
								,SUM(IF(LEFT(tanggal_pendaftaran,7)=CONCAT('".$tahun."','-','01'),1,0))  AS masuk_01
								,SUM(IF(LEFT(tanggal_putusan,7)=CONCAT('".$tahun."','-','01'),1,0))  AS putus_01
								,SUM(IF(LEFT(tanggal_pendaftaran,7)<CONCAT('".$tahun."','-','01') AND (tanggal_putusan IS NULL OR LEFT(tanggal_putusan,7)>=CONCAT('".$tahun."','-','01')),1,0))
								+SUM(IF(LEFT(tanggal_pendaftaran,7)=CONCAT('".$tahun."','-','01'),1,0))
								-SUM(IF(LEFT(tanggal_putusan,7)=CONCAT('".$tahun."','-','01'),1,0))  AS sisa_bln_ini_01

								,SUM(IF(LEFT(tanggal_pendaftaran,7)<CONCAT('".$tahun."','-','02') AND (tanggal_putusan IS NULL OR LEFT(tanggal_putusan,7)>=CONCAT('".$tahun."','-','02')),1,0))  AS sisa_bln_lalu_02
								,SUM(IF(LEFT(tanggal_pendaftaran,7)=CONCAT('".$tahun."','-','02'),1,0))  AS masuk_02
								,SUM(IF(LEFT(tanggal_putusan,7)=CONCAT('".$tahun."','-','02'),1,0))  AS putus_02
								,SUM(IF(LEFT(tanggal_pendaftaran,7)<CONCAT('".$tahun."','-','02') AND (tanggal_putusan IS NULL OR LEFT(tanggal_putusan,7)>=CONCAT('".$tahun."','-','02')),1,0))
								+SUM(IF(LEFT(tanggal_pendaftaran,7)=CONCAT('".$tahun."','-','02'),1,0))
								-SUM(IF(LEFT(tanggal_putusan,7)=CONCAT('".$tahun."','-','02'),1,0))  AS sisa_bln_ini_02

								,SUM(IF(LEFT(tanggal_pendaftaran,7)<CONCAT('".$tahun."','-','03') AND (tanggal_putusan IS NULL OR LEFT(tanggal_putusan,7)>=CONCAT('".$tahun."','-','03')),1,0))  AS sisa_bln_lalu_03
								,SUM(IF(LEFT(tanggal_pendaftaran,7)=CONCAT('".$tahun."','-','03'),1,0))  AS masuk_03
								,SUM(IF(LEFT(tanggal_putusan,7)=CONCAT('".$tahun."','-','03'),1,0))  AS putus_03
								,SUM(IF(LEFT(tanggal_pendaftaran,7)<CONCAT('".$tahun."','-','03') AND (tanggal_putusan IS NULL OR LEFT(tanggal_putusan,7)>=CONCAT('".$tahun."','-','03')),1,0))
								+SUM(IF(LEFT(tanggal_pendaftaran,7)=CONCAT('".$tahun."','-','03'),1,0))
								-SUM(IF(LEFT(tanggal_putusan,7)=CONCAT('".$tahun."','-','03'),1,0))  AS sisa_bln_ini_03

								,SUM(IF(LEFT(tanggal_pendaftaran,7)<CONCAT('".$tahun."','-','04') AND (tanggal_putusan IS NULL OR LEFT(tanggal_putusan,7)>=CONCAT('".$tahun."','-','04')),1,0))  AS sisa_bln_lalu_04
								,SUM(IF(LEFT(tanggal_pendaftaran,7)=CONCAT('".$tahun."','-','04'),1,0))  AS masuk_04
								,SUM(IF(LEFT(tanggal_putusan,7)=CONCAT('".$tahun."','-','04'),1,0))  AS putus_04
								,SUM(IF(LEFT(tanggal_pendaftaran,7)<CONCAT('".$tahun."','-','04') AND (tanggal_putusan IS NULL OR LEFT(tanggal_putusan,7)>=CONCAT('".$tahun."','-','04')),1,0))
								+SUM(IF(LEFT(tanggal_pendaftaran,7)=CONCAT('".$tahun."','-','04'),1,0))
								-SUM(IF(LEFT(tanggal_putusan,7)=CONCAT('".$tahun."','-','04'),1,0))  AS sisa_bln_ini_04

								,SUM(IF(LEFT(tanggal_pendaftaran,7)<CONCAT('".$tahun."','-','05') AND (tanggal_putusan IS NULL OR LEFT(tanggal_putusan,7)>=CONCAT('".$tahun."','-','05')),1,0))  AS sisa_bln_lalu_05
								,SUM(IF(LEFT(tanggal_pendaftaran,7)=CONCAT('".$tahun."','-','05'),1,0))  AS masuk_05
								,SUM(IF(LEFT(tanggal_putusan,7)=CONCAT('".$tahun."','-','05'),1,0))  AS putus_05
								,SUM(IF(LEFT(tanggal_pendaftaran,7)<CONCAT('".$tahun."','-','05') AND (tanggal_putusan IS NULL OR LEFT(tanggal_putusan,7)>=CONCAT('".$tahun."','-','05')),1,0))
								+SUM(IF(LEFT(tanggal_pendaftaran,7)=CONCAT('".$tahun."','-','05'),1,0))
								-SUM(IF(LEFT(tanggal_putusan,7)=CONCAT('".$tahun."','-','05'),1,0))  AS sisa_bln_ini_05

								,SUM(IF(LEFT(tanggal_pendaftaran,7)<CONCAT('".$tahun."','-','06') AND (tanggal_putusan IS NULL OR LEFT(tanggal_putusan,7)>=CONCAT('".$tahun."','-','06')),1,0))  AS sisa_bln_lalu_06
								,SUM(IF(LEFT(tanggal_pendaftaran,7)=CONCAT('".$tahun."','-','06'),1,0))  AS masuk_06
								,SUM(IF(LEFT(tanggal_putusan,7)=CONCAT('".$tahun."','-','06'),1,0))  AS putus_06
								,SUM(IF(LEFT(tanggal_pendaftaran,7)<CONCAT('".$tahun."','-','06') AND (tanggal_putusan IS NULL OR LEFT(tanggal_putusan,7)>=CONCAT('".$tahun."','-','06')),1,0))
								+SUM(IF(LEFT(tanggal_pendaftaran,7)=CONCAT('".$tahun."','-','06'),1,0))
								-SUM(IF(LEFT(tanggal_putusan,7)=CONCAT('".$tahun."','-','06'),1,0))  AS sisa_bln_ini_06

								,SUM(IF(LEFT(tanggal_pendaftaran,7)<CONCAT('".$tahun."','-','07') AND (tanggal_putusan IS NULL OR LEFT(tanggal_putusan,7)>=CONCAT('".$tahun."','-','07')),1,0))  AS sisa_bln_lalu_07
								,SUM(IF(LEFT(tanggal_pendaftaran,7)=CONCAT('".$tahun."','-','07'),1,0))  AS masuk_07
								,SUM(IF(LEFT(tanggal_putusan,7)=CONCAT('".$tahun."','-','07'),1,0))  AS putus_07
								,SUM(IF(LEFT(tanggal_pendaftaran,7)<CONCAT('".$tahun."','-','07') AND (tanggal_putusan IS NULL OR LEFT(tanggal_putusan,7)>=CONCAT('".$tahun."','-','07')),1,0))
								+SUM(IF(LEFT(tanggal_pendaftaran,7)=CONCAT('".$tahun."','-','07'),1,0))
								-SUM(IF(LEFT(tanggal_putusan,7)=CONCAT('".$tahun."','-','07'),1,0))  AS sisa_bln_ini_07

								,SUM(IF(LEFT(tanggal_pendaftaran,7)<CONCAT('".$tahun."','-','08') AND (tanggal_putusan IS NULL OR LEFT(tanggal_putusan,7)>=CONCAT('".$tahun."','-','08')),1,0))  AS sisa_bln_lalu_08
								,SUM(IF(LEFT(tanggal_pendaftaran,7)=CONCAT('".$tahun."','-','08'),1,0))  AS masuk_08
								,SUM(IF(LEFT(tanggal_putusan,7)=CONCAT('".$tahun."','-','08'),1,0))  AS putus_08
								,SUM(IF(LEFT(tanggal_pendaftaran,7)<CONCAT('".$tahun."','-','08') AND (tanggal_putusan IS NULL OR LEFT(tanggal_putusan,7)>=CONCAT('".$tahun."','-','08')),1,0))
								+SUM(IF(LEFT(tanggal_pendaftaran,7)=CONCAT('".$tahun."','-','08'),1,0))
								-SUM(IF(LEFT(tanggal_putusan,7)=CONCAT('".$tahun."','-','08'),1,0))  AS sisa_bln_ini_08

								,SUM(IF(LEFT(tanggal_pendaftaran,7)<CONCAT('".$tahun."','-','09') AND (tanggal_putusan IS NULL OR LEFT(tanggal_putusan,7)>=CONCAT('".$tahun."','-','09')),1,0))  AS sisa_bln_lalu_09
								,SUM(IF(LEFT(tanggal_pendaftaran,7)=CONCAT('".$tahun."','-','09'),1,0))  AS masuk_09
								,SUM(IF(LEFT(tanggal_putusan,7)=CONCAT('".$tahun."','-','09'),1,0))  AS putus_09
								,SUM(IF(LEFT(tanggal_pendaftaran,7)<CONCAT('".$tahun."','-','09') AND (tanggal_putusan IS NULL OR LEFT(tanggal_putusan,7)>=CONCAT('".$tahun."','-','09')),1,0))
								+SUM(IF(LEFT(tanggal_pendaftaran,7)=CONCAT('".$tahun."','-','09'),1,0))
								-SUM(IF(LEFT(tanggal_putusan,7)=CONCAT('".$tahun."','-','09'),1,0))  AS sisa_bln_ini_09

								,SUM(IF(LEFT(tanggal_pendaftaran,7)<CONCAT('".$tahun."','-','10') AND (tanggal_putusan IS NULL OR LEFT(tanggal_putusan,7)>=CONCAT('".$tahun."','-','10')),1,0))  AS sisa_bln_lalu_10
								,SUM(IF(LEFT(tanggal_pendaftaran,7)=CONCAT('".$tahun."','-','10'),1,0))  AS masuk_10
								,SUM(IF(LEFT(tanggal_putusan,7)=CONCAT('".$tahun."','-','10'),1,0))  AS putus_10
								,SUM(IF(LEFT(tanggal_pendaftaran,7)<CONCAT('".$tahun."','-','10') AND (tanggal_putusan IS NULL OR LEFT(tanggal_putusan,7)>=CONCAT('".$tahun."','-','10')),1,0))
								+SUM(IF(LEFT(tanggal_pendaftaran,7)=CONCAT('".$tahun."','-','10'),1,0))
								-SUM(IF(LEFT(tanggal_putusan,7)=CONCAT('".$tahun."','-','10'),1,0))  AS sisa_bln_ini_10

								,SUM(IF(LEFT(tanggal_pendaftaran,7)<CONCAT('".$tahun."','-','11') AND (tanggal_putusan IS NULL OR LEFT(tanggal_putusan,7)>=CONCAT('".$tahun."','-','11')),1,0))  AS sisa_bln_lalu_11
								,SUM(IF(LEFT(tanggal_pendaftaran,7)=CONCAT('".$tahun."','-','11'),1,0))  AS masuk_11
								,SUM(IF(LEFT(tanggal_putusan,7)=CONCAT('".$tahun."','-','11'),1,0))  AS putus_11
								,SUM(IF(LEFT(tanggal_pendaftaran,7)<CONCAT('".$tahun."','-','11') AND (tanggal_putusan IS NULL OR LEFT(tanggal_putusan,7)>=CONCAT('".$tahun."','-','11')),1,0))
								+SUM(IF(LEFT(tanggal_pendaftaran,7)=CONCAT('".$tahun."','-','11'),1,0))
								-SUM(IF(LEFT(tanggal_putusan,7)=CONCAT('".$tahun."','-','11'),1,0))  AS sisa_bln_ini_11

								,SUM(IF(LEFT(tanggal_pendaftaran,7)<CONCAT('".$tahun."','-','12') AND (tanggal_putusan IS NULL OR LEFT(tanggal_putusan,7)>=CONCAT('".$tahun."','-','12')),1,0))  AS sisa_bln_lalu_12
								,SUM(IF(LEFT(tanggal_pendaftaran,7)=CONCAT('".$tahun."','-','12'),1,0))  AS masuk_12
								,SUM(IF(LEFT(tanggal_putusan,7)=CONCAT('".$tahun."','-','12'),1,0))  AS putus_12
								,SUM(IF(LEFT(tanggal_pendaftaran,7)<CONCAT('".$tahun."','-','12') AND (tanggal_putusan IS NULL OR LEFT(tanggal_putusan,7)>=CONCAT('".$tahun."','-','12')),1,0))
								+SUM(IF(LEFT(tanggal_pendaftaran,7)=CONCAT('".$tahun."','-','12'),1,0))
								-SUM(IF(LEFT(tanggal_putusan,7)=CONCAT('".$tahun."','-','12'),1,0))  AS sisa_bln_ini_12
									
							FROM v_perkara AS p
							WHERE alur_perkara_id=".$idalurperkara);
		} catch (Exception $e) {
			
		}
	}

	function get_stat_perkara($period,$idalurperkara){
		try {
			return $this->db->query("
				SELECT alur_perkara_id,alur_perkara_nama,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NULL OR LEFT(tanggal_putusan,7)>='".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' THEN 1
						ELSE 0
						END
					) AS sisa,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)<'".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') THEN 1
						ELSE 0
						END
					) AS putus_blm_minut,
				SUM(
					CASE 
						WHEN (keputusan_mediasi IS NOT NULL AND LEFT(keputusan_mediasi,7)<'".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') AND hasil_mediasi='Y' THEN 1
						ELSE 0
						END
					) AS med_blm_minut,
				SUM(
					CASE 
						WHEN LEFT(tanggal_pendaftaran,7) = '".$period."' THEN 1
						ELSE 0
						END
					) AS masuk,
				SUM(
					CASE 
						WHEN (penetapan_majelis_hakim IS NULL OR LEFT(penetapan_majelis_hakim,7)>'".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS blm_majelis,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS putus,
				SUM(
					CASE 
						WHEN (tanggal_minutasi IS NOT NULL AND LEFT(tanggal_minutasi,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS minut,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)<='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>'".$period."') THEN 1
						WHEN (LEFT(mediasi_berhasil,7)<='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') THEN 1
						ELSE 0
						END
					) AS blm_minut,
				SUM(
					CASE 
						WHEN (tanggal_cabut IS NOT NULL AND LEFT(tanggal_cabut,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS cabut,
				SUM(
					CASE 
						WHEN (tanggal_gugur IS NOT NULL AND LEFT(tanggal_gugur,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS gugur,
				SUM(
					CASE 
						WHEN LEFT(tanggal_pendaftaran,7) <= '".$period."' AND hasil_mediasi='Y' AND status_mediator='H' AND LEFT(mediasi_berhasil,7) = '".$period."'  THEN 1
						ELSE 0
						END
					) AS mediator_hakim_berhasil,
					SUM(
					CASE 
						WHEN LEFT(tanggal_pendaftaran,7) <= '".$period."' AND hasil_mediasi='N' AND status_mediator='H' AND LEFT(mediasi_berhasil,7) = '".$period."'  THEN 1
						ELSE 0
						END
					) AS mediator_hakim_gagal
				FROM v_perkara
				WHERE alur_perkara_id IN (".$idalurperkara.")
				AND LEFT(tanggal_pendaftaran,7) <='".$period."';
				");
		} catch (Exception $e) {
			
		}
	}

	function get_stat_perkara_bln($period,$idalurperkara){
		try {
			return $this->db->query("
				SELECT jenis_perkara_id,jenis_perkara_nama,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NULL OR LEFT(tanggal_putusan,7)>='".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' THEN 1
						ELSE 0
						END
					) AS sisa,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)<'".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') THEN 1
						ELSE 0
						END
					) AS putus_blm_minut,
				SUM(
					CASE 
						WHEN (keputusan_mediasi IS NOT NULL AND LEFT(keputusan_mediasi,7)<'".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') AND hasil_mediasi='Y' THEN 1
						ELSE 0
						END
					) AS med_blm_minut,
				SUM(
					CASE 
						WHEN LEFT(tanggal_pendaftaran,7) = '".$period."' THEN 1
						ELSE 0
						END
					) AS masuk,
				SUM(
					CASE 
						WHEN (penetapan_majelis_hakim IS NULL OR LEFT(penetapan_majelis_hakim,7)>'".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS blm_majelis,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS putus,
				SUM(
					CASE 
						WHEN (tanggal_minutasi IS NOT NULL AND LEFT(tanggal_minutasi,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS minut,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)<='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>'".$period."') THEN 1
						WHEN (LEFT(mediasi_berhasil,7)<='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') THEN 1
						ELSE 0
						END
					) AS blm_minut,
				SUM(
					CASE 
						WHEN (tanggal_cabut IS NOT NULL AND LEFT(tanggal_cabut,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS cabut,
				SUM(
					CASE 
						WHEN (tanggal_gugur IS NOT NULL AND LEFT(tanggal_gugur,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS gugur,
				SUM(
					CASE 
						WHEN LEFT(tanggal_pendaftaran,7) <= '".$period."' AND hasil_mediasi='Y' AND LEFT(mediasi_berhasil,7) = '".$period."'  THEN 1
						ELSE 0
						END
					) AS mediasi_berhasil,
					SUM(
					CASE 
						WHEN LEFT(tanggal_pendaftaran,7) <= '".$period."' AND hasil_mediasi='N' AND LEFT(mediasi_berhasil,7) = '".$period."'  THEN 1
						ELSE 0
						END
					) AS mediasi_gagal
				FROM v_perkara
				WHERE alur_perkara_id IN (".$idalurperkara.")
				AND LEFT(tanggal_pendaftaran,7) <='".$period."'
				GROUP BY jenis_perkara_id;");
		} catch (Exception $e) {
			
		}
	}
	function get_lap_perkara($period,$idalurperkara){
		try {
			return $this->db->query("SELECT
									'Jumlah Perkara' 		AS uraian
									,SUM(IF((LEFT(tanggal_pendaftaran,7)<='".$period."' AND tanggal_putusan IS NULL OR LEFT(tanggal_putusan,7)>='".$period."') AND pm.matra=1,1,0))  AS sisa_ad
									,SUM(IF((LEFT(tanggal_pendaftaran,7)<='".$period."' AND tanggal_putusan IS NULL OR LEFT(tanggal_putusan,7)>='".$period."') AND pm.matra=2,1,0))  AS sisa_al
									,SUM(IF((LEFT(tanggal_pendaftaran,7)<='".$period."' AND tanggal_putusan IS NULL OR LEFT(tanggal_putusan,7)>='".$period."') AND pm.matra=3,1,0))  AS sisa_au
									,SUM(IF((LEFT(tanggal_pendaftaran,7)<='".$period."' AND tanggal_putusan IS NULL OR LEFT(tanggal_putusan,7)>='".$period."') AND pm.matra=1,1,0))
									+SUM(IF((LEFT(tanggal_pendaftaran,7)<='".$period."' AND tanggal_putusan IS NULL OR LEFT(tanggal_putusan,7)>='".$period."') AND pm.matra=2,1,0))
									+SUM(IF((LEFT(tanggal_pendaftaran,7)<='".$period."' AND tanggal_putusan IS NULL OR LEFT(tanggal_putusan,7)>='".$period."') AND pm.matra=3,1,0))  AS tot_sisa

									,SUM(IF(LEFT(tanggal_pendaftaran,7)='".$period."' AND pm.matra=1,1,0))  AS masuk_ad
									,SUM(IF(LEFT(tanggal_pendaftaran,7)='".$period."' AND pm.matra=2,1,0))  AS masuk_al
									,SUM(IF(LEFT(tanggal_pendaftaran,7)='".$period."' AND pm.matra=3,1,0))  AS masuk_au
									,SUM(IF(LEFT(tanggal_pendaftaran,7)='".$period."' AND pm.matra=1,1,0))  
									+SUM(IF(LEFT(tanggal_pendaftaran,7)='".$period."' AND pm.matra=2,1,0))  
									+SUM(IF(LEFT(tanggal_pendaftaran,7)='".$period."' AND pm.matra=3,1,0))  AS tot_masuk
									
									,SUM(IF(LEFT(tanggal_putusan,7)='".$period."' AND pm.matra=1,1,0))  AS putus_ad
									,SUM(IF(LEFT(tanggal_putusan,7)='".$period."' AND pm.matra=2,1,0))  AS putus_al
									,SUM(IF(LEFT(tanggal_putusan,7)='".$period."' AND pm.matra=3,1,0))  AS putus_au
									,SUM(IF(LEFT(tanggal_putusan,7)='".$period."' AND pm.matra=1,1,0))  
									+SUM(IF(LEFT(tanggal_putusan,7)='".$period."' AND pm.matra=2,1,0))  
									+SUM(IF(LEFT(tanggal_putusan,7)='".$period."' AND pm.matra=3,1,0))  AS tot_putus
									
									,SUM(IF((LEFT(tanggal_putusan,7)='".$period."' AND status_putusan_id=59) AND pm.matra=1,1,0))  AS dikembalikan_ad
									,SUM(IF((LEFT(tanggal_putusan,7)='".$period."' AND status_putusan_id=59) AND pm.matra=2,1,0))  AS dikembalikan_al
									,SUM(IF((LEFT(tanggal_putusan,7)='".$period."' AND status_putusan_id=59) AND pm.matra=3,1,0))  AS dikembalikan_au
									,SUM(IF((LEFT(tanggal_putusan,7)='".$period."' AND status_putusan_id=59) AND pm.matra=1,1,0))  
									+SUM(IF((LEFT(tanggal_putusan,7)='".$period."' AND status_putusan_id=59) AND pm.matra=2,1,0))  
									+SUM(IF((LEFT(tanggal_putusan,7)='".$period."' AND status_putusan_id=59) AND pm.matra=3,1,0))  AS tot_dikembalikan
									
									,SUM(IF((DATEDIFF(CURDATE(),tanggal_putusan)>7 AND p.perkara_id NOT IN (SELECT perkara_id FROM perkara_banding)
									 AND p.perkara_id NOT IN (SELECT perkara_id FROM perkara_kasasi) AND p.perkara_id NOT IN (SELECT perkara_id FROM perkara_pk)
									 AND pm.matra=1),1,0)) AS bht_ad
									,SUM(IF((DATEDIFF(CURDATE(),tanggal_putusan)>7 AND p.perkara_id NOT IN (SELECT perkara_id FROM perkara_banding)
									 AND p.perkara_id NOT IN (SELECT perkara_id FROM perkara_kasasi) AND p.perkara_id NOT IN (SELECT perkara_id FROM perkara_pk)
									 AND pm.matra=2),1,0)) AS bht_al
									,SUM(IF((DATEDIFF(CURDATE(),tanggal_putusan)>7 AND p.perkara_id NOT IN (SELECT perkara_id FROM perkara_banding)
									 AND p.perkara_id NOT IN (SELECT perkara_id FROM perkara_kasasi) AND p.perkara_id NOT IN (SELECT perkara_id FROM perkara_pk)
									 AND pm.matra=3),1,0)) AS bht_au
									,SUM(IF((DATEDIFF(CURDATE(),tanggal_putusan)>7 AND p.perkara_id NOT IN (SELECT perkara_id FROM perkara_banding)
									 AND p.perkara_id NOT IN (SELECT perkara_id FROM perkara_kasasi) AND p.perkara_id NOT IN (SELECT perkara_id FROM perkara_pk)
									 AND pm.matra=1),1,0))
									+SUM(IF((DATEDIFF(CURDATE(),tanggal_putusan)>7 AND p.perkara_id NOT IN (SELECT perkara_id FROM perkara_banding)
									 AND p.perkara_id NOT IN (SELECT perkara_id FROM perkara_kasasi) AND p.perkara_id NOT IN (SELECT perkara_id FROM perkara_pk)
									 AND pm.matra=2),1,0))
									+SUM(IF((DATEDIFF(CURDATE(),tanggal_putusan)>7 AND p.perkara_id NOT IN (SELECT perkara_id FROM perkara_banding)
									 AND p.perkara_id NOT IN (SELECT perkara_id FROM perkara_kasasi) AND p.perkara_id NOT IN (SELECT perkara_id FROM perkara_pk)
									 AND pm.matra=3),1,0)) AS tot_bht
									 
									,SUM(IF((LEFT(tanggal_putusan,7)='".$period."' AND status_putusan_id=61) AND pm.matra=1,1,0))  AS no_ad
									,SUM(IF((LEFT(tanggal_putusan,7)='".$period."' AND status_putusan_id=61) AND pm.matra=2,1,0))  AS no_al
									,SUM(IF((LEFT(tanggal_putusan,7)='".$period."' AND status_putusan_id=61) AND pm.matra=3,1,0))  AS no_au
									,SUM(IF((LEFT(tanggal_putusan,7)='".$period."' AND status_putusan_id=61) AND pm.matra=1,1,0))  
									+SUM(IF((LEFT(tanggal_putusan,7)='".$period."' AND status_putusan_id=61) AND pm.matra=2,1,0))  
									+SUM(IF((LEFT(tanggal_putusan,7)='".$period."' AND status_putusan_id=61) AND pm.matra=3,1,0))  AS tot_no
									 									
								FROM v_perkara AS p
								LEFT JOIN perkara_matra AS pm ON p.perkara_id=pm.perkara_id
								where alur_perkara_id=".$idalurperkara."
				");
		} catch (Exception $e) {
			
		}
	}
}