<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Report_pid_anak extends CI_Model{
	
	function get_info_pn(){
		try {
			$this->db->select('*');
			$this->db->where('id >=', 61); 
			return $this->db->get('sys_config');
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}
	function getJenisPerkara($idalurperkara){
		if(empty($idalurperkara)) return '';
		try {
			$this->db->where('id',$idalurperkara);
			return $this->db->get('alur_perkara')->row()->nama;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function get_tahun($idalurperkara){
		try {
			return $this->db->query('SELECT YEAR(min(tanggal_pendaftaran)) AS years FROM perkara WHERE alur_perkara_id IN ('.$idalurperkara.');');
		} catch (Exception $e) {
			
		}
	}

	function get_rekap($idalurperkara,$tahun){
		try {
			return $this->db->query("SELECT b.id,b.name_id 
					,(SELECT COUNT(p.perkara_id)
					FROM `v_perkara` AS p WHERE p.alur_perkara_id IN (".$idalurperkara.") 
					AND LEFT(p.tanggal_pendaftaran,7) < CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2)) 
					AND (p.tanggal_putusan IS NULL OR LEFT(p.tanggal_putusan,7) >= CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2))) 
					AND CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2)) <= CONCAT(YEAR(CURRENT_DATE),'-', RIGHT(CONCAT('0',CAST(MONTH(CURRENT_DATE) AS CHAR(2))),2))
					) AS BelumPutusBulanLalu
					,(SELECT COUNT(p.perkara_id)
					FROM `v_perkara` AS p WHERE p.alur_perkara_id IN (".$idalurperkara.") 
					AND LEFT(p.tanggal_pendaftaran,7) < CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2)) 
					AND (LEFT(p.tanggal_putusan,7) < CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2))) 
					AND (p.tanggal_minutasi IS NULL OR LEFT(p.tanggal_minutasi,7) >= CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2))) 
					AND CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2)) <= CONCAT(YEAR(CURRENT_DATE),'-', RIGHT(CONCAT('0',CAST(MONTH(CURRENT_DATE) AS CHAR(2))),2))
					) AS BelumMinutasiBulanLalu
					,(SELECT COUNT(p.perkara_id)
					FROM `v_perkara` AS p WHERE p.alur_perkara_id IN (".$idalurperkara.") 
					AND LEFT(p.tanggal_pendaftaran,7) = CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2)) 
					AND CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2)) <= CONCAT(YEAR(CURRENT_DATE),'-', RIGHT(CONCAT('0',CAST(MONTH(CURRENT_DATE) AS CHAR(2))),2))
					) AS MasukBulanIni
					,(SELECT COUNT(p.perkara_id)
					FROM `v_perkara` AS p WHERE p.alur_perkara_id IN (".$idalurperkara.") 
					AND LEFT(p.tanggal_pendaftaran,7) <= CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2)) 
					AND (LEFT(p.tanggal_putusan,7) = CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2))) 
					AND CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2)) <= CONCAT(YEAR(CURRENT_DATE),'-', RIGHT(CONCAT('0',CAST(MONTH(CURRENT_DATE) AS CHAR(2))),2))
					) AS PutusBulanIni
					,(SELECT COUNT(p.perkara_id)
						FROM `v_perkara` AS p WHERE p.alur_perkara_id IN (".$idalurperkara.") 
						AND LEFT(p.tanggal_pendaftaran,7) <= CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2)) 
						AND (p.penetapan_majelis_hakim IS NULL OR LEFT(p.penetapan_majelis_hakim,7) > CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2))) 
						AND CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2)) <= CONCAT(YEAR(CURRENT_DATE),'-', RIGHT(CONCAT('0',CAST(MONTH(CURRENT_DATE) AS CHAR(2))),2))
					) AS BelumPenetapan
					,(SELECT COUNT(p.perkara_id)
					FROM `v_perkara` AS p WHERE p.alur_perkara_id IN (".$idalurperkara.") 
					AND LEFT(p.tanggal_pendaftaran,7) <= CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2)) 
					AND (LEFT(p.tanggal_putusan,7) <= CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2))) 
					AND (LEFT(p.tanggal_minutasi,7) = CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2))) 
					AND CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2)) <= CONCAT(YEAR(CURRENT_DATE),'-', RIGHT(CONCAT('0',CAST(MONTH(CURRENT_DATE) AS CHAR(2))),2))
					) AS MinutasiBulanIni

					,(SELECT COUNT(ph.`id`)
					FROM perkara_pihak2 AS ph
					LEFT OUTER JOIN perkara_putusan_terdakwa AS pt ON ph.id = pt.pihak2_id 
					LEFT OUTER JOIN v_perkara AS pe ON ph.perkara_id = pe.perkara_id
					WHERE pe.alur_perkara_id IN (".$idalurperkara.") 
					AND CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2)) <= CONCAT(YEAR(CURRENT_DATE),'-', RIGHT(CONCAT('0',CAST(MONTH(CURRENT_DATE) AS CHAR(2))),2))
					AND 
					((LEFT(pe.tanggal_pendaftaran,7) < CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2)) 
						AND ((pe.tanggal_putusan IS NULL OR LEFT(pe.tanggal_putusan,7)>= CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2))) 
					    	OR 
					    	(pe.tanggal_putusan IS NOT NULL AND LEFT(pe.tanggal_putusan,7)< CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2)) 
					    	AND (pe.tanggal_minutasi IS NULL OR LEFT(pe.tanggal_minutasi,7)>= CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2))) 
					   		))) 
						OR(LEFT(pe.tanggal_pendaftaran,7) = CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2))))
					) AS JumlahTerdakwa
					,(SELECT COUNT(ph.`id`)
					FROM perkara_pihak2 AS ph
					LEFT OUTER JOIN perkara_putusan_terdakwa AS pt ON ph.id = pt.pihak2_id 
					LEFT OUTER JOIN v_perkara AS pe ON ph.perkara_id = pe.perkara_id
					WHERE pe.alur_perkara_id IN (".$idalurperkara.") 
					AND CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2)) <= CONCAT(YEAR(CURRENT_DATE),'-', RIGHT(CONCAT('0',CAST(MONTH(CURRENT_DATE) AS CHAR(2))),2))
					AND pt.status_putusan_id>=11 AND pt.status_putusan_id<=17
					AND 
					(( LEFT(pe.tanggal_pendaftaran,7) < CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2)) 
						AND ((pe.tanggal_putusan IS NULL OR LEFT(pe.tanggal_putusan,7)>= CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2))) 
					    	OR 
					    	(pe.tanggal_putusan IS NOT NULL AND LEFT(pe.tanggal_putusan,7)< CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2)) 
					    	AND (pe.tanggal_minutasi IS NULL OR LEFT(pe.tanggal_minutasi,7)>= CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2))) 
					   		))) 
						OR(LEFT(pe.tanggal_pendaftaran,7) = CONCAT('".$tahun."-', RIGHT(CONCAT('0',b.id),2))))
					) AS JumlahTerpidana
					FROM `sys_month_name` AS b
					ORDER BY b.id");
		} catch (Exception $e) {
			
		}
	}

	function get_stat_perkara($period,$idalurperkara){
		try {
			return $this->db->query("
				SELECT * FROM (
				SELECT alur_perkara_id,alur_perkara_nama,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NULL OR LEFT(tanggal_putusan,7)>='".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' THEN 1
						ELSE 0
						END
					) AS sisa,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)<'".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') THEN 1
						ELSE 0
						END
					) AS putus_blm_minut,
				SUM(
					CASE 
						WHEN (keputusan_mediasi IS NOT NULL AND LEFT(keputusan_mediasi,7)<'".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') AND hasil_mediasi='Y' THEN 1
						ELSE 0
						END
					) AS med_blm_minut,
				SUM(
					CASE 
						WHEN LEFT(tanggal_pendaftaran,7) = '".$period."' THEN 1
						ELSE 0
						END
					) AS masuk,
				SUM(
					CASE 
						WHEN (penetapan_majelis_hakim IS NULL OR LEFT(penetapan_majelis_hakim,7)>'".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS blm_majelis,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS putus,
				SUM(
					CASE 
						WHEN (tanggal_minutasi IS NOT NULL AND LEFT(tanggal_minutasi,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
						ELSE 0
						END
					) AS minut,
				SUM(
					CASE 
						WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)<='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>'".$period."') THEN 1
						WHEN (LEFT(mediasi_berhasil,7)<='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' AND 
								(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') THEN 1
						ELSE 0
						END
					) AS blm_minut,
				(SELECT COUNT(ph.`id`)
					FROM perkara_pihak2 AS ph
					LEFT OUTER JOIN perkara_putusan_terdakwa AS pt ON ph.id = pt.pihak2_id 
					LEFT OUTER JOIN v_perkara AS pe ON ph.perkara_id = pe.perkara_id
					WHERE pe.alur_perkara_id=".$idalurperkara." AND 
					(( LEFT(pe.tanggal_pendaftaran,7) < '".$period."' 
						AND ((pe.tanggal_putusan IS NULL OR LEFT(pe.tanggal_putusan,7)>='".$period."') 
						OR 
						(pe.tanggal_putusan IS NOT NULL AND LEFT(pe.tanggal_putusan,7)<'".$period."' 
						AND (pe.tanggal_minutasi IS NULL OR LEFT(pe.tanggal_minutasi,7)>='".$period."') 
							))) 
						OR(LEFT(pe.tanggal_pendaftaran,7) = '".$period."'))

					) AS terdakwa,
				(SELECT COUNT(ph.`id`)
					FROM perkara_pihak2 AS ph
					LEFT OUTER JOIN perkara_putusan_terdakwa AS pt ON ph.id = pt.pihak2_id 
					LEFT OUTER JOIN v_perkara AS pe ON ph.perkara_id = pe.perkara_id
					WHERE pe.alur_perkara_id=".$idalurperkara." AND pt.status_putusan_id>=11 AND pt.status_putusan_id<=17
					AND 
					(( LEFT(pe.tanggal_pendaftaran,7) < '".$period."' 
						AND ((pe.tanggal_putusan IS NULL OR LEFT(pe.tanggal_putusan,7)>='".$period."') 
						OR 
						(pe.tanggal_putusan IS NOT NULL AND LEFT(pe.tanggal_putusan,7)<'".$period."' 
						AND (pe.tanggal_minutasi IS NULL OR LEFT(pe.tanggal_minutasi,7)>='".$period."') 
							))) 
						OR(LEFT(pe.tanggal_pendaftaran,7) = '".$period."'))
								
				) AS terpidana
				FROM v_perkara
				WHERE alur_perkara_id IN (".$idalurperkara.")
				AND LEFT(tanggal_pendaftaran,7) <='".$period."') as A,

		(SELECT COUNT(*) AS tidak_diversi FROM perkara 
		WHERE alur_perkara_id=".$idalurperkara." AND perkara_id NOT IN (SELECT perkara_id FROM perkara_diversi)
		AND (LEFT(tanggal_pendaftaran,7)<='".$period."')) AS tidak_diversi,

		(SELECT COUNT(*) AS proses_diversi FROM perkara_diversi WHERE (LEFT(tgl_musyawarah,7)<='".$period."' AND tgl_musyawarah IS NOT NULL) 
		AND (LEFT(tgl_penetapan_kesepakatan_diversi,7)>'".$period."' OR (tgl_penetapan_kesepakatan_diversi IS NULL OR tgl_penetapan_kesepakatan_diversi='0000-00-00'))) AS proses_diversi,

		(SELECT COUNT(*) AS diversi_berhasil FROM perkara_diversi WHERE LEFT(tgl_penetapan_kesepakatan_diversi,7)<='".$period."' 
		AND hasil_diversi=1 AND tgl_penetapan_kesepakatan_diversi IS NOT NULL AND tgl_penetapan_kesepakatan_diversi <> '0000-00-00') AS diversi_berhasil,

		(SELECT COUNT(*) AS diversi_gagal FROM perkara_diversi WHERE LEFT(tgl_penetapan_kesepakatan_diversi,7)<='".$period."' 
		AND hasil_diversi=0 AND tgl_penetapan_kesepakatan_diversi IS NOT NULL AND tgl_penetapan_kesepakatan_diversi <> '0000-00-00') AS diversi_gagal;

				");
		} catch (Exception $e) {
			
		}
	}

	function get_stat_perkara_bln($period,$idalurperkara){
		try {
			if($idalurperkara==8){
				return $this->db->query("SELECT 
					p.id AS idJenisPerkara,
					j.alur_perkara_id, 
					j.jenis_perkara_id AS id,
					p.nama AS nama,
					p.nama_lengkap AS namaLengkap,
					(SELECT COUNT(*) FROM perkara WHERE LEFT(tanggal_pendaftaran,7)<='".$period."' AND jenis_perkara_id=p.id AND alur_perkara_id='".$idalurperkara."' AND tahapan_terakhir_id < '10') AS sisaLalu,
					(SELECT COUNT(*) FROM perkara WHERE LEFT(tanggal_pendaftaran,7)='".$period."' AND jenis_perkara_id=p.id AND alur_perkara_id='".$idalurperkara."') AS jumlahMasuk,
					(SELECT COUNT(*) FROM perkara WHERE LEFT(tanggal_pendaftaran,7)<='".$period."' AND jenis_perkara_id=p.id AND alur_perkara_id='".$idalurperkara."' AND tahapan_terakhir_id = '10') AS jumlahPutus
					FROM jenis_alur_perkara AS j, jenis_perkara AS p
					WHERE j.jenis_perkara_id = p.id AND j.alur_perkara_id='".$idalurperkara."'
					ORDER BY p.nama ASC");
			} else {
				return $this->db->query("
					SELECT jenis_perkara_id,jenis_perkara_nama,
					SUM(
						CASE 
							WHEN (tanggal_putusan IS NULL OR LEFT(tanggal_putusan,7)>='".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' THEN 1
							ELSE 0
							END
						) AS sisa,
					SUM(
						CASE 
							WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)<'".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' AND 
									(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') THEN 1
							ELSE 0
							END
						) AS putus_blm_minut,
					SUM(
						CASE 
							WHEN (keputusan_mediasi IS NOT NULL AND LEFT(keputusan_mediasi,7)<'".$period."') AND LEFT(tanggal_pendaftaran,7) < '".$period."' AND 
									(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') AND hasil_mediasi='Y' THEN 1
							ELSE 0
							END
						) AS med_blm_minut,
					SUM(
						CASE 
							WHEN LEFT(tanggal_pendaftaran,7) = '".$period."' THEN 1
							ELSE 0
							END
						) AS masuk,
					SUM(
						CASE 
							WHEN (penetapan_majelis_hakim IS NULL OR LEFT(penetapan_majelis_hakim,7)>'".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
							ELSE 0
							END
						) AS blm_majelis,
					SUM(
						CASE 
							WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
							ELSE 0
							END
						) AS putus,
					SUM(
						CASE 
							WHEN (tanggal_minutasi IS NOT NULL AND LEFT(tanggal_minutasi,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
							ELSE 0
							END
						) AS minut,
					SUM(
						CASE 
							WHEN (tanggal_putusan IS NOT NULL AND LEFT(tanggal_putusan,7)<='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' AND 
									(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>'".$period."') THEN 1
							WHEN (LEFT(mediasi_berhasil,7)<='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' AND 
									(tanggal_minutasi IS NULL OR LEFT(tanggal_minutasi,7)>='".$period."') THEN 1
							ELSE 0
							END
						) AS blm_minut,
					SUM(
						CASE 
							WHEN (tanggal_cabut IS NOT NULL AND LEFT(tanggal_cabut,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
							ELSE 0
							END
						) AS cabut,
					SUM(
						CASE 
							WHEN (tanggal_gugur IS NOT NULL AND LEFT(tanggal_gugur,7)='".$period."') AND LEFT(tanggal_pendaftaran,7) <= '".$period."' THEN 1
							ELSE 0
							END
						) AS gugur,
					SUM(
						CASE 
							WHEN LEFT(tanggal_pendaftaran,7) <= '".$period."' AND hasil_mediasi='Y' AND LEFT(mediasi_berhasil,7) = '".$period."'  THEN 1
							ELSE 0
							END
						) AS mediasi_berhasil,
						SUM(
						CASE 
							WHEN LEFT(tanggal_pendaftaran,7) <= '".$period."' AND hasil_mediasi='N' AND LEFT(mediasi_berhasil,7) = '".$period."'  THEN 1
							ELSE 0
							END
						) AS mediasi_gagal
					FROM v_perkara
					WHERE alur_perkara_id IN (".$idalurperkara.")
					AND LEFT(tanggal_pendaftaran,7) <='".$period."'
					GROUP BY jenis_perkara_id;");
				}
		} catch (Exception $e) {
			
		}
	}
	function get_lap_perkara($period,$idalurperkara){
		try {
			return $this->db->query("SELECT 
					pe.perkara_id 
					,pe.nomor_indeks
					,pe.nomor_perkara 
					,pe.majelis_hakim_nama
					,pe.panitera_pengganti_text 
					,pe.jenis_perkara_nama 
					,SUM(IF(phk.jenis_kelamin='L',1,0)) AS tedakwa_L
					,SUM(IF(phk.jenis_kelamin='P',1,0)) AS tedakwa_P
					,pe.tanggal_pendaftaran AS pendaftaran
					,IF(LEFT(pe.penetapan_majelis_hakim,7)>'".$period."',NULL,pe.penetapan_majelis_hakim)  AS penunjukan_hakim
					,IF(LEFT(pe.sidang_pertama,7)>'".$period."',NULL,pe.sidang_pertama) AS sidang_pertama
					,IF(LEFT(pe.tanggal_putusan,7)>'".$period."',NULL,pe.tanggal_putusan)  AS tanggal_putusan
					,IF(LEFT(pe.tanggal_minutasi,7)>'".$period."',NULL,pe.tanggal_minutasi) AS tanggal_minutasi 
					,IF(LEFT(pe.pemberitahuan_putusan_pihak2,7)>='".$period."',NULL,pe.pemberitahuan_putusan_pihak2) AS pemberitahuan_putusan_pihak2 
					,IF(LEFT(pe.pemberitahuan_putusan_pihak1,7)>='".$period."',NULL,pe.pemberitahuan_putusan_pihak1) AS pemberitahuan_putusan_pihak1 

					,SUM(IF(pt.status_putusan_id>=11 AND pt.status_putusan_id<=17 AND (DATEDIFF(pe.tanggal_pendaftaran,phk.tanggal_lahir)<=17) AND phk.jenis_kelamin='L',1,0)) AS terpidana_anak_l
					,SUM(IF(pt.status_putusan_id>=11 AND pt.status_putusan_id<=17 AND (DATEDIFF(pe.tanggal_pendaftaran,phk.tanggal_lahir)<=17) AND phk.jenis_kelamin='P',1,0)) AS terpidana_anak_p

					,SUM(IF(pt.status_putusan_id=11 AND (DATEDIFF(pe.tanggal_pendaftaran,phk.tanggal_lahir)<=17) AND phk.jenis_kelamin='L',1,0)) AS terpidana_mati_anak_l
					,SUM(IF(pt.status_putusan_id=11 AND (DATEDIFF(pe.tanggal_pendaftaran,phk.tanggal_lahir)<=17) AND phk.jenis_kelamin='P',1,0)) AS terpidana_mati_anak_p

					,SUM(IF(pt.status_putusan_id=12 AND (DATEDIFF(pe.tanggal_pendaftaran,phk.tanggal_lahir)<=17) AND phk.jenis_kelamin='L',1,0)) AS terpidana_seumurhdp_anak_l
					,SUM(IF(pt.status_putusan_id=12 AND (DATEDIFF(pe.tanggal_pendaftaran,phk.tanggal_lahir)<=17) AND phk.jenis_kelamin='P',1,0)) AS terpidana_seumurhdp_anak_p

					,SUM(IF(pt.status_putusan_id=13 AND (DATEDIFF(pe.tanggal_pendaftaran,phk.tanggal_lahir)<=17) AND phk.jenis_kelamin='L',1,0)) AS terpidana_wkttt_anak_l
					,SUM(IF(pt.status_putusan_id=13 AND (DATEDIFF(pe.tanggal_pendaftaran,phk.tanggal_lahir)<=17) AND phk.jenis_kelamin='P',1,0)) AS terpidana_wkttt_anak_p

					,SUM(IF(pt.status_putusan_id=14 AND (DATEDIFF(pe.tanggal_pendaftaran,phk.tanggal_lahir)<=17) AND phk.jenis_kelamin='L',1,0)) AS terpidana_kurungan_anak_l
					,SUM(IF(pt.status_putusan_id=14 AND (DATEDIFF(pe.tanggal_pendaftaran,phk.tanggal_lahir)<=17) AND phk.jenis_kelamin='P',1,0)) AS terpidana_kurungan_anak_p

					,SUM(IF(pt.status_putusan_id=16 AND (DATEDIFF(pe.tanggal_pendaftaran,phk.tanggal_lahir)<=17) AND phk.jenis_kelamin='L',1,0)) AS terpidana_denda_anak_l
					,SUM(IF(pt.status_putusan_id=16 AND (DATEDIFF(pe.tanggal_pendaftaran,phk.tanggal_lahir)<=17) AND phk.jenis_kelamin='P',1,0)) AS terpidana_denda_anak_p
					,SUM(IF(pt.status_putusan_id=16, durasi_nominal,0)) AS denda

					,SUM(IF(pt.status_putusan_id=17 AND (DATEDIFF(pe.tanggal_pendaftaran,phk.tanggal_lahir)<=17) AND phk.jenis_kelamin='L',1,0)) AS pidana_tambahan_anak_l
					,SUM(IF(pt.status_putusan_id=17 AND (DATEDIFF(pe.tanggal_pendaftaran,phk.tanggal_lahir)<=17) AND phk.jenis_kelamin='P',1,0)) AS pidana_tambahan_anak_p

					,SUM(IF(pt.status_putusan_id=23 AND (DATEDIFF(pe.tanggal_pendaftaran,phk.tanggal_lahir)<=17) AND phk.jenis_kelamin='L',1,0)) AS subsider_penjara_anak_l
					,SUM(IF(pt.status_putusan_id=23 AND (DATEDIFF(pe.tanggal_pendaftaran,phk.tanggal_lahir)<=17) AND phk.jenis_kelamin='P',1,0)) AS subsider_penjara_anak_p

					,SUM(IF(pt.status_putusan_id=24 AND (DATEDIFF(pe.tanggal_pendaftaran,phk.tanggal_lahir)<=17) AND phk.jenis_kelamin='L',1,0)) AS subsider_kurungan_anak_l
					,SUM(IF(pt.status_putusan_id=24 AND (DATEDIFF(pe.tanggal_pendaftaran,phk.tanggal_lahir)<=17) AND phk.jenis_kelamin='P',1,0)) AS subsider_kurungan_anak_p

					,SUM(IF(pt.status_putusan_id=25 AND (DATEDIFF(pe.tanggal_pendaftaran,phk.tanggal_lahir)<=17) AND phk.jenis_kelamin='L',1,0)) AS subsider_denda_anak_l
					,SUM(IF(pt.status_putusan_id=25 AND (DATEDIFF(pe.tanggal_pendaftaran,phk.tanggal_lahir)<=17) AND phk.jenis_kelamin='P',1,0)) AS subsider_denda_anak_p
					,SUM(IF(pt.status_putusan_id=25, durasi_nominal,0)) AS subsider_denda_nominal

					,SUM(IF(pt.status_putusan_id=20 AND (DATEDIFF(pe.tanggal_pendaftaran,phk.tanggal_lahir)<=17) AND phk.jenis_kelamin='L',1,0)) AS bebas_dakwaan_anak_l
					,SUM(IF(pt.status_putusan_id=20 AND (DATEDIFF(pe.tanggal_pendaftaran,phk.tanggal_lahir)<=17) AND phk.jenis_kelamin='P',1,0)) AS bebas_dakwaan_anak_p

					,SUM(IF(pt.status_putusan_id=21 AND (DATEDIFF(pe.tanggal_pendaftaran,phk.tanggal_lahir)<=17) AND phk.jenis_kelamin='L',1,0)) AS lepas_tuntutan_anak_l
					,SUM(IF(pt.status_putusan_id=21 AND (DATEDIFF(pe.tanggal_pendaftaran,phk.tanggal_lahir)<=17) AND phk.jenis_kelamin='P',1,0)) AS lepas_tuntutan_anak_p

					,IF(LEFT(pd.tgl_musyawarah,7)>'".$period."',NULL, pd.tgl_musyawarah)  AS tgl_musyawarah
					,IF(LEFT(pd.tgl_penetapan_kesepakatan_diversi,7)>'".$period."',NULL, pd.tgl_penetapan_kesepakatan_diversi)  AS tgl_penetapan_kesepakatan_diversi
					,IF(pd.hasil_diversi='1','Berhasil',IF(pd.hasil_diversi=0,'Tidak Berhasil','Tidak Diversi')) AS hasil_diversi
					FROM 
					perkara_pihak2 AS ph
					LEFT JOIN pihak AS phk ON ph.pihak_id=phk.id
					LEFT OUTER JOIN perkara_putusan_terdakwa AS pt ON ph.id = pt.pihak2_id 
					LEFT OUTER JOIN v_perkara AS pe ON ph.perkara_id = pe.perkara_id
					LEFT OUTER JOIN perkara_diversi AS pd ON ph.perkara_id = pd.perkara_id
					 
					WHERE 
					pe.alur_perkara_id='".$idalurperkara."' AND 
					( 
						( LEFT(pe.tanggal_pendaftaran,7) < '".$period."' 
							AND ( 
					    		(pe.tanggal_putusan IS NULL OR LEFT(pe.tanggal_putusan,7)>='".$period."') 
					    		OR 
					    		(pe.tanggal_putusan IS NOT NULL AND LEFT(pe.tanggal_putusan,7)<'".$period."' 
					    			AND (pe.tanggal_minutasi IS NULL OR LEFT(pe.tanggal_minutasi,7)>='".$period."') 
					   			) 
					    	) 
						) 
						OR 
						(LEFT(pe.tanggal_pendaftaran,7) = '".$period."') 
					) 
					GROUP BY 
					pe.perkara_id 
					,pe.nomor_indeks
					,pe.nomor_perkara 
					,pe.majelis_hakim_nama
					,pe.panitera_pengganti_text 
					,pe.jenis_perkara_kode 
					,pe.tanggal_pendaftaran 
					,pe.penetapan_majelis_hakim
					,pe.sidang_pertama
					,pe.tanggal_putusan
					,pe.tanggal_minutasi
					,pe.pemberitahuan_putusan_pihak2
					,pemberitahuan_putusan_pihak1
					ORDER BY pe.nomor_indeks;
				");
		} catch (Exception $e) {
			
		}
	}
}