<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Report_gugatan_sederhana_klasifikasi_perkara extends CI_Model{
	
	function get_info_pn(){
		try {
			$this->db->select('*');
			$this->db->where('id >=', 61); 
			return $this->db->get('sys_config');
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}
	function getJenisPerkara($idalurperkara){
		if(empty($idalurperkara)) return '';
		try {
			$this->db->where('id',$idalurperkara);
			return $this->db->get('alur_perkara')->row()->nama;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function get_tahun($idalurperkara){
		try {
			return $this->db->query('SELECT YEAR(min(tanggal_pendaftaran)) AS years FROM perkara WHERE alur_perkara_id IN ('.$idalurperkara.');');
		} catch (Exception $e) {
			
		}
	}

	function get_rekap($idalurperkara,$tahun){
		try {
			return $this->db->query('SELECT tanggal_pendaftaran, 
				left(tanggal_pendaftaran,7) AS tgl,
				tahun_pendaftaran,
				bulan_pendaftaran, 
				LEFT(tanggal_putusan,7) AS putusan, 
				LEFT(penetapan_majelis_hakim,7) AS majelis,
				hasil_mediasi,LEFT(tanggal_cabut,7) AS cabut,
				LEFT(keputusan_mediasi,7) AS mediasi, 
				LEFT(tanggal_gugur,7) AS gugur,LEFT(tanggal_minutasi,7) AS minutasi
				FROM v_perkara 
				WHERE alur_perkara_id IN ('.$idalurperkara.') AND tahun_pendaftaran<='.$tahun.';');
		} catch (Exception $e) {
			
		}
	}



	function get_stat_perkara($period,$idalurperkara){
		try {
			return $this->db->query("SELECT 
					p.id AS idJenisPerkara,
					j.alur_perkara_id, 
					j.jenis_perkara_id AS id,
					p.nama AS nama,
					p.nama_lengkap AS namaLengkap,
					(SELECT COUNT(*) FROM perkara WHERE LEFT(tanggal_pendaftaran,7)<='".$period."' AND jenis_perkara_id=p.id AND alur_perkara_id='".$idalurperkara."' AND tahapan_terakhir_id < '10') AS sisaLalu,
					(SELECT COUNT(*) FROM perkara WHERE LEFT(tanggal_pendaftaran,7)='".$period."' AND jenis_perkara_id=p.id AND alur_perkara_id='".$idalurperkara."') AS jumlahMasuk,
					(SELECT COUNT(*) FROM perkara WHERE LEFT(tanggal_pendaftaran,7)<='".$period."' AND jenis_perkara_id=p.id AND alur_perkara_id='".$idalurperkara."' AND tahapan_terakhir_id = '10') AS jumlahPutus
					FROM jenis_alur_perkara AS j, jenis_perkara AS p
					WHERE j.jenis_perkara_id = p.id AND j.alur_perkara_id='".$idalurperkara."'
					GROUP BY p.id ASC");
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function get_lap_perkara($period){
		try {
			return $this->db->query("SELECT
				jenisPerkara.nama AS namaJenisPerkara,
				GROUP_CONCAT(jenisPerkara.id) AS IDJenisPerkara,
				(SELECT COUNT(*) FROM v_perkara AS perkara 
					WHERE perkara.jenis_perkara_id IN (GROUP_CONCAT(jenisPerkara.id)) 
					AND perkara.alur_perkara_id='8'
					AND LEFT(perkara.tanggal_pendaftaran,7) ='".$period."'
				) AS perkaraDiterima,
				(SELECT COUNT(*) FROM v_perkara AS perkara 
					WHERE perkara.alur_perkara_id='8'
					AND LEFT(perkara.tanggal_pendaftaran,7) ='".$period."'
				) AS totalDiterima,
				(SELECT COUNT(*) FROM v_perkara AS perkara 
					WHERE perkara.jenis_perkara_id IN (GROUP_CONCAT(jenisPerkara.id)) 
					AND perkara.alur_perkara_id='8'
					AND nilai_sengketa IS NULL
					AND LEFT(perkara.tanggal_pendaftaran,7) = '".$period."'
				) AS perkaraKerugianNULL,
				(SELECT SUM(nilai_sengketa) FROM v_perkara AS perkara 
					WHERE perkara.jenis_perkara_id IN (GROUP_CONCAT(jenisPerkara.id)) 
					AND perkara.alur_perkara_id='8'
					AND LEFT(perkara.tanggal_pendaftaran,7) = '".$period."'
				) AS jumlahNilaiSengketa,
				(SELECT SUM(nilai_ganti_kerugian) FROM perkara_putusan AS putusan 
					LEFT JOIN perkara ON perkara.perkara_id=putusan.perkara_id
					WHERE perkara.jenis_perkara_id IN (GROUP_CONCAT(jenisPerkara.id)) 
					AND perkara.alur_perkara_id='8'
					AND LEFT(perkara.tanggal_pendaftaran,7) = '".$period."'
				) AS jumlahGantiKerugian,
				(SELECT COUNT(*) FROM v_perkara AS perkara 
					WHERE perkara.jenis_perkara_id IN (GROUP_CONCAT(jenisPerkara.id)) 
					AND perkara.alur_perkara_id='8'
					AND hasil_mediasi = 'Y'
					AND LEFT(perkara.tanggal_pendaftaran,7) = '".$period."'
				) AS jumlahPerdamaian,
				(SELECT COUNT(*) FROM v_perkara AS perkara 
					WHERE perkara.jenis_perkara_id IN (GROUP_CONCAT(jenisPerkara.id)) 
					AND perkara.alur_perkara_id='8'
					AND perkara.status_putusan_id = '28'
					AND LEFT(perkara.tanggal_pendaftaran,7) = '".$period."'
				) AS jumlahDismissal,
				(SELECT COUNT(*) FROM v_perkara AS perkara 
					WHERE perkara.jenis_perkara_id IN (GROUP_CONCAT(jenisPerkara.id)) 
					AND perkara.alur_perkara_id='8'
					AND perkara.status_putusan_id = '29'
					AND LEFT(perkara.tanggal_pendaftaran,7) = '".$period."'
				) AS jumlahGugur,
				(SELECT COUNT(*) FROM v_perkara AS perkara 
					WHERE perkara.jenis_perkara_id IN (GROUP_CONCAT(jenisPerkara.id)) 
					AND perkara.alur_perkara_id='8'
					AND perkara.status_putusan_id NOT IN (28,29)
					AND LEFT(perkara.tanggal_pendaftaran,7) = '".$period."'
				) AS jumlahPutusan
				FROM v_jenis_perkara AS jenisPerkara
				WHERE jenisPerkara.alur_perkara_id='8'
				GROUP BY jenisPerkara.nama
				ORDER BY jenisPerkara.nama ASC");
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}
}