<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Report_gugatan_sederhana_hakim extends CI_Model{
	
	function get_info_pn(){
		try {
			$this->db->select('*');
			$this->db->where('id >=', 61); 
			return $this->db->get('sys_config');
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}
	function getJenisPerkara($idalurperkara){
		if(empty($idalurperkara)) return '';
		try {
			$this->db->where('id',$idalurperkara);
			return $this->db->get('alur_perkara')->row()->nama;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function get_rekap($idalurperkara,$year){
		try {
			return $this->db->query("SELECT 
				id,
				nama_gelar AS hakim_nama,
				tblperkara.*
			FROM hakim_pn AS refhkm
			LEFT JOIN (
			SELECT 
				hakim_id,
				COUNT(*) AS jumlah_perkara,
				SUM(IF(DATEDIFF(tanggal_putusan,tanggal_pendaftaran)<=7,1,0)) AS value1,
				SUM(IF(DATEDIFF(tanggal_putusan,tanggal_pendaftaran)>=8 AND DATEDIFF(tanggal_putusan,tanggal_pendaftaran)<=14,1,0)) AS value2,
				SUM(IF(DATEDIFF(tanggal_putusan,tanggal_pendaftaran)>=15 AND DATEDIFF(tanggal_putusan,tanggal_pendaftaran)<=25,1,0)) AS value3,
				SUM(IF(DATEDIFF(tanggal_putusan,tanggal_pendaftaran)>25,1,0)) AS value4
				
			FROM (
				SELECT 
					p.perkara_id,
					p.tanggal_pendaftaran,
					p.tanggal_putusan, 
					hkm.hakim_id
				FROM v_perkara AS p
				LEFT JOIN 
					(SELECT perkara_id,hakim_id 
					FROM perkara_hakim_pn 
					GROUP BY perkara_id,hakim_id
					) AS hkm
				ON p.perkara_id=hkm.perkara_id
				WHERE alur_perkara_id=8 AND LEFT(tanggal_pendaftaran,4)='".$year."'
			) AS tabel_perkara
			WHERE hakim_id IS NOT NULL
			GROUP BY hakim_id
			) AS tblperkara
			ON refhkm.id=tblperkara.hakim_id
			WHERE aktif='Y'");
		} catch (Exception $e) {
			
		}
	}
}