<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Report_eksekusi extends CI_Model{
	function get_info_pn(){
		try {
			$this->db->select('*');
			$this->db->where('id >=', 61); 
			return $this->db->get('sys_config');
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}
	function getJenisPerkara($idalurperkara){
		if(empty($idalurperkara)) return '';
		try {
			$this->db->where('id',$idalurperkara);
			return $this->db->get('alur_perkara')->row()->nama;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function get_tahun($idalurperkara){
		try {
			return $this->db->query('SELECT YEAR(min(tanggal_pendaftaran)) AS years FROM perkara WHERE alur_perkara_id IN ('.$idalurperkara.');');
		} catch (Exception $e) {
			
		}
	}

	function get_stat_perkara($period,$idalurperkara){
		try {
			return $this->db->query("
				SELECT alur_perkara_id,
					SUM(
					CASE
						WHEN permohonan_eksekusi IS NOT NULL AND LEFT(permohonan_eksekusi,7) = '".$period."' THEN 1
						ELSE 0
						END
					) AS masuk,
					SUM(
					CASE
						WHEN (pelaksanaan_sita_eksekusi IS NULL OR LEFT(pelaksanaan_sita_eksekusi,7) >= '".$period."')
							AND (penyerahan_hasil_lelang IS NULL OR LEFT(penyerahan_hasil_lelang,7) >= '".$period."')
							AND (pelaksanaan_eksekusi_rill IS NULL OR LEFT(pelaksanaan_eksekusi_rill,7) >= '".$period."')
							AND (penetapan_noneksekusi IS NULL OR LEFT(penetapan_noneksekusi,7) >= '".$period."')
						 THEN 1
						ELSE 0
						END
					) AS sisa_lalu,
					SUM(
					CASE
						WHEN (pelaksanaan_sita_eksekusi IS NOT NULL OR LEFT(pelaksanaan_sita_eksekusi,7) <= '".$period."')
							OR (pelaksanaan_eksekusi_lelang IS NOT NULL OR LEFT(pelaksanaan_eksekusi_lelang,7) <= '".$period."')
							OR (pelaksanaan_eksekusi_rill IS NOT NULL OR LEFT(pelaksanaan_eksekusi_rill,7) <= '".$period."')
						 THEN 1
						ELSE 0
						END
					) AS selesai
					FROM v_perkara_eksekusi
					WHERE alur_perkara_id IN (".$idalurperkara.")
					AND LEFT(permohonan_eksekusi,7) <= '".$period."';
				");
		} catch (Exception $e) {
			
		}
	}

	function get_lap_perkara($period,$idalurperkara){
		try {
			return $this->db->query("
				SELECT 
					perkara_id,alur_perkara_id,nomor_perkara_pn,permohonan_eksekusi,penetapan_teguran_eksekusi,
					pelaksanaan_teguran_eksekusi,penetapan_sita_eksekusi,pelaksanaan_sita_eksekusi,penetapan_perintah_eksekusi_lelang,
					penetapan_perintah_eksekusi_rill,pelaksanaan_eksekusi_lelang,
					penyerahan_hasil_lelang,pelaksanaan_eksekusi_rill,penetapan_noneksekusi
				FROM v_perkara_eksekusi
				WHERE alur_perkara_id in (".$idalurperkara.") AND
					LEFT(permohonan_eksekusi,7) <= '".$period."' 
					AND ( pelaksanaan_sita_eksekusi is null OR LEFT(pelaksanaan_sita_eksekusi,7) >= '".$period."') 
					AND ( pelaksanaan_eksekusi_rill is null OR LEFT(pelaksanaan_eksekusi_rill,7) >= '".$period."') 
					AND ( penetapan_noneksekusi is null OR LEFT(penetapan_noneksekusi,7) >= '".$period."')
				ORDER BY tanggal_pendaftaran, nomor_perkara_pn ASC");
		} catch (Exception $e) {
			
		}
	}
}