<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class data_putusan extends CI_Model{

	function getDataPutusanSela($id,$action){
		try {
			if ($action=="edit"){
				$qry="	SELECT putusansela_id, perkara_id, urutan, tanggal_putusan_sela, is_keberatan_diterima,amar_sela, amar_sela_dok, pemberitahuan_putusan_sela_pihak1, pemberitahuan_putusan_sela_pihak2, pemberitahuan_putusan_sela_pihak3,pemberitahuan_putusan_sela_pihak4
					FROM perkara_putusan_sela WHERE putusansela_id=$id;";
			}
			else{
				$qry="	SELECT putusansela_id, perkara_id, urutan, tanggal_putusan_sela, is_keberatan_diterima,amar_sela, amar_sela_dok, pemberitahuan_putusan_sela_pihak1, pemberitahuan_putusan_sela_pihak2, pemberitahuan_putusan_sela_pihak3,pemberitahuan_putusan_sela_pihak4
					FROM perkara_putusan_sela WHERE perkara_id=$id ORDER BY putusansela_id ASC;";
			}
			return $this->db->query($qry);
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function getDataUmum($idperkara){
		try {
				$qry="	SELECT tanggal_pendaftaran
						FROM perkara WHERE perkara_id=$idperkara";
				return $this->db->query($qry);
		} catch (Exception $e) {
			return FALSE;
		}
	}
	
	function getDataPutusanByUrutan($idperkara,$urutan){
		try {
				$qry="	SELECT A.putusansela_id, B.tanggal_pendaftaran, A.urutan, A.tanggal_putusan_sela, A.amar_sela, A.amar_sela_dok, A.pemberitahuan_putusan_sela_pihak1, A.pemberitahuan_putusan_sela_pihak2, A.pemberitahuan_putusan_sela_pihak3
					FROM perkara_putusan_sela A, perkara B WHERE B.perkara_id=A.perkara_id AND A.perkara_id=$idperkara AND urutan=$urutan;";
				return $this->db->query($qry);
		} catch (Exception $e) {
			return FALSE;
		}
	}
	
	function getTanggalSidangPertama($idperkara){
		try {
			$result = $this->db->query('SELECT sidang_pertama AS tgl FROM v_perkara WHERE perkara_id = '.$idperkara);
			if($result->num_rows>0){
				return $result->row()->tgl;
			}else{
				return '';
			}
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function add($data){
		try {
			$nextid=$this->get_nextid_putusansela()->row()->nextid;
			$data['putusansela_id']=$nextid;
			
			$data['urutan']=($this->get_maxurutan_putusansela($data['perkara_id'])->row()->maxurutan)+1;			
			$this->db->insert('perkara_putusan_sela',$data);
			if($data['urutan']==1){
				$this->db->simple_query("CALL perkara_proses_update(".$data['perkara_id'].", 14, 'Persidangan', 203, 'Putusan Sela', '".$data['tanggal_putusan_sela']."', '', '".$this->session->userdata('username')."', '".date('Y-m-d H:i:s')."');");
				$this->db->simple_query("CALL perkara_update_status(".$data['perkara_id'].");");	
			}			
			$title = "Tambah Data Putusan Sela <br />dengan perkara_id [id=".$data['perkara_id']."]";
			$descrip = $this->fetch_description($title,$data);
			$this->add_audittrail("INSERT",$title,$descrip,'perkara_putusan_sela');
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function update($data,$id){
		try {
			$this->db->where('putusansela_id',$id);
			$this->db->update('perkara_putusan_sela',$data);
			$title = "UPDATE Data Putusan Sela <br />dengan perkara_id [id=".$id."]";
			$descrip = $this->fetch_description($title,$data);
			$this->add_audittrail("UPDATE",$title,$descrip,'perkara_putusan_sela');
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function del_data($idputsela,$urutan,$idperkara){
		try {
			if(!is_numeric($idputsela)){
				return FALSE;
			}
			if($urutan==1){
				$this->db->query("DELETE FROM perkara_proses WHERE perkara_id=".$idperkara." AND proses_id=203;");
				$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");
			}
			$this->db->query("DELETE FROM perkara_putusan_sela WHERE putusansela_id =".$idputsela);
			$title = "DELETE Data Putusan Sela <br />dengan putusansela_id [id=".$idputsela."]";
			$this->add_audittrail("DELETE",$title,'PENGHAPUSAN','perkara_putusan_sela');
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function get_nextid_putusansela(){
		try {
			$query = $this->db->query('SELECT IFNULL(MAX(putusansela_id)+1,1) AS nextid FROM perkara_putusan_sela');
			return $query;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function get_maxurutan_putusansela($idperkara){
		try {
			$query = $this->db->query("SELECT MAX(urutan) AS maxurutan FROM perkara_putusan_sela WHERE perkara_id=".$idperkara);
			return $query;
		} catch (Exception $e) {
			return FALSE;
		}
	}
	
	function getProsesId($idperkara){
		try{
			$qry="SELECT MAX(proses_id) AS proses_id FROM perkara_proses WHERE perkara_id=$idperkara";
			$query=$this->db->query($qry);
			if($query->num_rows>0){
				return $query->row()->proses_id;
			}
			return null;
		}catch (Exception $e){
			return FALSE;
		}
	}

	function fetch_description($title,$data){
		$descrip = '<br><table style="vertical-align:top" cellspacing="0" cellpadding="1" border="1">';
		$descrip .= '<tr><th>Nama Kolom</th><th>Nilai</th></tr>';
		foreach ($data as $key => $value) {
			$descrip .= '<tr>';
			$descrip .= '<td>'.$key.'</td>';
			$descrip .= '<td>'.$value.'</td>';
			$descrip .= '</tr>';
		}
		$descrip .= '</table>';
		return $descrip;
	}

	function add_audittrail($action,$title,$descrip,$tablename){
		try {
			$data = array(
				'datetime' => date("Y-m-d H:i:s"),
				'ipaddress' => $this->input->ip_address(),
				'username' => $this->session->userdata('username'),
				'tablename' => $tablename,
				'formname' => 'Add Perkara Perdata',
				'action' => $action,
				'title' => $title,
				'description' => $descrip
			);
			$this->db->insert('sys_audittrail', $data);
		} catch (Exception $e) {
		}
	}

	function getTemplateAmar(){
		try {
			$this->db->select('id,nama');
			$this->db->where('aktif', 'Y');
			$this->db->where('sela', 1);
			$res = $this->db->get('template_amar_putusan');
			return $res->result();
		} catch (Exception $e) {
			
		}
	}

	function getContentTemplateAmar($id){
		try {
			$this->db->select('template');
			$this->db->where('id',$id);
			return $this->db->get('template_amar_putusan');
			
		} catch (Exception $e) {
			
		}
	}

	function get_jadwal_sidang_perkara($perkara_id){
		try {
			$this->db->select('convert_tanggal_indonesia(tanggal_sidang) AS tanggal_sidang');
			$this->db->where('perkara_id',$perkara_id);
			return $this->db->get('perkara_jadwal_sidang');
		} catch (Exception $e) {
			
		}
	}
	
}
/* End of file data_putusan.php */
/* Location: ./application/models/putusan/data_putusan.php */