<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class New_pidana extends CI_Model{
	
	function getJenisPerkara($idalurperkara){
		if(empty($idalurperkara)) return '';
		try {
			$this->db->where('id',$idalurperkara);
			return $this->db->get('alur_perkara')->row()->nama;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function getNomorUrutPerkara($idalurperkara,$year){
		if(empty($idalurperkara)) return '';
		if(empty($year)) return '';
		try {
			$query = $this->db->query("SELECT ifnull(max(nomor_urut_perkara),0) + 1 AS nomor FROM perkara WHERE alur_perkara_id='".$idalurperkara."' AND year(tanggal_pendaftaran)='".$year."';");
			if($query->num_rows>0){
				foreach ($query->result() as $row) {
					return $row->nomor;
				}
	    	}else{
	    		return 0;
	    	}
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function getNomorUrutRegister($idalurperkara,$date){
		if(empty($idalurperkara)) return '';
		if(empty($date)) return '';
		try {
			$query = $this->db->query("SELECT (ifnull(max(nomor_urut_register),0)) +1 AS nomor 
				FROM perkara WHERE alur_perkara_id='".$idalurperkara."' AND LEFT(tanggal_pendaftaran,7) = '".$date."';");
			if($query->num_rows>0){
				foreach ($query->result() as $row) {
					return $row->nomor;
				}
	    	}else{
	    		return 0;
	    	}
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function getKlasifikasiPerkara($idalurperkara){
		if(empty($idalurperkara)) return '';
		if($idalurperkara<0) return '';
		try {
			$query = $this->db->query("SELECT alur_perkara_id, jenis_perkara_id AS id,nama_lengkap AS nama
				FROM jenis_alur_perkara AS j, jenis_perkara AS p
				WHERE j.jenis_perkara_id = p.id AND j.alur_perkara_id = ".$idalurperkara."
				ORDER BY nama_lengkap ASC");
			return $query;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	
	
	function getFormatPerkara($idjenisperkara){
		if(empty($idjenisperkara)) return '';
		try {
			$this->db->where('id',$idjenisperkara);
			return $this->db->get('jenis_perkara')->row()->format_nomor;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function getKodePerkara($idalurperkara){
		if(empty($idalurperkara)) return '';
		try {
			$this->db->where('id',$idalurperkara);
			$this->db->select('kode');
			return $this->db->get('alur_perkara')->row()->kode;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function cekNomorUrut($date, $urutan){
		try {
			$this->db->select('perkara_id');
			$this->db->where('nomor_urut_register',$urutan);
			$this->db->where('LEFT(tanggal_pendaftaran,7)',substr($date, 0, -3));
			return $this->db->get('perkara');
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function cekNomorPerkara($no_manual){
		if(empty($no_manual)) return '';
		try {
			$this->db->select('perkara_id');
			$this->db->where('nomor_perkara',$no_manual);
			return $this->db->get('perkara');
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function getKodePN(){
		try {
			$this->db->where('id',61);
			$this->db->select('value');
			return $this->db->get('sys_config')->row()->value;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function isNomorPerkaraExist($nomorPerkara){
		try {
			$this->db->where('nomor_perkara',$nomorPerkara);
			$this->db->select('nomor_perkara');
			$query = $this->db->get('perkara');
			if($query->num_rows>0){
				return TRUE;
			}else{
				return FALSE;
			}
		} catch (Exception $e) {
			log_message('error', $e);
			return -1;
		}
	}

	function isNomorUrutRegisterExists($tglPendaftaran,$idalurperkara,$noUrutReg){
		$tmp = explode("-", $tglPendaftaran);
		if(count($tmp)==3){
			$date = $tmp[0]."-".$tmp[1];
		}else{
			return -2;
		}
		try {
			$query = $this->db->query("SELECT nomor_urut_register 
				FROM perkara 
				WHERE LEFT(tanggal_pendaftaran,7)='".$date."' 
				AND alur_perkara_id='".$idalurperkara."' AND nomor_urut_register='".$noUrutReg."';");
			if($query->num_rows>0){
				return TRUE;
			}else{
				return FALSE;
			}
		} catch (Exception $e) {
			log_message('error', $e);
			return -2;
		}
	}

	function getJenisPerkaraNama($id){
		if(empty($id)) return '';
		try {
			$this->db->where('id',$id);
			$this->db->select('kode,nama,nama_lengkap');
			return $this->db->get('jenis_perkara');
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function fetch_description($title,$data){
		$descrip = '<br><table style="vertical-align:top" cellspacing="0" cellpadding="1" border="1">';
		$descrip .= '<tr><th>Nama Kolom</th><th>Nilai</th></tr>';
		foreach ($data as $key => $value) {
			$descrip .= '<tr>';
			$descrip .= '<td>'.$key.'</td>';
			$descrip .= '<td>'.$value.'</td>';
			$descrip .= '</tr>';
		}
		$descrip .= '</table>';
		return $descrip;
	}

	function add_audittrail($action,$title,$descrip,$tablename){
		try {
			$data = array(
				'datetime' => date("Y-m-d H:i:s"),
				'ipaddress' => $this->input->ip_address(),
				'username' => $this->session->userdata('username'),
				'tablename' => $tablename,
				'formname' => 'Add Perkara Pidana',
				'action' => $action,
				'title' => $title,
				'description' => $descrip
			);
			$this->db->insert('sys_audittrail', $data);
		} catch (Exception $e) {
			
		}
	}

	function add_data($data, $matra=''){
		try {
			$perkara_id = $this->db->query("SELECT IFNULL(max(perkara_id)+1,1) as perkara_id FROM perkara;")->row()->perkara_id;
			if($perkara_id>0){
				$data['perkara_id'] = $perkara_id;
				$noPerkara = $data['nomor_perkara'];
				$this->db->insert('perkara', $data);
				if ($matra!=''){
					$mat['perkara_id']=$perkara_id;
					$mat['matra']=$matra;
					$this->db->insert('perkara_matra', $mat);
				}
				$data_proses = array(
					'perkara_id' => $perkara_id,
					'tahapan_id' => 10,
					'tahapan_nama' => 'Pendaftaran',
					'proses_id' => 10,
					'proses_nama' => 'Pendaftaran Perkara',
					'tanggal' => $data['tanggal_pendaftaran'],
					'diinput_oleh' => $this->session->userdata('username'),
					'diinput_tanggal' => date("Y-m-d h:i:s",time())
				);
				$this->db->insert('perkara_proses', $data_proses);

				$title = "Tambah Data Perkara [Nomor Perkara=<b>".$data['nomor_perkara']."</b>]<br />Tambah table <b>Perkara</b> dari halaman <b>Tambah Perkara Pidana</b> dengan Primary Key [perkara_id=".$data['perkara_id']."]";
				$descrip = $this->fetch_description($title,$data);
				$this->add_audittrail("INSERT",$title,$descrip,'perkara');

				return TRUE;
			}else{
				return FALSE;
			}
		} catch (Exception $e) {
			return FALSE;
		}
	}

}