<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class New_eksekusi_ht extends CI_Model{

	function getNomorUrutRegisterEks($date){
		if(empty($date)) return '';
		try {
			$query = $this->db->query("SELECT (ifnull(max(nomor_urut_perkara_eksekusi),0)) +1 AS nomor 
				FROM perkara_eksekusi WHERE LEFT(permohonan_eksekusi,7) = '".$date."';");
			if($query->num_rows>0){
				foreach ($query->result() as $row) {
					return $row->nomor;
				}
	    	}else{
	    		return 0;
	    	}
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function getNomorUrutRegisterEksHt($date){
		if(empty($date)) return '';
		try {
			$query = $this->db->query("SELECT (ifnull(max(nomor_urut_perkara_eksekusi),0)) +1 AS nomor 
				FROM perkara_eksekusi_ht WHERE LEFT(permohonan_eksekusi,7) = '".$date."';");
			if($query->num_rows>0){
				foreach ($query->result() as $row) {
					return $row->nomor;
				}
	    	}else{
	    		return 0;
	    	}
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}


	function getNomorPerkaraEks($date){	
		if(empty($date)) return '';
		try {
			$query = $this->db->query("SELECT IFNULL(MAX(SUBSTRING_INDEX(nomor_register_eksekusi,'/',1)),0)+1 AS nomor 
				FROM perkara_eksekusi WHERE RIGHT(SUBSTRING_INDEX(nomor_register_eksekusi,'/',3),4)= '".$date."';");
			if($query->num_rows>0){
				foreach ($query->result() as $row) {
					return $row->nomor;
				}
	    	}else{
	    		return 0;
	    	}
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}


	function getNomorPerkaraEksHt($date){		
		if(empty($date)) return '';
		try {
			
			$query = $this->db->query("SELECT IFNULL(MAX(SUBSTRING_INDEX(eksekusi_nomor_perkara,'/',1)),0)+1 AS nomor 
				FROM perkara_eksekusi_ht WHERE alur_perkara_id = 0 AND RIGHT(SUBSTRING_INDEX(eksekusi_nomor_perkara,'/',3),4)= '".$date."';");
			if($query->num_rows>0){
				foreach ($query->result() as $row) {
					return $row->nomor;
				}
	    	}else{
	    		return 0;
	    	}
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}


	function cek_nomor_urut_eks($no_urut,$tgl_permohonan_eksekusi){
		if(empty($no_urut)) return '';
		if(empty($tgl_permohonan_eksekusi)) return '';
		try {

			$query = $this->db->query("SELECT COUNT(nomor_urut_perkara_eksekusi) AS a FROM perkara_eksekusi WHERE nomor_urut_perkara_eksekusi=".$no_urut." AND LEFT(permohonan_eksekusi,7)='".$tgl_permohonan_eksekusi."';");
			if($query->num_rows>0){
				foreach ($query->result() as $row) {
					return $row->a;
				}
	    	}else{
	    		return 0;
	    	}
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function cek_nomor_urut_eksht($no_urut,$tgl_permohonan_eksekusi){
		if(empty($no_urut)) return '';
		if(empty($tgl_permohonan_eksekusi)) return '';
		try {

			$query = $this->db->query("SELECT COUNT(nomor_urut_perkara_eksekusi) AS a FROM perkara_eksekusi_ht WHERE nomor_urut_perkara_eksekusi=".$no_urut." AND LEFT(permohonan_eksekusi,7)='".$tgl_permohonan_eksekusi."';");
			if($query->num_rows>0){
				foreach ($query->result() as $row) {
					return $row->a;
				}
	    	}else{
	    		return 0;
	    	}
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}


	function cek_nomor_perkara_eks($nomor_perkara){
		if(empty($nomor_perkara)) return '';		
		try {

			$query = $this->db->query("SELECT COUNT(nomor_register_eksekusi) AS a FROM perkara_eksekusi WHERE nomor_register_eksekusi='".$nomor_perkara."'");
			if($query->num_rows>0){
				foreach ($query->result() as $row) {
					return $row->a;
				}
	    	}else{
	    		return 0;
	    	}
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}


	function cek_nomor_perkara_eksht($nomor_perkara){
		if(empty($nomor_perkara)) return '';		
		try {

			$query = $this->db->query("SELECT COUNT(eksekusi_nomor_perkara) AS a FROM perkara_eksekusi_ht WHERE eksekusi_nomor_perkara='".$nomor_perkara."'");
			if($query->num_rows>0){
				foreach ($query->result() as $row) {
					return $row->a;
				}
	    	}else{
	    		return 0;
	    	}
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}



	function getKodePN(){
		try {
			$this->db->where('id',61);
			$this->db->select('value');
			$result = $this->db->get('sys_config');
			if($result->num_rows>0){
				return $result->row()->value;
			}else{
				return '';
			}
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}


	function data_para_pemohon($htid){
		try{
			$query = $this->db->query("SELECT GROUP_CONCAT(pihak_id) as para_pemohon FROM perkara_eksekusi_detil_ht WHERE status_pihak_id=1 AND ht_id='$htid';");
			return $query;
			} catch (Exception $e) {
            	log_message('error', $e);
		}
	}


	function get_biaya_pendaftaran(){
		
		try {

			$query = $this->db->query('SELECT 
						jb.id	 		AS id,
						jb.tahapan_id 		AS tahapan_id,
						jb.kategori_id  	AS kategori_id,
						jb.nama 		AS nama,
						bp.jumlah 		AS jumlah
					FROM jenis_biaya AS jb
					LEFT JOIN biaya_perkara AS bp ON jb.id=bp.jenis_biaya_id
					WHERE jb.tahapan_id=50 AND jb.id=65 GROUP BY jb.id;');
			return $query;
			
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function get_biaya_atk(){
		
		try {

			$query = $this->db->query('SELECT 
						jb.id	 		AS id,
						jb.tahapan_id 		AS tahapan_id,
						jb.kategori_id  	AS kategori_id,
						jb.nama 		AS nama,
						bp.jumlah 		AS jumlah
					FROM jenis_biaya AS jb
					LEFT JOIN biaya_perkara AS bp ON jb.id=bp.jenis_biaya_id
					WHERE jb.tahapan_id=50 AND jb.id=215 GROUP BY jb.id;');
			return $query;
			
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}


	function get_jurusita(){
		
		try {

			$query = $this->db->query("SELECT * FROM jurusita WHERE aktif='Y';");
			return $query;
			
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}	

	function add_perkara_eksekusi($data){
		
		try {
				$this->db->insert('perkara_eksekusi_ht', $data);

				$title = "Tambah Data Perkara Eksekusi Hak Tanggungan<br />Tambah table <b>perkara_eksekusi_ht</b> dari halaman <b>Tambah Data Eksekusi</b> dengan Primary Key [ID=".$data['ht_id']."]";
				$descrip = $this->fetch_description($title,$data);
				$this->add_audittrail("INSERT",$title,$descrip,'perkara_eksekusi_ht');

				return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}	

	function add_perkara_eksekusi_detil($datapihak){
		
		try {
			foreach ($datapihak as $data) {
				$this->db->insert('perkara_eksekusi_detil', $data);
			}
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function add_perkara_eksekusi_detil_ht($data){
		
		try {
			$this->db->insert('perkara_eksekusi_detil_ht', $data);
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}


	function add_perkara_biaya($data_biaya){
		
		try {
				foreach ($data_biaya as $data) {
					$id = $this->db->query("SELECT IFNULL(max(id)+1,1) as id FROM perkara_biaya_ht;")->row()->id;
					if($id>0){
						$data['id'] = $id;
						$this->db->insert('perkara_biaya_ht', $data);
					}
				}
				$title = "Tambah Data Biaya Hak Tanggungan <br />Tambah table <b>perkara_biaya_ht</b> dari halaman <b>Tambah Biaya</b> dengan Primary Key [ID=".$data['ht_id']."]";
				$descrip = $this->fetch_description($title,$data);
				$this->add_audittrail("INSERT",$title,$descrip,'perkara_biaya_ht');

				return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}	

	function update_perkara_eksekusi($data,$idperkara){
		
		try {
				$table = "perkara_eksekusi";
				$this->db->where('perkara_id', $idperkara);
				$this->db->update($table, $data);

				$title = "Edit Data Baya <br />Edit table <b>perkara_eksekusi</b> dari halaman <b>Edit Permohonan Eksekusi</b> dengan Primary Key [ID Perkara=".$idperkara."]";
				$descrip = $this->fetch_description($title,$data);
				$this->add_audittrail("EDIT",$title,$descrip,'perkara_eksekusi');

		}
		catch (Exception $e) {
			return FALSE;
		}
	}

	function dele_perkara_eksekusi_detil($idperkara){
		
		try {
				$table = "perkara_eksekusi_detil";
				$this->db->where('perkara_id', $idperkara);
				$this->db->delete($table); 

		}
		catch (Exception $e) {
			return FALSE;
		}
	}


	function get_detil_eksekusi($htid){
		try{
			$query = $this->db->query("SELECT
				pe.ht_id					AS ht_id,
				pe.alur_perkara_id 			AS alur_perkara_id,
				pe.nomor_perkara_pn 		AS nomor_perkara_pn,
				pe.putusan_pn 				AS putusan_pn,
				pe.nomor_perkara_banding	AS nomor_perkara_banding,
				pe.putusan_banding 			AS putusan_banding,
				pe.nomor_perkara_kasasi 	AS nomor_perkara_kasasi,
				pe.putusan_kasasi 			AS putusan_kasasi,
				pe.nomor_perkara_pk 		AS nomor_perkara_pk,
				pe.putusan_pk 				AS putusan_pk,
				pe.permohonan_eksekusi 		AS permohonan_eksekusi,
				pe.eksekusi_putusan 		AS eksekusi_putusan_id,
				pe.eksekusi_nomor_perkara 	AS eksekusi_nomor_perkara,
				pe.eksekusi_amar_putusan 	AS eksekusi_amar_putusan,
				pe.penetapan_teguran_eksekusi as penetapan_teguran_eksekusi,
				pe.nomor_penetapan_teguran_eksekusi as nomor_penetapan_teguran_eksekusi,
				pe.pelaksanaan_teguran_eksekusi as pelaksanaan_teguran_eksekusi,
				pe.penetapan_sita_eksekusi as penetapan_sita_eksekusi,
				pe.nomor_penetapan_sita_eksekusi as nomor_penetapan_sita_eksekusi,
				pe.pelaksanaan_sita_eksekusi as pelaksanaan_sita_eksekusi,
				pe.jurusita_id 			AS jurusita_id,
				pe.jurusita_nama 			AS jurusita_nama,
				pe.penetapan_perintah_eksekusi_lelang as penetapan_perintah_eksekusi_lelang,
				pe.pelaksanaan_eksekusi_lelang as pelaksanaan_eksekusi_lelang,
				pe.penyerahan_hasil_lelang as penyerahan_hasil_lelang,
				pe.penetapan_perintah_eksekusi_rill as penetapan_perintah_eksekusi_rill,
				pe.pelaksanaan_eksekusi_rill as pelaksanaan_eksekusi_rill,
				pe.penetapan_noneksekusi as penetapan_noneksekusi,
				pe.alasan_eksekusi as alasan_eksekusi,
				pe.catatan_eksekusi as catatan_eksekusi,
				pe.pemohon_eksekusi as pemohon_eksekusi,
				pe.jenis_ht_text as jenis_ht_text,
				pe.tgl_sertifikat as tgl_sertifikat,
				pe.no_sertifikat as no_sertifikat
				
			FROM perkara_eksekusi_ht AS pe
			WHERE pe.ht_id=$htid;");
			return $query;
			} catch (Exception $e) {
            	log_message('error', $e);
		}
	}

	function get_pemohon_eksekusi($htid){
		try{
			$query = $this->db->query("SELECT 
			ped.id 					AS id,
			ped.ht_id 				AS ht_id,
			ped.status_pihak_id 	AS status_pihak_id,
			ped.status_pihak_text 	AS status_pihak_text,
			ped.pihak_id 			AS pihak_id,
			ped.pihak_nama 			AS nama,
			ph.alamat 				AS alamat
		FROM perkara_eksekusi_detil_ht AS ped
		LEFT JOIN pihak AS ph ON ph.id=ped.pihak_id
		WHERE ped.ht_id=$htid AND ped.status_pihak_id=1 ORDER BY ped.status_pihak_id;");
			return $query;
			} catch (Exception $e) {
            	log_message('error', $e);
		}
	}

	function get_termohon_eksekusi($htid){
		try{
			$query = $this->db->query("SELECT 
			ped.id 					AS id,
			ped.ht_id 				AS ht_id,
			ped.status_pihak_id 	AS status_pihak_id,
			ped.status_pihak_text 	AS status_pihak_text,
			ped.pihak_id 			AS pihak_id,
			ped.pihak_nama 			AS nama,
			ph.alamat 				AS alamat
		FROM perkara_eksekusi_detil_ht AS ped
		LEFT JOIN pihak AS ph ON ph.id=ped.pihak_id
		WHERE ped.ht_id=$htid AND ped.status_pihak_id=2 ORDER BY ped.status_pihak_id;");
			return $query;
			} catch (Exception $e) {
            	log_message('error', $e);
		}
	}

	function get_detil_pihak_ht($htid){
		try{
			$query = $this->db->query("SELECT * FROM pihak WHERE id=$htid;");
			return $query;
			} catch (Exception $e) {
            	log_message('error', $e);
		}
	}

	function edit_perkara_eksekusi($data,$htid){
		
		try {
				$table = "perkara_eksekusi_ht";
				$this->db->where('ht_id', $htid);
				$this->db->update($table, $data);

				$title = "Edit Data Perkara Eksekusi <br />Edit table <b>perkara_eksekusi</b> dari halaman <b>Edit Permohonan Eksekusi</b> dengan Primary Key [ID Perkara=".$htid."]";
				$descrip = $this->fetch_description($title,$data);
				$this->add_audittrail("EDIT",$title,$descrip,'perkara_eksekusi_ht');

		}
		catch (Exception $e) {
			return FALSE;
		}
	}
	
	function get_pihak_eksekusi_ht($htid,$pihak_id){
		try{
			$query = $this->db->query("SELECT count(*) as pemohon_ada FROM perkara_eksekusi_detil_ht where ht_id=$htid AND pihak_id=$pihak_id;");
			return $query;
			} catch (Exception $e) {
            	log_message('error', $e);
		}
	}

	function hapus_perkara_eks_ht($ht_id){
		try {
			$this->db->where('ht_id', $ht_id);
			$this->db->delete('perkara_eksekusi_ht');

			$this->db->where('ht_id', $ht_id);
			$this->db->where('tahapan_id', 50);
			$this->db->delete('perkara_biaya_ht');
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}


	function fetch_description($title,$data){
		$descrip = '<br><table style="vertical-align:top" cellspacing="0" cellpadding="1" border="1">';
		$descrip .= '<tr><th>Nama Kolom</th><th>Nilai</th></tr>';
		foreach ($data as $key => $value) {
			$descrip .= '<tr>';
			$descrip .= '<td>'.$key.'</td>';
			$descrip .= '<td>'.$value.'</td>';
			$descrip .= '</tr>';
		}
		$descrip .= '</table>';
		return $descrip;
	}


	function hapus_pihak_ht($ht_id,$id_pihak){
		try {
			$this->db->where('ht_id',$ht_id);
			$this->db->where('pihak_id',$id_pihak);
			$this->db->delete('perkara_eksekusi_detil_ht');

			$title = "Hapus pihak di perkara hak tanggungan <br />Hapus table <b>perkara_eksekusi_detil_ht</b> dari halaman <b>Biaya Perkara</b> dengan Primary Key [ID Biaya=".$ht_id."] dan [ID Pihak=".$id_pihak."]";
			$descrip = '';
			$this->add_audittrail("HAPUS",$title,$descrip,'perkara_biaya');
			
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
		
	}

	function add_audittrail($action,$title,$descrip,$tablename){
		try {
			$data = array(
				'datetime' => date("Y-m-d H:i:s"),
				'ipaddress' => $this->input->ip_address(),
				'username' => $this->session->userdata('username'),
				'tablename' => $tablename,
				'formname' => 'Add Mediasi',
				'action' => $action,
				'title' => $title,
				'description' => $descrip
			);
			$this->db->insert('sys_audittrail', $data);
		} catch (Exception $e) {
			
		}
	}


}

?>