<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Eksekusi extends CI_Model{
	
	function getJenisPerkara($idalurperkara){
		if(empty($idalurperkara)) return '';
		try {
			$this->db->where('id',$idalurperkara);
			return $this->db->get('alur_perkara')->row()->nama;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}
	
	function isNomorPerkara($txt){
		$re1='(\\d+)';	# Integer Number 1
		$re2='(\\/)';	# Any Single Character 1
		$re3='.*?';	# Non-greedy match on filler
		$re4='(\\/)';	# Any Single Character 2
		$re5='((?:(?:[1]{1}\\d{1}\\d{1}\\d{1})|(?:[2]{1}\\d{3})))(?![\\d])';	# Year 1
		$re6='(\\/)';	# Any Single Character 3
		$re7='(PN)';	# Variable Name 1
		if ($c=preg_match_all ("/".$re1.$re2.$re3.$re4.$re5.$re6.$re7."/is", $txt, $matches)){
		      $int1=$matches[1][0];
		      $c1=$matches[2][0];
		      $c2=$matches[3][0];
		      $year1=$matches[4][0];
		      $c3=$matches[5][0];
		      $var1=$matches[6][0];
		      return 1;
		}else{
			return 0;
		}
	}

	function parseOrderby($col){
		if($col==1){
			return "nomor_perkara_pn"; 
		}else if($col==2){
			return "permohonan_eksekusi"; 
		}else if($col==3){
			return "pengiriman_berkas_eksekusi"; 
		}else if($col==4){
			return "putusan_eksekusi"; 
		}else if($col==5){
			return "nomor_perkara_eksekusi"; 
		}else if($col==6){
			return "penerimaan_berkas_eksekusi"; 
		}else if($col==7){
			return "pemberitahuan_putusan_eksekusi"; 
		}else if($col==8){
			return "nomor_perkara_pn"; 
		}else{
			return "permohonan_eksekusi";
		}
	}

	function getPerkaraList($idalurperkara='',$col=2,$type='DESC',$begin=0,$key=''){
		$orderby = $this->parseOrderby($col);
		$where = '';

		if($idalurperkara>0){
			$where = "AND alur_perkara_id IN (".$idalurperkara.")";
		}else{
			$where = "";
		}

		if(!empty($key)){
			if($this->isNomorPerkara($key)){
				$where_like = ' WHERE nomor_perkara_pn ="'.$key.'" OR nomor_perkara_banding="'.$key.'" ';

			}else{
				$where_like = ' WHERE (nomor_perkara_pn LIKE "%'.$key.'%" 
					OR permohonan_eksekusi LIKE "%'.$key.'%"
					OR pemohon_eksekusi LIKE "%'.$key.'%" 
					OR eksekusi_nomor_perkara LIKE "%'.$key.'%" 
					OR status_eksekusi_text LIKE "%'.$key.'%"
					OR nomor_penetapan_sita_eksekusi LIKE "%'.$key.'%"
					OR pelaksanaan_sita_eksekusi LIKE "%'.$key.'%"
					OR nomor_penetapan_teguran_eksekusi LIKE "%'.$key.'%"
					OR penetapan_teguran_eksekusi LIKE "%'.$key.'%") ';
			}
		}else{
			$where_like =" ";
			if($idalurperkara>0){
				$where = " WHERE alur_perkara_id IN (".$idalurperkara.")";
			}
		}
		try {
			$sql=("SELECT SQL_CALC_FOUND_ROWS perkara_id, 
				perkara_id,
				nomor_perkara_pn,
				nomor_register_eksekusi, 
				permohonan_eksekusi, 
				pemohon_eksekusi, 
				penetapan_teguran_eksekusi, 
				nomor_penetapan_teguran_eksekusi, 
				pelaksanaan_teguran_eksekusi, 
				penetapan_sita_eksekusi, 
				nomor_penetapan_sita_eksekusi, 
				pelaksanaan_sita_eksekusi ,
				diterima_permohonan,
				panggilan_parapihak,
				diterima_permohonan,
				penetapan_ketua
				FROM v_perkara_eksekusi ".$where_like." ".$where." ORDER BY ".$orderby." ".$type." LIMIT ".$begin.",50");
			$query = $this->db->query($sql);
			return $query;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function getPerkaraList_search_detail($idalurperkara='',$col=2,$type='DESC',$begin=0,$key=''){
		$orderby = $this->parseOrderby($col);
		$where = '';

		if($idalurperkara>0){
			$where = "AND alur_perkara_id IN (".$idalurperkara.")";
		}else{
			$where = "";
		}

		if(!empty($key)){
			$where_like = ' WHERE '.$key.' ';
		}else{
			$where_like =" ";
			if($idalurperkara>0){
				$where = " WHERE alur_perkara_id IN (".$idalurperkara.")";
			}
		}
		try {
			$sql=("SELECT SQL_CALC_FOUND_ROWS perkara_id, perkara_id,nomor_perkara_pn, 
				permohonan_eksekusi, pemohon_eksekusi, penetapan_teguran_eksekusi, 
				nomor_penetapan_teguran_eksekusi, pelaksanaan_teguran_eksekusi, 
				penetapan_sita_eksekusi, nomor_penetapan_sita_eksekusi, pelaksanaan_sita_eksekusi,diterima_permohonan,
				panggilan_parapihak,diterima_permohonan,penetapan_ketua 
				FROM v_perkara_eksekusi ".$where_like." ".$where." ORDER BY ".$orderby." ".$type." LIMIT ".$begin.",50");
			$query = $this->db->query($sql);
			return $query;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function getPerkaraEksekusiCetak($idalurperkara='',$key=''){
		$where = '';
		
		if($idalurperkara>0){
			$where = "AND alur_perkara_id IN (".$idalurperkara.")";
		}else{
			$where = "";
		}

		if(!empty($key)){
			if($this->isNomorPerkara($key)){
				$where_like = ' WHERE nomor_perkara_pn ="'.$key.'" OR nomor_perkara_banding="'.$key.'" ';

			}else{
				$where_like = ' WHERE (nomor_perkara_pn LIKE "%'.$key.'%" 
					OR permohonan_eksekusi LIKE "%'.$key.'%"
					OR pemohon_eksekusi LIKE "%'.$key.'%" 
					OR nomor_perkara_eksekusi LIKE "%'.$key.'%" 
					OR status_eksekusi_text LIKE "%'.$key.'%") ';
			}
		}else{
			$where_like =" ";
			if($idalurperkara>0){
				$where = " WHERE alur_perkara_id IN (".$idalurperkara.")";
			}
		}
		try {
			$query = $this->db->query("SELECT SQL_CALC_FOUND_ROWS perkara_id, perkara_id,nomor_perkara_pn, 
				permohonan_eksekusi, pemohon_eksekusi, penetapan_teguran_eksekusi, 
				nomor_penetapan_teguran_eksekusi, pelaksanaan_teguran_eksekusi, 
				penetapan_sita_eksekusi, nomor_penetapan_sita_eksekusi, pelaksanaan_sita_eksekusi 
				FROM v_perkara_eksekusi ".$where_like." ".$where." ORDER BY permohonan_eksekusi DESC");
			return $query;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	} 



	function fecth_data_num($idalurperkara,$key){
		$query = $this->db->query("SELECT FOUND_ROWS() as cnt;");
		if($query->num_rows>0){
			foreach ($query->result() as $row) {
				return $row->cnt;
			}
    		return $query->num_rows;
    	}else{
    		return 0;
    	}
	}
}

?>