<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Cabut_perkara extends CI_Model{
	
	function get_data_perkara($idperkara){
		if(empty($idperkara)) 
			{ 
				return '';
			}
		try {

			$this->db->where('perkara_id',$idperkara);
			return $this->db->get('perkara');

		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function get_maxid_perkara_putusan(){
		
		try {

			$query = $this->db->query('SELECT MAX(perkara_id)+1 AS maxidput  FROM perkara_putusan');
			return $query;
			
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function add_cabut($data_add){
		try {
				$this->db->insert('perkara_putusan', $data_add);

				$title = "Tambah Data Cabut Perkara/Putusan <br />Tambah table <b>perkara_putusan</b> dari halaman <b>Cabut Perkara</b> dengan Primary Key [perkara_id=".$data_add['perkara_id']."]";
				$descrip = $this->fetch_description($title,$data_add);
				$this->add_audittrail("INSERT",$title,$descrip,'perkara_putusan');

				return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function edit_cabut($data_edit,$perkara_id){
		
		try {
				$table = "perkara";
				$this->db->where('perkara_id', $perkara_id);
				$this->db->update($table, $data_edit);

		}
		catch (Exception $e) {
			return FALSE;
		}
	}


	function fetch_description($title,$data){
		$descrip = '<br><table style="vertical-align:top" cellspacing="0" cellpadding="1" border="1">';
		$descrip .= '<tr><th>Nama Kolom</th><th>Nilai</th></tr>';
		foreach ($data as $key => $value) {
			$descrip .= '<tr>';
			$descrip .= '<td>'.$key.'</td>';
			$descrip .= '<td>'.$value.'</td>';
			$descrip .= '</tr>';
		}
		$descrip .= '</table>';
		return $descrip;
	}

	function add_audittrail($action,$title,$descrip,$tablename){
		try {
			$data = array(
				'datetime' => date("Y-m-d H:i:s"),
				'ipaddress' => $this->input->ip_address(),
				'username' => $this->session->userdata('username'),
				'tablename' => $tablename,
				'formname' => 'Add Mediasi',
				'action' => $action,
				'title' => $title,
				'description' => $descrip
			);
			$this->db->insert('sys_audittrail', $data);
		} catch (Exception $e) {
			
		}
	}


}

?>