<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Jurnal_ht extends CI_Model{
	function isNomorPerkara($txt){
		$re1='(\\d+)';	# Integer Number 1
		$re2='(\\/)';	# Any Single Character 1
		$re3='.*?';	# Non-greedy match on filler
		$re4='(\\/)';	# Any Single Character 2
		$re5='((?:(?:[1]{1}\\d{1}\\d{1}\\d{1})|(?:[2]{1}\\d{3})))(?![\\d])';	# Year 1
		$re6='(\\/)';	# Any Single Character 3
		$re7='(PN)';	# Variable Name 1
		if ($c=preg_match_all ("/".$re1.$re2.$re3.$re4.$re5.$re6.$re7."/is", $txt, $matches)){
		      $int1=$matches[1][0];
		      $c1=$matches[2][0];
		      $c2=$matches[3][0];
		      $year1=$matches[4][0];
		      $c3=$matches[5][0];
		      $var1=$matches[6][0];
		      return 1;
		}else{
			return 0;
		}
	}

	function parseOrderby($col){
		if($col==1){
			return "nomor_eksekusi"; 
		}else if($col==2){
			return "tgl_permohonan"; 
		}else if($col==3){
			return "jenis_ht"; 
		}else if($col==6){
			return "pemohon"; 
		}else{
			return "tgl_permohonan";
		}
	}
	function getJurnalList($idalurperkara=0,$tahapan_id=51,$start_page=0,$key='',$col=2,$type='DESC'){
		
		$orderby = $this->parseOrderby($col);

		$where = "";

		if(!empty($key)){
			if($this->isNomorPerkara($key)){
				$where .= " AND (peh.eksekusi_nomor_perkara) = ".$key."";
			}else{
				$where .= ' AND (peh.eksekusi_nomor_perkara LIKE "%'.$key.'%" OR peh.jenis_ht_text LIKE "%'.$key.'%" OR peh.pemohon_eksekusi LIKE "%'.$key.'%") ';
			}
		}
		$sql = " SELECT 
					peh.ht_id 							AS ht_id,
					peh.eksekusi_nomor_perkara 			AS nomor_eksekusi,
					peh.jenis_ht_text 					AS jenis_ht,
					peh.pemohon_eksekusi 				AS pemohon,
					peh.permohonan_eksekusi 			AS tgl_permohonan,
					peh.alur_perkara_id 				AS alur_perkara_id,
					vpht.tahapan_id 					AS tahapan_id,
					vpht.pemasukan	 					AS pemasukan,
					vpht.pengeluaran 					AS pengeluaran,
					(vpht.pemasukan-vpht.pengeluaran) 	AS sisa 
				FROM perkara_eksekusi_ht AS peh
				LEFT JOIN v_sum_perkara_biaya_ht AS vpht ON peh.ht_id=vpht.ht_id
                WHERE tahapan_id = ".$tahapan_id." ".$where."
                ORDER BY ".$orderby." ".$type." 
				LIMIT ".$start_page.",50";
		try {
			return $this->db->query($sql);
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function fecth_data_num($idalurperkara=0,$tahapan_id=51,$key=''){

		$where = "";

		if(!empty($key)){
			if($this->isNomorPerkara($key)){
				$where .= " AND (peh.eksekusi_nomor_perkara) = ".$key."";
			}else{
				$where .= ' AND (peh.eksekusi_nomor_perkara LIKE "%'.$key.'%" OR peh.jenis_ht_text LIKE "%'.$key.'%" OR peh.pemohon_eksekusi LIKE "%'.$key.'%") ';
			}
		}
		try {
			$sql =("SELECT 
					count(peh.ht_id) as cnt
				FROM perkara_eksekusi_ht AS peh
				LEFT JOIN v_sum_perkara_biaya_ht AS vpht ON peh.ht_id=vpht.ht_id
                WHERE tahapan_id = ".$tahapan_id." ".$where."");
			$query = $this->db->query($sql);
			if($query->num_rows>0){
				foreach ($query->result() as $row) {
					return $row->cnt;
				}
	    		return $query->num_rows;
	    	}else{
	    		return 0;
	    	}
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function getJurnalListCetak($idalurperkara='',$key='',$tahapan_id=51){
		if(!empty($idalurperkara)){
			log_message('error', 'idalurperkara not expected = '.$idalurperkara);
			#show_404();
		}
		$where = "";

		if(!empty($key)){
			if($this->isNomorPerkara($key)){
				$where .= " AND (peh.eksekusi_nomor_perkara) = ".$key."";
			}else{
				$where .= ' AND (peh.eksekusi_nomor_perkara LIKE "%'.$key.'%" OR peh.jenis_ht_text LIKE "%'.$key.'%" OR peh.pemohon_eksekusi LIKE "%'.$key.'%") ';
			}
		}
		try {
			$query = $this->db->query("SELECT 
					peh.ht_id 							AS ht_id,
					peh.eksekusi_nomor_perkara 			AS nomor_eksekusi,
					peh.jenis_ht_text 					AS jenis_ht,
					peh.pemohon_eksekusi 				AS pemohon,
					peh.permohonan_eksekusi 			AS tgl_permohonan,
					peh.alur_perkara_id 				AS alur_perkara_id,
					vpht.tahapan_id 					AS tahapan_id,
					vpht.pemasukan	 					AS pemasukan,
					vpht.pengeluaran 					AS pengeluaran,
					(vpht.pemasukan-vpht.pengeluaran) 	AS sisa 
				FROM perkara_eksekusi_ht AS peh
				LEFT JOIN v_sum_perkara_biaya_ht AS vpht ON peh.ht_id=vpht.ht_id
                WHERE tahapan_id = ".$tahapan_id." ".$where."");
			return $query;
		} catch (Exception $e) {
			log_message('error', $e);
		}
	} 

	function maxid_perkara_eksekusi_ht(){
		try {

			$query = $this->db->query('SELECT MAX(ht_id)+1 AS maxid  FROM perkara_eksekusi_ht');
			return $query;
			
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}


}