<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Ikrar_talak_m extends CI_Model {
	function get_list_hakim($idperkara){
		try {
			$this->db->where('perkara_id',$idperkara);
			$this->db->where('tahapan_id',18);
			return $this->db->get('perkara_hakim_pn');
		} catch (Exception $e) {
			
		}
	}

	function get_list_hakim_lama($idperkara){
		try {
			$this->db->where('perkara_id',$idperkara);
			$this->db->where('aktif','Y');
			$this->db->where('tahapan_id',18);
			$this->db->order_by("urutan", "ASC"); 
			return $this->db->get('perkara_hakim_pn');
		} catch (Exception $e) {
			
		}
	}

	function get_list_panitera($idperkara){
		try {
			$this->db->where('perkara_id',$idperkara);
			$this->db->where('tahapan_id',18);
			return $this->db->get('perkara_panitera_pn');
		} catch (Exception $e) {
			
		}
	}

	function get_list_panitera_lama($idperkara){
		try {
			$this->db->where('perkara_id',$idperkara);
			$this->db->where('aktif','Y');
			$this->db->where('tahapan_id',18);
			$this->db->order_by("urutan", "ASC"); 
			return $this->db->get('perkara_panitera_pn');
		} catch (Exception $e) {
			
		}
	}

	function getLastSidang($idperkara){
		try {
			$query = $this->db->query("SELECT max(tanggal_sidang) as tglSidang FROM perkara_jadwal_sidang WHERE perkara_id = ".$idperkara.";");
			if($query->num_rows>0){
				return $query->row()->tglSidang;
			}
		} catch (Exception $e) {
			return '';
		}
	}

	function get_status_putusan(){
		try {
			$jenis_pengadilan = $this->session->userdata('jenis_pengadilan');
			$query_tambahan = ' ';
			if($jenis_pengadilan==3){
				$query_tambahan = 'AND urutan IN (1,2) ';
			}
			return $this->db->query("SELECT id, kode, nama FROM status_putusan WHERE jenis_perkara_id=1 AND jenis_pengadilan = ".$jenis_pengadilan." ".$query_tambahan." ORDER BY nama ASC;");
		} catch (Exception $e) {
			return '';
		}
	}
	
	function getStatusPutusanNama($id){
		try {
			$query = $this->db->query("SELECT nama FROM status_putusan WHERE jenis_perkara_id=1 AND id = ".$id.";");
			if($query->num_rows>0){
				return $query->row()->nama;
			}
		} catch (Exception $e) {
			return '';
		}
	}

	function getTanggalDismissal($idperkara){
		try {
			$query = $this->db->query("SELECT tanggal_penetapan FROM perkara_dismissal WHERE perkara_id = ".$idperkara.";");
			if($query->num_rows>0){
				return $query->row()->tanggal_penetapan;
			}
		} catch (Exception $e) {
			return '';
		}
	}

	function get_no_perkara($perkara_id){
		try {
			$query = $this->db->query("SELECT p.nomor_perkara, p.alur_perkara_id,p.jenis_perkara_id,p.proses_terakhir_id,pp.tanggal_putusan,pv.*,pp.* , pac.keadaan_istri,pjs.tanggal_sidang,pjs.jam_sidang
										FROM perkara p 
											LEFT JOIN (SELECT perkara_id,tanggal_putusan,tanggal_bht FROM perkara_putusan WHERE perkara_id=".$perkara_id.") pp 
											ON pp.perkara_id=p.perkara_id
											LEFT JOIN (SELECT * FROM perkara_ikrar_talak WHERE perkara_id=".$perkara_id.") pv 
											ON p.perkara_id=pv.perkara_id
											LEFT JOIN perkara_akta_cerai AS pac ON pac.perkara_id=p.perkara_id
											LEFT JOIN (SELECT * FROM perkara_jadwal_sidang WHERE perkara_id=31293 AND ikrar_talak='Y') pjs ON p.perkara_id=pjs.perkara_id
										WHERE p.perkara_id=".$perkara_id.";");
			if($query->num_rows>0){
				return $query->row();
			}
		} catch (Exception $e) {
			return '';
		}
	}
	function get_info_akta_cerai($perkara_id){
		try {
			$query = $this->db->query("SELECT fp.nama as faktor_penyebab, pac.keadaan_istri, pac.perkara_id, 
											pac.tahun_akta_cerai,
											pac.nomor_urut_akta_cerai,
											pac.nomor_akta_cerai,
											pac.tgl_akta_cerai,
											pac.no_seri_akta_cerai,
											pac.jenis_cerai,
											pac.faktor_perceraian_id,
											pac.qobla_bada,
											pac.perceraian_ke,
											pac.tgl_penyerahan_akta_cerai,
											pac.tgl_penyerahan_akta_cerai_pihak2,
											pac.akta_cerai_dok,
											(SELECT blangko_akta_cerai FROM perkara_akta_cerai ORDER BY diperbaharui_tanggal DESC LIMIT 1) AS blangko
										FROM (select * from perkara_akta_cerai WHERE perkara_id=".$perkara_id.") as pac
										LEFT JOIN perkara_ikrar_talak pit ON pac.perkara_id=pit.perkara_id 
										LEFT JOIN faktor_perceraian fp ON fp.id=pac.faktor_perceraian_id;");
			if($query->num_rows>0){
				return $query->row();
			}
		} catch (Exception $e) {
			return '';
		}
	}
	function get_info_akta_cerai_pihak($perkara_id){
		try {
			$query = $this->db->query("SELECT pihak1_text AS penggugat, pihak2_text AS tergugat
										FROM perkara WHERE perkara_id=".$perkara_id.";");
			if($query->num_rows>0){
				return $query->row();
			}
		} catch (Exception $e) {
			return '';
		}
	}

	function update_perkara_akta_cerai($perkara_id, $data){
		try {
			$this->db->where('perkara_id', $perkara_id);
			$this->db->update('perkara_akta_cerai', $data); 

			$title = "UPDATE TABLE <b>perkara_akta_cerai</b> dari halaman <b>AKTA CERAI</b> dengan Primary Key [perkara_id=".$perkara_id."]";
			$descrip = $this->fetch_description($title,$data);
			$this->add_audittrail("UPDATE",$title,$descrip,'perkara_akta_cerai');

			$tahapan_id = 19;
			$this->db->simple_query("CALL perkara_proses_update(".$perkara_id.", 19, 'Akta Cerai', 296, 'Pembuatan Akta Cerai', '".$data['tgl_akta_cerai']."', '', '".$this->session->userdata('username')."', '".date('Y-m-d H:i:s')."');");
			
			$this->db->simple_query("CALL perkara_update_status(".$perkara_id.");");	
			return TRUE;
		} catch (Exception $e) {
			return '';	
		}
	}
	

	function getPerkaraFaktorPercerian($idperkara){
		try {
			return $this->db->query('SELECT pac.faktor_perceraian_id,fp.nama FROM perkara_akta_cerai AS pac
							LEFT JOIN faktor_perceraian AS fp
							ON fp.id = pac.faktor_perceraian_id
							WHERE perkara_id='.$idperkara);
		} catch (Exception $e) {
			
		}
	}

	function getJenisPerkara($idperkara){
		try {
			return $this->db->query("SELECT jenis_perkara_nama FROM perkara
							WHERE perkara_id=$idperkara");
		} catch (Exception $e) {
			
		}
	}

	function getNomorUrutRegister($year){
		try {
			$sql="SELECT (ifnull(max(nomor_urut_akta_cerai),0)) +1 AS nomor FROM perkara_akta_cerai WHERE tahun_akta_cerai = '".$year."'";
			$query = $this->db->query($sql);
			if($query->num_rows>0){
				foreach ($query->result() as $row) {
					return $row->nomor;
				}
	    	}else{
	    		return 0;
	    	}
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function getnomoraktacerai($year){
		try {
			$sql="SELECT nomor_akta_cerai AS nomor
					FROM perkara_akta_cerai WHERE tahun_akta_cerai = '".$year."'
					ORDER BY nomor_urut_akta_cerai DESC LIMIT 1";
			$query = $this->db->query($sql);
			if($query->num_rows>0){
				foreach ($query->result() as $row) {
					$temp = explode("/", $row->nomor);
					$no = $temp[0] + 1;
					return $no;
				}
	    	}else{
	    		return 1;
	    	}
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function getkodesatker(){
		try {
			$sql="SELECT value FROM sys_config WHERE id = 61";
			$query = $this->db->query($sql);
			if($query->num_rows>0){
				foreach ($query->result() as $row) {
					return $row->value;
				}
	    	}else{
	    		return '';
	    	}
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function isNomorUrutRegisterExists($noUrutReg, $year){
		try {
			$query = $this->db->query("SELECT nomor_urut_akta_cerai
				FROM perkara_akta_cerai
				WHERE nomor_urut_akta_cerai='".$noUrutReg."' and tahun_akta_cerai = '".$year."';");
			if($query->num_rows>0){
				return TRUE;
			}else{
				return FALSE;
			}
		} catch (Exception $e) {
			log_message('error', $e);
			return -2;
		}
	}

	function addRiwayatPerkara($perkara_id,$tahapan_id, $proses_id, $proses_nama, $tanggal){
		try {
			$this->db->simple_query("CALL perkara_proses_update(".$perkara_id.", ".$tahapan_id.", 'Verzet', ".$proses_id.", '".$proses_nama."', '".$tanggal."', '', '".$this->session->userdata('username')."', '".date('Y-m-d H:i:s')."');");
			$this->db->simple_query("CALL perkara_update_status(".$perkara_id.");");
		} catch (Exception $e) {
			
		}
	}

	function delRiwayatPerkara($idperkara,$idproses){
		try {
			$this->db->where('perkara_id',$idperkara);
			$this->db->where('proses_id',$idproses);
			$this->db->delete('perkara_proses');
			$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");
		} catch (Exception $e) {
			
		}
	}

	function addJadwalSidang($data){
		try {
			$id = $this->db->query("SELECT IFNULL(max(id)+1,1) as id FROM perkara_jadwal_sidang")->row()->id;
			$data['id'] = $id;
			$urutan = $this->db->query("SELECT IFNULL(max(urutan)+1,1) as id FROM perkara_jadwal_sidang WHERE perkara_id =".$data['perkara_id'])->row()->id;
			$data['urutan'] = $urutan;
			$this->db->insert('perkara_jadwal_sidang', $data);
			return $id;
		} catch (Exception $e) {
			return 0;
		}
	}

	

	function getSidangPertamaVerzet($idperkara){
		try {
			return $this->db->query('SELECT id, min(tanggal_sidang) FROM perkara_jadwal_sidang WHERE perkara_id = '.$idperkara.' AND verzet = "Y";');
		} catch (Exception $e) {
			
		}
	}

	function updateJadwalSidangPertama($data){
		try {
			$this->db->where('id',$data['id']);
			$this->db->update('perkara_jadwal_sidang',$data);
		} catch (Exception $e) {
			
		}
	}
	
	function infoikrartalak($idperkara){
		try {
			$query = $this->db->query("SELECT * from perkara_ikrar_talak where perkara_id=$idperkara;");
			if($query->num_rows>0){
				return $query->row();
			}
		} catch (Exception $e) {
			return '';
		}
	}
	function exec_simple_query($query){
		try {
			$this->db->simple_query($query);
		} catch (Exception $e) {
			return '';
		}	
	}

	function fetch_description($title,$data){
		$descrip = '<br><table style="vertical-align:top" cellspacing="0" cellpadding="1" border="1">';
		$descrip .= '<tr><th>Nama Kolom</th><th>Nilai</th></tr>';
		foreach ($data as $key => $value) {
			$descrip .= '<tr>';
			$descrip .= '<td>'.$key.'</td>';
			$descrip .= '<td>'.$value.'</td>';
			$descrip .= '</tr>';
		}
		$descrip .= '</table>';
		return $descrip;
	}
	
	function add_audittrail($action,$title,$descrip,$tablename){
		try {
			$data = array(
				'datetime' => date("Y-m-d H:i:s"),
				'ipaddress' => $this->input->ip_address(),
				'username' => $this->session->userdata('username'),
				'tablename' => $tablename,
				'formname' => 'add/edit ikrar talak/akta cerai',
				'action' => $action,
				'title' => $title,
				'description' => $descrip
			);
			$this->db->insert('sys_audittrail', $data);
		} catch (Exception $e) {
			
		}
	}

	function deleteData($idperkara){
		try {
			$this->db->where('perkara_id',$idperkara);
			$this->db->delete('perkara_verzet');
			$title = "DELETE DATA VERZET dari halaman <b>EDIT DATA VERZET</b> dengan Primary Key [perkara_id=".$idperkara."]";
			$this->add_audittrail("DELETE",$title,'DELETE DATA VERZET','perkara_verzet');

			$this->db->where('perkara_id',$idperkara);
			$this->db->where('verzet','Y');
			$this->db->delete('perkara_jadwal_sidang');

			$this->db->where('perkara_id',$idperkara);
			$this->db->where('tahapan_id',16);
			$this->db->delete('perkara_proses');
			$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function hasSidangPertama($idperkara){
		try {
			$query = $this->db->query("SELECT tanggal_sidang_pertama_verzet FROM perkara_verzet WHERE perkara_id = ".$idperkara.";");
			if(!empty($query->row()->tanggal_sidang_pertama_verzet)){
				return TRUE;
			}else{
				return FALSE;
			}
		} catch (Exception $e) {
			return '';
		}
	}

	function getListHakim(){
		try {
			return $this->db->query('SELECT id,nama_gelar FROM hakim_pn WHERE aktif="Y" ORDER BY nama ASC;');
		} catch (Exception $e) {
			
		}
	}

	function getTanggalPermohonan($idperkara){
		try {
			$query = $this->db->query("SELECT tanggal_pendaftaran_verzet FROM perkara_verzet WHERE perkara_id = ".$idperkara.";");
			if($query->num_rows>0){
				return $query->row()->tanggal_pendaftaran_verzet;
			}
		} catch (Exception $e) {
			return '';
		}
	}

	function getHakimNama($idhakim){
		try {
			$query = $this->db->query("SELECT nama_gelar FROM hakim_pn WHERE id = ".$idhakim.";");
			if($query->num_rows>0){
				return $query->row()->nama_gelar;
			}
		} catch (Exception $e) {
			return '';
		}
	}

	function updateDataPenetapanMajelis($idperkara,$dataPenetapan,$datahakim=NULL,$action,$status=NULL){
		try {
			if($action=='add'){
				$this->db->insert('perkara_ikrar_talak', $dataPenetapan);
				if($status=='T'){
					$this->db->query('UPDATE perkara_hakim_pn SET aktif="T" WHERE perkara_id='.$idperkara.';');
					if(!empty($datahakim))
						$this->db->insert_batch('perkara_hakim_pn',$datahakim);
				}
			}else{
				$this->db->query('UPDATE perkara_hakim_pn SET aktif="T" WHERE perkara_id='.$idperkara.';');
				$this->db->where('perkara_id', $idperkara);
				$this->db->update('perkara_ikrar_talak', $dataPenetapan);
				if(!empty($datahakim))
					$this->db->insert_batch('perkara_hakim_pn',$datahakim);
			}

			$title = "UPDATE TABLE <b>perkara_ikrar_talak</b> dari halaman <b>PENETAPAN MAJELIS HAKIM</b> dengan Primary Key [perkara_id=".$idperkara."]";
			$descrip = $this->fetch_description($title,$dataPenetapan);
			$this->add_audittrail("UPDATE",$title,$descrip,'perkara_ikrar_talak');

			$tahapan_id = 18;
			$this->db->simple_query("CALL perkara_proses_update(".$idperkara.", 18, 'Ikrar Talak', 290, 'Penetapan Majelis Hakim Ikrar Talak', '".$dataPenetapan['penetapan_majelis_hakim']."', '', '".$this->session->userdata('username')."', '".date('Y-m-d H:i:s')."');");
			
			$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function getOldPenetapanMajelis($idperkara){
		try {
			return $this->db->query('SELECT penetapan_majelis_hakim,majelis_hakim_id,majelis_hakim_nama,majelis_hakim_text FROM perkara_penetapan WHERE perkara_id ='.$idperkara);
		} catch (Exception $e) {
			
		}
	}

	function getListPanitera(){
		try {
			return $this->db->query('SELECT id,nama_gelar FROM panitera_pn WHERE aktif="Y" ORDER BY nama ASC;');
		} catch (Exception $e) {
			
		}
	}

	function getPaniteraNama($idpanitera){
		try {
			$query = $this->db->query("SELECT nama_gelar FROM panitera_pn WHERE id = ".$idpanitera.";");
			if($query->num_rows>0){
				return $query->row()->nama_gelar;
			}
		} catch (Exception $e) {
			return '';
		}
	}

	function getOldPenetapanPanitera($idperkara){
		try {
			return $this->db->query('SELECT penetapan_panitera_pengganti,panitera_pengganti_id,panitera_pengganti_text FROM perkara_penetapan WHERE perkara_id ='.$idperkara);
		} catch (Exception $e) {
			
		}
	}

	function addDataPenetapanKembaliPP($datapanitera,$idperkara){
		try {
			$this->db->query('UPDATE perkara_panitera_pn SET aktif="T" WHERE tahapan_id = 18 AND perkara_id='.$idperkara.';');
			$this->db->insert_batch('perkara_panitera_pn',$datapanitera);
		} catch (Exception $e) {
			
		}
	}
	function updateDataKeadaanIstri($keadaanistri,$idperkara){
		try {
			$this->db->query('UPDATE perkara_akta_cerai SET keadaan_istri='.$keadaanistri.' WHERE perkara_id='.$idperkara.';');
			} catch (Exception $e) {
			
		}
	}
	function updateDataPenetapanPanitera($idperkara,$dataPenetapan,$datapanitera=NULL){
		try {
			$this->db->where('perkara_id', $idperkara);
			$this->db->update('perkara_ikrar_talak', $dataPenetapan);

			$title = "UPDATE TABLE <b>perkara_ikrar_talak</b> dari halaman <b>PENETAPAN PANITERA PENGGANTI</b> dengan Primary Key [perkara_id=".$idperkara."]";
			$descrip = $this->fetch_description($title,$dataPenetapan);
			$this->add_audittrail("UPDATE",$title,$descrip,'perkara_ikrar_talak');

			$tahapan_id = 18;
			$this->db->simple_query("CALL perkara_proses_update(".$idperkara.", 18, 'Ikrar Talak', 291, 'Penunjukan Panitera Pengganti Ikrar Talak', '".$dataPenetapan['penetapan_panitera_pengganti']."', '', '".$this->session->userdata('username')."', '".date('Y-m-d H:i:s')."');");
			
			$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");		
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function getListJurusita(){
		try {
			return $this->db->query('SELECT id,nama_gelar FROM jurusita WHERE aktif="Y" ORDER BY nama ASC;');
		} catch (Exception $e) {
			
		}
	}

	function getJurusitaNama($idpanitera){
		try {
			$query = $this->db->query("SELECT nama_gelar FROM jurusita WHERE id = ".$idpanitera.";");
			if($query->num_rows>0){
				return $query->row()->nama_gelar;
			}
		} catch (Exception $e) {
			return '';
		}
	}

	function getOldPenetapanJurusita($idperkara){
		try {
			return $this->db->query('SELECT penetapan_jurusita,jurusita_id,jurusita_text FROM perkara_penetapan WHERE perkara_id ='.$idperkara);
		} catch (Exception $e) {
			
		}
	}

	function updateDataPenetapanJurusita($idperkara,$dataPenetapan){
		try {
			$this->db->where('perkara_id', $idperkara);
			$this->db->update('perkara_ikrar_talak', $dataPenetapan);

			$title = "UPDATE TABLE <b>perkara_ikrar_talak</b> dari halaman <b>PENETAPAN JURUSITA</b> dengan Primary Key [perkara_id=".$idperkara."]";
			$descrip = $this->fetch_description($title,$dataPenetapan);
			$this->add_audittrail("UPDATE",$title,$descrip,'perkara_ikrar_talak');

			$this->db->simple_query("CALL perkara_proses_update(".$idperkara.", 18, 'Ikrar Talak', 292, 'Penetapan Jurusita Ikrar Talak', '".$dataPenetapan['penetapan_jurusita']."', '', '".$this->session->userdata('username')."', '".date('Y-m-d H:i:s')."');");
			$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function updateDataPenetapanSidang($idperkara,$dataPenetapan){
		try {
			$this->db->where('perkara_id', $idperkara);
			$this->db->update('perkara_ikrar_talak', $dataPenetapan);

			$title = "UPDATE TABLE <b>perkara_ikrar_talak</b> dari halaman <b>PENETAPAN SIDANG IKARA TALAK</b> dengan Primary Key [perkara_id=".$idperkara."]";
			$descrip = $this->fetch_description($title,$dataPenetapan);
			$this->add_audittrail("UPDATE",$title,$descrip,'perkara_ikrar_talak');
			$this->db->simple_query("CALL perkara_proses_update(".$idperkara.", 18, 'Ikrar Talak', 293, 'Penetapan Hari Sidang Ikrar Talak', '".$dataPenetapan['tanggal_penetapan_sidang_ikrar']."', '', '".$this->session->userdata('username')."', '".date('Y-m-d H:i:s')."');");
			$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function deleteDataSidang($idperkara,$idsidang){
		try {
			$dataverzet['sidang_id'] = NULL;
			$dataverzet['tanggal_penetapan_sidang_ikrar'] = NULL;
			$dataverzet['tanggal_sidang_pertama'] = NULL;
			$dataverzet['diperbaharui_oleh'] = $this->session->userdata('username');
			$dataverzet['diperbaharui_tanggal'] = date('Y-m-d H:i:s');

			$this->db->where('perkara_id', $idperkara);
			$this->db->update('perkara_ikrar_talak', $dataverzet);

			$title = "DELETE DATA PENETAPAN SIDANG PERTAMA IKRAR TALAK dari halaman <b>PENETAPAN SIDANG PERTAMA IKRAR TALAK</b> dengan Primary Key [perkara_id=".$idperkara."]";
			$this->add_audittrail("DELETE",$title,'DELETE DATA PENETAPAN SIDANG PERTAMA IKRAR TALAK','perkara_ikrar_talak');

			$this->db->where('perkara_id',$idperkara);
			$this->db->where('id',$idsidang);
			$this->db->delete('perkara_jadwal_sidang');

			$this->db->where('perkara_id',$idperkara);
			$this->db->where('proses_id',293);
			$this->db->delete('perkara_proses');

			$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function deleteDataPenJurusita($idperkara){
		try {
			$dataverzet['penetapan_jurusita'] = NULL;
			$dataverzet['jurusita_id'] = NULL;
			$dataverzet['jurusita_text'] = NULL;
			$dataverzet['diperbaharui_oleh'] = $this->session->userdata('username');
			$dataverzet['diperbaharui_tanggal'] = date('Y-m-d H:i:s');

			$this->db->where('perkara_id', $idperkara);
			$this->db->update('perkara_ikrar_talak', $dataverzet);

			$title = "DELETE DATA PENETAPAN JURUSITA IKRAR TALAK dari halaman <b>PENETAPAN JURUSITA IKRAR TALAK</b> dengan Primary Key [perkara_id=".$idperkara."]";
			$this->add_audittrail("DELETE",$title,'DELETE DATA PENETAPAN JURUSITA VERZET','perkara_ikrar_talak');

			$this->db->where('perkara_id',$idperkara);
			$this->db->where('proses_id',292);
			$this->db->delete('perkara_proses');

			$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function deleteDataPenPanitera($idperkara){
		try {
			$this->db->query("DELETE FROM perkara_panitera_pn WHERE tahapan_id = 18 AND aktif='Y' AND perkara_id =".$idperkara);
			
			$result = $this->db->query("SELECT * FROM perkara_panitera_pn WHERE tahapan_id = 18 AND perkara_id =".$idperkara." ORDER BY id DESC LIMIT 0,2");
			
			$dataverzet['penetapan_panitera_pengganti'] = NULL;
			$dataverzet['panitera_pengganti_id'] = NULL;
			$dataverzet['panitera_pengganti_text'] = NULL;

			if(!empty($result)){
				if($result->num_rows>0){
					foreach ($result->result() as $row) {
						if($row->urutan==2){
							$dataverzet['panitera_pengganti_id'] .= $row->panitera_id;
							$dataverzet['panitera_pengganti_text'] .= $row->panitera_nama;
							$this->db->query("UPDATE perkara_panitera_pn SET aktif='Y' WHERE id = ".$row->id);
						}

						if($row->urutan==1){
							if(!empty($dataverzet['panitera_pengganti_text'])){
								$dataverzet['panitera_pengganti_id'] = ','.$dataverzet['panitera_pengganti_id'];
								$dataverzet['panitera_pengganti_text'] = '<br>'.$dataverzet['panitera_pengganti_text'];
							}
							$dataverzet['panitera_pengganti_text'] = 'Panitera : '.$row->panitera_nama.$dataverzet['panitera_pengganti_text'];
							$dataverzet['panitera_pengganti_id'] = $row->panitera_id.$dataverzet['panitera_pengganti_id'];
							$dataverzet['penetapan_panitera_pengganti'] = $row->tanggal_penetapan;
							$this->db->query("UPDATE perkara_panitera_pn SET aktif='Y' WHERE id = ".$row->id);
							break;
						}
					}
				}
			}
			
			$dataverzet['diperbaharui_oleh'] = $this->session->userdata('username');
			$dataverzet['diperbaharui_tanggal'] = date('Y-m-d H:i:s');

			$this->db->where('perkara_id', $idperkara);
			$this->db->update('perkara_ikrar_talak', $dataverzet);

			$title = "DELETE DATA PENETAPAN PANITERA PENGGANTI IKRAR TALAK dari halaman <b>PENETAPAN PANITERA PENGGANTI IKRAR TALAK</b> dengan Primary Key [perkara_id=".$idperkara."]";
			$this->add_audittrail("DELETE",$title,'DELETE DATA PENETAPAN PANITERA PENGGANTI IKRAR TALAK','perkara_ikrar_talak');

			$this->db->where('perkara_id',$idperkara);
			$this->db->where('proses_id',291);
			$this->db->delete('perkara_proses');

			$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}
	function deleteDataAktaCerai($idperkara){
			try {			
			$this->db->query("DELETE FROM perkara_akta_cerai WHERE perkara_id =".$idperkara);
			

			$title = "DELETE DATA AKTA CERAI dari halaman <b>EDIT AKTA CERAI</b> dengan Primary Key [perkara_id=".$idperkara."]";
			$this->add_audittrail("DELETE",$title,'DELETE DATA AKTA CERAI','perkara_akta_cerai');

			$this->db->where('perkara_id',$idperkara);
			$this->db->where('proses_id',296);
			$this->db->delete('perkara_proses');

			$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function deleteDataPenHakim($idperkara){
		try {
			$this->db->query("DELETE FROM perkara_hakim_pn WHERE tahapan_id = 18 AND aktif='Y' AND perkara_id =".$idperkara);
			
			$result = $this->db->query("SELECT * FROM perkara_hakim_pn WHERE tahapan_id = 18 AND perkara_id =".$idperkara." ORDER BY id DESC LIMIT 0,3");


			$dataverzet['penetapan_majelis_hakim'] = NULL;
			$dataverzet['majelis_hakim_id'] = NULL;
			$dataverzet['majelis_hakim_nama'] = NULL;
			$dataverzet['majelis_hakim_text'] = NULL;

			if(!empty($result)){
				if($result->num_rows>0){
					foreach ($result->result() as $row) {
						if($row->urutan==3){
							$dataverzet['majelis_hakim_id'] = $row->hakim_id;
							$dataverzet['majelis_hakim_nama'] = $row->hakim_nama;
							$dataverzet['majelis_hakim_text'] = $row->hakim_nama;
							$this->db->query("UPDATE perkara_hakim_pn SET aktif='Y' WHERE id = ".$row->id);
						}

						if($row->urutan==2){
							if(!empty($dataverzet['majelis_hakim_nama'])){
								$dataverzet['majelis_hakim_id'] = ','.$dataverzet['majelis_hakim_id'];
								$dataverzet['majelis_hakim_nama'] = '<br>'.$dataverzet['majelis_hakim_nama'];
								$dataverzet['majelis_hakim_text'] = '<br>'.$dataverzet['majelis_hakim_text'];
							}
							$dataverzet['majelis_hakim_id'] = $row->hakim_id.$dataverzet['majelis_hakim_id'];
							$dataverzet['majelis_hakim_nama'] = $row->hakim_nama.$dataverzet['majelis_hakim_nama'];
							$dataverzet['majelis_hakim_text'] = $row->hakim_nama.$dataverzet['majelis_hakim_text'];
							$this->db->query("UPDATE perkara_hakim_pn SET aktif='Y' WHERE id = ".$row->id);
						}

						if($row->urutan==1){
							if(!empty($dataverzet['majelis_hakim_nama'])){
								$dataverzet['majelis_hakim_id'] = ','.$dataverzet['majelis_hakim_id'];
								$dataverzet['majelis_hakim_nama'] = '<br>'.$dataverzet['majelis_hakim_nama'];
								$dataverzet['majelis_hakim_text'] = '<br>'.$dataverzet['majelis_hakim_text'];
							}
							$dataverzet['majelis_hakim_nama'] = $row->hakim_nama.$dataverzet['majelis_hakim_nama'];
							$dataverzet['majelis_hakim_text'] = 'Majelis Hakim : '.$row->hakim_nama.$dataverzet['majelis_hakim_text'];
							$dataverzet['majelis_hakim_id'] = $row->hakim_id.$dataverzet['majelis_hakim_id'];
							$dataverzet['penetapan_majelis_hakim'] = $row->tanggal_penetapan;
							$this->db->query("UPDATE perkara_hakim_pn SET aktif='Y' WHERE id = ".$row->id);
							break;
						}
					}
				}
			}
			$dataverzet['diperbaharui_oleh'] = $this->session->userdata('username');
			$dataverzet['diperbaharui_tanggal'] = date('Y-m-d H:i:s');

			$this->db->where('perkara_id', $idperkara);
			$this->db->update('perkara_ikrar_talak', $dataverzet);

			$title = "DELETE DATA PENETAPAN MAJELIS HAKIM IKRAR TALAK dari halaman <b>PENETAPAN MAJELIS HAKIM IKRAR TALAK</b> dengan Primary Key [perkara_id=".$idperkara."]";
			$this->add_audittrail("DELETE",$title,'DELETE DATA PENETAPAN MAJELIS HAKIM IKRAR TALAK','perkara_ikrar_talak');

			$this->db->where('perkara_id',$idperkara);
			$this->db->where('proses_id',290);
			$this->db->delete('perkara_proses');

			$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}
	function deleteRowDataPenHakim($idperkara){
		try {
			$this->db->query("DELETE FROM perkara_hakim_pn WHERE tahapan_id = 18 AND aktif='Y' AND perkara_id =".$idperkara);
			
			$result = $this->db->query("SELECT * FROM perkara_hakim_pn WHERE tahapan_id = 18 AND perkara_id =".$idperkara." ORDER BY id DESC LIMIT 0,3");


			$dataverzet['penetapan_majelis_hakim'] = NULL;
			$dataverzet['majelis_hakim_id'] = NULL;
			$dataverzet['majelis_hakim_nama'] = NULL;
			$dataverzet['majelis_hakim_text'] = NULL;

			if(!empty($result)){
				if($result->num_rows>0){
					foreach ($result->result() as $row) {
						if($row->urutan==3){
							$dataverzet['majelis_hakim_id'] = $row->hakim_id;
							$dataverzet['majelis_hakim_nama'] = $row->hakim_nama;
							$dataverzet['majelis_hakim_text'] = $row->hakim_nama;
							$this->db->query("UPDATE perkara_hakim_pn SET aktif='Y' WHERE id = ".$row->id);
						}

						if($row->urutan==2){
							if(!empty($dataverzet['majelis_hakim_nama'])){
								$dataverzet['majelis_hakim_id'] = ','.$dataverzet['majelis_hakim_id'];
								$dataverzet['majelis_hakim_nama'] = '<br>'.$dataverzet['majelis_hakim_nama'];
								$dataverzet['majelis_hakim_text'] = '<br>'.$dataverzet['majelis_hakim_text'];
							}
							$dataverzet['majelis_hakim_id'] = $row->hakim_id.$dataverzet['majelis_hakim_id'];
							$dataverzet['majelis_hakim_nama'] = $row->hakim_nama.$dataverzet['majelis_hakim_nama'];
							$dataverzet['majelis_hakim_text'] = $row->hakim_nama.$dataverzet['majelis_hakim_text'];
							$this->db->query("UPDATE perkara_hakim_pn SET aktif='Y' WHERE id = ".$row->id);
						}

						if($row->urutan==1){
							if(!empty($dataverzet['majelis_hakim_nama'])){
								$dataverzet['majelis_hakim_id'] = ','.$dataverzet['majelis_hakim_id'];
								$dataverzet['majelis_hakim_nama'] = '<br>'.$dataverzet['majelis_hakim_nama'];
								$dataverzet['majelis_hakim_text'] = '<br>'.$dataverzet['majelis_hakim_text'];
							}
							$dataverzet['majelis_hakim_nama'] = $row->hakim_nama.$dataverzet['majelis_hakim_nama'];
							$dataverzet['majelis_hakim_text'] = 'Majelis Hakim : '.$row->hakim_nama.$dataverzet['majelis_hakim_text'];
							$dataverzet['majelis_hakim_id'] = $row->hakim_id.$dataverzet['majelis_hakim_id'];
							$dataverzet['penetapan_majelis_hakim'] = $row->tanggal_penetapan;
							$this->db->query("UPDATE perkara_hakim_pn SET aktif='Y' WHERE id = ".$row->id);
							break;
						}
					}
				}
			}
			$dataverzet['diperbaharui_oleh'] = $this->session->userdata('username');
			$dataverzet['diperbaharui_tanggal'] = date('Y-m-d H:i:s');

			$this->db->where('perkara_id', $idperkara);
			$this->db->delete('perkara_ikrar_talak');

			$title = "DELETE DATA PENETAPAN MAJELIS HAKIM IKRAR TALAK dari halaman <b>PENETAPAN MAJELIS HAKIM IKRAR TALAK</b> dengan Primary Key [perkara_id=".$idperkara."]";
			$this->add_audittrail("DELETE",$title,'DELETE DATA PENETAPAN MAJELIS HAKIM IKRAR TALAK','perkara_ikrar_talak');

			$this->db->where('perkara_id',$idperkara);
			$this->db->where('proses_id',290);
			$this->db->delete('perkara_proses');

			$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function updateDataPenetapan($idperkara,$dataPenetapan){
		try {
			$this->db->where('perkara_id', $idperkara);
			$this->db->update('perkara_ikrar_talak', $dataPenetapan);

			$title = "UPDATE TABLE <b>perkara_ikrar_talak</b> dari halaman <b>PENETAPAN IKRAR TALAK</b> dengan Primary Key [perkara_id=".$idperkara."]";
			$descrip = $this->fetch_description($title,$dataPenetapan);
			$this->add_audittrail("UPDATE",$title,$descrip,'perkara_ikrar_talak');

			$this->db->simple_query("CALL perkara_proses_update(".$idperkara.", 18, 'Ikrar Talak', 295, 'Penetapan Ikrar Talak', '".$dataPenetapan['tgl_ikrar_talak']."', '', '".$this->session->userdata('username')."', '".date('Y-m-d H:i:s')."');");
			$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function getTglPutusanVerzet($idperkara){
		try {
			$query = $this->db->query("SELECT putusan_verzet FROM perkara_verzet WHERE perkara_id = ".$idperkara.";");
			if($query->num_rows>0){
				return $query->row()->putusan_verzet;
			}
		} catch (Exception $e) {
			return '';
		}
	}

	function updateDataPemberitahuan($idperkara,$dataPemberitahuan){
		try {
			$this->db->where('perkara_id', $idperkara);
			$this->db->update('perkara_verzet', $dataPemberitahuan);

			$title = "UPDATE TABLE <b>perkara_verzet</b> dari halaman <b>PUTUSAN PEMBERITAHUAN</b> dengan Primary Key [perkara_id=".$idperkara."]";
			$descrip = $this->fetch_description($title,$dataPemberitahuan);
			$this->add_audittrail("UPDATE",$title,$descrip,'perkara_verzet');

			if($this->session->userdata('jenis_pengadilan')==3){
				$this->db->simple_query("CALL perkara_proses_update(".$idperkara.", 15, 'Putusan', 218, 'Pemberitahuan Putusan', '".$dataPemberitahuan['pemberitahuan_putusan']."', '', '".$this->session->userdata('username')."', '".date('Y-m-d H:i:s')."');");
			}else{
				$this->db->simple_query("CALL perkara_proses_update(".$idperkara.", 16, 'Verzet', 280, 'Pemberitahuan Hasil Putusan Verzet', '".$dataPemberitahuan['pemberitahuan_putusan']."', '', '".$this->session->userdata('username')."', '".date('Y-m-d H:i:s')."');");
			}
			$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function deleteDataPemberitahuan($idperkara){
		try {
			$dataverzet['pemberitahuan_putusan'] = NULL;
			$dataverzet['pemberitahuan_putusan_verzet_pihak1'] = NULL;
			$dataverzet['pemberitahuan_putusan_verzet_pihak2'] = NULL;
			$dataverzet['diperbaharui_oleh'] = $this->session->userdata('username');
			$dataverzet['diperbaharui_tanggal'] = date('Y-m-d H:i:s');

			$this->db->where('perkara_id', $idperkara);
			$this->db->update('perkara_verzet', $dataverzet);

			$title = "DELETE DATA PEMBERITAHUAN PUTUSAN VERZET dari halaman <b>PEMBERITAHUAN PUTUSAN VERZET</b> dengan Primary Key [perkara_id=".$idperkara."]";
			$this->add_audittrail("DELETE",$title,'DELETE DATA PEMBERITAHUAN PUTUSAN VERZET','perkara_verzet');

			$this->db->where('perkara_id',$idperkara);
			if($this->session->userdata('jenis_pengadilan')==3){
				$this->db->where('proses_id',218);
				$this->db->or_where('proses_id',17);
			}else{
				$this->db->where('proses_id',280);
			}
			$this->db->delete('perkara_proses');

			$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function deleteDataPutusan($idperkara){
		try {
			$dataverzet['tgl_ikrar_talak'] = NULL;
			$dataverzet['status_penetapan_ikrar_talak_id'] = NULL;			
			$dataverzet['amar_ikrar_talak'] = NULL;			
			$dataverzet['diperbaharui_oleh'] = $this->session->userdata('username');
			$dataverzet['diperbaharui_tanggal'] = date('Y-m-d H:i:s');

			$this->db->where('perkara_id', $idperkara);
			$this->db->update('perkara_ikrar_talak', $dataverzet);

			$dataakta['keadaan_istri'] = NULL;
			$this->db->where('perkara_id', $idperkara);
			$this->db->update('perkara_akta_cerai', $dataakta);

			$title = "DELETE DATA PENETAPAN IKRAR TALAK dari halaman <b>EDIT PENETAPAN IKRAR TALAK</b> dengan Primary Key [perkara_id=".$idperkara."]";
			$this->add_audittrail("DELETE",$title,'DELETE DATA PENETAPAN IKRAR TALAK','perkara_ikrar_talak');

			$this->db->where('perkara_id',$idperkara);
			$this->db->where('proses_id',295);
			$this->db->delete('perkara_proses');

			$this->db->simple_query("CALL perkara_update_status(".$idperkara.");");
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function getTglPemberitahuanPihak1($idperkara){
		try {
			$query = $this->db->query("SELECT pemberitahuan_putusan_verzet_pihak1 FROM perkara_verzet WHERE perkara_id = ".$idperkara.";");
			if($query->num_rows>0){
				return $query->row()->pemberitahuan_putusan_verzet_pihak1;
			}
		} catch (Exception $e) {
			return '';
		}
	}
}

