<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

class m_template_tun_akta_banding extends CI_Model {
	function getListPihak($idperkara,$pihakke){
		try {
			if(!is_numeric($idperkara) OR !is_numeric($pihakke)){
				return '';
			}
			return $this->db->query('SELECT pihak_id,nama FROM perkara_pihak'.$pihakke.' WHERE perkara_id='.$idperkara);
		} catch (Exception $e) {
			
		}
	}

	function getFilename($idalurperkara,$idtahapan){
		try{
			if(!is_numeric($idalurperkara) OR !is_numeric($idtahapan)){
				return '';
		}
		return $this->db->query('SELECT * FROM template_dokumen WHERE alur_perkara_id='.$idalurperkara.' AND tahapan_id='.$idtahapan.' AND nomor<=300;');
	} catch (Exception $e){
		}
	}

	function getDataPerkara($idperkara){
		try {
			if(!is_numeric($idperkara)){
					return '';
				}
			return $this->db->query('SELECT nomor_perkara,nomor_surat,tanggal_surat, tanggal_pendaftaran FROM perkara WHERE perkara_id ='.$idperkara);
		} catch(PDOException $e) {		
		}
	}
	function getTanggalPutusan($idperkara){
		try {
			if(!is_numeric($idperkara)){
					return '';
				}
			return $this->db->query('SELECT pp.tanggal_putusan, pp.amar_putusan,pb.nomor_putusan_banding,pb.amar_putusan_banding,pb.putusan_banding
					FROM perkara_putusan AS pp
					LEFT JOIN ((SELECT * FROM perkara_banding  WHERE perkara_id='.$idperkara.') AS pb)  ON pb.perkara_id=pp.perkara_id
					WHERE pp.perkara_id ='.$idperkara);
		} catch(PDOException $e) {		
		}
	}
	function getDataPN(){
		try {
			return $this->db->query ("SELECT * FROM 
					(SELECT value AS NamaPN FROM sys_config WHERE id = 62) AS T1,
					(SELECT value AS Panses FROM sys_config WHERE id = 68) AS T2,
					(SELECT value AS AlamatPN FROM sys_config WHERE id = 63) AS T3,
					(SELECT value AS Wapan FROM sys_config WHERE id = 70) AS T4,
					(SELECT value AS ZonaWaktu FROM sys_config WHERE id = 75) AS T5,
					(SELECT value AS NamaPT FROM sys_config WHERE id = 76) AS T6;");
			} catch(PDOException $e) {
			}
	}
	function infoPembanding($idperkara,$idpihak){
		try{
			if(!is_numeric($idperkara) OR !is_numeric($idpihak)){
				return '';
		}
		return $this->db->query("SELECT pbd.pihak_asal_text,pbd.permohonan_banding,pbd.pemohon_nama,pbd.pemohon_tanggal_surat,pbd.pemohon_nomor_surat, pihak.nama,pihak.warga_negara,pihak.alamat,pihak.pekerjaan 
							FROM perkara_banding_detil AS pbd
							LEFT JOIN pihak AS pihak ON pihak.id=pbd.pemohon_id
							WHERE pbd.perkara_id=".$idperkara." AND pbd.pemohon_id=".$idpihak);
	} catch (Exception $e){
		}
	}

	function infoPihak($idperkara,$idpihak){
		try{
			if(!is_numeric($idperkara) OR !is_numeric($idpihak)){
				return '';
		}
		return $this->db->query("SELECT pbd.pihak_asal_text,pihak.nama,pihak.warga_negara,pihak.alamat,pihak.pekerjaan,pihak.jenis_pihak_id,pbd.pemberitahuan_permohonan_banding
							FROM perkara_banding_detil AS pbd
							LEFT JOIN pihak AS pihak ON pihak.id=pbd.pihak_id
							WHERE pbd.perkara_id=".$idperkara." AND pbd.pihak_id=".$idpihak);
	} catch (Exception $e){
		}
	}

	function infoTglBandingAll($idperkara){
		try {
			return $this->db->query ("SELECT permohonan_banding, pemohon_nama
							FROM perkara_banding_detil 
							WHERE perkara_id=$idperkara AND permohonan_banding IS NOT NULL;");
			} catch(PDOException $e) {
			}
	}
	function infoTglTerimaMemori($idperkara){
		try {
			return $this->db->query ("SELECT penerimaan_memori_banding, pihak_nama
							FROM perkara_banding_detil 
							WHERE perkara_id=$idperkara AND penerimaan_memori_banding IS NOT NULL;");
			} catch(PDOException $e) {
			}
	}
	function infoTglTerimaKontraMemori($idperkara){
		try {
			return $this->db->query ("SELECT penerimaan_kontra_banding, pihak_nama
							FROM perkara_banding_detil 
							WHERE perkara_id=$idperkara AND penerimaan_kontra_banding IS NOT NULL;");
			} catch(PDOException $e) {
			}
	}	
	
	function infoAllPembanding($idperkara){
		try {
			return $this->db->query ("SELECT pbd.permohonan_banding,pbd.pemohon_nama,pbd.pemohon_tanggal_surat,pbd.pemohon_nomor_surat, pihak.nama, pihak.alamat,pihak.pekerjaan,pihak.jenis_pihak_id,pbd.pihak_asal_text,pbd.pihak_asal
							FROM perkara_banding_detil AS pbd
							LEFT JOIN (SELECT * FROM pihak WHERE id IN (SELECT pihak_id FROM perkara_banding_detil WHERE perkara_id=$idperkara)) AS pihak ON pihak.id=pbd.pihak_id
							WHERE pbd.perkara_id=$idperkara AND pbd.status_pihak_id IN (1,2,4) AND pbd.pemohon_id IS NOT NULL;");
			} catch(PDOException $e) {
			}
	}
	function infoAllTerbanding($idperkara){
		try {
			return $this->db->query ("SELECT pbd.pihak_asal,pbd.pihak_asal_text,pihak.nama, pihak.alamat,pihak.pekerjaan,pihak.jenis_pihak_id,pbd.status_pihak_text
							FROM perkara_banding_detil AS pbd
							LEFT JOIN (SELECT * FROM pihak WHERE id IN (SELECT pihak_id FROM perkara_banding_detil WHERE perkara_id=$idperkara)) AS pihak ON pihak.id=pbd.pihak_id
							WHERE pbd.perkara_id=$idperkara AND pbd.status_pihak_id IN (3,4,5);");
			} catch(PDOException $e) {
			}
	}
	function infoKuasaPihak($idperkara,$idpihak){
		try{
			if(!is_numeric($idperkara) OR !is_numeric($idpihak)){
				return '';
		}
		return $this->db->query("SELECT  pbd.permohonan_banding, pbd.pemohon_tanggal_surat AS tglKuasa, pbd.pemohon_nomor_surat AS nomorKuasa, p.nama,p.alamat,p.pekerjaan,pbd.pihak_nama AS pihakdiwakili
							FROM perkara_banding_detil pbd
							LEFT JOIN pihak AS p ON pbd.pemohon_id=p.id 
							WHERE pemohon_id =$idpihak
							AND perkara_id =$idperkara AND pihak_diwakili='Y';");
	} catch (Exception $e){
		}
	}
	
	function getDataPihakBanding($idperkara,$idpemohon){
		try {
			if(!is_numeric($idperkara) AND !is_numeric($idpemohon)){
					return '';
				}
			return $this->db->query('SELECT perkara_id as IDPerkara,pihak_nama AS nama,permohonan_banding AS tglPemberitahuan, penerimaan_memori_banding AS tglmemori, penerimaan_kontra_banding AS tglkontramemori, pihak_id AS IDPihak, pihak_asal AS pihakke,status_pihak_text, tanggal_cabut FROM perkara_banding_detil WHERE perkara_id ='.$idperkara.' AND pemohon_id ='.$idpemohon);
		} catch(PDOException $e) {		
		}
	}
	function getDataPihak($idperkara,$idpemohon){
		try {
			if(!is_numeric($idperkara) AND !is_numeric($idpemohon)){
					return '';
				}
			return $this->db->query('SELECT perkara_id as IDPerkara,pihak_nama AS nama,permohonan_banding AS tglPemberitahuan, penerimaan_memori_banding AS tglmemori, penerimaan_kontra_banding AS tglkontramemori, pihak_id AS IDPihak, pihak_asal AS pihakke,status_pihak_text FROM perkara_banding_detil WHERE perkara_id ='.$idperkara.' AND pihak_id ='.$idpemohon);
		} catch(PDOException $e) {		
		}
	}
	function getDataTerdakwa($idperkara,$idpemohon){
		try {
			if(!is_numeric($idperkara) AND !is_numeric($idpemohon)){
					return '';
				}
			return $this->db->query('SELECT pihak_nama AS nama,pihak_id AS IDPihak, pihak_asal AS pihakke, permohonan_banding AS tglPemberitahuan, penerimaan_memori_banding AS tglMemori 
				FROM perkara_banding_detil WHERE perkara_id ='.$idperkara.' AND pihak_id ='.$idpemohon);
		} catch(PDOException $e) {		
		}
	}
	function getKuasaPenggugat($idperkara,$idpihak){
		try {
			if(!is_numeric($idperkara) AND !is_numeric($idpihak)){
					return '';
				}
			return $this->db->query("SELECT  pemohon_nama AS nama, pemohon_id AS IDPihak, pihak_asal AS pihakke, permohonan_banding AS tglPemberitahuan, pemohon_tanggal_surat AS tglKuasa, pemohon_nomor_surat AS nomorKuasa, penerimaan_memori_banding AS tglMemori 
						FROM perkara_banding_detil 
						WHERE pemohon_id NOT IN (SELECT pihak_id FROM perkara_pihak2 WHERE perkara_id =$idperkara)
						AND perkara_id =$idperkara AND pihak_asal = 1 AND pihak_id=$idpihak AND pihak_diwakili='Y' ");
		} catch(PDOException $e) {		
		}
	}
	function getKuasaTergugat($idperkara,$idpihak){
		try {
			if(!is_numeric($idperkara) AND !is_numeric($idpihak)){
					return '';
				}
			return $this->db->query("SELECT  pemohon_nama AS nama, pemohon_id AS IDPihak, pihak_asal AS pihakke, permohonan_banding AS tglPemberitahuan, pemohon_tanggal_surat AS tglKuasa, pemohon_nomor_surat AS nomorKuasa, penerimaan_memori_banding AS tglMemori 
						FROM perkara_banding_detil 
						WHERE pemohon_id NOT IN (SELECT pihak_id FROM perkara_pihak1 WHERE perkara_id =$idperkara)
						AND perkara_id =$idperkara AND pihak_asal = 2 AND pihak_id=$idpihak AND pihak_diwakili='Y' ");
		} catch(PDOException $e) {		
		}
	}
	function getKuasaIntervensi($idperkara,$idpihak){
		try {
			if(!is_numeric($idperkara) AND !is_numeric($idpihak)){
					return '';
				}
			return $this->db->query("SELECT  pemohon_nama AS nama, pemohon_id AS IDPihak, pihak_asal AS pihakke, permohonan_banding AS tglPemberitahuan, pemohon_tanggal_surat AS tglKuasa, pemohon_nomor_surat AS nomorKuasa, penerimaan_memori_banding AS tglMemori 
						FROM perkara_banding_detil 
						WHERE pemohon_id NOT IN (SELECT pihak_id FROM perkara_pihak1 WHERE perkara_id =$idperkara)
						AND pemohon_id NOT IN ((SELECT pihak_id FROM perkara_pihak2 WHERE perkara_id =$idperkara))
						AND perkara_id =$idperkara AND pihak_asal = 3 AND pihak_id=$idpihak AND pihak_diwakili='Y' ");
		} catch(PDOException $e) {		
		}
	}
	function infoKuasaPenggugat($idperkara,$idpihak){
		try {
			if(!is_numeric($idperkara) AND !is_numeric($idpihak)){
					return '';
				}
			return $this->db->query("SELECT  pemohon_nama AS nama, pemohon_id AS IDPihak, pihak_asal AS pihakke, permohonan_banding AS tglPemberitahuan, pemohon_tanggal_surat AS tglKuasa, pemohon_nomor_surat AS nomorKuasa, penerimaan_memori_banding AS tglMemori 
						FROM perkara_banding_detil 
						WHERE perkara_id =$idperkara AND pihak_asal = 1 AND pemohon_id=$idpihak AND pihak_diwakili='Y' ");
		} catch(PDOException $e) {		
		}
	}
	function infoKuasaTergugat($idperkara,$idpihak){
		try {
			if(!is_numeric($idperkara) AND !is_numeric($idpihak)){
					return '';
				}
			return $this->db->query("SELECT  pemohon_nama AS nama, pemohon_id AS IDPihak, pihak_asal AS pihakke, permohonan_banding AS tglPemberitahuan, pemohon_tanggal_surat AS tglKuasa, pemohon_nomor_surat AS nomorKuasa, penerimaan_memori_banding AS tglMemori 
						FROM perkara_banding_detil 
						WHERE perkara_id =$idperkara AND pihak_asal = 2 AND pemohon_id=$idpihak AND pihak_diwakili='Y' ");
		} catch(PDOException $e) {		
		}
	}
	function infoKuasaIntervensi($idperkara,$idpihak){
		try {
			if(!is_numeric($idperkara) AND !is_numeric($idpihak)){
					return '';
				}
			return $this->db->query("SELECT  pemohon_nama AS nama, pemohon_id AS IDPihak, pihak_asal AS pihakke, permohonan_banding AS tglPemberitahuan, pemohon_tanggal_surat AS tglKuasa, pemohon_nomor_surat AS nomorKuasa, penerimaan_memori_banding AS tglMemori 
						FROM perkara_banding_detil 
						WHERE perkara_id =$idperkara AND pihak_asal = 3 AND pemohon_id=$idpihak AND pihak_diwakili='Y' ");
		} catch(PDOException $e) {		
		}
	}
	//-----------------end
	function getDataBandingPT($idperkara){
		try {
			if(!is_numeric($idperkara)){
					return '';
				}
			return $this->db->query('SELECT nomor_perkara_banding, putusan_banding AS tglPutusanBanding, amar_putusan_banding
				FROM perkara_banding WHERE perkara_id='.$idperkara);
		} catch(PDOException $e) {		
		}
	}
	
	
	function getAllTerdakwa($idperkara){
		try {
			if(!is_numeric($idperkara)){
					return '';
				}
			return $this->db->query('SELECT pihak_id AS IDPihak, pihak_nama AS nama 
				FROM perkara_banding_detil WHERE perkara_id ='.$idperkara.' AND pihak_asal=2');
		} catch(PDOException $e) {		
		}
	}
	function getTerdakwaKontraMemori($idperkara){
		try {
			if(!is_numeric($idperkara)){
					return '';
				}
			return $this->db->query('SELECT pihak_nama AS nama,pihak_id AS IDPihak, 
				pihak_asal AS pihakke, 
				permohonan_banding AS tglPemberitahuan, 
				penerimaan_memori_banding AS tglMemori, penyerahan_memori_banding AS tglPenyerahanMemori,
				penerimaan_kontra_banding AS tglKontraMemori 
				FROM perkara_banding_detil 
				WHERE perkara_id ='.$idperkara.' AND pihak_asal !=1 AND status_pihak_id IN (4,5)');
		} catch(PDOException $e) {		
		}
	}
	function relaasTerdakwaPembanding($idpihak){
		try {
			if(!is_numeric($idpihak)){
					return '';
				}
			return $this->db->query('SELECT pihak_id, pihak_nama, status_pihak_text, penerimaan_memori_banding, penyerahan_kontra_banding, pemberitahuan_inzage, pemberitahuan_putusan_banding
				FROM perkara_banding_detil 
				WHERE pihak_id ='.$idpihak.' AND pihak_asal !=1 AND status_pihak_id=1');
		} catch(PDOException $e) {		
		}
	}
	function getDataTerdakwaBanding($idperkara,$idpihak){
		try {
			if(!is_numeric($idperkara) OR !is_numeric($idpihak)){
					return '';
				}				
			return $this->db->query('SELECT 
									  pbd.pihak_id,
									  p.tanggal_pendaftaran,
									  pp.nama,
									  pp.tempat_lahir,  
									  pp.tanggal_lahir,
									  (YEAR(p.tanggal_pendaftaran) - YEAR(pp.tanggal_lahir)) AS umur,
									  pp.warga_negara,
									  pp.alamat,
									  pp.agama_nama,
									  pp.pekerjaan,
									  pp.jenis_kelamin, 
                                      pp2.nrp, 
                                      pp2.kesatuan, 
                                      pp2.pangkat, 
                                      pp2.jabatan, 
                                      pp2.nama
									FROM perkara AS p
									LEFT JOIN perkara_banding_detil AS pbd ON p.perkara_id = pbd.perkara_id
									LEFT JOIN pihak AS pp ON pp.id = pbd.pihak_id
									LEFT JOIN perkara_pihak2 as pp2 ON pp2.perkara_id = p.perkara_id and pp2.pihak_id = pp.id 
									WHERE pbd.perkara_id ='.$idperkara.' AND pbd.pihak_id ='.$idpihak);
		} catch(PDOException $e) {		
		}
	}
	function getTanggalPemberitahuan($idperkara,$idstatus){
		try {
			if(!is_numeric($idperkara) OR !is_numeric($idstatus)){
					return '';
				}
			return $this->db->query('SELECT * FROM perkara_banding_detil WHERE perkara_id ='.$idperkara.' AND status_pihak_id ='.$idstatus);
		} catch(PDOException $e) {		
		}
	}
	
	function getPHKontraMemoriBanding($idperkara){
		try {
			if(!is_numeric($idperkara)){
					return '';
				}
			return $this->db->query('SELECT  pemohon_nama AS nama, pemohon_id AS IDPihak, 
					pihak_asal AS pihakke, permohonan_banding AS tglPemberitahuan, 
					pemohon_tanggal_surat AS tglKuasa, pemohon_nomor_surat AS nomorKuasa, penerimaan_kontra_banding AS tglKontraMemori 
                    FROM perkara_banding_detil 
                    WHERE pemohon_id NOT IN (SELECT pihak_id FROM perkara_pihak2 WHERE perkara_id ='.$idperkara.')
                    AND perkara_id ='.$idperkara.'
                    AND pihak_asal != 1
                    AND status_pihak_id IN (4,5)');
		} catch(PDOException $e) {		
		}
	}
	function getDataBandingParties($idperkara,$idpemohon){
		try {
			if(!is_numeric($idperkara)OR !is_numeric($idpemohon)){
					return '';
				}
			$sql="SELECT 	a.pemohon_nama as pemohonbanding,
						a.penerimaan_memori_banding as tglPenerimaan,
						a.pemohon_tanggal_surat as tglKuasa,
						a.pemohon_nomor_surat as nomorKuasa,
						b.nama, 	 
						c.jenis_kelamin, 
						c.tempat_lahir,
						c.tanggal_lahir,
						c.pekerjaan,
						c.warga_negara,
						b.alamat,
						c.agama_nama,
						c.jenis_kelamin
				FROM perkara_banding_detil a, perkara_pihak2 b, pihak c
				WHERE a.pihak_id = b.pihak_id
				AND b.pihak_id=c.id				
				AND a.perkara_id ='$idperkara'
				AND a.pemohon_id ='$idpemohon'
				AND a.pihak_asal !=1";
				$query=$this->db->query($sql);
				return $query;
		} catch(PDOException $e) {		
		}
	}
	function getDataBandingParties2($idperkara){
		try {
			if(!is_numeric($idperkara)){
					return '';
				}
			$sql="SELECT	a.permohonan_banding, b.nama, c.jenis_kelamin, 
						c.tempat_lahir,
						c.tanggal_lahir,
						c.pekerjaan,
						c.warga_negara,
						b.alamat,
						c.agama_nama
				FROM perkara_banding_detil a, perkara_pihak2 b, pihak c
				WHERE a.pihak_id = b.pihak_id
				AND b.pihak_id=c.id				
				AND a.perkara_id ='$idperkara'				
				AND a.pihak_asal !=1";
			$query=$this->db->query($sql);
			return $query;
		} catch(PDOException $e) {		
		}
	}
	function getDataJaksa($idperkara,$idpemohon){
		try {
			if(!is_numeric($idperkara) AND !is_numeric($idpemohon)){
					return '';
				}
			return $this->db->query('SELECT pihak_nama AS nama,pihak_id AS IDPihak, pihak_asal AS pihakke, permohonan_banding AS tglPemberitahuan, penerimaan_memori_banding AS tglMemori FROM perkara_banding_detil WHERE perkara_id='.$idperkara.' AND pemohon_id='.$idpemohon);
		} catch(PDOException $e) {		
		}
	}
	function getInfoPihak($idperkara,$idpihak){
		try {
			if(!is_numeric($idperkara) AND !is_numeric($idpihak)){
					return '';
				}
			return $this->db->query('SELECT pihak_nama AS nama, pihak_id AS IDPihak FROM perkara_banding_detil WHERE perkara_id='.$idperkara.' AND pihak_id='.$idpihak);
		} catch(PDOException $e) {		
		}
	}
	function getAllJaksa($idperkara){
		try {
			if(!is_numeric($idperkara)){
					return '';
				}
			return $this->db->query('SELECT pihak_id AS IDPihak, pihak_nama AS nama FROM perkara_banding_detil WHERE  perkara_id ='.$idperkara.' AND pihak_asal=1');
		} catch(PDOException $e) {		
		}
	}
	function getJaksaRelaasBanding($idperkara){
		try {
			if(!is_numeric($idperkara)){
					return '';
				}
			return $this->db->query('SELECT pihak_id AS IDPihak, pihak_nama AS nama, pemberitahuan_permohonan_banding, penyerahan_memori_banding, penerimaan_kontra_banding, pemberitahuan_inzage, 
				pemberitahuan_putusan_banding
				FROM perkara_banding_detil 
				WHERE  perkara_id ='.$idperkara.'
				AND status_pihak_id IN (4,5)');
		} catch(PDOException $e) {		
		}
	}
	function getJaksaBanding($idperkara,$idpihak){
		try {
			if(!is_numeric($idperkara) OR !is_numeric($idpihak)){				
					return '';
				}
			return $this->db->query('SELECT pihak_id, pihak_nama, status_pihak_text, penerimaan_memori_banding, penyerahan_kontra_banding, pemberitahuan_inzage, pemberitahuan_putusan_banding
				FROM perkara_banding_detil 
				WHERE perkara_id='.$idperkara.' AND pihak_id ='.$idpihak.' AND pihak_asal =1 AND  status_pihak_id=1');
		} catch(PDOException $e) {		
		}
	}
	function getJaksaKontraBanding($idperkara){
		try {
			if(!is_numeric($idperkara)){
					return '';
				}
			return $this->db->query('SELECT pihak_nama AS nama,pihak_id AS IDPihak, pihak_asal AS pihakke, 
				permohonan_banding AS tglPemberitahuan, penerimaan_kontra_banding AS tglKontraMemori 
				FROM perkara_banding_detil 
				WHERE perkara_id ='.$idperkara.' AND pihak_asal =1 AND status_pihak_id IN (4,5)');
		} catch(PDOException $e) {		
		}
	}
	function cetakDataJaksa($idperkara){
		try {
			if(!is_numeric($idperkara)){
					return '';
				}
			return $this->db->query('SELECT a.permohonan_banding,a.pemohon_nama,b.NIP
					FROM perkara_banding_detil a, pihak_jaksa b
                    WHERE a.pihak_id = b.pihak_id
                    AND perkara_id ='.$idperkara.'
                    AND pihak_asal=1');
		} catch(PDOException $e) {		
		}
	}
	function cetakJaksaKontra($idperkara){
		try {
			if(!is_numeric($idperkara)){
					return '';
				}
			return $this->db->query('SELECT a.pihak_nama,b.NIP
					FROM perkara_banding_detil a, pihak_jaksa b
                    WHERE a.pihak_id = b.pihak_id
                    AND perkara_id ='.$idperkara.'
                    AND status_pihak_id IN (4,5)');
		} catch(PDOException $e) {		
		}
	}
	function cetakJaksaParties($idperkara){
		try {
			if(!is_numeric($idperkara)){
					return '';
				}
			$sql="SELECT a.permohonan_banding as tglbandingPu, a.pihak_nama as nama, b.NIP, a.pihak_asal_text as pekerjaan
					FROM perkara_banding_detil a, pihak_jaksa b
                    WHERE a.pihak_id = b.pihak_id AND pihak_asal = 1
                    AND perkara_id ='$idperkara'";
            $query=$this->db->query($sql);
            return $query;
		} catch(PDOException $e) {		
		}
	}
	function pembuatAkta(){
		try {			
			return $this->db->query("SELECT id,CONCAT('Panitera >> [ ',value,' ]') AS namaPanitera FROM sys_config WHERE id = '68' UNION
				SELECT id,CONCAT('Wakil Panitera >> [ ',value,' ]') AS namaPanitera FROM sys_config WHERE id = '70' ");
		} catch(PDOException $e) {				
		}
	}
	function getTanggalCabutBanding($idperkara){
		try{
			if(!is_numeric($idperkara)){
					return '';
		}
		return $this->db->query('SELECT * FROM perkara_banding WHERE perkara_id ='.$idperkara);
		} catch(PDOException $e) {		
		}
	}
	function getAllJurusita(){
		try{			
		return $this->db->query("SELECT id, nama_gelar FROM jurusita WHERE aktif!='T' GROUP BY nama_gelar ASC");
		} catch(PDOException $e) {		
		}
	}
	function cetakJurusita($idjurusita){
		try{
			if(!is_numeric($idjurusita)){
					return '';
		}			
		return $this->db->query("SELECT id, nama_gelar FROM jurusita WHERE id=".$idjurusita);
		} catch(PDOException $e) {		
		}
	}	
	function getTanggalPemberitahuanBanding($idperkara,$idpihak){
		try{
			if(!is_numeric($idperkara) OR !is_numeric($idpihak)){
					return '';
		}
		return $this->db->query('SELECT pihak_id, permohonan_banding, status_pihak_text, pemberitahuan_permohonan_banding AS pemberitahuan, penerimaan_memori_banding, penyerahan_memori_banding, 
			penerimaan_kontra_banding, penyerahan_kontra_banding, pemberitahuan_inzage, pelaksanaan_inzage, pemberitahuan_putusan_banding 
			FROM perkara_banding_detil WHERE   perkara_id='.$idperkara.' AND pihak_id='.$idpihak);
		} catch(PDOException $e) {		
		}
	}
	function cetakPemberitahuanBandingPU($idperkara){
		try{
			if(!is_numeric($idperkara)){
					return '';
		}
		return $this->db->query('SELECT pemberitahuan_permohonan_banding AS pemberitahuan FROM perkara_banding_detil WHERE  pihak_asal=1 AND status_pihak_id!=1 AND perkara_id='.$idperkara);
		} catch(PDOException $e) {		
		}
	}	
	function cetakPemberitahuanPU($idperkara){
		try{
			if(!is_numeric($idperkara)){
					return '';
		}
		return $this->db->query('SELECT a.nama, b.NIP FROM perkara_pihak1 a, pihak_jaksa b WHERE a.pihak_id = b.pihak_id AND perkara_id='.$idperkara);
		} catch(PDOException $e) {		
		}
	}
	function getPihakPembanding($idperkara){
		try{
			if(!is_numeric($idperkara)){
					return '';
		}
		return $this->db->query('SELECT pihak_id AS IDPihak, pihak_nama AS nama, penyerahan_kontra_banding FROM perkara_banding_detil WHERE perkara_id='.$idperkara.' AND status_pihak_id IN (1,2)');
		} catch(PDOException $e) {		
		}
	}
	function getPihakTerbanding($idperkara){
		try{
			if(!is_numeric($idperkara)){
					return '';
		}
		return $this->db->query('SELECT pihak_id AS IDPihak, pihak_nama AS nama, penerimaan_kontra_banding FROM perkara_banding_detil WHERE perkara_id='.$idperkara.' AND status_pihak_id IN (3,4,5)');
		} catch(PDOException $e) {		
		}
	}
	function getAllPihakBanding($idperkara,$idpihak){
		try{
			if(!is_numeric($idperkara) OR !is_numeric($idpihak)){
					return '';
		}
		return $this->db->query('SELECT a.pihak_id, p.nama, p.alamat, p.pekerjaan 
			FROM perkara_banding_detil a LEFT JOIN pihak p 
				ON p.id = a.pihak_id
			WHERE a.perkara_id ='.$idperkara.' AND a.pihak_id ='.$idpihak);
		} catch(PDOException $e) {		
		}
	}

	function infoTglBanding($idperkara){
		try{
			if(!is_numeric($idperkara)){
					return '';
		}
		return $this->db->query('SELECT permohonan_banding FROM perkara_banding_detil WHERE perkara_id='.$idperkara.' AND pihak_asal=2');
		} catch(PDOException $e) {		
		}
	}

function getDataDocumentTemplate($idalurperkara,$idatahapan,$idproses,$notemplate,$keyword)
{
	if (empty($keyword) or $keyword=='')
	{
	$sql="SELECT a.nama AS jnsperkara,b.nomor AS notenmplate,b.kode AS kdtemplate,b.nama AS namatemplate 
			FROM alur_perkara a,template_dokumen b 
			WHERE a.id=b.alur_perkara_id 	AND a.id=$idalurperkara 
											AND b.tahapan_id =$idatahapan 
											AND b.proses_id=$idproses 
											AND b.nomor=$notemplate";
	}
	else
	{
	$sql="SELECT a.nama AS jnsperkara,b.nomor AS notenmplate,b.kode AS kdtemplate,b.nama AS namatemplate 
			FROM alur_perkara a,template_dokumen b 
			WHERE a.id=b.alur_perkara_id 	AND a.id=$idalurperkara 
											AND b.tahapan_id =$idatahapan 
											AND b.proses_id=$idproses 
											AND b.nama LIKE '%$keyword%'";
	}
	$query=$this->db->query($sql);
	return $query;
}

}
	

?>