<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class m_template_putusan_agama extends CI_Model {

	function get_data_putusan($idperkara){
			try {
			if(!is_numeric($idperkara)){
				return '';
			}
			$sql = "SELECT * from (SELECT tanggal_sidang as tanggal_sidang_putusan,(CASE 
										WHEN dihadiri_oleh=1 THEN 'Semua Hadir' 
										WHEN dihadiri_oleh=2 THEN 'Penggugat'
										WHEN dihadiri_oleh=3 THEN 'Tergugat'
										WHEN dihadiri_oleh=4 THEN 'Para Pihak Tidak Hadir'
										WHEN dihadiri_oleh IS NULL THEN '.........'
										END) AS dihadiri_oleh
										FROM perkara_jadwal_sidang WHERE perkara_id=".$idperkara." ORDER BY tanggal_sidang_putusan DESC LIMIT 1) AS akhir_sidang,
									(SELECT tanggal_putusan,
											sumber_hukum_id,
											tanggal_cabut,
											tanggal_gugur,
											amar_putusan,
											tanggal_minutasi FROM perkara_putusan 
											WHERE perkara_id=".$idperkara.") as perkara_putusan";
			return $this->db->query($sql);
				} catch (Exception $e) {
				return '';
			}
	}
		function get_data_dismissal($idperkara){
			try {
				if(!is_numeric($idperkara)){
					return '';
				}
				return $this->db->query("SELECT * FROM perkara_dismissal 
											 WHERE perkara_id=".$idperkara);
				} catch (Exception $e) {
				return '';
			}
		}


	function get_data_pihak($idperkara,$jenispihak){
		try {
			if(!is_numeric($idperkara)){
				return '';
			}
			$sql="SELECT a.nomor_perkara, b.urutan, b.pihak_id as id_pihak,c.pengacara_id as id_kuasa,
					d.nama, (year(now()) - year(d.tanggal_lahir)) as umur, e.nama as agama, 
					d.pekerjaan, f.nama as pendidikan, d.alamat, c.nama as nama_kuasa, c.alamat as alamat_kuasa, c.aktif_mulai as tgl_kuasa
					FROM perkara a 
					join perkara_pihak".$jenispihak." b on a.perkara_id = b.perkara_id
					left join perkara_pengacara c on a.perkara_id = c.perkara_id and b.pihak_id = c.pihak_id
					join pihak d on b.pihak_id = d.id
					join agama e on d.agama_id = e.id
					left join tingkat_pendidikan f on d.pendidikan_id = f.id
					where a.perkara_id = ".$idperkara." 
					order by b.urutan";
			return $this->db->query($sql);
			} catch (Exception $e) {
				return '';
			}	
	}

		function get_data_cabut($idperkara){
			try {
				if(!is_numeric($idperkara)){
					return '';
				}
				return $this->db->query("SELECT * FROM perkara_putusan
											 WHERE status_putusan_id='7' AND perkara_id=".$idperkara);
				} catch (Exception $e) {
				return '';
			}
		}
		function get_data_putusan_sela($idperkara,$idPutusanSela){
			try {
			if(!is_numeric($idperkara)){
				return '';
			}
			return $this->db->query("SELECT * from (SELECT tanggal_sidang as tanggal_sidang_putusan,(CASE 
										WHEN dihadiri_oleh=1 THEN 'Semua Hadir' 
										WHEN dihadiri_oleh=2 THEN 'Penggugat'
										WHEN dihadiri_oleh=3 THEN 'Tergugat'
										WHEN dihadiri_oleh=4 THEN 'Para Pihak Tidak Hadir'
										WHEN dihadiri_oleh IS NULL THEN '.........'
										END) AS dihadiri_oleh
										FROM perkara_jadwal_sidang WHERE perkara_id=".$idperkara." ORDER BY tanggal_sidang_putusan DESC LIMIT 1) AS akhir_sidang,
									(SELECT * FROM perkara_putusan_sela 
											WHERE perkara_id=".$idperkara." AND putusansela_id=".$idPutusanSela.") as perkara_putusan_sela");
				} catch (Exception $e) {
				return '';
			}
		}

		function get_biaya_perkara($idperkara){
			try {
				if(!is_numeric($idperkara)){
					return '';
				}
				return $this->db->query("SELECT a.kategori_id,a.tanggal_transaksi,b.nama,a.jumlah FROM perkara_biaya  AS a
											LEFT JOIN 
											(SELECT * FROM jenis_biaya) AS b
											ON a.`jenis_biaya_id`=b.id AND a.kategori_id=b.kategori_id
											 WHERE perkara_id=".$idperkara);
				} catch (Exception $e) {
				return '';
			}
		}
		
		function get_biaya_ikrar($idperkara){
			try {
				if(!is_numeric($idperkara)){
					return '';
				}
				return $this->db->query("SELECT a.kategori_id,a.tanggal_transaksi,b.nama,a.jumlah, jenis_biaya_id FROM perkara_biaya  AS a
										LEFT JOIN 
										(SELECT * FROM jenis_biaya) AS b
										ON a.jenis_biaya_id=b.id AND a.kategori_id=b.kategori_id 
										LEFT JOIN perkara_ikrar_talak AS c ON a.perkara_id = c.perkara_id
										WHERE a.tanggal_transaksi >= c.tanggal_penetapan_sidang_ikrar AND a.tahapan_id = 10 and a.perkara_id=".$idperkara);
				} catch (Exception $e) {
				return '';
			}
		}

		function getPenetapanPersiapan($idperkara){
			try {
				return $this->db->query( "SELECT tanggal_penetapan_persiapan FROM perkara_persiapan WHERE perkara_id=".$idperkara);
			} catch(Exception $e) {
				return false;
			}
		}


		function get_data_mediasi($idperkara){
			if(empty($idperkara)){ 
					return '';
			}
			try {
				return $this->db->query( "SELECT *  FROM perkara_mediasi WHERE perkara_id=".$idperkara);
			} catch(Exception $e) {
				return false;
			}
		}


		function get_data_penetapan_hakim($idperkara){
			try {
			if(!is_numeric($idperkara)){
				return '';
			}
			$sql = ('SELECT tanggal_penetapan  AS penetapan_majelis,
								    		nomor_sk_penetapan AS nomor_sk_penetapan_majelis,
											urutan AS urutan_hakim,
											jabatan_hakim_nama,
											hakim_nip,
											hakim_nama 
											FROM perkara_hakim_pn WHERE aktif="Y" AND tahapan_id="10" AND perkara_id='.$idperkara);
				return $this->db->query($sql);
			} catch (Exception $e) {
				return '';
			}
		}

		function get_data_penetapan_pp_sidang($idperkara){

			try {
			if(!is_numeric($idperkara)){
				return '';
			}
			$sql = 'SELECT 	a.tanggal_penetapan 	AS penetapan_pp,
							a.nomor_sk_penetapan 	AS nomor_sk_penetapan_pp,
							a.panitera_nama,
							a.panitera_nip,
							b.tanggal_sidang,
							b.jam_sidang
					FROM perkara_panitera_pn a  
					left join perkara_jadwal_sidang b 
						on a.perkara_id = b.perkara_id
					WHERE a.aktif="Y" AND a.perkara_id='.$idperkara.' AND b.urutan=1';

				return $this->db->query($sql);

			} catch (Exception $e) {
				return '';
			}
		}



		function get_data_perkara($idperkara){
		try {
			if(!is_numeric($idperkara)){
				return '';
			}
			$sql = ("SELECT tanggal_pendaftaran,
							jenis_perkara_nama,
							nomor_perkara,
							tanggal_surat,
							nomor_surat,
							dakwaan,
							petitum
							FROM perkara WHERE perkara_id=".$idperkara);
				return $this->db->query($sql);
			} catch (Exception $e) {
				return '';
			}
	}

	function get_data_persiapan($idperkara){
		try {
			if(!is_numeric($idperkara)){
				return '';
			}
			return $this->db->query('SELECT tanggal_penetapan_persiapan,
										  petitum AS petitum_persiapan
											FROM perkara_persiapan  WHERE perkara_id='.$idperkara);
			} catch (Exception $e) {
				return '';
			}
	}

	function get_jenis_perkara($idjenis){
		try {
			if(!is_numeric($idperkara)){
					return '';
			}			
			return $this->db->query('SELECT nama FROM jenis_perkara');
			} catch (Exception $e) {
				return '';
			}
	}

	function get_data_pihak_old($idperkara,$jenispihak){
		try {
			if(!is_numeric($idperkara)){
				return '';
			}
			return $this->db->query('SELECT b.*,  a.*,c.nama AS kewarganegaraan, d.nama as agama, f.nama AS pendidikan,
											group_concat(e.pengacara_id) as pengacara_id 
											FROM pihak AS a
											LEFT JOIN
											(SELECT * FROM perkara_pihak'.$jenispihak.') AS b
											ON a.id=b.pihak_id
											LEFT JOIN
											(SELECT id,nama FROM negara) AS c
											ON a.warga_negara_id=c.id
											LEFT JOIN
											(SELECT id,nama FROM agama) AS d
											ON a.agama_id=d.id
											LEFT JOIN
											(SELECT id,nama FROM tingkat_pendidikan) AS f
											ON a.pendidikan_id=f.id
											LEFT JOIN
											(SELECT pengacara_id, pihak_id, perkara_id FROM perkara_pengacara) AS e
											ON b.pihak_id=e.pihak_id and e.perkara_id=b.perkara_id
											WHERE b.perkara_id='.$idperkara.' GROUP BY b.id ORDER BY b.id ASC');
			} catch (Exception $e) {
				return '';
			}
	}

	function get_data_pengacara($idperkara,$jenispihak){
		try {
			if(!is_numeric($idperkara)){
				return '';
			}
			return $this->db->query ("SELECT a.id,
						GROUP_CONCAT(a.pihak_id SEPARATOR ';') AS pihak_id,
						a.urutan,a.nama,a.alamat,
						a.aktif_mulai,'Indonesia' AS kewarganegaraan,
						b.pekerjaan,b.jenis_pihak_id
					FROM perkara_pengacara AS a
										LEFT JOIN
										(SELECT * FROM pihak ) AS b
										ON b.id=a.pengacara_id
										WHERE a.pihak_id IN 
										(SELECT pihak_id FROM perkara_pihak".$jenispihak." WHERE perkara_id=".$idperkara.")
										AND perkara_id=".$idperkara." 
										GROUP BY a.pengacara_id
										ORDER BY urutan ASC");
			} catch (Exception $e) {
				return '';
			}
	}

	function get_data_pn(){
			try {
				return $this->db->query( "SELECT * FROM 
			(SELECT value AS NamaPN FROM sys_config WHERE id = 62) AS T1,
			(SELECT value AS KetuaPNNama FROM sys_config WHERE id = 64) AS T2,
			(SELECT value AS AlamatPN FROM sys_config WHERE id = 63) AS T3,
			(SELECT value AS WakilKetuaPNNama FROM sys_config WHERE id = 66) AS T4,
			(SELECT value AS PansekPNNama FROM sys_config WHERE id = 68) AS T5,
			(SELECT value AS WaPanNama FROM sys_config WHERE id = 70) AS T6");
				
			} catch(Exception $e) {
				return false;
			}
	}

	function getAlurPerkara($idperkara){
		try {
			return $this->db->query( "SELECT alur_perkara_id FROM perkara WHERE perkara_id=$idperkara ");
			} catch(Exception $e) {
				return false;
			}
	}

	function get_data_pernikahan($idperkara){
		try {
			return $this->db->query( "SELECT * FROM perkara_data_pernikahan WHERE perkara_id=$idperkara ");
			} catch(Exception $e) {
				return false;
			}
	}

	function get_data_ikrar_talak($idperkara){
		try {
			return $this->db->query( "SELECT 	t.penetapan_majelis_hakim 	AS penetapan_majelis_hakim_ikrar ,
												t.majelis_hakim_text 		AS majelis_hakim_text_ikrar,
												t.penetapan_panitera_pengganti 	AS penetapan_panitera_pengganti_ikrar,
												t.panitera_pengganti_text 	AS panitera_pengganti_text_ikrar,
												t.penetapan_jurusita 		AS penetapan_jurusita_ikrar,
												t.jurusita_text 		AS jurusita_text_ikrar,
												t.sidang_id 			AS sidang_id_ikrar,
												t.tanggal_penetapan_sidang_ikrar,
												t.tanggal_sidang_pertama 	AS tgl_sidang_pertama_ikrar,
												t.tgl_ikrar_talak,
												t.status_penetapan_ikrar_talak_id,
												t.amar_ikrar_talak,
											j.tanggal_sidang 		AS tgl_sidang_akhir_ikrar
											FROM perkara_ikrar_talak 	AS t
											LEFT JOIN
											(SELECT id,tanggal_sidang,MAX(urutan) FROM perkara_jadwal_sidang) AS j
											ON t.sidang_id=j.id
										 WHERE perkara_id=$idperkara ");
			} catch(Exception $e) {
				return false;
			}
	}
	function blangko_putusan($alur){
		try{
			$sql = "SELECT kode,nama,nomor 
					FROM template_dokumen 
					WHERE 
					alur_perkara_id=".$alur." AND tahapan_id='15' AND proses_id='210' AND nomor >= 1 and nomor <= 100";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}
	function blangko_pra_persidangan($alur){
		try{
			$sql = "SELECT kode,nama,nomor 
					FROM template_dokumen 
					WHERE (alur_perkara_id='15' OR alur_perkara_id='16') AND tahapan_id='14' AND proses_id='200' AND nomor >= 500 and nomor <= 525";
			$query=$this->db->query($sql);
			return $query;	
		}catch(Exception $e) { return false; }
	}
}										
?>