<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Validated extends CI_Model{
	function getSystemInfo(){
		try {
            if($this->db=='xxx'){
                show_error('Database belum disetting.');
            }
			$this->db->select('*');
			$this->db->where('id >=', 61); 
			return $this->db->get('sys_config');
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function is_logged_in(){
		try {
			$this->db->where('userid',$this->session->userdata('userid'));
			$this->db->where('session_id',$this->session->userdata('session_id'));
			$this->db->where('host_address',$this->session->userdata('host_address'));
			$query = $this->db->get('sys_user_online');
			if($query->num_rows()<1){
				redirect("logout");
			}
		} catch (Exception $e) {
			
		}
	}

	function getListPihakStatus($idtahapan){
    	try {
    		$this->db->where('tahapan_id',$idtahapan);
            $this->db->select('tahapan_id,alur_perkara_id,pihak_ke,nama');
            return $this->db->get('status_pihak');
        } catch (Exception $e) {
            return '';
        }
    }

    function getListLangguage($jenis_pengadilan){
        try {
            $this->db->where('jenis_pengadilan',$jenis_pengadilan);
            $this->db->select('id,jenis_pengadilan,nama,translate');
            return $this->db->get('sys_langguage');
        } catch (Exception $e) {
            return '';
        }
    }

    function getListTahapan(){
        try {
            return $this->db->query('SELECT DISTINCT tahapan_id FROM status_pihak;');
        } catch (Exception $e) {
            return '';
        }
    }

    function setup(){
        $listTahapan = $this->getListTahapan();
        if($listTahapan!=''){
            foreach ($listTahapan->result() as $row) {
                $tahapan = $this->parseStatusPihak($row->tahapan_id);
                $this->nativesession->set('is_status_pihak', TRUE);
                $this->nativesession->set('var_'.$row->tahapan_id, $tahapan);
            }
        }
	}

    function setup_language(){
        $jenis_pengadilan = $this->session->userdata('jenis_pengadilan');
        $listLangguage = $this->getListLangguage($jenis_pengadilan);
        if($listLangguage!=''){
            foreach ($listLangguage->result() as $row) {
                $this->nativesession->set('is_langguage', TRUE);
                $this->nativesession->set($row->nama, $row->translate);
            }
        }
    }

    function parseStatusPihak($idtahapan){
    	$listStatusPihak = $this->getListPihakStatus($idtahapan);
    	$statuspihak = '';
    	if($listStatusPihak!=''){
			if($listStatusPihak->num_rows>0){
				foreach ($listStatusPihak->result() as $row) {
					$statuspihak[$row->alur_perkara_id] = $this->parsePihakKe($listStatusPihak,$row->alur_perkara_id);
				}
			}else{
				$this->error_handle();
			}
		}else{
			$this->error_handle();
		}

		return $statuspihak;
    }

    function parsePihakKe($listStatusPihak,$idalurperkara){
    	$listpihakke = '';
    	foreach ($listStatusPihak->result() as $row) {
    		if($row->alur_perkara_id==$idalurperkara){
    			$listpihakke[$row->pihak_ke] = $row->nama;
    		}
		}
		return $listpihakke;
    }

    function error_handle(){
    	echo "DATABASE ERROR, TABLE TIDAK DITEMUKAN";
    	exit();
    }

    function get_new_message($userid){
        try {
            $result = $this->db->query('SELECT count(id) AS jml FROM v_pesan_masuk WHERE status <2 AND status != -1 AND ke_userid = '.$userid);
            if($result->num_rows>0){
                return $result->row()->jml;
            }
            return 0;
        } catch (Exception $e) {
            
        }
    }
}