<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Biaya_perkara_m_ht extends CI_Model{
	
	function get_biaya_perkara($htid){
		if(empty($htid)) 
			{ 
				return '';
			}
		try {

			$this->db->where('ht_id',$idperkara);
			$this->db->order_by("tahapan_id", "ASC"); 
			$this->db->order_by("tanggal_transaksi", "ASC");
			$this->db->order_by("jenis_transaksi", "DESC"); 
			return $this->db->get('perkara_biaya_ht');#->result_array();

		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function get_jurnal_biaya_perkara($htid,$tahapanidperkara){
		if(empty($htid)) 
			{ 
				return '';
			}
		try {

			$this->db->where('ht_id',$htid);
			$this->db->where('tahapan_id',$tahapanidperkara);
			$this->db->order_by("tanggal_transaksi", "ASC");
			$this->db->order_by("id", "ASC");
			$this->db->order_by("jenis_transaksi", "DESC"); 
			return $this->db->get('perkara_biaya_ht');

		} catch (Exception $e) {
			log_message('error', $e);
		}
	}



	function data_perkara($htid){
		if(empty($htid)) 
			{ 
				return '';
			}
		try {

			$this->db->where('ht_id',$htid);
			return $this->db->get('perkara_eksekusi_ht');

		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function get_kategori_biaya(){
		try {
			$this->db->where("aktif","Y");
			$this->db->order_by("id", "ASC"); 
			return $this->db->get('kategori_biaya');

		} catch (Exception $e) {
			log_message('error', $e);
		}
	}


	function get_jenis_biaya($tahapan){
		try {
			$this->db->where("tahapan_id",$tahapan);
			$this->db->where("aktif","Y");
			$this->db->order_by("id", "ASC"); 
			return $this->db->get('jenis_biaya');

		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function get_detil_biaya($htid){
		try {
			$this->db->where("ht_id",$htid);
			$this->db->group_by("id_pembiayaan"); 
			return $this->db->get('perkara_biaya_ht');

		} catch (Exception $e) {
			log_message('error', $e);
		}
	}
	
	function get_data_edit_biaya($idbiayaperkara){
		try {
			$this->db->where("id",$idbiayaperkara);
			return $this->db->get('perkara_biaya_ht');

		} catch (Exception $e) {
			log_message('error', $e);
		}
	}	

	function get_detil_jenis_biaya($id_jenis_biaya){
		try {
			$this->db->where("id",$id_jenis_biaya);
			return $this->db->get('jenis_biaya');

		} catch (Exception $e) {
			log_message('error', $e);
		}
	}


	function get_maxid_perkara_biaya(){
		
		try {

			$query = $this->db->query('SELECT MAX(id)+1 AS maxid  FROM perkara_biaya_ht');
			return $query;
			
		} catch (Exception $e) {
			log_message('error', $e);
		}
	}

	function add_perkara_biaya($data){
		
		try {
				$this->db->insert('perkara_biaya_ht', $data);

				$title = "Tambah Data Biaya <br />Tambah table <b>Perkara_Biaya</b> dari halaman <b>Tambah Biaya</b> dengan Primary Key [ID=".$data['id']."]";
				$descrip = $this->fetch_description($title,$data);
				$this->add_audittrail("INSERT",$title,$descrip,'perkara_biaya_ht');

				return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function edit_perkara_biaya($data_edit,$idbiayaperkara){
		
		try {
				$table = "perkara_biaya_ht";
				$this->db->where('id', $idbiayaperkara);
				$this->db->update($table, $data_edit);

				$title = "Edit Data Biaya Hak Tanggungan <br />Edit table <b>perkara_biaya_ht</b> dari halaman <b>Biaya Perkara</b> dengan Primary Key [ID Biaya=".$idbiayaperkara."]";
				$descrip = $this->fetch_description($title,$data_edit);
				$this->add_audittrail("EDIT",$title,$descrip,'perkara_biaya');

		}
		catch (Exception $e) {
			return FALSE;
		}
	}

	function hapus_perkara_biaya_ht($idbiayaperkara){
		try {
			$this->db->where('id',$idbiayaperkara);
			$this->db->delete('perkara_biaya_ht');

			$title = "Hapus Biaya <br />Hapus table <b>Perkara_Biaya_ht</b> dari halaman <b>Biaya Perkara</b> dengan Primary Key [ID Biaya=".$idbiayaperkara."]";
			$descrip = '';
			$this->add_audittrail("HAPUS",$title,$descrip,'perkara_biaya_ht');
			
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
		
	}

	function fetch_description($title,$data){
		$descrip = '<br><table style="vertical-align:top" cellspacing="0" cellpadding="1" border="1">';
		$descrip .= '<tr><th>Nama Kolom</th><th>Nilai</th></tr>';
		foreach ($data as $key => $value) {
			$descrip .= '<tr>';
			$descrip .= '<td>'.$key.'</td>';
			$descrip .= '<td>'.$value.'</td>';
			$descrip .= '</tr>';
		}
		$descrip .= '</table>';
		return $descrip;
	}

	function add_audittrail($action,$title,$descrip,$tablename){
		try {
			$data = array(
				'datetime' => date("Y-m-d H:i:s"),
				'ipaddress' => $this->input->ip_address(),
				'username' => $this->session->userdata('username'),
				'tablename' => $tablename,
				'formname' => 'Add Mediasi',
				'action' => $action,
				'title' => $title,
				'description' => $descrip
			);
			$this->db->insert('sys_audittrail', $data);
		} catch (Exception $e) {
			
		}
	}


}

?>