<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class List_Actio_Pauliana extends CI_Model{
	function parseOrderby($col){
		if($col==1){
			return "pp.tanggal_pendaftaran_actio"; 
		}else if($col==2){
			return "pi.nama"; 
		}else if($col==3){
			return "p.nomor_perkara"; 
		}else if($col==4){
			return "p.tanggal_pendaftaran"; 
		}else if($col==5){
			return "p.majelis_hakim_text"; 
		}else if($col==6){
			return "p.panitera_pengganti_text"; 
		}else if($col==7){
			return "p.tanggal_putusan"; 
		}else{
			return "pp.tanggal_pendaftaran_actio";
		}
	}

	function getListActio($col=9,$type='DESC',$begin=0,$idalurperkara,$key=''){
		try {
			$orderby = $this->parseOrderby($col);
			$where = '';
			if(!empty($key)){
				$where .= ' WHERE (pp.tanggal_pendaftaran_actio LIKE "%'.$key.'%" OR 
					p.nomor_perkara LIKE "%'.$key.'%" OR p.tanggal_pendaftaran LIKE "%'.$key.'%" OR
					pi.nama LIKE "%'.$key.'%" OR pi.alamat LIKE "%'.$key.'%"
					OR pi.pekerjaan LIKE "%'.$key.'%" OR p.majelis_hakim_text LIKE "%'.$key.'%"
					OR p.panitera_pengganti_text LIKE "%'.$key.'%") ';
			}
			return $this->db->query("SELECT SQL_CALC_FOUND_ROWS p.perkara_id,
				pp.tanggal_pendaftaran_actio,p.nomor_perkara,p.nomor_perkara,
				pi.nama,pi.alamat,pi.pekerjaan,p.majelis_hakim_text,p.panitera_pengganti_text,
				p.tanggal_putusan,p.tanggal_minutasi,p.tanggal_pendaftaran
				FROM perkara_actio_pauliana AS pp
				LEFT JOIN v_perkara AS p
				ON p.perkara_id = pp.perkara_id
				LEFT JOIN pihak AS pi
				ON pi.id = pp.pemohon_id
				".$where." ORDER BY ".$orderby." ".$type." LIMIT ".$begin.",30;");
		} catch (Exception $e) {
			log_message('error', $e);
			return '';
		}
	}

	function getNomorPerkara($idalurperkara){
		try {
			return $this->db->query('SELECT perkara_id,nomor_perkara FROM perkara WHERE alur_perkara_id IN ('.$idalurperkara.');');
		} catch (Exception $e) {
			return '';
		}
	}

	function getTglPendaftaranKepailitan($idperkara){
		try {
			$result = $this->db->query('SELECT tanggal_pendaftaran FROM perkara WHERE perkara_id = '.$idperkara);
			if($result->num_rows>0){
				return $result->row()->tanggal_pendaftaran;
			}else{
				return '';
			}
		} catch (Exception $e) {
			log_message('error', $e);
			return '';
		}
	}

	function getInfoPerkara($idperkara){
		try {
			return $this->db->query('SELECT perkara_id,nomor_perkara,tanggal_pendaftaran,tanggal_putusan,
				tanggal_minutasi
				FROM v_perkara WHERE perkara_id = '.$idperkara);
		} catch (Exception $e) {
			log_message('error', $e);
			return '';
		}
	}

	function isPerkaraExist($idperkara){
		try {
			$result = $this->db->query('SELECT perkara_id FROM perkara_actio_pauliana WHERE perkara_id = '.$idperkara);
			if($result->num_rows>0){
				return TRUE;
			}else{
				return FALSE;
			}
		} catch (Exception $e) {
			log_message('error', $e);
			return '-1';
		}
	}

	function getInfoActio($idperkara){
		try {
			return $this->db->query('SELECT a.perkara_id,p.nomor_perkara,
				p.tanggal_pendaftaran,p.tanggal_putusan,p.tanggal_minutasi,
				pi.nama, pi.alamat,pi.pekerjaan,tanggal_pendaftaran_actio,a.catatan_pendaftaran,
				pi.id AS idpihak
				FROM perkara_actio_pauliana as a
				LEFT JOIN v_perkara as p
				ON p.perkara_id = a.perkara_id
				LEFT JOIN pihak as pi
				on pi.id = a.pemohon_id
				WHERE a.perkara_id = '.$idperkara);
		} catch (Exception $e) {
			log_message('error', $e);
			return '';
		}
	}
	function getDetilPerkara($idperkara){
		try {
			return $this->db->query('SELECT p.nomor_perkara,p.tanggal_pendaftaran,p.tanggal_putusan,
				p.tanggal_minutasi,p.panitera_pengganti_text,p.majelis_hakim_text,p.amar_putusan,p.para_pihak,
				p.penetapan_majelis_hakim,p.penetapan_panitera_pengganti,p.penetapan_hari_sidang,
				p.sidang_pertama,p.petitum,a.catatan_pendaftaran,pi.nama, pi.alamat,pi.pekerjaan,
				a.tanggal_pendaftaran_actio
				FROM perkara_actio_pauliana AS a
				LEFT JOIN v_perkara AS p
					ON p.perkara_id = a.perkara_id
				LEFT JOIN pihak AS pi
					ON pi.id = a.pemohon_id
				WHERE a.perkara_id = '.$idperkara);
		} catch (Exception $e) {
			return '';
		}
	}

	function fecth_data_num(){
		try {
			$query = $this->db->query("SELECT FOUND_ROWS() as cnt;");
			if($query->num_rows>0){
				foreach ($query->result() as $row) {
					return $row->cnt;
				}
	    		return $query->num_rows;
	    	}else{
	    		return 0;
	    	}
		} catch (Exception $e) {
			
		}
	}

	function getNoUrut(){
		try {
			return $this->db->query("SELECT IFNULL(max(nomor_urut_register)+1,1) as id FROM perkara_penyegelan;")->row()->id;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function fetch_description($title,$data){
		$descrip = '<br><table style="vertical-align:top" cellspacing="0" cellpadding="1" border="1">';
		$descrip .= '<tr><th>Nama Kolom</th><th>Nilai</th></tr>';
		foreach ($data as $key => $value) {
			$descrip .= '<tr>';
			$descrip .= '<td>'.$key.'</td>';
			$descrip .= '<td>'.$value.'</td>';
			$descrip .= '</tr>';
		}
		$descrip .= '</table>';
		return $descrip;
	}

	function add_audittrail($action,$title,$descrip,$tablename){
		try {
			$data = array(
				'datetime' => date("Y-m-d H:i:s"),
				'ipaddress' => $this->input->ip_address(),
				'username' => $this->session->userdata('username'),
				'tablename' => $tablename,
				'formname' => 'Add Referensi Pihak',
				'action' => $action,
				'title' => $title,
				'description' => $descrip
			);
			$this->db->insert('sys_audittrail', $data);
		} catch (Exception $e) {
			
		}
	}

	function add_data($data){
		try {
			$this->db->insert('perkara_actio_pauliana', $data);
			$title = "Tambah Register Perkara Actio Pauliana [perkara_id=<b>".$data['perkara_id']."</b>]<br />Tambah table <b>perkara_actio_pauliana</b> dari halaman <b>REGISTER PERKARA ACTION PAULIANA</b> dengan Primary Key [id=".$data['perkara_id']."]";
			$descrip = $this->fetch_description($title,$data);
			$this->add_audittrail("INSERT",$title,$descrip,'perkara_actio_pauliana');
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function update_data($data,$idperkara){
		try {
			if($idperkara>0){
				$this->db->where('perkara_id', $idperkara);
				$this->db->update('perkara_actio_pauliana', $data); 
				$title = "Ubah Data Register Perkara Actio Pauliana [perkara_id=<b>".$data['perkara_id']."</b>]<br />Update table <b>perkara_actio_pauliana</b> dari halaman <b>REGISTER ACTION PAULIANA</b> dengan Primary Key [id=".$data['perkara_id']."]";
				$descrip = $this->fetch_description($title,$data);
				$this->add_audittrail("UPDATE",$title,$descrip,'perkara_actio_pauliana');
				return TRUE;
			}else{
				return FALSE;
			}
		} catch (Exception $e) {
			return FALSE;
		}
	}

	function del_data($idperkara){
		try {
			$this->db->query("DELETE FROM perkara_actio_pauliana WHERE perkara_id =".$idperkara);
			$title = "Delete Data Register Perkara Actio Pauliana <br />dengan id [perkara_id=".$idperkara."] Oleh = ".$this->session->userdata('username');
			$this->add_audittrail("DELETE",$title,'DELETE DATA','perkara_actio_pauliana');
			return TRUE;
		} catch (Exception $e) {
			return FALSE;
		}
	}

}