<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class View_laporan_pidana_militer extends CI_Controller {
	function rekap(){
		if(empty($_POST)){
			show_404();
		}

		$event = trim($this->input->post('events',TRUE));
		$th_name = trim($this->input->post('th_name',TRUE));
		$tahun = trim($this->input->post('tahun_opt',TRUE));
		$type = trim($this->input->post('jenis',TRUE));
		$idalur = trim($this->input->post('idalur',TRUE));
		$tahapan = trim($this->input->post('tahapan',TRUE));
		$status = FALSE;
		if(is_numeric($event)){
			if($event>0 AND $event<=12){
				$this->nativesession->set_flash_session('event','rekap_bulan');
				$this->nativesession->set_flash_session('month',$event);
				$status = TRUE;
			}
		}elseif($event=='tab'){
			$this->nativesession->set_flash_session('event','tab');
			$status = TRUE;
		}elseif($event=='graph'){
			$this->nativesession->set_flash_session('event','graph');
			$status = TRUE;
		}

		//$this->nativesession->set_flash_session('idalurperkara',$idalur);

		if(is_numeric($idalur)){
			if($idalur>=0){
				$this->nativesession->set_flash_session('idalur',$idalur);
				$status = TRUE;
			}
		}else{
			$status = FALSE;
		}


		if(is_numeric($tahun)){
			if($tahun>=0){
				$this->nativesession->set_flash_session('tahun',$tahun);
				$status = TRUE;
			}
		}else{
			$status = FALSE;
		}

		if(is_numeric($type)){
			if($type>0 AND $type<=9){
				$this->nativesession->set_flash_session('type',$type);
				$status = TRUE;
			}else{
				$status = FALSE;
			}
		}else{
			$status = FALSE;
		}

		if(is_numeric($tahapan)){
			if($tahapan==10 OR $tahapan==20 OR $tahapan==30 OR $tahapan==40 OR $tahapan==50 OR $tahapan==60 OR $tahapan==88 OR $tahapan==99){
				$this->nativesession->set_flash_session('tahapan',$tahapan);
				$status = TRUE;
			}else{
				$status = FALSE;
			}
		}else{
			$status = FALSE;
		}

		if($status===TRUE){
			$this->nativesession->set_flash_session('view','view_rekap_perkara');
			echo json_encode(array('st'=>1,'msg'=>'Done'));
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Invalid Argument'));
		}
	}

	function rekap_bulan(){
		if(empty($_POST)){
			show_404();
		}

		$event = trim($this->input->post('events',TRUE));
		$th_name = trim($this->input->post('th_name',TRUE));
		$tahun = trim($this->input->post('tahun_opt',TRUE));
		$idalur = trim($this->input->post('idalur',TRUE));
		$type = trim($this->input->post('jenis',TRUE));
		$tahapan = trim($this->input->post('tahapan',TRUE));
		$bulan = trim($this->input->post('bulan',TRUE));
		$status = FALSE;
		if(is_numeric($event)){
			if($event>0 AND $event<=12){
				$this->nativesession->set_flash_session('event','rekap_bulan');
				$this->nativesession->set_flash_session('month',$event);
				$status = TRUE;
			}
		}elseif($event=='tab'){
			$this->nativesession->set_flash_session('event','tab');
			$status = TRUE;
		}elseif($event=='graph'){
			$this->nativesession->set_flash_session('event','graph');
			$status = TRUE;
		}

		$this->nativesession->set_flash_session('idalurperkara',$idalur);

		if(is_numeric($tahun)){
			if($tahun>=0){
				$this->nativesession->set_flash_session('tahun',$tahun);
				$status = TRUE;
			}
		}else{
			$status = FALSE;
		}

		if(is_numeric($bulan)){
			if($bulan>=0){
				$this->nativesession->set_flash_session('bulan',$bulan);
				$status = TRUE;
			}
		}else{
			$status = FALSE;
		}

		if(is_numeric($type)){
			if($type>0 AND $type<=8){
				$this->nativesession->set_flash_session('type',$type);
				$status = TRUE;
			}else{
				$status = FALSE;
			}
		}else{
			$status = FALSE;
		}

		if(is_numeric($tahapan)){
			if($tahapan==10 OR $tahapan==20 OR $tahapan==30 OR $tahapan==40 OR $tahapan==50 OR $tahapan==60 OR $tahapan==88 OR $tahapan==99){
				$this->nativesession->set_flash_session('tahapan',$tahapan);
				$status = TRUE;
			}else{
				$status = FALSE;
			}
		}else{
			$status = FALSE;
		}

		if($status===TRUE){
			$this->nativesession->set_flash_session('view','view_rekap_perkara_bulan');
			echo json_encode(array('st'=>1,'msg'=>'Done'));
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Invalid Argument'));
		}
	}

	function laporan(){
		if(empty($_POST)){
			show_404();
		}

		$event = trim($this->input->post('month',TRUE));
		$jenis = trim($this->input->post('jenis',TRUE));
		$tahun = trim($this->input->post('tahun_opt',TRUE));
		$tahapan = trim($this->input->post('tahapan',TRUE));
		$lap_pidmil = trim($this->input->post('lap_pidmil',TRUE));
		$status = FALSE;
		if(is_numeric($event)){
			if($event>0 AND $event<=12){
				$this->nativesession->set_flash_session('event','laporan');
				$this->nativesession->set_flash_session('month',$event);
				$status = TRUE;
			}
		}

		if(is_numeric($lap_pidmil)){
			if($lap_pidmil==1 OR $lap_pidmil==2 OR $lap_pidmil==3 OR $lap_pidmil==4 OR $lap_pidmil==5){
				$this->nativesession->set_flash_session('lap_pidmil',$lap_pidmil);
				$status = TRUE;
			}else{
				$status = FALSE;
			}
		}else{
			$status = FALSE;
		}


		if(is_numeric($tahapan)){
			if($tahapan==10 OR $tahapan==20 OR $tahapan==30 OR $tahapan==40 OR $tahapan==50 OR $tahapan==60 OR $tahapan==88 OR $tahapan==99){
				$this->nativesession->set_flash_session('tahapan',$tahapan);
				$status = TRUE;
			}else{
				$status = FALSE;
			}
		}else{
			$status = FALSE;
		}

		$this->nativesession->set_flash_session('idalurperkara',$jenis);
		if(is_numeric($tahun)){
			if($tahun>=0){
				$this->nativesession->set_flash_session('tahun',$tahun);
				$status = TRUE;
			}
		}else{
			$status = FALSE;
		}

		if($status===TRUE){
			$this->nativesession->set_flash_session('view','view_laporan');
			echo json_encode(array('st'=>1,'msg'=>'Silahkan Membuka Laporan Pada Tab'));
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Invalid Argument'));
		}
	}

	function index(){
		$act = $this->nativesession->get_flash_session('view');
		if($act==='view_rekap_perkara'){
			$this->view_rekap_perkara();
		}elseif($act==='view_laporan'){
			$this->view_laporan_perkara();
		}elseif($act==='view_rekap_perkara_bulan'){
			$this->view_rekap_perkara_bulan();
		}else{
			show_404();
		}
	}

	function view_rekap_perkara_bulan(){
		$idalurperkara = $this->nativesession->get_flash_session('idalurperkara');
		$tahun = $this->nativesession->get_flash_session('tahun');
		$bulan = $this->nativesession->get_flash_session('bulan');
		$type = $this->nativesession->get_flash_session('type');
		$tahapan = $this->nativesession->get_flash_session('tahapan');
		$data['bulan'] = $bulan;
		$bulan = ($bulan<10)? '0'.$bulan:$bulan;
		$periode = $tahun.'-'.$bulan;
		$this->load->model('report/report','report');
		$data['laporan'] = $this->report->get_stat_perkara_bln($periode,$idalurperkara);
		$data['tahun'] = $tahun;
		$data['idalurperkara'] = $idalurperkara;
		//$data['perkara_nama'] = strtoupper($this->report->getJenisPerkara($idalurperkara));
		$query = $this->report->get_info_pn();
		foreach ($query->result() as $row) {
			if($row->id == 62){
				if(!empty($row->value)){
					$data['nama_pn'] = $row->value;
				}
			}
		}
		$data['view_lap'] = 'laporan/view_laporan_perkara_bulan';
		$this->load->vars($data);
		$this->load->view('laporan/view_laporan_perkara');
		$this->load->view('footer');
	}

	function view_rekap_perkara(){
		$idalurperkara = $this->nativesession->get_flash_session('idalur');
		$tahun = $this->nativesession->get_flash_session('tahun');
		$type = $this->nativesession->get_flash_session('type');
		$tahapan = $this->nativesession->get_flash_session('tahapan');
		if($type==1){
			$this->load->model('report/report_pidmil_klasifikasi','report');
			$data['view_lap'] = 'laporan/view_laporan_pidmil_klasifikasi_thn';			
			if($idalurperkara==120){
				$data['perkara_nama'] = 'LAPORAN REKAPITULASI KLASIFIKASI PERKARA KEJAHATAN BIASA';	
			}elseif($idalurperkara==121){
				$data['perkara_nama'] = 'LAPORAN REKAPITULASI KLASIFIKASI PERKARA PIDANA (PELANGGARAN)';	
			}

		}elseif($type==2){
			$this->load->model('report/report_pidmil_keadaan_perkara','report');
			$data['view_lap'] = 'laporan/view_laporan_pidmil_keadaan_perkara_thn';
			if($idalurperkara==120){
				$data['perkara_nama'] = 'LAPORAN REKAPITULASI KEADAAN PERKARA KEJAHATAN BIASA';	
			}elseif($idalurperkara==121){
				$data['perkara_nama'] = 'LAPORAN REKAPITULASI KEADAAN PERKARA PIDANA (PELANGGARAN)';	
			}
			
		}elseif($type==3){
			$this->load->model('report/report_pidmil_keadaan_perkara_tahunan','report');
			$data['view_lap'] = 'laporan/view_laporan_pidmil_keadaan_perkara_tahunan';
			if($idalurperkara==120){
				$data['perkara_nama'] = 'LAPORAN REKAPITULASI KEADAAN PERKARA KEJAHATAN BIASA TAHUNAN';	
			}elseif($idalurperkara==121){
				$data['perkara_nama'] = 'LAPORAN REKAPITULASI KEADAAN PERKARA PIDANA (PELANGGARAN) TAHUNAN';	
			}

		}elseif($type==4){
			$this->load->model('report/report_pidmil_keuangan','report');
			$data['view_lap'] = 'laporan/view_laporan_pidmil_keuangan_thn';
			if($idalurperkara==120){
				$data['perkara_nama'] = 'LAPORAN REKAPITULASI KEUANGAN PERKARA KEJAHATAN BIASA PER TAHUN';	
			}elseif($idalurperkara==121){
				$data['perkara_nama'] = 'LAPORAN REKAPITULASI KEUANGAN PERKARA PIDANA (PELANGGARAN) PER TAHUN';	
			}

		}elseif($type==5){
			$this->load->model('report/report_pidmil_upaya_hukum','report');
			$data['view_lap'] = 'laporan/view_laporan_pidmil_upaya_hukum_thn';
			if($idalurperkara==120){
				$data['perkara_nama'] = 'LAPORAN REKAPITULASI PERKARA KEJAHATAN YANG MENGAJUKAN UPAYA HUKUM';	
			}elseif($idalurperkara==121){
				$data['perkara_nama'] = 'LAPORAN REKAPITULASI PERKARA PELANGGARAN YANG MENGAJUKAN UPAYA HUKUM';	
			}

		}
		
		$data['rekap'] = $this->report->get_rekap($idalurperkara,$tahun);
		$data['tahun'] = $tahun;
		
		$data['idalurperkara'] = $idalurperkara;
		
		$query = $this->report->get_info_pn();
		foreach ($query->result() as $row) {
			if($row->id == 62){
				if(!empty($row->value)){
					$data['nama_pn'] = $row->value;
				}
			}
		}
		$this->load->vars($data);
		$this->load->view('laporan/view_laporan_perkara');
		$this->load->view('footer');
	}

	function view_laporan_perkara(){
		$idalurperkara = $this->nativesession->get_flash_session('idalurperkara');
		$tahun = $this->nativesession->get_flash_session('tahun');
		$bulan = $this->nativesession->get_flash_session('month');
		$tahapan = $this->nativesession->get_flash_session('tahapan');
		$lap_pidmil = $this->nativesession->get_flash_session('lap_pidmil');
		if($tahapan==10 && $lap_pidmil==1){
			$this->load->model('report/report_pidmil_klasifikasi','report');
			$data['view_lap'] = 'laporan/view_laporan_pidmil_klasifikasi_bul';
			if($idalurperkara==120){
				$data['perkara_nama'] = 'LAPORAN KLASIFIKASI PERKARA PIDANA (KEJAHATAN) BIASA';	
			}elseif($idalurperkara==121){
				$data['perkara_nama'] = 'LAPORAN KLASIFIKASI PERKARA PIDANA (PELANGGARAN)';
			}
			
		}elseif($tahapan==10 && $lap_pidmil==2){
			$this->load->model('report/report_pidmil_keadaan_perkara','report');
			$data['view_lap'] = 'laporan/view_laporan_pidmil_keadaan_perkara_bul';
			if($idalurperkara==120){
				$data['perkara_nama'] = 'LAPORAN KEADAAN PERKARA PIDANA (KEJAHATAN) BIASA';	
			}elseif($idalurperkara==121){
				$data['perkara_nama'] = 'LAPORAN KEADAAN PERKARA PIDANA (PELANGGARAN)';
			}

		}elseif($tahapan==10 && $lap_pidmil==3){
			$this->load->model('report/report_pidmil_keuangan','report');
			$data['view_lap'] = 'laporan/view_laporan_pidmil_keuangan_bul';
			if($idalurperkara==120){
				$data['perkara_nama'] = 'LAPORAN KEUANGAN PERKARA PIDANA (KEJAHATAN) BIASA';	
			}elseif($idalurperkara==121){
				$data['perkara_nama'] = 'LAPORAN KEUANGAN PERKARA PIDANA (PELANGGARAN)';
			}

		}elseif($tahapan==10 && $lap_pidmil==4){
			$this->load->model('report/report_pidmil_kinerja_hakim_pp','report');
			$data['view_lap'] = 'laporan/view_laporan_pidmil_kinerja_hakim_pp';
			if($idalurperkara==120){
				$data['perkara_nama'] = 'LAPORAN KINERJA HAKIM DAN PANITERA PERKARA PIDANA (KEJAHATAN) BIASA';	
			}elseif($idalurperkara==121){
				$data['perkara_nama'] = 'LAPORAN KINERJA HAKIM DAN PANITERA PERKARA PIDANA (PELANGGARAN)';
			}

		}elseif($tahapan==10 && $lap_pidmil==5){
			$this->load->model('report/report_pidmil_upaya_hukum','report');
			$data['view_lap'] = 'laporan/view_laporan_pidmil_upaya_hukum';
			if($idalurperkara==120){
				$data['perkara_nama'] = 'LAPORAN PERKARA KEJAHATAN YANG MENGAJUKAN UPAYA HUKUM';	
			}elseif($idalurperkara==121){
				$data['perkara_nama'] = 'LAPORAN PELANGGARAN KEJAHATAN YANG MENGAJUKAN UPAYA HUKUM';
			}

		}



		$data['tahun'] = $tahun;
		$data['bulan'] = $bulan;
		$data['idalurperkara'] = $idalurperkara;
		$query = $this->report->get_info_pn();
		foreach ($query->result() as $row) {
			if($row->id == 62){
				if(!empty($row->value)){
					$data['nama_pn'] = $row->value;
				}
			}
		}
		$bln = ($bulan<10)? '0'.$bulan:$bulan;
		$data['bulanmed']=($bulan<10)? '0'.$bulan:$bulan;
		$period = $tahun.'-'.$bln;
		$data['laporan'] = $this->report->get_lap_perkara($period,$idalurperkara);
		$data['stat'] = $this->report->get_stat_perkara($period,$idalurperkara);
		$this->load->vars($data);
		$this->load->view('laporan/view_laporan_perkara');
		$this->load->view('footer');
	}


	function detil_mediator_thn(){
		$idalurperkara = $this->nativesession->get_flash_session('idalur');
		$tahun = $this->nativesession->get_flash_session('tahun');
		$type = $this->nativesession->get_flash_session('type');
		$tahapan = $this->nativesession->get_flash_session('tahapan');
		
		$segment = $this->uri->segment_array();
		$data['idmediator'] = $this->encrypt->decode(base64_decode($segment[3]));
		$data['tahun'] = $this->encrypt->decode(base64_decode($segment[4]));
		$data['idalurperkara'] = $this->encrypt->decode(base64_decode($segment[5]));
		$data['nama_mediator'] = $this->encrypt->decode(base64_decode($segment[6]));

		$this->load->model('report/report_rekapitulasi_mediator_detil','report');
		$data['view_lap'] = 'laporan/view_rekapitulasi_mediator_detil';
		$data['perkara_nama'] = 'REKAPITULASI MEDIASI DETIL MEDIATOR';

		$data['rekap'] = $this->report->get_rekap($data['idmediator'],$data['idalurperkara'],$data['tahun']);
		//$data['tahun'] = $tahun;
		
		//$data['idalurperkara'] = $idalurperkara;
		
		$query = $this->report->get_info_pn();
		foreach ($query->result() as $row) {
			if($row->id == 62){
				if(!empty($row->value)){
					$data['nama_pn'] = $row->value;
				}
			}
		}
		$this->load->vars($data);
		$this->load->view('laporan/view_laporan_perkara');
		$this->load->view('footer');
	}

	function detil_mediator_bln(){
		$idalurperkara = $this->nativesession->get_flash_session('idalur');
		$tahun = $this->nativesession->get_flash_session('tahun');
		$type = $this->nativesession->get_flash_session('type');
		$tahapan = $this->nativesession->get_flash_session('tahapan');
		
		$segment = $this->uri->segment_array();
		$data['idmediator'] = $this->encrypt->decode(base64_decode($segment[3]));	
		$data['idalurperkara'] = $this->encrypt->decode(base64_decode($segment[5]));
		$data['tahun'] = $this->encrypt->decode(base64_decode($segment[4]));
		$data['bulan'] = $this->encrypt->decode(base64_decode($segment[6]));
		$data['nama_mediator'] = $this->encrypt->decode(base64_decode($segment[7]));
		$periode=$data['tahun'].'-'.$data['bulan'];

		$this->load->model('report/report_rekapitulasi_mediator_detil_bln','report');
		$data['view_lap'] = 'laporan/view_rekapitulasi_mediator_detil_bln';
		$data['perkara_nama'] = 'REKAPITULASI MEDIASI DETIL MEDIATOR';

		$data['rekap'] = $this->report->get_rekap($data['idmediator'],$data['idalurperkara'],$periode);
		//$data['tahun'] = $tahun;
		
		//$data['idalurperkara'] = $idalurperkara;
		
		$query = $this->report->get_info_pn();
		foreach ($query->result() as $row) {
			if($row->id == 62){
				if(!empty($row->value)){
					$data['nama_pn'] = $row->value;
				}
			}
		}
		$this->load->vars($data);
		$this->load->view('laporan/view_laporan_perkara');
		$this->load->view('footer');
	}

}