<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class View_laporan_pidana_militer extends CI_Controller {
	function rekap(){
		if(empty($_POST)){
			show_404();
		}

		$event = trim($this->input->post('events',TRUE));
		$th_name = trim($this->input->post('th_name',TRUE));
		$tahun = trim($this->input->post('tahun_opt',TRUE));
		$type = trim($this->input->post('jenis',TRUE));
		$idalur = trim($this->input->post('idalur',TRUE));
		$tahapan = trim($this->input->post('tahapan',TRUE));
		$bln_awal = trim($this->input->post('bln_awal',TRUE));
		$tahun_awal = trim($this->input->post('tahun_awal',TRUE));
		$bln_akhir = trim($this->input->post('bln_akhir',TRUE));
		$tahun_akhir = trim($this->input->post('tahun_akhir',TRUE));
		$status = FALSE;
		if(is_numeric($event)){
			if($event>0 AND $event<=12){
				$this->nativesession->set_flash_session('event','rekap_bulan');
				$this->nativesession->set_flash_session('month',$event);
				$status = TRUE;
			}
		}elseif($event=='tab'){
			$this->nativesession->set_flash_session('event','tab');
			$status = TRUE;
		}elseif($event=='graph'){
			$this->nativesession->set_flash_session('event','graph');
			$status = TRUE;
		}

		//$this->nativesession->set_flash_session('idalurperkara',$idalur);

		if(is_numeric($idalur)){
			if($idalur>=0){
				$this->nativesession->set_flash_session('idalur',$idalur);
				$status = TRUE;
			}
		}else{
			$status = FALSE;
		}


		if(is_numeric($tahun)){
			if($tahun>=0){
				$this->nativesession->set_flash_session('tahun',$tahun);
				$status = TRUE;
			}
		}else{
			$status = FALSE;
		}

		if(is_numeric($type)){
			if($type>0 AND $type<=20){
				$this->nativesession->set_flash_session('type',$type);
				$status = TRUE;
			}else{
				$status = FALSE;
			}
		}else{
			$status = FALSE;
		}

		if(is_numeric($tahapan)){
			if($tahapan==10 OR $tahapan==20 OR $tahapan==30 OR $tahapan==40 OR $tahapan==50 OR $tahapan==60 OR $tahapan==88 OR $tahapan==99){
				$this->nativesession->set_flash_session('tahapan',$tahapan);
				$status = TRUE;
			}else{
				$status = FALSE;
			}
		}else{
			$status = FALSE;
		}

		if(!empty($bln_awal) && !empty($tahun_awal) && !empty($bln_akhir) && !empty($tahun_akhir)){
			$this->nativesession->set_flash_session('bln_awal',$bln_awal);
			$this->nativesession->set_flash_session('tahun_awal',$tahun_awal);
			$this->nativesession->set_flash_session('bln_akhir',$bln_akhir);
			$this->nativesession->set_flash_session('tahun_akhir',$tahun_akhir);
			$status = TRUE;
			
		}else{
			$status = FALSE;
		}


		if($status===TRUE){
			$this->nativesession->set_flash_session('view','view_rekap_perkara');
			echo json_encode(array('st'=>1,'msg'=>'Done'));
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Invalid Argument'));
		}
	}

	function rekap_bulan(){
		if(empty($_POST)){
			show_404();
		}

		$event = trim($this->input->post('events',TRUE));
		$th_name = trim($this->input->post('th_name',TRUE));
		$tahun = trim($this->input->post('tahun_opt',TRUE));
		$idalur = trim($this->input->post('idalur',TRUE));
		$type = trim($this->input->post('jenis',TRUE));
		$tahapan = trim($this->input->post('tahapan',TRUE));
		$bulan = trim($this->input->post('bulan',TRUE));
		$status = FALSE;
		if(is_numeric($event)){
			if($event>0 AND $event<=12){
				$this->nativesession->set_flash_session('event','rekap_bulan');
				$this->nativesession->set_flash_session('month',$event);
				$status = TRUE;
			}
		}elseif($event=='tab'){
			$this->nativesession->set_flash_session('event','tab');
			$status = TRUE;
		}elseif($event=='graph'){
			$this->nativesession->set_flash_session('event','graph');
			$status = TRUE;
		}

		$this->nativesession->set_flash_session('idalurperkara',$idalur);

		if(is_numeric($tahun)){
			if($tahun>=0){
				$this->nativesession->set_flash_session('tahun',$tahun);
				$status = TRUE;
			}
		}else{
			$status = FALSE;
		}

		if(is_numeric($bulan)){
			if($bulan>=0){
				$this->nativesession->set_flash_session('bulan',$bulan);
				$status = TRUE;
			}
		}else{
			$status = FALSE;
		}

		if(is_numeric($type)){
			if($type>0 AND $type<=8){
				$this->nativesession->set_flash_session('type',$type);
				$status = TRUE;
			}else{
				$status = FALSE;
			}
		}else{
			$status = FALSE;
		}

		if(is_numeric($tahapan)){
			if($tahapan==10 OR $tahapan==20 OR $tahapan==30 OR $tahapan==40 OR $tahapan==50 OR $tahapan==60 OR $tahapan==88 OR $tahapan==99){
				$this->nativesession->set_flash_session('tahapan',$tahapan);
				$status = TRUE;
			}else{
				$status = FALSE;
			}
		}else{
			$status = FALSE;
		}

		if($status===TRUE){
			$this->nativesession->set_flash_session('view','view_rekap_perkara_bulan');
			echo json_encode(array('st'=>1,'msg'=>'Done'));
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Invalid Argument'));
		}
	}

	function laporan(){
		if(empty($_POST)){
			show_404();
		}

		$event = trim($this->input->post('month',TRUE));
		$jenis = trim($this->input->post('jenis',TRUE));
		$tahun = trim($this->input->post('tahun_opt',TRUE));
		$tahapan = trim($this->input->post('tahapan',TRUE));
		$lap_pidmil = trim($this->input->post('lap_pidmil',TRUE));
		$status = FALSE;
		if(is_numeric($event)){
			if($event>0 AND $event<=12){
				$this->nativesession->set_flash_session('event','laporan');
				$this->nativesession->set_flash_session('month',$event);
				$status = TRUE;
			}
		}

		if(is_numeric($lap_pidmil)){
			if($lap_pidmil==1 OR $lap_pidmil==2 OR $lap_pidmil==3 OR $lap_pidmil==4 OR $lap_pidmil==5){
				$this->nativesession->set_flash_session('lap_pidmil',$lap_pidmil);
				$status = TRUE;
			}else{
				$status = FALSE;
			}
		}else{
			$status = FALSE;
		}


		if(is_numeric($tahapan)){
			if($tahapan==10 OR $tahapan==20 OR $tahapan==30 OR $tahapan==40 OR $tahapan==50 OR $tahapan==60 OR $tahapan==88 OR $tahapan==99){
				$this->nativesession->set_flash_session('tahapan',$tahapan);
				$status = TRUE;
			}else{
				$status = FALSE;
			}
		}else{
			$status = FALSE;
		}

		$this->nativesession->set_flash_session('idalurperkara',$jenis);
		if(is_numeric($tahun)){
			if($tahun>=0){
				$this->nativesession->set_flash_session('tahun',$tahun);
				$status = TRUE;
			}
		}else{
			$status = FALSE;
		}

		if($status===TRUE){
			$this->nativesession->set_flash_session('view','view_laporan');
			echo json_encode(array('st'=>1,'msg'=>'Silahkan Membuka Laporan Pada Tab'));
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Invalid Argument'));
		}
	}

	function index(){
		$act = $this->nativesession->get_flash_session('view');
		if($act==='view_rekap_perkara'){
			$this->view_rekap_perkara();
		}elseif($act==='view_laporan'){
			$this->view_laporan_perkara();
		}elseif($act==='view_rekap_perkara_bulan'){
			$this->view_rekap_perkara_bulan();
		}else{
			show_404();
		}
	}

	function view_rekap_perkara_bulan(){
		$idalurperkara = $this->nativesession->get_flash_session('idalurperkara');
		$tahun = $this->nativesession->get_flash_session('tahun');
		$bulan = $this->nativesession->get_flash_session('bulan');
		$type = $this->nativesession->get_flash_session('type');
		$tahapan = $this->nativesession->get_flash_session('tahapan');
		$data['bulan'] = $bulan;
		$bulan = ($bulan<10)? '0'.$bulan:$bulan;
		$periode = $tahun.'-'.$bulan;
		$this->load->model('report/report','report');
		$data['laporan'] = $this->report->get_stat_perkara_bln($periode,$idalurperkara);
		$data['tahun'] = $tahun;
		$data['idalurperkara'] = $idalurperkara;
		//$data['perkara_nama'] = strtoupper($this->report->getJenisPerkara($idalurperkara));
		$query = $this->report->get_info_pn();
		foreach ($query->result() as $row) {
			if($row->id == 62){
				if(!empty($row->value)){
					$data['nama_pn'] = $row->value;
				}
			}
		}
		$data['view_lap'] = 'laporan/view_laporan_perkara_bulan';
		$this->load->vars($data);
		$this->load->view('laporan/view_laporan_perkara');
		$this->load->view('footer');
	}

	function view_rekap_perkara(){
		$idalurperkara = $this->nativesession->get_flash_session('idalur');
		$tahun = $this->nativesession->get_flash_session('tahun');
		$type = $this->nativesession->get_flash_session('type');
		$tahapan = $this->nativesession->get_flash_session('tahapan');
		$bln_awal = $this->nativesession->get_flash_session('bln_awal');
		$tahun_awal = $this->nativesession->get_flash_session('tahun_awal');
		$bln_akhir = $this->nativesession->get_flash_session('bln_akhir');
		$tahun_akhir = $this->nativesession->get_flash_session('tahun_akhir');
		if($type==1){
			$this->load->model('report/report_pidmil_klasifikasi','report');
			$data['view_lap'] = 'laporan/view_laporan_pidmil_klasifikasi_thn';			
			if($idalurperkara==120){
				$data['perkara_nama'] = 'LAPORAN REKAPITULASI KLASIFIKASI PERKARA KEJAHATAN BIASA';	
			}elseif($idalurperkara==121){
				$data['perkara_nama'] = 'LAPORAN REKAPITULASI KLASIFIKASI PERKARA PIDANA (PELANGGARAN)';	
			}

		}elseif($type==2){
			$this->load->model('report/report_pidmil_keadaan_perkara','report');
			$data['view_lap'] = 'laporan/view_laporan_pidmil_keadaan_perkara_thn';
			if($idalurperkara==120){
				$data['perkara_nama'] = 'LAPORAN REKAPITULASI KEADAAN PERKARA KEJAHATAN BIASA';	
			}elseif($idalurperkara==121){
				$data['perkara_nama'] = 'LAPORAN REKAPITULASI KEADAAN PERKARA PIDANA (PELANGGARAN)';	
			}
			
		}elseif($type==3){
			$this->load->model('report/report_pidmil_keadaan_perkara_tahunan','report');
			$data['view_lap'] = 'laporan/view_laporan_pidmil_keadaan_perkara_tahunan';
			if($idalurperkara==120){
				$data['perkara_nama'] = 'LAPORAN REKAPITULASI KEADAAN PERKARA KEJAHATAN BIASA TAHUNAN';	
			}elseif($idalurperkara==121){
				$data['perkara_nama'] = 'LAPORAN REKAPITULASI KEADAAN PERKARA PIDANA (PELANGGARAN) TAHUNAN';	
			}

		}elseif($type==4){
			$this->load->model('report/report_pidmil_keuangan','report');
			$data['view_lap'] = 'laporan/view_laporan_pidmil_keuangan_thn';
			if($idalurperkara==120){
				$data['perkara_nama'] = 'LAPORAN REKAPITULASI KEUANGAN PERKARA KEJAHATAN BIASA PER TAHUN';	
			}elseif($idalurperkara==121){
				$data['perkara_nama'] = 'LAPORAN REKAPITULASI KEUANGAN PERKARA PIDANA (PELANGGARAN) PER TAHUN';	
			}

		}elseif($type==5){
			$this->load->model('report/report_pidmil_upaya_hukum','report');
			$data['view_lap'] = 'laporan/view_laporan_pidmil_upaya_hukum_thn';
			if($idalurperkara==120){
				$data['perkara_nama'] = 'LAPORAN REKAPITULASI PERKARA KEJAHATAN YANG MENGAJUKAN UPAYA HUKUM';	
			}elseif($idalurperkara==121){
				$data['perkara_nama'] = 'LAPORAN REKAPITULASI PERKARA PELANGGARAN YANG MENGAJUKAN UPAYA HUKUM';	
			}

		}elseif($type==6){
			$this->load->model('report/report_pidmil_nominatif_sisa_awal','report');
			$data['view_lap'] = 'laporan/view_laporan_pidmil_nominatif_sisa_awal';
			if($idalurperkara==120){
				$data['perkara_nama'] = 'DAFTAR NOMINATIF PERKARA KEJAHATAN TINGKAT PERTAMA SISA AWAL';	
			}elseif($idalurperkara==121){
				$data['perkara_nama'] = 'DAFTAR NOMINATIF PERKARA PELANGGARAN TINGKAT PERTAMA SISA AWAL';	
			}

		}elseif($type==7){
			$this->load->model('report/report_pidmil_nominatif_masuk','report');
			$data['view_lap'] = 'laporan/view_laporan_pidmil_nominatif_masuk';
			if($idalurperkara==120){
				$data['perkara_nama'] = 'DAFTAR NOMINATIF PERKARA KEJAHATAN TINGKAT PERTAMA MASUK';	
			}elseif($idalurperkara==121){
				$data['perkara_nama'] = 'DAFTAR NOMINATIF PERKARA PELANGGARAN TINGKAT PERTAMA MASUK';	
			}

		}elseif($type==8){
			$this->load->model('report/report_pidmil_nominatif_putus','report');
			$data['view_lap'] = 'laporan/view_laporan_pidmil_nominatif_putus';
			if($idalurperkara==120){
				$data['perkara_nama'] = 'DAFTAR NOMINATIF PERKARA KEJAHATAN TINGKAT PERTAMA PUTUS';	
			}elseif($idalurperkara==121){
				$data['perkara_nama'] = 'DAFTAR NOMINATIF PERKARA PELANGGARAN TINGKAT PERTAMA PUTUS';	
			}

		}elseif($type==9){
			$this->load->model('report/report_pidmil_nominatif_sisa_akhir','report');
			$data['view_lap'] = 'laporan/view_laporan_pidmil_nominatif_sisa_akhir';
			if($idalurperkara==120){
				$data['perkara_nama'] = 'DAFTAR NOMINATIF PERKARA KEJAHATAN TINGKAT PERTAMA SISA AKHIR';	
			}elseif($idalurperkara==121){
				$data['perkara_nama'] = 'DAFTAR NOMINATIF PERKARA PELANGGARAN TINGKAT PERTAMA SISA AKHIR';	
			}
		}elseif($type==10){
			$this->load->model('report/report_pidmil_nominatif_banding','report');
			$data['view_lap'] = 'laporan/view_laporan_pidmil_nominatif_banding';
			if($idalurperkara==120){
				$data['perkara_nama'] = 'DAFTAR NOMINATIF PERKARA KEJAHATAN UPAYA HUKUM BANDING';	
			}elseif($idalurperkara==121){
				$data['perkara_nama'] = 'DAFTAR NOMINATIF PERKARA KEJAHATAN UPAYA HUKUM BANDING';	
			}
		}elseif($type==11){
			$this->load->model('report/report_pidmil_nominatif_kasasi','report');
			$data['view_lap'] = 'laporan/view_laporan_pidmil_nominatif_kasasi';
			if($idalurperkara==120){
				$data['perkara_nama'] = 'DAFTAR NOMINATIF PERKARA KEJAHATAN UPAYA HUKUM KASASI';	
			}elseif($idalurperkara==121){
				$data['perkara_nama'] = 'DAFTAR NOMINATIF PERKARA KEJAHATAN UPAYA HUKUM KASASI';	
			}
		}elseif($type==12){
			$this->load->model('report/report_pidmil_nominatif_pk','report');
			$data['view_lap'] = 'laporan/view_laporan_pidmil_nominatif_pk';
			if($idalurperkara==120){
				$data['perkara_nama'] = 'DAFTAR NOMINATIF PERKARA KEJAHATAN UPAYA HUKUM PENINJAUAN KEMBALI';	
			}elseif($idalurperkara==121){
				$data['perkara_nama'] = 'DAFTAR NOMINATIF PERKARA KEJAHATAN UPAYA HUKUM PENINJAUAN KEMBALI';	
			}
		}elseif($type==13){
			$this->load->model('report/report_pidmil_nominatif_grasi','report');
			$data['view_lap'] = 'laporan/view_laporan_pidmil_nominatif_grasi';
			if($idalurperkara==120){
				$data['perkara_nama'] = 'DAFTAR NOMINATIF PERKARA KEJAHATAN UPAYA HUKUM GRASI';	
			}elseif($idalurperkara==121){
				$data['perkara_nama'] = 'DAFTAR NOMINATIF PERKARA KEJAHATAN UPAYA HUKUM GRASI';	
			}
		}
		
		/* pending -->  dilmil guf
		elseif($type==10){
			$this->load->model('report/report_pidmil_nominatif_sisa_awal_banding','report');
			$data['view_lap'] = 'laporan/view_laporan_pidmil_nominatif_sisa_awal_banding';
			if($idalurperkara==120){
				$data['perkara_nama'] = 'DAFTAR NOMINATIF PERKARA TINGKAT BANDING SISA AWAL';	
			}elseif($idalurperkara==121){
				$data['perkara_nama'] = 'DAFTAR NOMINATIF PERKARA TINGKAT BANDING SISA AWAL';	
			}

		}elseif($type==11){
			$this->load->model('report/report_pidmil_nominatif_masuk_banding','report');
			$data['view_lap'] = 'laporan/view_laporan_pidmil_nominatif_masuk_banding';
			if($idalurperkara==120){
				$data['perkara_nama'] = 'DAFTAR NOMINATIF PERKARA TINGKAT BANDING MASUK';	
			}elseif($idalurperkara==121){
				$data['perkara_nama'] = 'DAFTAR NOMINATIF PERKARA TINGKAT BANDING MASUK';	
			}

		} */
		
		$periode_awal=$tahun_awal."-".$bln_awal;
		$periode_akhir = $tahun_akhir."-".$bln_akhir;

		$data['rekap_tahunan'] = $this->report->get_rekap1($idalurperkara,$tahun);
		$data['rekap'] = $this->report->get_rekap($idalurperkara,$periode_awal,$periode_akhir);
		$data['tahun'] = $tahun;
		
		if($bln_awal=='01'){$bulan_awal='Januari';}
		elseif($bln_awal=='02'){$bulan_awal='Februari';}
		elseif($bln_awal=='03'){$bulan_awal='Maret';}
		elseif($bln_awal=='04'){$bulan_awal='April';}
		elseif($bln_awal=='05'){$bulan_awal='Mei';}
		elseif($bln_awal=='06'){$bulan_awal='Juni';}
		elseif($bln_awal=='07'){$bulan_awal='Juli';}
		elseif($bln_awal=='08'){$bulan_awal='Agustus';}
		elseif($bln_awal=='09'){$bulan_awal='September';}
		elseif($bln_awal=='10'){$bulan_awal='Oktober';}
		elseif($bln_awal=='11'){$bulan_awal='Nopember';}
		elseif($bln_awal=='12'){$bulan_awal='Desember';}

		if($bln_akhir=='01'){$bulan_akhir='Januari';}
		elseif($bln_akhir=='02'){$bulan_akhir='Februari';}
		elseif($bln_akhir=='03'){$bulan_akhir='Maret';}
		elseif($bln_akhir=='04'){$bulan_akhir='April';}
		elseif($bln_akhir=='05'){$bulan_akhir='Mei';}
		elseif($bln_akhir=='06'){$bulan_akhir='Juni';}
		elseif($bln_akhir=='07'){$bulan_akhir='Juli';}
		elseif($bln_akhir=='08'){$bulan_akhir='Agustus';}
		elseif($bln_akhir=='09'){$bulan_akhir='September';}
		elseif($bln_akhir=='10'){$bulan_akhir='Oktober';}
		elseif($bln_akhir=='11'){$bulan_akhir='Nopember';}
		elseif($bln_akhir=='12'){$bulan_akhir='Desember';}


		$data['periode_awal']=$bulan_awal."-".$tahun_awal;
		$data['periode_akhir'] = $bulan_akhir."-".$tahun_akhir;

		$data['idalurperkara'] = $idalurperkara;
		
		$query = $this->report->get_info_pn();
		foreach ($query->result() as $row) {
			if($row->id == 62){
				if(!empty($row->value)){
					$data['nama_pn'] = $row->value;
				}
			}
		}
		$this->load->vars($data);
		$this->load->view('laporan/view_laporan_perkara');
		$this->load->view('footer');
	}

	function view_laporan_perkara(){
		$idalurperkara = $this->nativesession->get_flash_session('idalurperkara');
		$tahun = $this->nativesession->get_flash_session('tahun');
		$bulan = $this->nativesession->get_flash_session('month');
		$tahapan = $this->nativesession->get_flash_session('tahapan');
		$lap_pidmil = $this->nativesession->get_flash_session('lap_pidmil');
		if($tahapan==10 && $lap_pidmil==1){
			$this->load->model('report/report_pidmil_klasifikasi','report');
			$data['view_lap'] = 'laporan/view_laporan_pidmil_klasifikasi_bul';
			if($idalurperkara==120){
				$data['perkara_nama'] = 'LAPORAN KLASIFIKASI PERKARA PIDANA (KEJAHATAN) BIASA';	
			}elseif($idalurperkara==121){
				$data['perkara_nama'] = 'LAPORAN KLASIFIKASI PERKARA PIDANA (PELANGGARAN)';
			}
			
		}elseif($tahapan==10 && $lap_pidmil==2){
			$this->load->model('report/report_pidmil_keadaan_perkara','report');
			$data['view_lap'] = 'laporan/view_laporan_pidmil_keadaan_perkara_bul';
			if($idalurperkara==120){
				$data['perkara_nama'] = 'LAPORAN KEADAAN PERKARA PIDANA (KEJAHATAN) BIASA';	
			}elseif($idalurperkara==121){
				$data['perkara_nama'] = 'LAPORAN KEADAAN PERKARA PIDANA (PELANGGARAN)';
			}

		}elseif($tahapan==10 && $lap_pidmil==3){
			$this->load->model('report/report_pidmil_keuangan','report');
			$data['view_lap'] = 'laporan/view_laporan_pidmil_keuangan_bul';
			if($idalurperkara==120){
				$data['perkara_nama'] = 'LAPORAN KEUANGAN PERKARA PIDANA (KEJAHATAN) BIASA';	
			}elseif($idalurperkara==121){
				$data['perkara_nama'] = 'LAPORAN KEUANGAN PERKARA PIDANA (PELANGGARAN)';
			}

		}elseif($tahapan==10 && $lap_pidmil==4){
			$this->load->model('report/report_pidmil_kinerja_hakim_pp','report');
			$data['view_lap'] = 'laporan/view_laporan_pidmil_kinerja_hakim_pp';
			if($idalurperkara==120){
				$data['perkara_nama'] = 'LAPORAN KINERJA HAKIM DAN PANITERA PERKARA PIDANA (KEJAHATAN) BIASA';	
			}elseif($idalurperkara==121){
				$data['perkara_nama'] = 'LAPORAN KINERJA HAKIM DAN PANITERA PERKARA PIDANA (PELANGGARAN)';
			}

		}elseif($tahapan==10 && $lap_pidmil==5){
			$this->load->model('report/report_pidmil_upaya_hukum','report');
			$data['view_lap'] = 'laporan/view_laporan_pidmil_upaya_hukum';
			if($idalurperkara==120){
				$data['perkara_nama'] = 'LAPORAN PERKARA KEJAHATAN YANG MENGAJUKAN UPAYA HUKUM';	
			}elseif($idalurperkara==121){
				$data['perkara_nama'] = 'LAPORAN PELANGGARAN KEJAHATAN YANG MENGAJUKAN UPAYA HUKUM';
			}

		}



		$data['tahun'] = $tahun;
		$data['bulan'] = $bulan;
		$data['idalurperkara'] = $idalurperkara;
		$query = $this->report->get_info_pn();
		foreach ($query->result() as $row) {
			if($row->id == 62){
				if(!empty($row->value)){
					$data['nama_pn'] = $row->value;
				}
			}
		}
		$bln = ($bulan<10)? '0'.$bulan:$bulan;
		$data['bulanmed']=($bulan<10)? '0'.$bulan:$bulan;
		$period = $tahun.'-'.$bln;
		$data['laporan'] = $this->report->get_lap_perkara($period,$idalurperkara);
		$data['stat'] = $this->report->get_stat_perkara($period,$idalurperkara);
		$this->load->vars($data);
		$this->load->view('laporan/view_laporan_perkara');
		$this->load->view('footer');
	}


	function detil_mediator_thn(){
		$idalurperkara = $this->nativesession->get_flash_session('idalur');
		$tahun = $this->nativesession->get_flash_session('tahun');
		$type = $this->nativesession->get_flash_session('type');
		$tahapan = $this->nativesession->get_flash_session('tahapan');
		
		$segment = $this->uri->segment_array();
		$data['idmediator'] = $this->encrypt->decode(base64_decode($segment[3]));
		$data['tahun'] = $this->encrypt->decode(base64_decode($segment[4]));
		$data['idalurperkara'] = $this->encrypt->decode(base64_decode($segment[5]));
		$data['nama_mediator'] = $this->encrypt->decode(base64_decode($segment[6]));

		$this->load->model('report/report_rekapitulasi_mediator_detil','report');
		$data['view_lap'] = 'laporan/view_rekapitulasi_mediator_detil';
		$data['perkara_nama'] = 'REKAPITULASI MEDIASI DETIL MEDIATOR';

		$data['rekap'] = $this->report->get_rekap($data['idmediator'],$data['idalurperkara'],$data['tahun']);
		//$data['tahun'] = $tahun;
		
		//$data['idalurperkara'] = $idalurperkara;
		
		$query = $this->report->get_info_pn();
		foreach ($query->result() as $row) {
			if($row->id == 62){
				if(!empty($row->value)){
					$data['nama_pn'] = $row->value;
				}
			}
		}
		$this->load->vars($data);
		$this->load->view('laporan/view_laporan_perkara');
		$this->load->view('footer');
	}

	function detil_mediator_bln(){
		$idalurperkara = $this->nativesession->get_flash_session('idalur');
		$tahun = $this->nativesession->get_flash_session('tahun');
		$type = $this->nativesession->get_flash_session('type');
		$tahapan = $this->nativesession->get_flash_session('tahapan');
		
		$segment = $this->uri->segment_array();
		$data['idmediator'] = $this->encrypt->decode(base64_decode($segment[3]));	
		$data['idalurperkara'] = $this->encrypt->decode(base64_decode($segment[5]));
		$data['tahun'] = $this->encrypt->decode(base64_decode($segment[4]));
		$data['bulan'] = $this->encrypt->decode(base64_decode($segment[6]));
		$data['nama_mediator'] = $this->encrypt->decode(base64_decode($segment[7]));
		$periode=$data['tahun'].'-'.$data['bulan'];

		$this->load->model('report/report_rekapitulasi_mediator_detil_bln','report');
		$data['view_lap'] = 'laporan/view_rekapitulasi_mediator_detil_bln';
		$data['perkara_nama'] = 'REKAPITULASI MEDIASI DETIL MEDIATOR';

		$data['rekap'] = $this->report->get_rekap($data['idmediator'],$data['idalurperkara'],$periode);
		//$data['tahun'] = $tahun;
		
		//$data['idalurperkara'] = $idalurperkara;
		
		$query = $this->report->get_info_pn();
		foreach ($query->result() as $row) {
			if($row->id == 62){
				if(!empty($row->value)){
					$data['nama_pn'] = $row->value;
				}
			}
		}
		$this->load->vars($data);
		$this->load->view('laporan/view_laporan_perkara');
		$this->load->view('footer');
	}

}