<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Tab_diversi_c extends CI_Controller {
	//dipakai
	function index(){
		$data=$this->load_data();
		$this->load->view('perkara_tab/diversi/tab_diversi_v', $data);
	}

	//dipakai
	function add_diversi(){
		$data=$this->load_data();
		$data['namahalaman']="TAMBAH DATA PENETAPAN KESEPAKATAN DIVERSI";
		$this->load->view('perkara_tab/diversi/add_diversi_v', $data);
	}

	//dipakai
	function edit_diversi(){
		$data=$this->load_data();
		$data['namahalaman']="EDIT DATA PENETAPAN KESEPAKATAN DIVERSI";
		$this->load->view('perkara_tab/diversi/edit_diversi_v', $data);
	}

	##adityo 201707
	//dipakai
	function edit_lanjut_diversi(){
		$data=$this->load_data();
		$data['select_keputusan_lanjut_diversi'] = array('-1'=>'Pilih Kesepakatan','1'=>'Sepakat Melaksanakan Diversi','2'=>'Tidak Sepakat Melaksanakan Diversi');
		$data['namahalaman']="EDIT DATA KESEPAKATAN PELAKSANAAN MUSYAWARAH DIVERSI";
		$this->load->view('perkara_tab/diversi/edit_lanjut_diversi_v', $data);
	}
	//dipakai
	function edit_hasil_diversi(){
		$data=$this->load_data();
		if($data['detail_diversi']->kesepakatan_melaksanakan_diversi==2){
			$data['select_hasil_diversi'] = "Tidak Berhasil/Tidak Mencapai Kesepakatan";
		}else{
			$data['select_hasil_diversi'] = array('-1'=>'Pilih Kesepakatan','1'=>'Berhasil/Mencapai Kesepakatan','0'=>'Tidak Berhasil/Tidak Mencapai Kesepakatan');
		}
		$data['isihslmusy']="
		-----Tuliskan Isi Hasil Kesepakatan Di Sini-----
		-----Dua Pasal Di Bawah Harus Termuat-----
		<p style='text-align:center;'>
		Pasal .....
		<br type='_moz'>
		</p>
		<p>
		Apabila kesepakatan ini tidak dipenuhi para pihak maka proses pemeriksaan dilanjutkan dalam proses persidangan
		</p>		
		<p style='text-align:center;'>
		Pasal .....
		<br type='_moz'>
		</p>
		<p>
		Kesepakatan ini dibuat oleh para pihak tanpa adanya unsur paksaan, kekeliruan dan penipuan dari pihak manapun
		</p>		
		";
		$data['namahalaman']="EDIT DATA HASIL MUSYAWARAH DIVERSI";
		$this->load->view('perkara_tab/diversi/edit_hasil_diversi_v', $data);
	}
	//dipakai
	function edit_penetapan_kesepakatan_diversi(){
		$data=$this->load_data();
		$data['namahalaman']="EDIT DATA PENETAPAN KESEPAKATAN DIVERSI";
		$this->load->view('perkara_tab/diversi/edit_penkesepakatan_diversi_v', $data);
	}
	//dipakai
	function edit_pelaksanaan_kesepakatan_diversi(){
		$data=$this->load_data();
		$data['laporan_pembimbing_masyarakat'] = array('-1'=>'Pilih','1'=>'Kesepakatan Diversi Dilaksanakan Sepenuhnya','2'=>'Kesepakatan Diversi Dilaksanakan Sebagian/Tidak Dilaksanakan');
		$data['namahalaman']="EDIT DATA PELAKSANAAN KESEPAKATAN DIVERSI";
		$this->load->view('perkara_tab/diversi/edit_pelaksanaan_diversi_v', $data);
	}
	##

	//dipakai
	function load_data(){
		if($this->nativesession->get_flash_session('security')==FALSE){
			redirect('main');
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$this->load->model('diversi/diversi_m');

		$this->load->library('ckeditor');
		$this->ckeditor->basePath = base_url().'resources/ckeditor/';
		$this->ckeditor->config['toolbar'] = array(
			array('-','Cut','Copy','Paste','PasteText','PasteFromWord',
				'-','Bold', 'Italic', 'Underline','Subscript', 'Superscript',
					'-', 'RemoveFormat','-', 'Blockquote',
					'-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock',
					'-','Undo','Redo','-','NumberedList','BulletedList','/',
					'-','Image'),
			array('-','Format', 'Font', 'FontSize',
				'-','TextColor', 'BGColor','Table',
				'-','Find', 'Replace', '-', 'SelectAll', '-', 'Scayt','-','HorizontalRule',
				'-','Print','Preview'
				));
		$this->ckeditor->config['pasteFromWordNumberedHeadingToList'] = 'true';
		$this->ckeditor->config['pasteFromWordPromptCleanup'] = 'true';
		$this->ckeditor->config['resize'] = 'false';
		$this->ckeditor->config['language'] = 'en';
		$this->ckeditor->config['width'] = '850px';
		$this->ckeditor->config['height'] = '250px';

		$data['current_date']	=	date('d/m/Y');
		$data['enc']			=	$this->nativesession->get_flash_session('enc');
		$data['encdiversi']		=	$this->nativesession->get_flash_session('encdiversi');
		$perkara_id				=	$this->encrypt->decode(base64_decode($data['enc']));
		$data['perkara']		=	$this->diversi_m->get_no_perkara($perkara_id)[0];
		$data['nomor_perkara']	=	$data['perkara']->nomor_perkara;
		$data['detail_diversi']	=	$this->diversi_m->get_data_diversi($perkara_id);
		
		if (empty($data['detail_diversi'])){
			$data['detail_diversi']=new stdClass();
			$data['detail_diversi']->pihak_diversi = "";
			$data['detail_diversi']->no_reg_penyidik = "";
			$data['detail_diversi']->no_reg_penuntut_umum = "";
			$data['detail_diversi']->tgl_penetapan_musyawarah = "";
			$data['detail_diversi']->tgl_musyawarah = "";
			$data['detail_diversi']->tgl_kesepakatan_diversi = "";
			$data['detail_diversi']->isi_singkat_diversi = "";
			$data['detail_diversi']->tgl_laporan_hakim = "";
			$data['detail_diversi']->tgl_penetapan_kesepakatan_diversi = "";
			$data['detail_diversi']->no_penetapan_kesepakatan = "";
			$data['detail_diversi']->tgl_lap_pembimbing_masyarakat = "";
			$data['detail_diversi']->hasil_diversi = -1;
			$data['detail_diversi']->dibuka_kembali = 0;
			$data['detail_diversi']->no_dibuka_kembali = "";
			$data['detail_diversi']->tgl_dibuka_kembali = "";
			$data['detail_diversi']->tgl_pelaksanaan_isi_diversi = "";
			$data['detail_diversi']->tgl_minutasi = "";
			$data['detail_diversi']->hasil_lap_pembimbing_masyarakat = "";
			$data['detail_diversi']->nomor_laporan_pembimbing_masyarakat = "";

		}
		$data['detail_terdakwa']	=	$this->diversi_m->get_data_terdakwa($perkara_id);
		$data['detail_korban']		=	$this->diversi_m->get_data_korban($perkara_id);
		$data['detail_pembimbing']	=	$this->diversi_m->get_data_pembimbing($perkara_id);
		$data['detail_peksos']		=	$this->diversi_m->get_data_peksos($perkara_id);
		$data['detail_wakil_m']		=	$this->diversi_m->get_data_perwakilan_m($perkara_id);
		
		$this->load->model('diversi/jadwal_diversi_m');
		$data['jdiversiterakhir']	=	$this->diversi_m->get_jadwal_diversi_terakhir($data['detail_diversi']->id);
		$data['jadwaldiversi']		=	$this->jadwal_diversi_m->get_data_jadwal_diversi($data['detail_diversi']->id);
		$data['detail_bb']			=	$this->diversi_m->get_data_barangbukti($perkara_id);
		
		$this->load->model('putusan/data_putusan_akhir');
		$data['adaputusanakhir']=$this->data_putusan_akhir->isDataPutusanExists($perkara_id);
		
		$this->load->model('penetapan/penetapan_m');
		$data['perkarapenetapan']=$this->penetapan_m->get_penetapan($perkara_id);
		return $data;
	}

	function f_validate_add(){
		$uncalke=$this->input->post();
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$this->form_validation->set_rules('tgl_penetapan_musyawarah', 'Tanggal Penetapan Musyawarah Diversi Pertama', 'trim|required|xss_clean');
		$this->form_validation->set_rules('tgl_musyawarah', 'Tanggal Musyawarah Diversi Pertama', 'trim|required|xss_clean');
		$this->form_validation->set_rules('pihak_diversi[]', 'Anak Berhadapan dengan Hukum', 'trim|required|xss_clean');

		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil '.validation_errors()));
			return;
		}else{
			$this->load->model('diversi/diversi_m');
			$perkara_id=$this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
			if(!is_numeric($perkara_id) OR intval($perkara_id) <1){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Perkara Tidak Diketahui.'));
				return;
			}

			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			$tgl_pen_hakim=$this->input->post('tglpenhakim',TRUE);
			
			$tgl_penetapan_musyawarah = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_penetapan_musyawarah',TRUE));
			if($tgl_penetapan_musyawarah==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Penetapan Musyawarah Diversi Pertama Tidak Benar. Format Tanggal : Hari/Bulan/Tahun. Contoh 20/01/2015.'));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tgl_penetapan_musyawarah);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Penetapan Musyawarah Diversi Dihari Libur, Sabtu Dan Minggu.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tgl_penetapan_musyawarah,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Musyawarah Diversi Pertama Tidak Boleh Melebihi Hari ini. Hari ini Tanggal, '.$todayDate));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tgl_pen_hakim,$tgl_penetapan_musyawarah);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Musyawarah Diversi Pertama Tidak Boleh Kurang Dari Tanggal Penetapan Hakim Fasilitator.'));
				return;
			}

			$tgl_musyawarah = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_musyawarah',TRUE));
			if($tgl_musyawarah==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Musyawarah Diversi Pertama Tidak Benar. Format Tanggal : Hari/Bulan/Tahun. Contoh 20/01/2015.'));
				return;
			}
			
			$dayname = $this->tanggalhelper->getDayName($tgl_musyawarah);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Musyawarah Diversi Pertama Di Hari Libur, Sabtu dan Minggu.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tgl_penetapan_musyawarah,$tgl_musyawarah);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Musyawarah Diversi Pertama Tidak Boleh Kurang Dari Tanggal Penetapan Musyawarah Diversi Pertama.'));
				return;
			}

			$pihak_diversi=implode(",", $this->input->post('pihak_diversi',TRUE));
			$namahalaman=$this->input->post('namahalaman',TRUE);
			$idberikut=$this->diversi_m->get_next_id_diversi();

			$this->load->model('diversi/register_diversi','register_diversi');
			$id_diversi			= $this->register_diversi->last_id_diversi();
			$no_urut_diversi	= $this->register_diversi->get_last_nomor_diversi()+1;
			$format_no_diversi	= '/Pen.Div/'.date(Y).'/PN '.$this->register_diversi->getKodePN(); 
			$new_no_diversi		= $no_urut_diversi.$format_no_diversi;

			$data_diversi=array(
				"id"						=> $idberikut,
				"perkara_id"				=> $perkara_id,
				"diversi_register_id"		=> $id_diversi,
	            "pihak_diversi"				=> $pihak_diversi,
	            "no_reg_penyidik"			=> NULL,
	            "no_reg_penuntut_umum"		=> NULL,
	            "tgl_penetapan_musyawarah"	=> $tgl_penetapan_musyawarah,
	            "tgl_musyawarah"			=> $tgl_musyawarah,
	            "hasil_diversi"				=> NULL,
	            "diinput_oleh"				=> $this->session->userdata('username'),
				"diinput_tanggal"			=> date('Y-m-d H:i:s')
			);	
			$query = $this->diversi_m->simpan_data_awal($perkara_id,$data_diversi,$tgl_musyawarah,$namahalaman);		

			$perkara=$this->diversi_m->get_no_perkara($perkara_id)[0];
			
			$data_diversi_register=array(
				"id"						=>  $id_diversi,
				"no_urut"					=>  $no_urut_diversi,
				"no_diversi"				=>	$new_no_diversi,
				"tgl_permohonan_diversi"	=>	$tgl_penetapan_musyawarah,
				"pemohon_diversi"			=>	'3',
				"no_perkara"				=>	$perkara->nomor_perkara,
				"perkara_id"				=>	$perkara->perkara_id,
				"pasal_sangkaan_dakwaan"	=>	$perkara->pasal_dakwaan,
				"diinput_oleh"				=>	$this->session->userdata('username'),
				"diinput_tanggal"			=>	date('Y-m-d H:i:s')
			);
			$result = $this->diversi_m->add_diversi_register($data_diversi_register,$namahalaman);	
				
			$this->load->model('riwayatperkara/riwayat_perkara_m');
			$this->riwayat_perkara_m->updateproses($perkara_id,'65',$tgl_penetapan_musyawarah,'',$namahalaman,'1');
			
			if($result==true){	
				echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan.'));	
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Terjadi Kesalahan Penyimpanan Data.'));
			}
		}
	}

	function f_validate_edit(){
		if(empty($_POST)){ show_404(); 	}
		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$this->form_validation->set_rules('tgl_penetapan_musyawarah', 'Tanggal Penetapan Musyawarah Diversi', 'trim|required|xss_clean');
		$this->form_validation->set_rules('tgl_musyawarah', 'Tanggal Musyawarah', 'trim|required|xss_clean');
		$this->form_validation->set_rules('pihak_diversi[]', 'Anak Berhadapan dengan Hukum', 'trim|required|xss_clean');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil '.validation_errors()));
			return;
		}else{
			$this->load->model('diversi/diversi_m');
			$perkara_id=$this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
			if(!is_numeric($perkara_id) OR intval($perkara_id) <1){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Perkara Tidak Diketahui.'));
				return;
			}

			$diversi_id=$this->encrypt->decode(base64_decode($this->input->post('encdiversi',TRUE)));
			if(!is_numeric($diversi_id) OR intval($diversi_id) <1){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Diversi Tidak Diketahui.'));
				return;
			}

			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			$tgl_penetapan_musyawarah = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_penetapan_musyawarah',TRUE));
			if($tgl_penetapan_musyawarah==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Penetapan Musyawarah Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tgl_penetapan_musyawarah,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Musyawarah Tidak Boleh Melebihi Hari ini. Hari ini Tanggal, '.$todayDate));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tgl_penetapan_musyawarah);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Musyawarah Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$tgl_musyawarah = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_musyawarah',TRUE));
			if($tgl_musyawarah==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Musyawarah Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}
			
			$dayname = $this->tanggalhelper->getDayName($tgl_musyawarah);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Musyawarah Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tgl_musyawarah);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Penetapan Musyawarah Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$pihak_diversi=implode(",", $this->input->post('pihak_diversi',TRUE));
			$namahalaman=$this->input->post('namahalaman',TRUE);
			
			$data_diversi=array(
				"pihak_diversi" => $pihak_diversi,
				"tgl_penetapan_musyawarah" => $tgl_penetapan_musyawarah,
				"tgl_musyawarah" => $tgl_musyawarah,
				"diperbaharui_oleh" => $this->session->userdata('username'),
				"diperbaharui_tanggal" => date('Y-m-d H:i:s')
			);
			$query = $this->diversi_m->edit_perkara_diversi($diversi_id,$data_diversi,$namahalaman);

			$data_diversi_load=$this->diversi_m->get_data_diversi($perkara_id);
			$data_diversi_register=array(
				"tgl_permohonan_diversi"	=>	$tgl_penetapan_musyawarah,
				"diperbaharui_oleh"			=>	$this->session->userdata('username'),
				"diperbaharui_tanggal"		=>	date('Y-m-d H:i:s')
			);
			$result = $this->diversi_m->update_diversi_register($data_diversi_load->diversi_register_id,$data_diversi_register,$namahalaman);			

			$this->load->model('riwayatperkara/riwayat_perkara_m');
			$this->riwayat_perkara_m->updateproses($perkara_id,'65',$tgl_penetapan_musyawarah,'',$namahalaman,'1');			
			
			if($result==true){	
				echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan.'));	
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Terjadi Kesalahan Penyimpanan Data.'));
			}
		}
	}
	
	//dipakai
	function f_hasil_diversi_check($str){
		if (intval($str)==-1){
			$this->form_validation->set_message('f_hasil_diversi_check', 'Pilih %s ');
			return FALSE;
		}else{
			return TRUE;
		}
	}

	//dipakai
	function validate_edit_lanjut_diversi(){
		if(empty($_POST)){ show_404(); 	}
		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$this->form_validation->set_rules('kesepakatan_melaksanakan_diversi', 'Kesepakatan Para Pihak Melaksanakan Diversi', 'trim|required|xss_clean|callback_f_hasil_diversi_check');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil '.validation_errors()));
			return;
		}else{
			$this->load->model('diversi/diversi_m');		

			$perkara_id=$this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
			if(!is_numeric($perkara_id) OR intval($perkara_id) <1){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Perkara Tidak Diketahui.'));
				return;
			}
			$diversi_id=$this->encrypt->decode(base64_decode($this->input->post('encdiversi',TRUE)));
			if(!is_numeric($diversi_id) OR intval($diversi_id) <1){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Diversi Tidak Diketahui.'));
				return;
			}

			$namahalaman=$this->input->post('namahalaman',TRUE);
			$kesepakatan_melaksanakan_diversi = $this->input->post('kesepakatan_melaksanakan_diversi',TRUE);

			// $query = $this->diversi_m->edit_kesepakatan_melaksanakan_diversi($perkara_id,$diversi_id,$kesepakatan_melaksanakan_diversi,$namahalaman);
			$data_diversi=array(
				"kesepakatan_melaksanakan_diversi"	=>	$kesepakatan_melaksanakan_diversi,
				"diperbaharui_oleh"					=>	$this->session->userdata('username'),
				"diperbaharui_tanggal"				=>	date('Y-m-d H:i:s')
			);
			$query=$this->diversi_m->edit_perkara_diversi($diversi_id,$data_diversi,$namahalaman);

			$detail_diversi=$this->diversi_m->get_data_diversi($perkara_id);
			
			$this->load->model('diversi/jadwal_diversi_m');
			$data['tgljdiversiterakhir']=$this->diversi_m->get_jadwal_diversi_terakhir($detail_diversi->id)->tanggal_musyawarah;
			$jumjdiversi=count($data['tgljdiversiterakhir']);
			if ($jumjdiversi==0){
				$data_add['id']=$this->jadwal_diversi_m->get_id_jadwal_diversi_terakhir()->row()->id + 1;
				$data_add['diversi_id']=$detail_diversi->id;
				$data_add['urutan']=1;
				$data_add['tanggal_musyawarah']=$detail_diversi->tgl_musyawarah;
				// $data_add['tempat']="Ditentukan Kemudian";
				$data_add['tempat']="";
				$data_add['ditunda']="T";
				$data_add['diinput_oleh']=$this->session->userdata('username');
				$data_add['diinput_tanggal']=date("Y-m-d h:i:s",time());
				$this->jadwal_diversi_m->add_jadwal_diversi($data_add);
			}

			$this->load->model('riwayatperkara/riwayat_perkara_m');
			if($kesepakatan_melaksanakan_diversi==1){
				$this->riwayat_perkara_m->updateproses($perkara_id,'66',$detail_diversi->tgl_musyawarah,'',$namahalaman,'1');
				$this->riwayat_perkara_m->updateproses($perkara_id,'68',$detail_diversi->tgl_musyawarah,'',$namahalaman,'1');
			}else{
				$this->riwayat_perkara_m->updateproses($perkara_id,'68',$detail_diversi->tgl_musyawarah,'',$namahalaman,'2');
				$this->riwayat_perkara_m->updateproses($perkara_id,'66',$detail_diversi->tgl_musyawarah,'',$namahalaman,'1');
			}
			
			if($query==true){	
				echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan.'));	
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Terjadi Kesalahan Penyimpanan Data.'));
			}
		}
	}

	//dipakai
	function validate_edit_hasil_diversi(){
		if(empty($_POST)){ show_404(); 	}
		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$this->form_validation->set_rules('hasil_diversi', 'Hasil Musyawarah Diversi', 'trim|required|xss_clean|callback_f_hasil_diversi_check');
		$this->form_validation->set_rules('tgl_hsl_musy_diversi', 'Tanggal Hasil Musyawarah Diversi', 'trim|required|xss_clean');
		$this->form_validation->set_rules('isi_hsl_musy_diversi_text', 'Isi Hasil Musyawarah Diversi', 'trim|required|xss_clean|min_length[50]');
		$this->form_validation->set_rules('tgl_laporan_hakim', 'Tanggal Laporan Hakim Fasilitator Kepada Ketua Pengadilan Negeri', 'trim|required|xss_clean');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil '.validation_errors()));
			return;
		}else{
			$this->load->model('diversi/diversi_m');		

			$perkara_id=$this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
			if(!is_numeric($perkara_id) OR intval($perkara_id) <1){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Nomor Perkara Tidak Diketahui.'));
				return;
			}

			$diversi_id=$this->encrypt->decode(base64_decode($this->input->post('encdiversi',TRUE)));
			if(!is_numeric($diversi_id) OR intval($diversi_id) <1){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Diversi Tidak Diketahui.'));
				return;
			}

			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			$tgl_hsl_musy_diversi=$this->input->post('tgl_hsl_musy_diversi',TRUE);
			if($tgl_hsl_musy_diversi==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Hasil Musyawarah Diversi Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$tgl_laporan_hakim=$this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_laporan_hakim',TRUE));
			if($tgl_laporan_hakim==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Laporan Hakim Fasilitator Kepada Ketua Pengadilan Negeri Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tgl_laporan_hakim);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Laporan Hakim Fasilitator Kepada Ketua Pengadilan Negeri Di Hari Libur, Sabtu dan Minggu.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tgl_laporan_hakim,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Laporan Hakim Fasilitator Kepada Ketua Pengadilan Negeri Tidak Boleh Melebihi Hari ini. Hari ini Tanggal, '.$todayDate));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tgl_hsl_musy_diversi,$tgl_laporan_hakim);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Laporan Hakim Fasilitator Kepada Ketua Pengadilan Negeri Tidak Boleh Kurang Dari Tanggal Hasil Musyawarah Diversi.'));
				return;
			}

			$isi_hsl_musy_diversi_text = trim($this->input->post('isi_hsl_musy_diversi_text',TRUE));
			$isi_hsl_musy_diversi_text = str_replace("&nbsp;", " ", $isi_hsl_musy_diversi_text);
			if(strlen($isi_hsl_musy_diversi_text)<50){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Isi Hasil Musyawarah Diversi Tidak Boleh kurang dari 50 Karakter'));
				return;
			}

			$hasil_diversi = $this->input->post('hasil_diversi',TRUE);
			$namahalaman=$this->input->post('namahalaman',TRUE);

			$data_diversi=array(
				"tgl_kesepakatan_diversi"	=> $tgl_hsl_musy_diversi,
				"isi_singkat_diversi"		=> $isi_hsl_musy_diversi_text,
				"tgl_laporan_hakim"			=> $tgl_laporan_hakim, 
				"hasil_diversi"				=> $hasil_diversi,
				"diperbaharui_oleh"			=> $this->session->userdata('username'),
				"diperbaharui_tanggal"		=> date('Y-m-d H:i:s')
			);	
			
			$query = $this->diversi_m->edit_perkara_diversi($diversi_id,$data_diversi,$namahalaman);
			
			$data_diversi=$this->diversi_m->get_data_diversi($perkara_id);
			$perkara=$this->diversi_m->get_no_perkara($perkara_id)[0];
			
			$data_diversi_register=array(
				"no_berita_acara"			=>	$perkara->nomor_perkara,
				"tgl_berita_acara"			=>	$tgl_hsl_musy_diversi,
				"tgl_kesepakatan_diversi"	=>	$tgl_hsl_musy_diversi,
				"isi_kesepakatan_diversi"	=>	$isi_hsl_musy_diversi_text,
				"diperbaharui_oleh"			=>	$this->session->userdata('username'),
				"diperbaharui_tanggal"		=>	date('Y-m-d H:i:s')
			);
			$result = $this->diversi_m->update_diversi_register($data_diversi->diversi_register_id,$data_diversi_register,$namahalaman);			
			
			$this->load->model('riwayatperkara/riwayat_perkara_m');
			if($hasil_diversi==1){
				$this->riwayat_perkara_m->updateproses($perkara_id,'70',$tgl_hsl_musy_diversi,'',$namahalaman,'1');
			}else{
				$this->riwayat_perkara_m->updateproses($perkara_id,'74',$tgl_hsl_musy_diversi,'',$namahalaman,'2');
				$this->riwayat_perkara_m->updateproses($perkara_id,'72',$tgl_hsl_musy_diversi,'',$namahalaman,'2');
				$this->riwayat_perkara_m->updateproses($perkara_id,'71',$tgl_hsl_musy_diversi,'',$namahalaman,'2');
				$this->riwayat_perkara_m->updateproses($perkara_id,'70',$tgl_hsl_musy_diversi,'',$namahalaman,'1');
			}
			
			if($result==true){	
				echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan.'));	
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Terjadi Kesalahan Penyimpanan Data.'));
			}
		}		
	}
	
	//dipakai
	function validate_edit_penetapan_kesepakatan_diversi(){
		if(empty($_POST)){ show_404(); 	}
		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		
		$this->form_validation->set_rules('tgl_penetapan_kesepakatan', 'Tanggal Penetapan Kesepakatan Diversi', 'trim|required|xss_clean');
		$this->form_validation->set_rules('tgl_mulai_pelaksanaan', 'Tanggal Mulai Pelaksanaan Kesepakatan Diversi', 'trim|required|xss_clean');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil '.validation_errors()));
			return;
		}else{
			$perkara_id=$this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
			if(!is_numeric($perkara_id) OR intval($perkara_id) <1){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Perkara Tidak Diketahui.'));
				return;
			}

			$diversi_id=$this->encrypt->decode(base64_decode($this->input->post('encdiversi',TRUE)));
			if(!is_numeric($diversi_id) OR intval($diversi_id) <1){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Diversi Tidak Diketahui.'));
				return;
			}

			$this->load->model('diversi/diversi_m');		
			
			$data_diversi=$this->diversi_m->get_data_diversi($perkara_id);
			
			$diversi_register=$this->diversi_m->get_diversi_register($diversi_id);
			$no_penetapan=$diversi_register->no_penetapan;
			
			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			$tgl_penetapan_kesepakatan=$this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_penetapan_kesepakatan',TRUE));
			if($tgl_penetapan_kesepakatan==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Penetapan Kesepakatan Diversi Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tgl_penetapan_kesepakatan);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Penetapan Kesepakatan Diversi Di Hari Libur, Sabtu dan Minggu.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tgl_penetapan_kesepakatan,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Kesepakatan Diversi Tidak Boleh Melebihi Hari ini. Hari ini Tanggal, '.$todayDate));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($data_diversi->tgl_laporan_hakim,$tgl_penetapan_kesepakatan);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Kesepakatan Diversi Tidak Boleh Kurang Dari Laporan Hakim Fasilitator Kepada Ketua Pengadilan Negeri'));
				return;
			}

			$tgl_mulai_pelaksanaan=$this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_mulai_pelaksanaan',TRUE));
			if($tgl_mulai_pelaksanaan==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Mulai Pelaksanaan Kesepakatan Diversi Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tgl_penetapan_kesepakatan,$tgl_mulai_pelaksanaan);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Mulai Pelaksanaan Kesepakatan Diversi Tidak Boleh Kurang Dari Tanggal Penetapan Kesepakatan Diversi'));
				return;
			}

			$namahalaman=$this->input->post('namahalaman',TRUE);

			$diversi_data=array(
				"tgl_penetapan_kesepakatan_diversi"	=>	$tgl_penetapan_kesepakatan,
				"no_penetapan_kesepakatan"			=>	$no_penetapan,
				"tgl_pelaksanaan_isi_diversi"		=>	$tgl_mulai_pelaksanaan,
				"diperbaharui_oleh"					=>	$this->session->userdata('username'),
				"diperbaharui_tanggal"				=>	date('Y-m-d H:i:s')
			);
			$result=$this->diversi_m->edit_perkara_diversi($diversi_id,$diversi_data,$namahalaman);
			
			$uraian_barang_bukti=$this->diversi_m->get_uraian_barang_bukti($perkara_id);
			$amar="
			1.&nbsp;Memerintahkan para pihak untuk melaksanakan Kesepakatan Diversi;
			<br>
			2.&nbsp;Memerintahkan pengadilan untuk bertanggung jawab atas barang bukti sampai Kesepakatan Diversi dilaksanakan seluruhnya/sepenuhnya;
			<br>
			3.&nbsp;Menetapkan barang bukti berupa ".$uraian_barang_bukti->uraian_barang_bukti." dalam hal Kesepakatan Diversi telah dilaksanakan;
			<br>
			4.&nbsp;Memerintahkan Panitera menyampaikan salinan penetapan ini kepada Hakim, Penuntut Umum dan Pembimbing Kemasyarakatan.
			";
			$diversi_register_data=array(
				"tanggal_penetapan_kpn"				=>	$tgl_penetapan_kesepakatan,
				"tgl_pengiriman_penetapan_kpn"		=>	$tgl_penetapan_kesepakatan,
				"amar"								=>	$amar,
				"tgl_pelaksanaan_isi_diversi"		=>	$tgl_mulai_pelaksanaan,
				"diperbaharui_oleh"					=>	$this->session->userdata('username'),
				"diperbaharui_tanggal"				=>	date('Y-m-d H:i:s')
			);
			$result=$this->diversi_m->update_diversi_register($diversi_register->iddiversiregister,$diversi_register_data,$namahalaman);
			
			$getbb=$this->diversi_m->get_data_barangbukti($perkara_id);
			foreach($getbb->result() as $row){
				$namaform='tindakan'.$row->id;
				$dataupdate=array(
					"tindakan_utk_pen_kesepakatan_diversi" => $this->input->post($namaform)
				);
				
				$result=$this->diversi_m->update_data_barangbukti($row->id,$dataupdate,$namahalaman);
			}

			$this->load->model('riwayatperkara/riwayat_perkara_m');
			$this->riwayat_perkara_m->updateproses($perkara_id,'71',$tgl_mulai_pelaksanaan,'',$namahalaman,'1');
			if($result==TRUE){	
				echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan.'));	
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Terjadi Kesalahan Penyimpanan Data.'));
			}
		}		
	}

	//dipakai
	function validate_edit_pelaksanaan_kesepakatan_diversi(){
		if(empty($_POST)){ show_404(); 	}
		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		
		$this->form_validation->set_rules('hasil_laporan_pembimbing_kemasyarakatan', 'Status Pelaksanaan Kesepakatan Diversi', 'trim|required|xss_clean|callback_f_hasil_diversi_check');
		$this->form_validation->set_rules('tgl_lap_pembimbing_masyarakat', 'Tanggal Laporan Pembimbing Kemasyarakatan Kepada Hakim Fasilitator', 'trim|required|xss_clean');
		$this->form_validation->set_rules('nomor_laporan_pembimbing_masyarakat', 'Nomor Laporan Pembimbing Kemasyarakatan Kepada Hakim Fasilitator', 'trim|required|xss_clean|max_length[50]');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil '.validation_errors()));
			return;
		}else{
			$perkara_id=$this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
			if(!is_numeric($perkara_id) OR intval($perkara_id) <1){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Perkara Tidak Diketahui.'));
				return;
			}

			$diversi_id=$this->encrypt->decode(base64_decode($this->input->post('encdiversi',TRUE)));
			if(!is_numeric($diversi_id) OR intval($diversi_id) <1){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Diversi Tidak Diketahui.'));
				return;
			}

			$this->load->model('diversi/diversi_m');		

			$data_diversi=$this->diversi_m->get_data_diversi($perkara_id);
			
			$hasil_laporan_pembimbing_kemasyarakatan = $this->input->post('hasil_laporan_pembimbing_kemasyarakatan',TRUE);

			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			$tgl_lap_pembimbing_masyarakat=$this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_lap_pembimbing_masyarakat',TRUE));
			if($tgl_lap_pembimbing_masyarakat==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Laporan Pembimbing Kemasyarakatan. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tgl_lap_pembimbing_masyarakat,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Laporan Pembimbing Kemasyarakatan Tidak Boleh Melebihi Hari ini. Hari ini Tanggal, '.$todayDate));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($data_diversi->tgl_pelaksanaan_isi_diversi,$tgl_lap_pembimbing_masyarakat);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Laporan Pembimbing Kemasyarakatan Tidak Boleh Kurang Dari Tanggal Mulai Pelaksanaan Kesepakatan Diversi'));
				return;
			}

			$nomor_laporan_pembimbing_masyarakat = $this->input->post('nomor_laporan_pembimbing_masyarakat',TRUE);

			$diversi_data=array(
				"hasil_lap_pembimbing_masyarakat"		=>	$hasil_laporan_pembimbing_kemasyarakatan,
				"tgl_lap_pembimbing_masyarakat"			=>	$tgl_lap_pembimbing_masyarakat,
				"nomor_laporan_pembimbing_masyarakat"	=>	$nomor_laporan_pembimbing_masyarakat,
				"diperbaharui_oleh"						=>	$this->session->userdata('username'),
				"diperbaharui_tanggal"					=>	date('Y-m-d H:i:s')
			);
			$namahalaman=$this->input->post('namahalaman',TRUE);
			$result=$this->diversi_m->edit_perkara_diversi($diversi_id,$diversi_data,$namahalaman);

			$this->load->model('riwayatperkara/riwayat_perkara_m');
			if($hasil_laporan_pembimbing_kemasyarakatan==1){
				$this->riwayat_perkara_m->updateproses($perkara_id,'74',$tgl_lap_pembimbing_masyarakat,'',$namahalaman,'1');
			}else{
				$this->riwayat_perkara_m->updateproses($perkara_id,'74',$tgl_lap_pembimbing_masyarakat,'',$namahalaman,'1');
			}
			if($result==TRUE){	
				echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan.'));	
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Terjadi Kesalahan Penyimpanan Data.'));
			}
		}
	}		

	function hapus_diversi(){
		if(empty($_POST)){ show_404(); 	}
		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$perkara_id=$this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($perkara_id) OR intval($perkara_id) <1){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Perkara Tidak Diketahui.'));
			return;
		}

		$diversi_id=$this->encrypt->decode(base64_decode($this->input->post('encdiversi',TRUE)));
		if(!is_numeric($diversi_id) OR intval($diversi_id) <1){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Diversi Tidak Diketahui.'));
			return;
		}
		$this->load->model('diversi/diversi_m');	

		$namahalaman=$this->input->post('namahalaman',TRUE);
		$result=$this->diversi_m->hapus_diversi($perkara_id, $diversi_id,$namahalaman);		

		$this->load->model('riwayatperkara/riwayat_perkara_m');
		$this->riwayat_perkara_m->updateproses($perkara_id,'74','','',$namahalaman,'2');
		$this->riwayat_perkara_m->updateproses($perkara_id,'72','','',$namahalaman,'2');
		$this->riwayat_perkara_m->updateproses($perkara_id,'71','','',$namahalaman,'2');
		$this->riwayat_perkara_m->updateproses($perkara_id,'70','','',$namahalaman,'2');
		$this->riwayat_perkara_m->updateproses($perkara_id,'68','','',$namahalaman,'2');
		$this->riwayat_perkara_m->updateproses($perkara_id,'66','','',$namahalaman,'2');
		$this->riwayat_perkara_m->updateproses($perkara_id,'65','','',$namahalaman,'2');

		if($result==TRUE){	
			echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Dihapus.'));	
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Terjadi Kesalahan Penghapusan Data.'));
		}
	}	

	function hapus_datapart_diversi(){
		if(empty($_POST)){ show_404(); 	}
		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$perkara_id=$this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($perkara_id) OR intval($perkara_id) <1){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Perkara Tidak Diketahui.'));
			return;
		}

		$diversi_id=$this->encrypt->decode(base64_decode($this->input->post('encdiversi',TRUE)));
		if(!is_numeric($diversi_id) OR intval($diversi_id) <1){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Diversi Tidak Diketahui.'));
			return;
		}
		
		$kode=$this->input->post('code',TRUE);
		if(!is_numeric($kode) OR intval($kode) <1){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Kode Tidak Diketahui.'));
			return;
		}
		
		$this->load->model('diversi/diversi_m');	
		$diversi_register=$this->diversi_m->get_diversi_register($diversi_id);
		$namahalaman=$this->input->post('namahalaman',TRUE);

		$this->load->model('riwayatperkara/riwayat_perkara_m');
		if($kode==4){
			$diversi_data=array(
				"hasil_lap_pembimbing_masyarakat"		=>	NULL,
				"tgl_lap_pembimbing_masyarakat"			=>	NULL,
				"nomor_laporan_pembimbing_masyarakat"	=>	NULL,
				"diperbaharui_oleh"						=> $this->session->userdata('username'),
				"diperbaharui_tanggal"					=> date('Y-m-d H:i:s')
			);
			
			$this->riwayat_perkara_m->updateproses($perkara_id,'74','','',$namahalaman,'2');
		}elseif($kode==3){
			//penetapan kesepakatan diversi
			$diversi_data=array(
				"tgl_penetapan_kesepakatan_diversi"	=>	NULL,
				"no_penetapan_kesepakatan"			=>	NULL,
				"tgl_pelaksanaan_isi_diversi"		=>	NULL,
				"diperbaharui_oleh"					=> $this->session->userdata('username'),
				"diperbaharui_tanggal"				=> date('Y-m-d H:i:s')
			);

			$diversi_register_data=array(
				"tanggal_penetapan_kpn"				=>	NULL,
				"tgl_pengiriman_penetapan_kpn"		=>	NULL,
				"amar"								=>	NULL,
				"tgl_pelaksanaan_isi_diversi"		=>	NULL,
				"diperbaharui_oleh"					=> $this->session->userdata('username'),
				"diperbaharui_tanggal"				=> date('Y-m-d H:i:s')
			);
			$result=$this->diversi_m->update_diversi_register($diversi_register->iddiversiregister,$diversi_register_data,$namahalaman);
			
			$getbb=$this->diversi_m->get_data_barangbukti($perkara_id);
			foreach($getbb->result() as $row){
				$namaform='tindakan'.$row->id;
				$dataupdate=array(
					"tindakan_utk_pen_kesepakatan_diversi" => NULL
				);
				$result=$this->diversi_m->update_data_barangbukti($row->id,$dataupdate,$namahalaman);
			}

			$this->riwayat_perkara_m->updateproses($perkara_id,'74','','',$namahalaman,'2');
			$this->riwayat_perkara_m->updateproses($perkara_id,'72','','',$namahalaman,'2');
			$this->riwayat_perkara_m->updateproses($perkara_id,'71','','',$namahalaman,'2');
		}elseif($kode==2){
			//hasil musyawarah diversi
			$diversi_data=array(
				"tgl_kesepakatan_diversi"	=> NULL,
				"isi_singkat_diversi"		=> NULL,
				"tgl_laporan_hakim"			=> NULL, 
				"hasil_diversi"				=> NULL,
				"diperbaharui_oleh"			=> $this->session->userdata('username'),
				"diperbaharui_tanggal"		=> date('Y-m-d H:i:s')
			);	

			$diversi_register_data=array(
				"no_berita_acara"			=>	NULL,
				"tgl_berita_acara"			=>	NULL,
				"tgl_kesepakatan_diversi"	=>	NULL,
				"isi_kesepakatan_diversi"	=>	NULL,
				"diperbaharui_oleh"			=> $this->session->userdata('username'),
				"diperbaharui_tanggal"		=> date('Y-m-d H:i:s')
			);
			$result=$this->diversi_m->update_diversi_register($diversi_register->iddiversiregister,$diversi_register_data,$namahalaman);
			
			$this->riwayat_perkara_m->updateproses($perkara_id,'74',$tgl_hsl_musy_diversi,'',$namahalaman,'2');
			$this->riwayat_perkara_m->updateproses($perkara_id,'72',$tgl_hsl_musy_diversi,'',$namahalaman,'2');
			$this->riwayat_perkara_m->updateproses($perkara_id,'71',$tgl_hsl_musy_diversi,'',$namahalaman,'2');
		}elseif($kode==1){
			//untuk sepakat/tidak sepakat melaksanakan diversi
			$this->diversi_m->hapus_jadwal_diversi($diversi_id,$namahalaman);
			$diversi_data=array(
				"kesepakatan_melaksanakan_diversi"		=> 0
			);	
			$this->riwayat_perkara_m->updateproses($perkara_id,'74',$tgl_hsl_musy_diversi,'',$namahalaman,'2');
			$this->riwayat_perkara_m->updateproses($perkara_id,'72',$tgl_hsl_musy_diversi,'',$namahalaman,'2');
			$this->riwayat_perkara_m->updateproses($perkara_id,'71',$tgl_hsl_musy_diversi,'',$namahalaman,'2');
			$this->riwayat_perkara_m->updateproses($perkara_id,'70',$tgl_hsl_musy_diversi,'',$namahalaman,'2');
			$this->riwayat_perkara_m->updateproses($perkara_id,'68',$tgl_hsl_musy_diversi,'',$namahalaman,'2');
			$this->riwayat_perkara_m->updateproses($perkara_id,'66',$tgl_hsl_musy_diversi,'',$namahalaman,'2');
		}
		
		$result=$this->diversi_m->edit_perkara_diversi($diversi_id,$diversi_data,$namahalaman);
		if($result==TRUE){	
			echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Dihapus.'));	
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Terjadi Kesalahan Penghapusan Data.'));
		}
	}	
}