<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Rekonvensi extends CI_Controller {
	function index($enc){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$data['enc'] = $enc;
		$data['perkara_id'] = $this->encrypt->decode(base64_decode($enc));
		$this->load->model('rekonvensi/rekonvensi_m','rekonvensi');

		$data_rekon = $this->rekonvensi->get_info_rekonvensi($data['perkara_id']);
		$data['tanggal_pendaftaran'] = '';
		$data['isi_petitum'] = '';
		$data['parapihak'] = '';
		if($data_rekon->num_rows>0){
			foreach ($data_rekon->result() as $row) {
				$data['tanggal_pendaftaran'] = $row->tanggal_pendaftaran;
				$data['isi_petitum'] = $row->isi_petitum;
				$data['parapihak'] = $row->parapihak;
			}
		}
		$this->load->view('perkara_tab/rekonvensi/tab_rekonvensi', $data);
	}

	function add_rekonven($enc){

		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$data['enc'] = $enc;
		$data['perkara_id'] = $this->encrypt->decode(base64_decode($enc));
		$this->load->model('rekonvensi/rekonvensi_m','rekonvensi');

		$data_rekon = $this->rekonvensi->get_info_rekonvensi($data['perkara_id']);
		$data['tanggal_pendaftaran'] = '';
		$data['isi_petitum'] = '';
		if($data_rekon->num_rows>0){
			foreach ($data_rekon->result() as $row) {
				$data['tanggal_pendaftaran'] = $row->tanggal_pendaftaran;
				$data['isi_petitum'] = $row->isi_petitum;
			}
		}
		$data['current_date'] = date('d/m/Y');
		$data['list_penggugat'] = $this->rekonvensi->get_para_pihak($data['perkara_id'],1);
		$data['list_tergugat'] = $this->rekonvensi->get_para_pihak($data['perkara_id'],2);
		$data['list_turut_tergugat'] = $this->rekonvensi->get_para_pihak($data['perkara_id'],4);
		$data['parapihakrekonvensi'] = $this->rekonvensi->getListParaPihak($data['perkara_id']);
		$this->assign_ckeditor();
		$this->load->view('perkara_tab/rekonvensi/form_add_rekonvensi',$data);
	}

	function assign_ckeditor(){
		$this->load->library('ckeditor');
		$this->ckeditor->basePath = base_url().'resources/ckeditor/';
		$this->ckeditor->config['toolbar'] = array(
			array('-','Cut','Copy','Paste','PasteText','PasteFromWord',
				'-','Bold', 'Italic', 'Underline','Subscript', 'Superscript',
					'-', 'RemoveFormat','-', 'Blockquote',
					'-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock',
					'-','Undo','Redo','-','NumberedList','BulletedList','/',
					'-','Image'),
			array('-','Format', 'Font', 'FontSize',
				'-','TextColor', 'BGColor','Table',
				'-','Find', 'Replace', '-', 'SelectAll', '-', 'Scayt','-','HorizontalRule',
				'-','Print','Preview'
				));
		$this->ckeditor->config['pasteFromWordNumberedHeadingToList'] = 'true';
		$this->ckeditor->config['pasteFromWordPromptCleanup'] = 'true';
		$this->ckeditor->config['resize'] = 'false';
		$this->ckeditor->config['language'] = 'en';
		$this->ckeditor->config['width'] = '850px';
		$this->ckeditor->config['height'] = '200px';
	}

	function validateInput(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		$this->form_validation->set_rules('tgl_pendaftaran', 'Tanggal Pendaftaran Rekonvensi', 'trim|required|xss_clean|exact_length[10]');
		
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$idperkara = ($this->encrypt->decode(base64_decode($this->input->post('enc', TRUE))));

			$tgl_pendaftaran = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_pendaftaran', TRUE));

			if($tgl_pendaftaran==false){
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}
			
			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			$selisih = $this->tanggalhelper->getSelisihHari($tgl_pendaftaran,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Tanggal Pendaftaran Rekonvensi Tidak Boleh Melebihi Hari Ini. Hari ini Tanggal '.$todayDate));
				return;
			}

			$tgl_pendaftaran_gugatan = $this->tanggalhelper->getTanggalPendaftaran($idperkara);
			$selisih = $this->tanggalhelper->getSelisihHari($tgl_pendaftaran_gugatan,$tgl_pendaftaran);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Tanggal Pendaftaran Rekonvensi Tidak Boleh Kurang Dari Tanggal Pendaftaran Konvensi'));
				return;
			}

			$this->load->model('rekonvensi/rekonvensi_m','rekonvensi');
			$data_pihak = array();
			$data_termohon = array();
			$parapihakrekonvensi = '';
			$pihak2_list = $this->input->post('para_pihak2',TRUE);
			$urutan_turut_termohon =1;
			if(!empty($pihak2_list)){
				$i=0;
				foreach ($pihak2_list as $key) {
					$tmp = explode('_', $key);
					if($tmp[1]=='2')
						$pihak_asal = 'Tergugat';
					elseif($tmp[1]=='4')
						$pihak_asal = 'Turut Tergugat';
					else{
						echo json_encode(array('st'=>0,'msg'=>'Pihak Tidak Ditemukan'));
						return;
					}
					$key = $tmp[0];
					$urutan = $this->input->post('pihak_'.$key,TRUE);
					$pihakdetil = $this->rekonvensi->get_info_pihak($key);
					if($pihakdetil->num_rows>0){
						foreach ($pihakdetil->result() as $row) {
							$nama = $row->nama;
							$alamat = $row->alamat;
						}
					}else{
						echo json_encode(array('st'=>0,'msg'=>'Informasi Pihak Penggugat Tidak Ditemukan'));
						return;
					}
					
					if(empty($urutan) OR intval($urutan)<1){
						echo json_encode(array('st'=>0,'msg'=>'Mohon Memilih Urutan Penggugat '.$nama));
						return;
					}
					
					$data_pihak[$i] = array(
						'perkara_id' => $idperkara,
						'pihak_id' => $key,
						'tanggal_pendaftaran' => $tgl_pendaftaran,
						'urutan' => $urutan,
						'status_pihak_id' => 1,
						'status_pihak_text' => 'Penggugat',
						'pihak_asal' => $tmp[1],
						'pihak_asal_text' => $pihak_asal,
						'nama' => $nama,
						'alamat' => $alamat,
						'diinput_oleh'=>$this->session->userdata('username'),
						'diinput_tanggal'=>date('Y-m-d H:i:s')
						);
					$i++;
					$parapihakrekonvensi .= 'Penggugat Ke-'.$i.'. '.$nama.' (Dahulu '.$pihak_asal.')</br>';
				}
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Pilih Pihak Penggugat Rekonvensi Terlebih Dahulu'));
				return;
			}
			/*
			$list_tergugat = $this->rekonvensi->get_para_pihak($idperkara,2);

			if($list_tergugat->num_rows>0){
				foreach ($list_tergugat->result() as $row) {
					$idpihak = $row->pihak_id;
					if($this->isThere($pihak2_list,$idpihak)==FALSE){
						$pihakdetil = $this->rekonvensi->get_info_pihak($idpihak);
						if($pihakdetil->num_rows>0){
							foreach ($pihakdetil->result() as $row) {
									$nama = $row->nama;
									$alamat = $row->alamat;
								}
						}else{
							echo json_encode(array('st'=>0,'msg'=>'Informasi Pihak Turut Tergugat Tidak Ditemukan'));
							return;
						}
						$data_pihak[$i] = array(
							'perkara_id' => $idperkara,
							'pihak_id' => $idpihak,
							'tanggal_pendaftaran' => $tgl_pendaftaran,
							'urutan' => $urutan_turut_termohon,
							'status_pihak_id' => 5,
							'status_pihak_text' => 'Turut Tergugat',
							'pihak_asal' => 2,
							'pihak_asal_text' => 'Tergugat',
							'nama' => $nama,
							'alamat' => $alamat,
							'diinput_oleh'=>$this->session->userdata('username'),
							'diinput_tanggal'=>date('Y-m-d H:i:s')
						);
						$parapihakrekonvensi .= 'Turut Tergugat Ke-'.$urutan_turut_termohon.'. '.$nama.' (Dahulu Tergugat)</br>';
						$i++;
						$urutan_turut_termohon++;
					}
				}
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Pihak Penggugat Rekonvensi Tidak Ditemukan. Please Logout dan Login kembali'));
				return;
			}*/


			$pihak1_list = $this->input->post('para_pihak1',TRUE);
			if(!empty($pihak1_list)){
				$i = 1;
				foreach ($pihak1_list as $key) {
					$urutan = $this->input->post('pihak_'.$key,TRUE);
					$pihakdetil = $this->rekonvensi->get_info_pihak($key);

					if($pihakdetil->num_rows>0){
						foreach ($pihakdetil->result() as $row) {
							$nama = $row->nama;
							$alamat = $row->alamat;
						}
					}else{
						echo json_encode(array('st'=>0,'msg'=>'Informasi Pihak Pemohon Tidak Ditemukan'));
						return;
					}

					if(empty($urutan) OR intval($urutan)<1){
						echo json_encode(array('st'=>0,'msg'=>'Mohon Memilih Urutan Tergugat '.$nama));
						return;
					}
					$data_pihak[$i] = array(
						'perkara_id' => $idperkara,
						'pihak_id' => $key,
						'tanggal_pendaftaran' => $tgl_pendaftaran,
						'urutan' => $urutan,
						'status_pihak_id' => 1,
						'status_pihak_text' => 'Tergugat',
						'pihak_asal' => 1,
						'pihak_asal_text' => 'Pengugat',
						'nama' => $nama,
						'alamat' => $alamat,
						'diinput_oleh'=>$this->session->userdata('username'),
						'diinput_tanggal'=>date('Y-m-d H:i:s')
						);
					$parapihakrekonvensi .= 'Tergugat Ke-'.$i.'. '.$nama.' (Dahulu Penggugat)</br>';
					$i++;
					
				}
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Pilih Pihak Tergugat'));
				return;
			}

			$list_penggugat = $this->rekonvensi->get_para_pihak($idperkara,1);

			if($list_penggugat->num_rows>0){
				foreach ($list_penggugat->result() as $row) {
					$idpihak = $row->pihak_id;
					if($this->isThere($pihak1_list,$idpihak)==FALSE){
						$pihakdetil = $this->rekonvensi->get_info_pihak($idpihak);
						if($pihakdetil->num_rows>0){
							foreach ($pihakdetil->result() as $row) {
									$nama = $row->nama;
									$alamat = $row->alamat;
								}
						}else{
							echo json_encode(array('st'=>0,'msg'=>'Informasi Pihak Turut Tergugat Tidak Ditemukan'));
							return;
						}
						$data_pihak[$i] = array(
							'perkara_id' => $idperkara,
							'pihak_id' => $idpihak,
							'tanggal_pendaftaran' => $tgl_pendaftaran,
							'urutan' => $urutan_turut_termohon,
							'status_pihak_id' => 5,
							'status_pihak_text' => 'Turut Tergugat',
							'pihak_asal' => 1,
							'pihak_asal_text' => 'Penggugat',
							'nama' => $nama,
							'alamat' => $alamat,
							'diinput_oleh'=>$this->session->userdata('username'),
							'diinput_tanggal'=>date('Y-m-d H:i:s')
						);
						$i++;
						$parapihakrekonvensi .= 'Turut Tergugat Ke-'.$urutan_turut_termohon.'. '.$nama.' (Dahulu Penggugat)</br>';
						$urutan_turut_termohon++;
					}
				}
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Pihak Turut Tergugat Rekonvensi Tidak Ditemukan. Please Logout dan Login kembali'));
				return;
			}

			$isi_petitum = trim($this->input->post('isi_petitum_text',TRUE));
			if(strlen($isi_petitum)<50){
				echo json_encode(array('st'=>0,'msg'=>'Tidak Berhasil, Mohon Memasukan Data isi petitum rekonvensi secara lengkap.'));
			return;
			}
			$data = array(
					'perkara_id'=>$idperkara, 
					'tanggal_pendaftaran'=>$tgl_pendaftaran,
					'parapihak'=>$parapihakrekonvensi,
					'isi_petitum'=>$isi_petitum,
					'diinput_oleh'=>$this->session->userdata('username'),
					'diinput_tanggal'=>date('Y-m-d H:i:s')
				);
			$result = $this->rekonvensi->add_rekonvensi($data);
			$result = $this->rekonvensi->add_pihak_rekonvensi($idperkara,$data_pihak);
			if($result){
				echo json_encode(array('st'=>1,'msg'=>'Data Rekonvensi Berhasil Disimpan.'));
				return;
			}
			echo json_encode(array('st'=>0,'msg'=>'Data Rekonvensi Tidak Berhasil Disimpan.'));
			return;
		}
	}

	function isThere($pihakList,$idpihak){
		foreach ($pihakList as $val) {
			if($idpihak==$val){
				return TRUE;
			}
		}
		return FALSE;
	}

	function validateDelete(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = ($this->encrypt->decode(base64_decode($this->input->post('enc', TRUE))));
		if(empty($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Invalid Data.'));
			return;
		}
		$this->load->model('rekonvensi/rekonvensi_m','rekonvensi');
		$result = $this->rekonvensi->deleteData($idperkara);
		if($result){
				echo json_encode(array('st'=>1,'msg'=>'Data Rekonvensi Berhasil Dihapus.'));
				return;
			}
			echo json_encode(array('st'=>0,'msg'=>'Data Rekonvensi Tidak Berhasil Dihapus.'));
			return;
	}
}