<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Perkara_list_grasi extends CI_Controller {

	function index(){
		if($this->session->userdata('is_logged_in')===FALSE){
			redirect('login');
		}
		$functions = $this->nativesession->get_flash_session('function');
		$enc = $this->nativesession->get_flash_session('enc');

		if($this->session->userdata('is_logged_in') AND empty($enc)){
			redirect('dashboard');
		}
		$idalurperkara = $this->encrypt->decode(base64_decode($enc));
		if($functions == 'sort'){
			$col = $this->nativesession->get_flash_session('col');
			$keyword = $this->nativesession->get_flash_session('keyword');
			$this->sort($col,$enc,$keyword);
		}elseif($functions == 'type'){
			$this->session->set_userdata('total_rows',-1);
			$this->showData($enc,$idalurperkara);
		}elseif($functions == 'page'){
			$page = $this->nativesession->get_flash_session('page');
			$keyword = $this->nativesession->get_flash_session('keyword');
			$column_sorted = $this->nativesession->get_flash_session('col');
			$this->showData($enc,$idalurperkara,$column_sorted,$page,$keyword);
		}elseif($functions == 'search'){
			$keyword ='';
			if($this->nativesession->is_flash_session('keyword')===TRUE){
				$keyword = $this->nativesession->get_flash_session('keyword');
				$this->session->set_userdata('keyword',$keyword);
			}else{
				$this->session->set_userdata('keyword','');
			}
			$page = $this->nativesession->get_flash_session('page');
			$this->session->set_userdata('total_rows',-1);
			$this->showData($enc,$idalurperkara,2,$page,$keyword);
		}else{
			$this->session->set_userdata('asc_desc','DESC');
			$this->session->set_userdata('total_rows',-1);
			$this->showData();
		}
	}

	function sort($col=null,$enc=null,$keyword=null){
		if($this->session->userdata('asc_desc')){
			if($this->session->userdata('asc_desc')=="DESC"){
				$this->session->set_userdata('asc_desc','ASC');
			}else{
				$this->session->set_userdata('asc_desc','DESC');
			}
		}else{
			$this->session->set_userdata('asc_desc','ASC');
		}

		$idalurperkara = $this->encrypt->decode(base64_decode($enc));
		$this->showData($enc,$idalurperkara,$col,0,$keyword);
	}

	function showData($enc='',$idalurperkara='',$col=2,$start_page=0,$keyword=''){
		if($this->session->userdata('is_logged_in')===FALSE){
			redirect('login');
		}
		$asc_desc = $this->session->userdata('asc_desc');
		$this->load->model('perkara/grasi');
		if($start_page>0){
			$begin_limit = ($start_page-1)*50;
		}else{
			$begin_limit = 0;
			$start_page = 1;
		}
		$query = $this->grasi->getPerkaraList($idalurperkara,$col,$asc_desc,$begin_limit,$keyword);
		
		$data['list_perkara'] = $query;

		if($this->session->userdata('total_rows')){
			if($this->session->userdata('total_rows')==-1){
				$data['total_rows'] = $this->grasi->fecth_data_num($idalurperkara,$keyword);
				$this->session->set_userdata('total_rows',$data['total_rows']);
			}else{
				$data['total_rows'] = $this->session->userdata('total_rows');
			}
		}else{
			$data['total_rows'] = $this->grasi->fecth_data_num($idalurperkara,$keyword);
			$this->session->set_userdata('total_rows',$data['total_rows']);
		}
		
		$title_perkara = '';
		$tmp = explode(",", $idalurperkara);
		if(count($tmp)>0){
			for ($i=0; $i < count($tmp); $i++) {
				if($i>0){
					$title_perkara .= " DAN ";
				}
				$title_perkara .= strtoupper($this->grasi->getJenisPerkara($tmp[$i]));
			}
		}else{
			$title_perkara = strtoupper($this->grasi->getJenisPerkara($idalurperkara));
		}
		
		$data['page_active'] = $begin_limit;
		$data['page_title'] = 'DAFTAR PERKARA PERMOHONAN GRASI '.$title_perkara;
		
		$data['main_body'] = 'perkara_list/perkara_list_grasi';
		$data['enc'] = $enc;
		$data['idalurperkara'] = $idalurperkara;
		$data['lang_nomor_perkara']=$this->nativesession->getLangguage('nomor_perkara');
		
		$data['page_number'] = $start_page;
		$data['page_url'] = 'perkara_grasi_list';
		$data['keyword'] = $keyword;
		$data['column_sorted'] = $col;
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body');
	}
}