<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class penuntutan_c extends CI_Controller {

	function ckeditor()
	{
		#configurasi CKeditor, this editior has been costumize for SIPP need.
		$this->load->library('ckeditor');
		$this->ckeditor->basePath = base_url().'resources/ckeditor/';
		$this->ckeditor->config['toolbar'] = array(
			array('-','Cut','Copy','Paste','PasteText','PasteFromWord',
				'-','Bold', 'Italic', 'Underline','Subscript', 'Superscript',
					'-', 'RemoveFormat','-', 'Blockquote',
					'-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock',
					'-','Undo','Redo','-','NumberedList','BulletedList','/',
					'-','Image'),
			array('-','Format', 'Font', 'FontSize',
				'-','TextColor', 'BGColor','Table',
				'-','Find', 'Replace', '-', 'SelectAll', '-', 'Scayt','-','HorizontalRule',
				'-','Print','Preview'
				));
		$this->ckeditor->config['pasteFromWordNumberedHeadingToList'] = 'true';
		$this->ckeditor->config['pasteFromWordPromptCleanup'] = 'true';
		$this->ckeditor->config['resize'] = 'false';
		$this->ckeditor->config['language'] = 'en';
		$this->ckeditor->config['width'] = '850px';
		$this->ckeditor->config['height'] = '250px';
	}
	
	function index(){
        if($this->session->userdata('is_logged_in')===FALSE){
        redirect('login'); }

		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$data['idperkara']=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($data['idperkara']) OR !intval($data['idperkara'])>0){
            show_404();
            exit();
        }
		
		$this->load->model('penuntutan/penuntutan_m'); //panggil file model jadwalsidang/jadwal_sidang
		
		if ($query=$this->penuntutan_m->get_detil_data_penuntutan($data['idperkara'])){
			$data['penuntutanrecords']=$query;
		}
		$this->load->view('perkara_tab/penuntutan_v',$data);
	}

	function tambah(){
        if($this->nativesession->get_flash_session('security')==FALSE){
        	redirect('main');
    	}

        if($this->session->userdata('is_logged_in')==FALSE){
        	redirect('login');
        }

		$data['curr_date'] = date('d/m/Y');

		$data['enc']=$this->nativesession->get_flash_session('enc');
		$idperkara=($this->encrypt->decode(base64_decode($data['enc'])));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }

		$this->load->model('penuntutan/penuntutan_m');
		
		if ($query=$this->penuntutan_m->get_detil_data_utama($idperkara));{
			$data['detpenuntutan']=$query;
		}
		$this->ckeditor();
		$data['namahalaman']="TAMBAH DATA TUNTUTAN";
		$this->load->view('perkara_tab/penuntutan_p_tambah',$data);
	}

	function edit()
	{
        if($this->nativesession->is_flash_session('security')===FALSE){
        redirect('main'); }

        if($this->session->userdata('is_logged_in')===FALSE){
        redirect('login'); }

		$data['curr_date'] = date('d/m/Y'); // ini didunakan untuk validasi tanggal

		$data['enc']=$this->nativesession->get_flash_session('enc');
		$idperkara=($this->encrypt->decode(base64_decode($data['enc'])));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }

		$this->load->model('penuntutan/penuntutan_m'); //panggil file model jadwalsidang/jadwal_sidang
		
		if ($query=$this->penuntutan_m->get_detil_data_penuntutan($idperkara));
		{
			$data['detpenuntutan']=$query;
		}

		$this->ckeditor();
		$data['namahalaman']="EDIT DATA TUNTUTAN";
		$this->load->view('perkara_tab/penuntutan_p_edit',$data);
	}

	function validateEdit(){
        if($this->session->userdata('is_logged_in')==FALSE){
        	redirect('login');
    	}

		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}


		$this->form_validation->set_rules('tgl_tuntutan', 'Tanggal Tuntutan', 'required|trim|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('isituntutan', 'Isi Penuntutan', 'required|trim|xss_clean|min_length[50]');

		if ($this->form_validation->run() == FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}
		else{
			$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc')));
	        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
	            show_404();
	            exit();
	        }

			$tanggaltuntutan = $this->input->post('tgl_tuntutan',TRUE);
			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			$tanggaltuntutan = $this->tanggalhelper->convertToMysqlDate($tanggaltuntutan);
			if($tanggaltuntutan==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tanggaltuntutan,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Tuntutan Tidak Boleh Melebihi Hari ini. Hari ini Tanggal, '.$todayDate));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tanggaltuntutan);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Tuntutan Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$isituntutan = trim($this->input->post('isituntutan_text',TRUE));
			$isituntutan = str_replace("&nbsp;", " ", $isituntutan);
			
			if(strlen($isituntutan)<50){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Isi Tuntutan Tidak Boleh kurang dari 50 Karakter'));
				return;
			}

			$datainsert=array(
				'tanggal_penuntutan'=>$tanggaltuntutan,
				'isi_penuntutan'=>$isituntutan,
				'diperbaharui_oleh' => $this->session->userdata('username'),
				'diperbaharui_tanggal' => date("Y-m-d h:i:s",time()),
			);

			$this->load->model('penuntutan/penuntutan_m');
			$namahalaman = $this->input->post('namahalaman',TRUE);
			if($this->penuntutan_m->update_penuntutan($idperkara,$datainsert,$namahalaman)){
				$this->load->model('riwayatperkara/riwayat_perkara_m');
				$this->riwayat_perkara_m->updateproses($idperkara,'206',$tanggaltuntutan,'',$namahalaman,1);
				echo json_encode(array('st'=>1,'msg'=>'Perubahan Data Tuntutan Berhasil'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'));
				return;
			}
		}
	}

	function validateTambah(){
		if($this->session->userdata('is_logged_in')===FALSE){
        	redirect('login');
        }

		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$this->form_validation->set_rules('tgl_tuntutan', 'Tanggal Tuntutan', 'required|trim|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('isituntutan_text', 'Isi Penuntutan', 'required|trim|xss_clean');

		if ($this->form_validation->run() == FALSE)
		{
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}
		else
		{
			$this->load->model('penuntutan/penuntutan_m');

			$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc')));
	        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
	            show_404();
	            exit();
	        }

			$tanggaltuntutan=$this->input->post('tgl_tuntutan',TRUE);
			$cektgl=strpos($tanggaltuntutan,'/');

			if ($cektgl>0)
			{
				$tanggaltuntutan=$this->tanggalhelper->convertToMysqlDate($tanggaltuntutan);
			}

			$isituntutan = trim($this->input->post('isituntutan_text',TRUE));
			$isituntutan = str_replace('%3Cp%3E', '', $isituntutan);
			$isituntutan = str_replace('%3C%2Fp%3E%0A', '', $isituntutan);

			if(strlen($isituntutan)<50){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Isi Tuntutan Tidak Boleh kurang dari 50 Karakter'));
				return;
			}

			$datainsert=array(
				'perkara_id'=>$idperkara,
				'tanggal_penuntutan'=>$tanggaltuntutan,
				'isi_penuntutan'=>$isituntutan,
				'diinput_oleh' => $this->session->userdata('username'),
				'diinput_tanggal' => date("Y-m-d h:i:s",time()),
				);
			
			$namahalaman = $this->input->post('namahalaman',TRUE);
			if($this->penuntutan_m->tambah_penuntutan($datainsert,$namahalaman))
			{
				$this->load->model('riwayatperkara/riwayat_perkara_m');
				$this->riwayat_perkara_m->updateproses($idperkara,'206',$tanggaltuntutan,'',$namahalaman,1);
				echo json_encode(array('st'=>1,'msg'=>'Penambahan Data Tuntutan Berhasil'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'));
				return;
			}
		}
	}

	function hapus_penuntutan(){
        if($this->nativesession->is_flash_session('security')===FALSE){
        redirect('main'); }

        if($this->session->userdata('is_logged_in')===FALSE){
        redirect('login'); }

		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->uri->segment(3)));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }
		
		// ===== Script ini disesuaikan dengan yang ada di fileupload_c =====
		$this->load->model('fileupload/fileupload_m');
		$idkirim=$idperkara;
		$from="tuntut";
		$namadokumen=$this->fileupload_m->get_nama_dok($idkirim,$from);

		//check file and directory to delete
		$arrdirectory=explode('/',$namadokumen);
		array_pop($arrdirectory);
		$direktori=implode("/",$arrdirectory);
		$arrparentdirectory=explode('/',$direktori);
		array_pop($arrparentdirectory);
		$parentdirektori=implode("/",$arrparentdirectory);
		
		//delete the file
		@unlink($namadokumen);
		//delete the directories if empty. if at least one file inside, this script is passed automaticaly
		@rmdir($direktori); 
		@rmdir($parentdirektori); 

		// ===================================================================
		$this->load->model('penuntutan/penuntutan_m');
		$namahalaman = $this->input->post('namahalaman',TRUE);
		if($this->penuntutan_m->hapus_penuntutan($idperkara,$namahalaman)){
			$this->load->model('riwayatperkara/riwayat_perkara_m');
			$this->riwayat_perkara_m->updateproses($idperkara,'206','','',$namahalaman,2);
			echo json_encode(array('st'=>1,'msg'=>'Penghapusan Data Tuntutan Berhasil'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Penghapusan Data Tuntutan Tidak Berhasil'));
			return;
		}
	}
}
/* End of file penuntutan_c.php */
/* Location: ./application/controllers/penuntutan_c.php */