<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Penahanan_list_c extends CI_Controller {
	function index(){
		if($this->session->userdata('is_logged_in')===FALSE){
			redirect('login');
			return;
		}
		$this->nativesession->set_flash_session('url_from_dataumum', '');
		$this->nativesession->set_flash_session('security', TRUE);
		$functions = $this->nativesession->get_flash_session('function');
		$enc = $this->nativesession->get_flash_session('enc');

		if($this->session->userdata('is_logged_in') AND empty($enc)){
			redirect('dashboard');
		}
		$idalurperkara = $this->encrypt->decode(base64_decode($enc));
		if($functions == 'sort'){
			$col = $this->nativesession->get_flash_session('col');
			$keyword = $this->nativesession->get_flash_session('keyword');
			$this->sort($col,$enc,$keyword);
		}elseif($functions == 'type'){
			$this->session->set_userdata('asc_desc','DESC');
			$this->session->set_userdata('total_rows',-1);
			$this->showData($enc,$idalurperkara);
		}elseif($functions == 'page'){
			$page = $this->nativesession->get_flash_session('page');
			$keyword = $this->nativesession->get_flash_session('keyword');
			$column_sorted = $this->nativesession->get_flash_session('col');
			$this->showData($enc,$idalurperkara,$column_sorted,$page,$keyword);
		}elseif($functions == 'search'){
			$keyword ='';
			if($this->nativesession->is_flash_session('keyword')===TRUE){
				$keyword = $this->nativesession->get_flash_session('keyword');
				$this->session->set_userdata('keyword',$keyword);
			}else{
				$this->session->set_userdata('keyword','');
			}
			$page = $this->nativesession->get_flash_session('page');
			$this->session->set_userdata('total_rows',-1);
			$this->showData($enc,$idalurperkara,2,$page,$keyword);
		}else{
			$this->session->set_userdata('asc_desc','DESC');
			$this->session->set_userdata('total_rows',-1);
			$this->showData();
		}
	}

	function sort($col=null,$enc=null,$keyword=null){
		if($this->session->userdata('asc_desc')){
			if($this->session->userdata('asc_desc')=="DESC"){
				$this->session->set_userdata('asc_desc','ASC');
			}else{
				$this->session->set_userdata('asc_desc','DESC');
			}
		}else{
			$this->session->set_userdata('asc_desc','ASC');
		}
		$idalurperkara = $this->encrypt->decode(base64_decode($enc));
		$this->showData($enc,$idalurperkara,$col,0,$keyword);
	}

	function showData($enc='',$idalurperkara='',$col=2,$start_page=0,$keyword=''){
		
		$asc_desc = $this->session->userdata('asc_desc');
		$this->load->model('penahanan/penahanan_m');
		
		if($start_page>0){
			$begin_limit = ($start_page-1)*50;
		}else{
			$begin_limit = 0;
			$start_page = 1;
		}
		$query = $this->penahanan_m->getPenahananList($idalurperkara,$col,$asc_desc,$begin_limit,$keyword);
		
		$data['list_perkara'] = $query;

		if($this->session->userdata('total_rows')){
			if($this->session->userdata('total_rows')==-1){
				$data['total_rows'] = $this->penahanan_m->fecth_data_num($idalurperkara,$keyword);
				$this->session->set_userdata('total_rows',$data['total_rows']);
			}else{
				$data['total_rows'] = $this->session->userdata('total_rows');
			}
		}else{
			$data['total_rows'] = $this->penahanan_m->fecth_data_num($idalurperkara,$keyword);
			$this->session->set_userdata('total_rows',$data['total_rows']);
		}
		
		$data['page_active'] = $begin_limit;
		$data['page_title'] = 'REGISTER PENAHANAN PERKARA '.strtoupper($this->penahanan_m->getJenisPerkara($idalurperkara));
		$data['previous'] = $this->nativesession->get_flash_session('url_requested');
		$data['main_body'] = 'penahanan_list/penahanan_list_v';
		$data['enc'] = $enc;
		$data['idalurperkara'] = $idalurperkara;
		
		$data['page_number'] = $start_page;
		$data['page_url'] = 'perkara_list';
		$data['keyword'] = $keyword;
		$data['column_sorted'] = $col;
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body');
	}

}