<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class mediasi_diluar extends CI_Controller {
	function index(){
        if($this->nativesession->is_flash_session('security')===FALSE){
        redirect('main'); }

        if($this->session->userdata('is_logged_in')===FALSE){
        redirect('login'); }

		$idperkara = $this->encrypt->decode(base64_decode($this->nativesession->get_flash_session('enc')));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }
		
		$this->load->model('mediasi/mediasi_luar_m'); 
		$query					= $this->mediasi_luar_m->get_data_mediasi($idperkara);
		if(!empty($query)){
			foreach ($query->result() as $var) {
				$data['tgl_kesepakatan']	= $this->tanggalhelper->convertDayDate($var->tgl_kesepakatan_perdamaian);
				$data['mediator']			= $var->mediator_text;
				$data['status_mediator']	= $var->status_mediator;
				if(empty($var->isi_kesepakatan_perdamaian)){
					$data['kesepakatan_perdamaian'] = "-";
				}else{
					$data['kesepakatan_perdamaian'] = "Telah diisi";
				}
				$data['keterangan'] 				= $var->catatan_mediasi;
			}
		}
		print_r($data['mediator_text']);
		$data['enc'] = base64_encode($this->encrypt->encode($idperkara));
		$this->load->view('perkara_tab/mediasi_diluar_v',$data);
	}

	function kesepakatan_mediasi(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$segment 		= $this->uri->segment_array();
		$data['enc']	= $segment[3];
		$idperkara 		= $this->encrypt->decode(base64_decode($data['enc']));												
		if(empty($idperkara) OR intval($idperkara)<1){
			show_404();
		}
		$this->load->model('mediasi/mediasi_luar_m');
		$data['current_date'] 	= date('d/m/Y');		
		$data_mediasi			= $this->mediasi_luar_m->get_data_mediasi($idperkara);
		if(!empty($data_mediasi)){
			if($data_mediasi->num_rows>0){
				foreach ($data_mediasi->result() as $row) {
					$data['tgl_kesepakatan'] 			= $this->tanggalhelper->convertToInputDate($row->tgl_kesepakatan_perdamaian);
					$data['isi_kesepakatan_perdamaian'] = $row->isi_kesepakatan_perdamaian;
					$data['keterangan'] 				= $row->catatan_mediasi;
				}
				$data['action'] 		= 'edit';
				$data['data_mediator']	= $this->mediasi_luar_m->get_mediator_edit($idperkara);
			}else{
				$data['action'] = 'add';
			}												
		}		
		$data_perkara = $this->mediasi_luar_m->getInfoPerkara($idperkara);
		if(!empty($data_perkara)){
			if($data_perkara->num_rows()>0){
				foreach ($data_perkara->result() as $row) {
					$data['nomor_perkara'] = $row->nomor_perkara;
					$data['tgl_pendaftaran'] = $this->templatehelper->convertKeTglIndo($row->tanggal_pendaftaran);
					$data['default_tgl_pendaftaran'] = $this->tanggalhelper->convertToInputDate($row->tanggal_pendaftaran);
				}
			}
		}
		$this->ckeditor();
		$this->load->vars($data);
		$this->load->view('perkara_tab/mediasi_diluar_edit');
	}

	function validate_input_add(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = ($this->encrypt->decode(base64_decode($this->input->post('enc'))));
		if(empty($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}
		$action 			= $this->input->post('action');
		$btn_action			= $this->input->post('btn_action');
		$isi_kesepakatan 	= $this->input->post('isi_kesepakatan_text');
		$jml_mediator 		= count($_POST["mediator"]);
		for ($i=0; $i <$jml_mediator ; $i++) { 
			$this->form_validation->set_rules('mediator['.$i.']', 'Nama Mediator', 'trim|xss_clean');
		}
		$this->form_validation->set_rules('isi_kesepakatan_text', 'Isi Kesepakatan', 'trim|required|min_length[5]|xss_clean');
		$this->form_validation->set_rules('tgl_mediasi', 'Tanggal Kesepakatan Mediasi Di Luar Pengadilan', 'trim|required|max_length[10]|xss_clean');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;

		}else{
			$tgl_kesepakatan_mediasi = $this->input->post('tgl_mediasi', TRUE);
			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			$tgl_kesepakatan_mediasi = $this->tanggalhelper->convertToMysqlDate($tgl_kesepakatan_mediasi);
			if($tgl_kesepakatan_mediasi==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}
			$selisih = $this->tanggalhelper->getSelisihHari($tgl_kesepakatan_mediasi,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}

			$this->load->model('mediasi/mediasi_luar_m');
			$maxid 				= $this->mediasi_luar_m->get_maxid_mediasi()->row()->maxid;
			$id_mediasi 		= $maxid;
			$arr_mediator_id 	= array();
			$i=1;
			foreach($this->input->post('mediatorid') as $val){
				$arr_mediator_id[] = $this->encrypt->decode(base64_decode($val,TRUE));
				$nomor = $i++;
			}
			$arr 				= $this->input->post('mediator');
			$arr_status			= $this->input->post('status');
			$mediator_text		= implode("<br/>", $arr);
			$status 			= implode(",",$arr_status);
			$mediator_id 		= implode(',',$arr_mediator_id);
			$datamediasi = array(
								'tahapan_id' 					=> 10,
								'perkara_id' 					=> $idperkara,
								'jenis_mediasi' 				=> 3,
								'mediator_id'					=> $mediator_id,
								'status_mediator'				=> $status,
								'mediator_text'					=> $mediator_text,
								'tgl_kesepakatan_perdamaian' 	=> $tgl_kesepakatan_mediasi,
								'isi_kesepakatan_perdamaian'	=> $isi_kesepakatan,
								'catatan_mediasi'				=> $this->input->post('keterangan',TRUE)
			);
			if($arr_mediator_id[0]!=''){
				$diperbaharui_tanggal 	= $this->mediasi_luar_m->get_date_tanggal($idperkara);
				$jml_perkara_mediator	= $this->mediasi_luar_m->get_perkara_mediator();
				$result 				= $this->mediasi_luar_m->delete_update($idperkara);
				$id_perkara_mediator	= intval($jml_perkara_mediator+1);
			
				for($i=0; $i< $jml_mediator; $i++){
					$data_mediator = array(
									'id'					=> $id_perkara_mediator,
									'perkara_id' 			=> $idperkara,
									'mediator_id' 			=> $this->encrypt->decode(base64_decode($_POST["mediatorid"][$i],TRUE)),
									'status_mediator' 		=> $_POST["status"][$i],
									'nama_mediator' 		=> $_POST["mediator"][$i],
									'aktif' 				=> 'Y',							
									'diinput_oleh' 			=> $this->session->userdata('username'),
					);
					if($btn_action=='add'){
						$data_mediator['diinput_tanggal'] = date("Y-m-d h:i:s",time());
					}else{
						$data_mediator['diinput_tanggal'] 		= $diperbaharui_tanggal[0]->diinput_tanggal;
						$data_mediator['diperbaharui_oleh']		= $this->session->userdata('username');
						$data_mediator['diperbaharui_tanggal'] 	= date("Y-m-d h:i:s",time());
					}

				$result = $this->mediasi_luar_m->addmediator($data_mediator,$action);
				$id_perkara_mediator++;
				}
			}
			if($action=='add'){
				$datamediasi['mediasi_id'] 		= $id_mediasi;
				$datamediasi['diinput_oleh']	= $this->session->userdata('username');
				$datamediasi['diinput_tanggal']	= date("Y-m-d h:i:s",time());
				$result = $this->mediasi_luar_m->addmediasi($datamediasi,$action);
			}else{
				$datamediasi['diperbaharui_oleh']	= $this->session->userdata('username');
				$datamediasi['diperbaharui_tanggal']= date("Y-m-d h:i:s",time());
				$result = $this->mediasi_luar_m->addmediasi($datamediasi,$action,$idperkara);
			}
			
			if($result){
				echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Error, Data Tidak Dapat Disimpan'));
				return;
			}
		}
	}

	function hapus_tgl_kesepakatan(){
		if(empty($_POST)){
			show_404();
		}
		
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = ($this->encrypt->decode(base64_decode($this->input->post('enc'))));
		if(empty($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$this->load->model('mediasi/mediasi_luar_m');
		$delData = $this->mediasi_luar_m->hapus_kesepakatan($idperkara);
		if($delData){
			echo json_encode(array('st'=>1,'msg'=>'Data Mediasi Berhasil Di Hapus.'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Penghapusan Data Mediasi Gagal.'));
			return;
		}
	}
	function popup_mediator($var=NULL){
		$this->load->model('mediasi/mediasi_luar_m');
		$data['data_mediator'] 	= $this->mediasi_luar_m->get_mediator();
		$data['nilai_var'] 		= $var;
		$data['judulatas']		='DAFTAR MEDIATOR LUAR PENGADILAN';
		$this->load->vars($data);
		$this->load->view('perkara_tab/popup_mediator');
	}

	function ckeditor(){
		$this->load->library('ckeditor');
		$this->ckeditor->basePath = base_url().'resources/ckeditor/';
		$this->ckeditor->config['toolbar'] = array(
			array('-','Cut','Copy','Paste','PasteText','PasteFromWord',
				'-','Bold', 'Italic', 'Underline','Subscript', 'Superscript',
					'-', 'RemoveFormat','-', 'Blockquote',
					'-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock',
					'-','Undo','Redo','-','NumberedList','BulletedList','/',
					'-','Image'),
			array('-','Format', 'Font', 'FontSize',
				'-','TextColor', 'BGColor','Table',
				'-','Find', 'Replace', '-', 'SelectAll', '-', 'Scayt','-','HorizontalRule',
				'-','Print','Preview'
				));
		$this->ckeditor->config['pasteFromWordNumberedHeadingToList'] = 'true';
		$this->ckeditor->config['pasteFromWordPromptCleanup'] = 'true';
		$this->ckeditor->config['resize'] = 'false';
		$this->ckeditor->config['language'] = 'en';
		$this->ckeditor->config['width'] = 'aut0';
		$this->ckeditor->config['height'] = '150px';
	}
}
