<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Manage_register_diversi extends CI_Controller {
	
	function index(){
		$functions = $this->nativesession->get_flash_session('function');
		$enc = $this->nativesession->get_flash_session('enc');

		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}

		if($functions == 'sort'){
			$col = $this->nativesession->get_flash_session('col');
			$keyword = $this->nativesession->get_flash_session('keyword');
			$this->sort($col,$enc,$keyword);
		}elseif($functions == 'type'){
			$this->session->set_userdata('total_rows',-1);
			$this->showData($enc,$idalurperkara);
		}elseif($functions == 'page'){
			$page = $this->nativesession->get_flash_session('page');
			$keyword = $this->nativesession->get_flash_session('keyword');
			$column_sorted = $this->nativesession->get_flash_session('col');
			$this->showData($keyword,$column_sorted,$page);
		}elseif($functions == 'search'){
			$keyword ='';
			if($this->nativesession->is_flash_session('keyword')){
				$keyword = $this->nativesession->get_flash_session('keyword');
				$this->session->set_userdata('keyword',$keyword);
			}else{
				$this->session->set_userdata('keyword','');
			}
			$page = $this->nativesession->get_flash_session('page');
			$this->session->set_userdata('total_rows',-1);
			$this->showData($keyword);
		}else{
			$this->session->set_userdata('asc_desc','DESC');
			$this->session->set_userdata('total_rows',-1);
			$this->showData();
		}

	}

	function sort($col=null,$enc=null,$keyword=null){
		if($this->session->userdata('asc_desc')){
			if($this->session->userdata('asc_desc')=="DESC"){
				$this->session->set_userdata('asc_desc','ASC');
			}else{
				$this->session->set_userdata('asc_desc','DESC');
			}
		}else{
			$this->session->set_userdata('asc_desc','ASC');
		}
		$this->showData($keyword,$col,0);
	}

	function showData($keyword='',$col=2,$start_page=0){
		if($this->nativesession->is_flash_session('keyword') AND empty($keyword)){
			$keyword = $this->nativesession->get_flash_session('keyword');
		}
			
		$asc_desc = $this->session->userdata('asc_desc');
		$this->load->model('diversi/register_diversi','register_diversi');
		if($start_page>0){
			$begin_limit = ($start_page-1)*50;
		}else{
			$begin_limit = 0;
			$start_page = 1;
		}
		$query = $this->register_diversi->get_register_diversi_list($col,$asc_desc,$begin_limit,$keyword);
		
		$data['diversi_list'] = $query;
		if($this->session->userdata('total_rows')){
			if($this->session->userdata('total_rows')==-1){
				$data['total_rows'] = $this->register_diversi->fecth_data_num();
				$this->session->set_userdata('total_rows',$data['total_rows']);
			}else{
				$data['total_rows'] = $this->session->userdata('total_rows');
			}
		}else{
			$data['total_rows'] = $this->register_diversi->fecth_data_num();
			$this->session->set_userdata('total_rows',$data['total_rows']);
		}
		$data['page_active'] = $begin_limit;
		$data['page_title'] = 'REGISTER KESEPAKATAN DIVERSI';

		$data['main_body'] = 'diversi/register_diversi_list_v';
		$data['enc'] = "-";

		$data['page_number'] = $start_page;
		$data['page_url'] = 'register_diversi_list';
		$data['keyword'] = $keyword;
		$data['column_sorted'] = $col;
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body');
	}

	function info(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$this->load->model('staff/register_diversi','register_diversi');
		$enc_biaya = intval($this->encrypt->decode(base64_decode($this->input->post('enc',TRUE))));
		$enc_alur=intval($this->encrypt->decode(base64_decode($this->input->post('enc_alur',TRUE))));
		if($enc_biaya>0) {
				$query = $this->register_diversi->get_register_diversi_info($enc_alur,$enc_biaya);
				if($query->num_rows>0){
					foreach ($query->result() as $row) {
						echo json_encode(array(
							'st'=>1,
							'enc_by'=>base64_encode($this->encrypt->encode($row->jenis_biaya_id)),
							'enc_al'=>base64_encode($this->encrypt->encode($row->alur_perkara_id)),
							'klasifikasi'=>$row->alur_perkara_id,
	        				'tahapan_proses'=>$row->tahapan_id,
	        				'jenis_transaksi'=>$row->jenis_transaksi,
	        				'kategori_biaya'=>$row->kategori_id,
	        				'jenis_biaya'=>$row->jenis_biaya_id,
	        				'jumlah'=>str_replace(str_split(',.'),'',number_format($row->jumlah)),
	        				'keterangan'=>$row->keterangan,
	        				'aktif'=>$row->aktif
							)
						);
						return;
					}
				}else{
					return;
				}
		}else{
			return;
		}
	}

	function validate_input(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		$enc_biaya = $this->encrypt->decode(base64_decode($this->input->post('enc_by',TRUE)));
		$enc_alur=$this->encrypt->decode(base64_decode($this->input->post('enc_al',TRUE)));
		
		$enc_biaya = $this->encrypt->decode(base64_decode($this->input->post('enc_by')));
		if(!is_numeric($enc_biaya) OR !intval($enc_biaya)>0){
			echo json_encode(array('st'=>0,'msg'=>'Referensi Biaya Perkara Tidak Ditemukan.'));
			return;
		}
		$enc_alur = $this->encrypt->decode(base64_decode($this->input->post('enc_al')));
		if(!is_numeric($enc_alur) OR !intval($enc_alur)>0){
			echo json_encode(array('st'=>0,'msg'=>'Alur Perkara Tidak Ditemukan.'));
			return;
		}

		$this->load->model('staff/register_diversi','register_diversi');
		$this->form_validation->set_rules('jumlah', 'Jumlah Biaya', 'numeric|xss_clean');
		$this->form_validation->set_rules('keterangan', 'Keterangan', 'trim|xss_clean');

		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
		}else{

			$aktif = array(
				'aktif'=> $this->input->post('aktif',TRUE)
			);

			$data = array(
               'jumlah' => intval($this->input->post('jumlah',TRUE)),
               'keterangan' => $this->input->post('keterangan',TRUE)
            );
			if ($this->register_diversi->update_data($data,$aktif,$enc_biaya,$enc_alur)){
				echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Saat Simpan Kedatabase'));
				return;
			}
		}
		
	}

	function searchPage(){
		if(empty($_POST)){
			show_404();
		}
		$keyword = $this->input->post('keyword_pihak',TRUE);
		$column = $this->input->post('search_field',TRUE);
		$this->nativesession->set_flash_session('security', TRUE);
		$this->nativesession->set_flash_session('keyword_pihak', $keyword);
		$this->nativesession->set_flash_session('column', $column);
		echo json_encode(array('st'=>1));
	}
}

?>