<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class manage_panitera_pt extends CI_Controller {
	function index(){
		$functions = $this->nativesession->get_flash_session('function');
		$enc = $this->nativesession->get_flash_session('enc');

		#prevent direct access to page
		#the user should only access the page through menu
		if($this->nativesession->get_flash_session('security')==FALSE){
			redirect('main');
		}
		$sec = $this->nativesession->get_flash_session('security');
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}

		if($functions == 'sort'){
			$col = $this->nativesession->get_flash_session('col');
			$keyword = $this->nativesession->get_flash_session('keyword');
			$this->sort($col,$enc,$keyword);
		}elseif($functions == 'type'){
			$this->session->set_userdata('total_rows',-1);
			$this->showData($enc,$idalurperkara);
		}elseif($functions == 'page'){
			$page = $this->nativesession->get_flash_session('page');
			$keyword = $this->nativesession->get_flash_session('keyword');
			$column_sorted = $this->nativesession->get_flash_session('col');
			$this->showData($keyword,$column_sorted,$page);
		}elseif($functions == 'search'){
			$keyword ='';
			if($this->nativesession->is_flash_session('keyword')){
				$keyword = $this->nativesession->get_flash_session('keyword');
				$this->session->set_userdata('keyword',$keyword);
			}else{
				$this->session->set_userdata('keyword','');
			}
			$page = $this->nativesession->get_flash_session('page');
			$this->session->set_userdata('total_rows',-1);
			$this->showData($keyword);
		}else{
			$this->session->set_userdata('asc_desc','ASC');
			$this->session->set_userdata('total_rows',-1);
			$this->showData();
		}

	}

	function sort($col=null,$enc=null,$keyword=null){
		if($this->session->userdata('asc_desc')){
			if($this->session->userdata('asc_desc')=="DESC"){
				$this->session->set_userdata('asc_desc','ASC');
			}else{
				$this->session->set_userdata('asc_desc','DESC');
			}
		}else{
			$this->session->set_userdata('asc_desc','ASC');
		}
		$this->showData($keyword,$col,0);
	}

	function showData($keyword='',$col=3,$start_page=0){
		if($this->nativesession->is_flash_session('keyword') AND empty($keyword)){
			$keyword = $this->nativesession->get_flash_session('keyword');
		}
			
		$asc_desc = $this->session->userdata('asc_desc');
		$this->load->model('staff/panitera_pt','staff');
		if($start_page>0){
			$begin_limit = ($start_page-1)*50;
		}else{
			$begin_limit = 0;
			$start_page = 1;
		}
		$query = $this->staff->get_panitera_list($col,$asc_desc,$begin_limit,$keyword);
		
		$data['users_list'] = $query;
		if($this->session->userdata('total_rows')){
			if($this->session->userdata('total_rows')==-1){
				$data['total_rows'] = $this->staff->fecth_data_num();
				$this->session->set_userdata('total_rows',$data['total_rows']);
			}else{
				$data['total_rows'] = $this->session->userdata('total_rows');
			}
		}else{
			$data['total_rows'] = $this->staff->fecth_data_num();
			$this->session->set_userdata('total_rows',$data['total_rows']);
		}
		
		$data['page_active'] = $begin_limit;
		$data['page_title'] = 'DAFTAR PANITERA PENGADILAN TINGGI';
		
		$data['main_body'] = 'staff/panitera_pt_list';
		$data['enc'] = "-";
		
		$data['page_number'] = $start_page;
		$data['page_url'] = 'panitera_pt_list';
		$data['keyword'] = $keyword;
		$data['column_sorted'] = $col;
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body');
	}

	function info(){
		if(empty($_POST)){
			show_404();
		}
		$this->load->model('staff/panitera_pt','staff');
		if($this->input->post('enc',TRUE)){
			$id = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
			if(!empty($id)){
				$query = $this->staff->get_panitera_info($id);
				if($query->num_rows>0){
					foreach ($query->result() as $row) {
						echo json_encode(array(
							'st'=>1,
							'idH'=>$row->id,
							'nama'=>$row->nama,
							'pangkat'=>$row->pangkat,
							'jabatan'=>$row->jabatan,							
							'nama_gelar'=>$row->nama_gelar,
							'nip'=>$row->nip,
							'aktif'=>$row->aktif,
							'kode'=>$row->kode,
							'ket'=>$row->keterangan
							)
						);
					}
				}
			}else{
				echo json_encode(array('st'=>0));
			}
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Invalid Argument'));
		}
	}

	function validate_input(){
		if(empty($_POST)){
			show_404();
		}
		$this->load->model('staff/panitera_pt','staff');
		$id = $this->input->post('idH',TRUE);
		$update = FALSE;
		$status = FALSE;
		if(!empty($id) AND $id>0){
			$this->form_validation->set_rules('idH', 'Panitera', 'trim|required|xss_clean|numeric');
			$update = TRUE;
		}else{
			$row = $this->staff->get_last_id();
			$id = $row->id+1;
		}

		if($this->session->userdata('jenis_pengadilan')==2){
			$this->form_validation->set_rules('pangkat', 'Pangkat', 'trim|required|xss_clean');
			$this->form_validation->set_rules('jabatan', 'jabatan', 'trim|required|xss_clean');	
		}

		$this->form_validation->set_rules('kode_panitera', 'Kode Panitera', 'trim|xss_clean');
		$this->form_validation->set_rules('nama', 'Nama Tanpa Gelar', 'trim|required|xss_clean');
		$this->form_validation->set_rules('nama_gelar', 'Nama Dengan Gelar', 'trim|required|xss_clean]');
		$this->form_validation->set_rules('aktif', 'Aktif', 'trim|required|xss_clean|numeric');
		$this->form_validation->set_rules('keterangan', 'Keterangan', 'trim|xss_clean');

		if($update AND ($this->input->post('nip',TRUE)===$this->input->post('nip_lama',TRUE))){
			if($this->session->userdata('jenis_pengadilan')!=2){
				$this->form_validation->set_rules('nip', 'NIP Panitera', 'trim|required|xss_clean|numeric|min_length[9]|max_length[18]');
			}
		}else{
			if($this->session->userdata('jenis_pengadilan')!=2){
				$this->form_validation->set_rules('nip', 'NIP Panitera', 'trim|required|xss_clean|numeric|min_length[9]|max_length[18]|is_unique[panitera_pt.nip]');
			}else{
				$this->form_validation->set_rules('nip', 'NIP Panitera', 'trim|required|xss_clean|min_length[5]|max_length[18]|is_unique[panitera_pt.nip]');
			}	
		}

		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
		}else{
			$aktif = ($this->input->post('aktif',TRUE)==1)? 'Y':'T';
			$data = array(
               'kode' => $this->input->post('kode_panitera',TRUE),
               'nip' => $this->input->post('nip',TRUE),
               'pangkat' => $this->input->post('pangkat',TRUE),
               'jabatan' => $this->input->post('jabatan',TRUE),              
               'nama' => $this->input->post('nama',TRUE),
               'nama_gelar' => $this->input->post('nama_gelar',TRUE),
               'aktif' => $aktif,
               'keterangan' => $this->input->post('keterangan',TRUE)
            );
            if($update){
            	$data['diperbaharui_oleh'] = $this->session->userdata('username');
				$data['diperbaharui_tanggal'] = date("Y-m-d h:i:s",time());
				$status = $this->staff->update_data($data,$id);
            }else{
            	$data['id'] = $id;
            	$data['diinput_oleh'] = $this->session->userdata('username');
				$data['diinput_tanggal'] = date("Y-m-d h:i:s",time());
				$status = $this->staff->add_data($data);
            }
			if($status===TRUE){
				echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
			}else{
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Saat Simpan Kedatabase'));
			}
		}
	}
}

?>