<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class manage_mediator extends CI_Controller {
	function index(){
		$functions = $this->nativesession->get_flash_session('function');
		$enc = $this->nativesession->get_flash_session('enc');

		#prevent direct access to page
		#the user should only access the page through menu
		if($this->nativesession->get_flash_session('security')==FALSE){
			redirect('main');
		}
		$sec = $this->nativesession->get_flash_session('security');

		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}


		if($functions == 'sort'){
			$col = $this->nativesession->get_flash_session('col');
			$keyword = $this->nativesession->get_flash_session('keyword');
			$this->sort($col,$enc,$keyword);
		}elseif($functions == 'type'){
			$this->session->set_userdata('total_rows',-1);
			$this->showData($enc,$idalurperkara);
		}elseif($functions == 'page'){
			$page = $this->nativesession->get_flash_session('page');
			$keyword = $this->nativesession->get_flash_session('keyword');
			$column_sorted = $this->nativesession->get_flash_session('col');
			$this->showData($keyword,$column_sorted,$page);
		}elseif($functions == 'search'){
			$keyword ='';
			if($this->nativesession->is_flash_session('keyword')){
				$keyword = $this->nativesession->get_flash_session('keyword');
				$this->session->set_userdata('keyword',$keyword);
			}else{
				$this->session->set_userdata('keyword','');
			}
			$page = $this->nativesession->get_flash_session('page');
			$this->session->set_userdata('total_rows',-1);
			$this->showData($keyword);
		}else{
			$this->session->set_userdata('asc_desc','ASC');
			$this->session->set_userdata('total_rows',-1);
			$this->showData();
		}

	}

	function sort($col=null,$enc=null,$keyword=null){
		if($this->session->userdata('asc_desc')){
			if($this->session->userdata('asc_desc')=="DESC"){
				$this->session->set_userdata('asc_desc','ASC');
			}else{
				$this->session->set_userdata('asc_desc','DESC');
			}
		}else{
			$this->session->set_userdata('asc_desc','ASC');
		}
		$this->showData($keyword,$col,0);
	}

	function showData($keyword='',$col=3,$start_page=0){
		if($this->nativesession->is_flash_session('keyword') AND empty($keyword)){
			$keyword = $this->nativesession->get_flash_session('keyword');
		}
			
		$asc_desc = $this->session->userdata('asc_desc');
		$this->load->model('staff/mediator');
		if($start_page>0){
			$begin_limit = ($start_page-1)*50;
		}else{
			$begin_limit = 0;
			$start_page = 1;
		}
		$query = $this->mediator->get_mediator_list($col,$asc_desc,$begin_limit,$keyword);
		$query_hakim = $this->mediator->get_hakim_list();
		$query_pendidikan = $this->mediator->get_pendidikan_list();

		$data['users_list'] = $query;
		$data['hakim_list'] = $query_hakim;
		$data['pendidikan_list'] = $query_pendidikan;
		if($this->session->userdata('total_rows')){
			if($this->session->userdata('total_rows')==-1){
				$data['total_rows'] = $this->mediator->fecth_data_num();
				$this->session->set_userdata('total_rows',$data['total_rows']);
			}else{
				$data['total_rows'] = $this->session->userdata('total_rows');
			}
		}else{
			$data['total_rows'] = $this->mediator->fecth_data_num();
			$this->session->set_userdata('total_rows',$data['total_rows']);
		}
		
		$data['page_active'] = $begin_limit;
		$data['page_title'] = 'DAFTAR MEDIATOR';
		$data['tgl_sekarang'] = date('d/m/Y');
		$data['main_body'] = 'staff/mediator_list';
		$data['enc'] = "-";
		
		$data['page_number'] = $start_page;
		$data['page_url'] = 'mediator_list';
		$data['keyword'] = $keyword;
		$data['column_sorted'] = $col;
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body');
	}

	function info(){
		if(empty($_POST)){
			show_404();
		}
		
		$this->load->model('staff/mediator');
		if($this->input->post('enc',TRUE)){
			$id = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
			if(!empty($id)){
				$query = $this->mediator->get_mediator_info($id);
				if($query->num_rows>0){
					foreach ($query->result() as $row) {
						echo json_encode(array(
							'st'=>1,
							'idH'=>$row->id,
							'nama'=>$row->nama,
							'hakim'=>$row->hakim_id,
							'status_mediator'=>$row->status_mediator,
							'nama_gelar'=>$row->nama_gelar,
							'alamat'=>$row->alamat,
							'tempat_lahir'=>$row->tempat_lahir,
							'tgl_lahir'=>$this->tanggalhelper->convertToInputDate($row->tgl_lahir),
							'pendidikan'=>$row->pendidikan_id,
							'keahlian'=>$row->keahlian,
							'nomor_sk_ketua'=>$row->nomor_sk_ketua,
							'tgl_sk_ketua'=>$this->tanggalhelper->convertToInputDate($row->tgl_sk_ketua),
							'nip'=>$row->nip,
							'aktif'=>$row->aktif,
							'foto'=>$row->foto,
							'profesi'=>$row->profesi,
							'bersertifikat'=>$row->bersertifikat,
							'no_sertifikasi'=>$row->no_sertifikasi,
							'tgl_sertifikasi'=>$this->tanggalhelper->convertToInputDate($row->tgl_sertifikasi),
							'lembaga_sertifikasi'=>$row->lembaga_sertifikasi,							
							'ket'=>$row->keterangan
							)
						);
					}
				}
			}else{
				echo json_encode(array('st'=>0));
			}
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Invalid Argument'));
		}
	}

	function validate_input(){
		if(empty($_POST)){
			show_404();
		}
		$this->load->model('staff/mediator');
		$id = $this->input->post('idH',TRUE);
		$update = FALSE;
		$status = FALSE;
		if(!empty($id) AND $id>0){
			$this->form_validation->set_rules('idH', 'Meditor ID', 'trim|required|xss_clean|numeric');
			$update = TRUE;
		}else{
			$row = $this->mediator->get_last_id();
			$id = $row->id+1;
		}	
		
		$this->form_validation->set_rules('status_mediator', 'Status Mediator', 'trim|required|xss_clean|numeric');
		$this->form_validation->set_rules('profesi', 'Profesi', 'trim|required|xss_clean');
		$this->form_validation->set_rules('nama', 'Nama Tanpa Gelar', 'trim|required|xss_clean');
		$this->form_validation->set_rules('nama_gelar', 'Nama Dengan Gelar', 'trim|required|xss_clean');
		$this->form_validation->set_rules('bersertifikat', 'Bersertifikat', 'trim|required|xss_clean|numeric');
		$this->form_validation->set_rules('$tempat_lahir','Tempat Lahir','trim|xss_clean');
		$this->form_validation->set_rules('$tgl_lahir','Tanggal Lahir','trim|xss_clean');
		$this->form_validation->set_rules('$pendidikan','Pendidikan','trim|xss_clean');
		$this->form_validation->set_rules('$keahlian','keahlian','trim|xss_clean');

		if($this->input->post('pendidikan', TRUE)!=-1){
			$pendidikan_nama=$this->mediator->get_pendidikan_list($this->input->post('pendidikan', TRUE))->result();
		}
		if($this->input->post('bersertifikat', TRUE)==1){
			$this->form_validation->set_rules('no_sertifikasi', 'Nomor Sertifikasi', 'trim|required|xss_clean');
			$this->form_validation->set_rules('tgl_sertifikasi', 'Tanggal Sertifikasi', 'trim|required|xss_clean|exact_length[10]');
			$this->form_validation->set_rules('lembaga_sertifikasi', 'Lembaga Sertifikasi', 'trim|required|xss_clean');
		}
		$this->form_validation->set_rules('aktif', 'Aktif', 'trim|required|xss_clean|numeric');
		$this->form_validation->set_rules('keterangan', 'Keterangan', 'trim|xss_clean');
		//$this->form_validation->set_rules('nip', 'NIP HAKIM', 'trim|required|xss_clean|min_length[9]|max_length[18]|is_unique[mediator.nip]');
		$cekeditupload=$_FILES['foto_mediator']['name'];
		if ($cekeditupload!=""){
			$nama_file="mediator_".$id;
			$config['upload_path'] 		= './resources/file/foto';
			$config['allowed_types'] 	= 'gif|jpg|png';
			
			$config['file_name']		= $nama_file;
			$config['max_width'] = 0;
			$config['max_height'] = 0;
			$config['max_size'] = 0;
			$this->upload->initialize($config);
			$this->load->library('upload', $config);
			
			if (!$this->upload->do_upload('foto_mediator')){
				$error = $this->upload->display_errors();
			}else{
				$file_foto_db=$this->upload->data()['file_name'];
				$data=array('foto'=>$file_foto_db);
			}
		}else{
			if ( $this->input->post('nama_file_foto',TRUE)!=""){
				$file_foto_db=$this->input->post('nama_file_foto',TRUE);
			}
			
		}

		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
		}else{
			$nama = $this->input->post('nama',TRUE);
			$alamat = $this->input->post('alamat',TRUE);
			$nip = $this->input->post('nip',TRUE);
			$nama_gelar = $this->input->post('nama_gelar',TRUE);
			$idHakim =NULL;
			$status = $this->input->post('status_mediator',TRUE);
			$tempat_lahir=$this->input->post('tempat_lahir',TRUE);
			$tgl_lahir=$this->input->post('tgl_lahir',TRUE);
			if ($tgl_lahir==""){
				$tgl_lahir='(NULL)';
			}
			$tgl_sk_ketua=$this->input->post('tgl_sk_ketua',TRUE);
			if ($tgl_sk_ketua==""){
				$tgl_sk_ketua='(NULL)';
			}
			$nomor_sk_ketua=$this->input->post('nomor_sk_ketua',TRUE);
			$pendidikan_id=$this->input->post('pendidikan',TRUE);
			$pendidikan=$pendidikan_nama[0]->nama;
			$keahlian=$this->input->post('keahlian',TRUE);
			if($this->input->post('status_mediator',TRUE)==1){
				$status='N';
				$nip='';
			}else if($this->input->post('status_mediator',TRUE)==2){
				$status='H';
			}else{
				$status='P';
			}
			if($this->input->post('status_mediator',TRUE)==2){
				#fetch data Hakim dari db
				$nip = '';
				$idH== $this->input->post('idH',TRUE);
				$idHakim = $this->input->post('hakim',TRUE);
				if ($idHakim==-1){
					$idHakim=$idH;
				}
				$query = $this->mediator->get_hakim_info($idHakim);
				if($query->num_rows>0){
					foreach ($query->result() as $row) {
						$nama = $row->nama;
						$nip = $row->nip;
						$nama_gelar = $row->nama_gelar;
					}
				}
				// else{
				// 	echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Data Hakim Tidak Ditemukan'));
				// 	return;
				// }
			}
			$nduwesertifikatora = ($this->input->post('bersertifikat', TRUE)==1)? 'Y':'T';
			$aktif = ($this->input->post('aktif',TRUE)==1)? 'Y':'T';
			$data = array(
					'status_mediator' => $status,
					'profesi' => $this->input->post('profesi',TRUE),
					'nip' => $nip,
					'hakim_id'=>$idHakim,
					'nama' => $nama,
					'nama_gelar' => $nama_gelar,
					'tempat_lahir'=>$tempat_lahir,
					'tgl_lahir'=>$this->tanggalhelper->convertToMysqlDate($tgl_lahir),
					'pendidikan_id'=>$pendidikan_id,
					'pendidikan'=>$pendidikan,
					'keahlian'=>$keahlian,
					'alamat'=>$alamat,
					'foto'=>$file_foto_db,
					'nomor_sk_ketua'=>$nomor_sk_ketua,
					'tgl_sk_ketua'=>$this->tanggalhelper->convertToMysqlDate($tgl_sk_ketua),
					'bersertifikat' => $nduwesertifikatora,
					'no_sertifikasi' => $this->input->post('no_sertifikasi',TRUE),
					'tgl_sertifikasi' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_sertifikasi',TRUE)),
					'lembaga_sertifikasi' => $this->input->post('lembaga_sertifikasi',TRUE),
					'aktif' => $aktif,
					'keterangan' => $this->input->post('keterangan',TRUE)
            );
            if($update){
            	$data['diperbaharui_oleh'] = $this->session->userdata('username');
				$data['diperbaharui_tanggal'] = date("Y-m-d h:i:s",time());
				$status = $this->mediator->update_data($data,$id);
            }else{
            	$data['id'] = $id;
            	$data['diinput_oleh'] = $this->session->userdata('username');
				$data['diinput_tanggal'] = date("Y-m-d h:i:s",time());
				$status = $this->mediator->add_data($data);
            }
			if($status===TRUE){
				redirect(base_url().'mediator_list');
			}
		}
	}
}

?>