<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class ManageRehabilitasi extends CI_Controller {
	function index(){
		if($this->nativesession->get_flash_session('security')===FALSE){
			redirect('main');
		}
		$sec = $this->nativesession->get_flash_session('security');

		if($this->session->userdata('is_logged_in')===FALSE){
			redirect('login');
		}
		$enc = $this->nativesession->get_flash_session('enc');
		$idalurperkara = $this->encrypt->decode(base64_decode($enc));

		$functions = $this->nativesession->get_flash_session('function');
		
		if($functions == 'sort'){
			$col = $this->nativesession->get_flash_session('col');
			$keyword = $this->nativesession->get_flash_session('keyword');
			$this->sort($col,$enc,$keyword);
		}elseif($functions == 'type'){
			$this->session->set_userdata('asc_desc','DESC');
			$this->session->set_userdata('total_rows',-1);
			$this->showData($enc,$idalurperkara);
		}elseif($functions == 'page'){
			$page = $this->nativesession->get_flash_session('page');
			$keyword = $this->nativesession->get_flash_session('keyword');
			$column_sorted = $this->nativesession->get_flash_session('col');
			$this->showData($enc,$idalurperkara,$column_sorted,$page,$keyword);
		}elseif($functions == 'search'){
			$keyword ='';

			$keyword = $this->nativesession->get_flash_session('keyword');
			$this->session->set_userdata('keyword',$keyword);
			$page = $this->nativesession->get_flash_session('page');
			$this->session->set_userdata('total_rows',-1);
			$this->showData($enc,$idalurperkara,3,$page,$keyword);
		}else{
			$this->session->set_userdata('asc_desc','DESC');
			$this->session->set_userdata('total_rows',-1);
			$this->showData($enc, $idalurperkara);
		}
	}

	function sort($col=null,$enc=null,$keyword=null){
		if($this->session->userdata('asc_desc')){
			if($this->session->userdata('asc_desc')=="DESC"){
				$this->session->set_userdata('asc_desc','ASC');
			}else{
				$this->session->set_userdata('asc_desc','DESC');
			}
		}else{
			$this->session->set_userdata('asc_desc','ASC');
		}
		$idalurperkara = $this->encrypt->decode(base64_decode($enc));
		$this->showData($enc,$idalurperkara,$col,0,$keyword);
	}

	function showData($enc='',$idalurperkara='',$col=3,$start_page=0,$keyword=''){
		$asc_desc = $this->session->userdata('asc_desc');
		if($start_page>0){
			$begin_limit = ($start_page-1)*50;
		}else{
			$begin_limit = 0;
			$start_page = 1;
		}
		$data['page_url'] = 'rehabilitasi/rehabilitasi_list';
		$this->load->model('rehabilitasi/list_rehabilitasi', 'rehabilitasi');
		$data['rehabilitasi'] = $this->rehabilitasi->getListRehabilitasi(9,'DESC',$begin_limit,$idalurperkara,$keyword);
		if($this->session->userdata('total_rows')){
			if($this->session->userdata('total_rows')==-1){
				$data['total_rows'] = $this->rehabilitasi->fecth_data_num();
				$this->session->set_userdata('total_rows',$data['total_rows']);
			}else{
				$data['total_rows'] = $this->session->userdata('total_rows');
			}
		}else{
			$data['total_rows'] = $this->rehabilitasi->fecth_data_num();
			$this->session->set_userdata('total_rows',$data['total_rows']);
		}
		$data['list_perkara'] = $this->rehabilitasi->getNomorPerkara(3);
		$data['page_active'] = $begin_limit;

		$data['page_title'] = 'REGISTER REHABILITASI';
		$data['main_body'] = 'rehabilitasi/rehabilitasi_list';
		$data['enc'] = $enc;
		$data['enc_alurperkara'] = base64_encode($this->encrypt->encode(3));
		$data['idalurperkara'] = $idalurperkara;
		$data['enc_act'] = base64_encode($this->encrypt->encode('add'));
		$data['curr_date'] = date('d/m/Y');
		$data['page_number'] = $start_page;
		$data['page_url'] = 'rehabilitasi/rehabilitasi_list';
		$data['keyword'] = $keyword;
		$data['column_sorted'] = $col;
		$data['url_requested'] = $this->nativesession->get_flash_session('url_requested');

		$this->load->library('ckeditor');
		$this->ckeditor->basePath = base_url().'resources/ckeditor/';
		$this->ckeditor->config['toolbar'] = array(
			array('-','Cut','Copy','Paste','PasteText','PasteFromWord',
				'-','Bold', 'Italic', 'Underline','Subscript', 'Superscript',
					'-', 'RemoveFormat','-', 'Blockquote',
					'-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock',
					'-','Undo','Redo','-','NumberedList','BulletedList','/',
					'-','Image'),
			array('-','Format', 'Font', 'FontSize',
				'-','TextColor', 'BGColor','Table',
				'-','Find', 'Replace', '-', 'SelectAll', '-', 'Scayt','-','HorizontalRule',
				'-','Print','Preview'
				));
		$this->ckeditor->config['pasteFromWordNumberedHeadingToList'] = 'true';
		$this->ckeditor->config['pasteFromWordPromptCleanup'] = 'true';
		$this->ckeditor->config['resize'] = 'false';
		$this->ckeditor->config['language'] = 'en';
		$this->ckeditor->config['width'] = '850px';
		$this->ckeditor->config['height'] = '250px';

		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body');
	}

	function fetchNoUrut(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Please Refresh Your Page'));
			return;
		}
		$this->load->model('rehabilitasi/list_rehabilitasi', 'rehabilitasi');
		$noUrut = $this->rehabilitasi->getNoUrut();
		if(!empty($noUrut)){
			echo json_encode(array('st'=>1,'noUrut'=>$noUrut));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Please Refresh Your Browser'));
			return;
		}
			
	}
	function fetchData(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Please Refresh Your Page'));
			return;
		}
		$enc = $this->input->post('val',TRUE);
		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('val',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara)<0){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$act = $this->input->post('act',TRUE);

		$this->load->model('rehabilitasi/list_rehabilitasi', 'rehabilitasi');
		$text = '<td style="padding:0px;padding-left:5px;" id="parapihak">';
		if($act=='add'){
			$exsist = $this->rehabilitasi->isPerkaraExist($idperkara);
			if($exsist==TRUE){
				echo json_encode(array('st'=>0,'msg'=>'Perkara Sudah Terdaftar.'));
				return;
			}elseif($exsist=='-1'){
				echo json_encode(array('st'=>0,'msg'=>'Something Bad Happen.'));
				return;
			}
			$tglPutusanPerkara = $this->rehabilitasi->getTglPutusan($idperkara);
			if(empty($tglPutusanPerkara)){
				echo json_encode(array('st'=>0,'msg'=>'Tidak Dapat Mendaftarkan Rehabilitasi, Perkara Belum Putus.'));
				return;
			}
			$parapihak = $this->rehabilitasi->getParaPihak($idperkara);
			$text .= $parapihak;
			$text .= '</td>';
			$enc_act = base64_encode($this->encrypt->encode('add'));
			echo json_encode(array(
				'st'=>1,
				'parapihak'=> $text,
				'enc' => $enc,
				'enc_act' => $enc_act,
				'tglPutusanPerkara' => $this->tanggalhelper->convertToInputDate($tglPutusanPerkara)
				));
			return;
		}elseif($act=='updt'){
			$data = $this->rehabilitasi->getDetilPerkara($idperkara);
			if($data->num_rows>0){
				foreach ($data->result() as $row) {
					$parapihak = $row->para_pihak;
					$no = $row->nomor_putusan_mohon;
					$noUrut = $row->nomor_urut_register;
					$tglPermohonan = $this->tanggalhelper->convertToInputDate($row->tanggal_permohonan);
					$tglPutusMohon = $this->tanggalhelper->convertToInputDate($row->tanggal_putusan_mohon);
					$alasan = $row->alasan_permohonan;
					$tglBerita = $this->tanggalhelper->convertToInputDate($row->tanggal_berita_putusan);
					$tglSuratKabar = $this->tanggalhelper->convertToInputDate($row->tanggal_surat_kabar);
					$suratKabar = $row->surat_kabar;
					$tglPerlawanan = $this->tanggalhelper->convertToInputDate($row->tanggal_perlawanan);
					$tglPutusanRehab = $this->tanggalhelper->convertToInputDate($row->tanggal_putusan);
					$amarPutusan = $row->amar_putusan;
					$edocAmar = $row->amar_putusan_dok;
					$ket = $row->keterangan;
				}
				$enc_act = base64_encode($this->encrypt->encode('updt'));
				$text .= $parapihak;
				$text .= '</td>';
				echo json_encode(array(
						'st'=>1,
						'noUrut' => $noUrut,
						'parapihak'=> $text,
						'enc' => $enc,
						'enc_act' => $enc_act,
						'no'=> $no,
						'tglPermohonan'=> $tglPermohonan,
						'tglPutusMohon'=> $tglPutusMohon,
						'alasan'=> $alasan,
						'tglBerita'=> $tglBerita,
						'tglSuratKabar'=> $tglSuratKabar,
						'suratKabar'=> $suratKabar,
						'tglPerlawanan'=> $tglPerlawanan,
						'tglPutusanRehab'=> $tglPutusanRehab,
						'amarPutusan'=> $amarPutusan,
						'edocAmar'=> $edocAmar,
						'ket'=> $ket
					));
			}else{
				echo json_encode(array(
						'st'=>0,
						'msg'=> 'Perkara Tidak Ditemukan. Refresh Browser Anda'
					));
			}
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Something Bad Happen, Please refresh your browser'));
			return;
		}
	}

	function validateInput(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Please Refresh Your Page'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara)<0){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukans.'.$idperkara));
			return;
		}

		$this->form_validation->set_rules('no_urut', 'Nomor Urut Register', 'trim|required|numeric|xss_clean');
		$this->form_validation->set_rules('no_perkara', 'Nomor Perkara', 'trim|required|xss_clean');
		$this->form_validation->set_rules('tgl_permohonan', 'Tanggal Permohonan', 'trim|required|exact_length[10]|xss_clean');
		$this->form_validation->set_rules('alasan_text', 'Alasan Rehabilitasi', 'trim|required|xss_clean|min_length[50]');
		$this->form_validation->set_rules('tgl_putusan', 'Tanggal Putusan Yang dimohonkan Rehabilitasi', 'trim|required|exact_length[10]|xss_clean');
		
		$curr_date = date('Y-m-d');
		$todayDate = date('m/d/Y');

		$tgl_berita_ri= $this->input->post('tgl_berita_ri',TRUE);
		if(!empty($tgl_berita_ri)){
			$this->form_validation->set_rules('tgl_berita_ri', 'Tanggal Pengumuman Rehabilitasi dalam Berita Negara RI', 'trim|exact_length[10]|xss_clean');
		}
		
		$tgl_surat_berita = $this->input->post('tgl_surat_berita',TRUE);
		if(!empty($tgl_surat_berita)){
			$this->form_validation->set_rules('tgl_surat_berita', 'Tanggal Dimuat dalam Surat Kabar', 'trim|exact_length[10]|xss_clean');
		}
		
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}

		$this->load->model('rehabilitasi/list_rehabilitasi', 'rehabilitasi');
		$tglPutusanPerkara = $this->rehabilitasi->getTglPutusan($idperkara);
		
		if(empty($tglPutusanPerkara)){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Belum Diputus.'));
			return;
		}

		$tgl_permohonan= $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_permohonan',TRUE));

		$selisih = $this->tanggalhelper->getSelisihHari($tgl_permohonan,$curr_date);
		if($selisih<0){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Permohonan Rehabilitasi Tidak Boleh Melebihi Hari Ini. Hari ini Tanggal '.$todayDate));
			return;
		}

		$selisih = $this->tanggalhelper->getSelisihHari($tglPutusanPerkara,$tgl_permohonan);
		if($selisih<0){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Permohonan Rehabilitasi Tidak Boleh Kurang Dari Tanggal Putusan.'));
			return;
		}

		$dayname = $this->tanggalhelper->getDayName($tgl_permohonan);
		if($dayname=='Saturday' OR $dayname=='Sunday'){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Permohonan Rehabilitasi Dihari Libur, Sabtu dan Minggu.'));
			return;
		}

		$alasan = trim($this->input->post('alasan_text',TRUE));
		$alasan = strip_tags($alasan);
		if(strlen($alasan)<50){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Alasan Permohonan Rehabilitasi Tidak Boleh kurang dari 50 Karakter'));
			return;
		}

		$data = array(
			'perkara_id' => $idperkara,
			'nomor_urut_register' => $this->input->post('no_urut',TRUE),
			'tanggal_permohonan' => $tgl_permohonan,
			'alasan_permohonan' => trim($this->input->post('alasan_text',TRUE)),
			'tanggal_putusan_mohon' => $tglPutusanPerkara,
			'amar_putusan_dok' => $this->input->post('edoc_amar',TRUE),
			'keterangan' => $this->input->post('keterangan',TRUE)
		);

		$tgl_berita_ri= $this->input->post('tgl_berita_ri',TRUE);
		if(!empty($tgl_berita_ri)){
			$tgl_berita_ri = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_berita_ri',TRUE));
			$dayname = $this->tanggalhelper->getDayName($tgl_berita_ri);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Pengumuman Rehabilitasi dalam Berita Negara RI Dihari Libur, Sabtu dan Minggu.'));
				return;
			}
			
			$selisih = $this->tanggalhelper->getSelisihHari($tgl_berita_ri,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pengumuman Rehabilitasi dalam Berita Negara RI Tidak Boleh Melebihi Hari Ini. Hari ini Tanggal '.$todayDate));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tgl_permohonan,$tgl_berita_ri);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pengumuman Rehabilitasi dalam Berita Negara RI Tidak Boleh Kurang Dari Tanggal Permohonan Rehabilitasi'));
				return;
			}
			$data['tanggal_berita_putusan'] = $tgl_berita_ri;
		}
		
		$tgl_surat_berita = $this->input->post('tgl_surat_berita',TRUE);
		$suratKabar = $this->input->post('nama_surat_kabar',TRUE);
		if(!empty($tgl_surat_berita)){
			$tgl_surat_berita = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_surat_berita',TRUE));

			$selisih = $this->tanggalhelper->getSelisihHari($tgl_permohonan,$tgl_surat_berita);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Dimuat dalam Surat Kabar Tidak Boleh Kurang Dari Tanggal Permohonan Rehabilitasi'));
				return;
			}
			
			if(empty($suratKabar)){
				echo json_encode(array('st'=>0,'msg'=>'Nama Surat Kabar Belum Diisikan.'));
				return;
			}
			$data['tanggal_surat_kabar'] = $tgl_surat_berita;
			$data['surat_kabar'] = $suratKabar;
		}
		
		if(!empty($suratKabar) AND empty($tgl_surat_berita)){
			echo json_encode(array('st'=>0,'msg'=>'Tanggal Dimuat dalam Surat Kabar Belum Diisikan.'));
			return;
		}

		$tgl_perlawanan= $this->input->post('tgl_perlawanan',TRUE);
		if(!empty($tgl_perlawanan)){
			$tgl_perlawanan = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_perlawanan',TRUE));
			$dayname = $this->tanggalhelper->getDayName($tgl_perlawanan);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Perlawanan Dihari Libur, Sabtu dan Minggu.'));
				return;
			}
			
			$selisih = $this->tanggalhelper->getSelisihHari($tgl_perlawanan,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Perlawanan Tidak Boleh Melebihi Hari Ini. Hari ini Tanggal '.$todayDate));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tgl_permohonan,$tgl_perlawanan);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Perlawanan Tidak Boleh Kurang Dari Tanggal Permohonan Rehabilitasi'));
				return;
			}
			$data['tanggal_perlawanan'] = $tgl_perlawanan;
		}

		$tgl_putusan_rehab= $this->input->post('tgl_putusan_rehab',TRUE);
		
		$amar = filter_var_array($_POST['amar_put'], FILTER_SANITIZE_STRING);
		$amar = trim($amar);
		
		if(!empty($tgl_putusan_rehab)){
			$tgl_putusan_rehab = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_putusan_rehab',TRUE));
			$dayname = $this->tanggalhelper->getDayName($tgl_putusan_rehab);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Putusan Rehabilitasi Dihari Libur, Sabtu dan Minggu.'));
				return;
			}
			
			$selisih = $this->tanggalhelper->getSelisihHari($tgl_putusan_rehab,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Putusan Tidak Boleh Melebihi Hari Ini. Hari ini Tanggal '.$todayDate));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tgl_permohonan,$tgl_putusan_rehab);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Putusan Rehabilitasi Tidak Boleh Kurang Dari Tanggal Permohonan Rehabilitasi'));
				return;
			}
			if(empty($amar)){
				echo json_encode(array('st'=>0,'msg'=>'Amar Putusan Belum Diisikan.'));
				return;
			}
			$amar = strip_tags($amar);
			if(strlen($amar)<50){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Amar Putusan Tidak Boleh kurang dari 50 Karakter'));
				return;
			}
			$data['tanggal_putusan'] = $tgl_putusan_rehab;
			$data['amar_putusan'] = trim($this->input->post('amar_put',TRUE));
		}

		if(!empty($amar) AND empty($tgl_putusan_rehab)){
			echo json_encode(array('st'=>0,'msg'=>'Tanggal Putusan Rehabilitasi Belum Diisikan.'));
			return;
		}

		$act = $this->input->post('enc_act',TRUE);
		$act = $this->encrypt->decode(base64_decode($act));

		if($act=='add'){
			$exsist = $this->rehabilitasi->isPerkaraExist($idperkara);
			if($exsist==TRUE){
				echo json_encode(array('st'=>0,'msg'=>'Perkara Sudah Terdaftar.'));
				return;
			}elseif($exsist=='-1'){
				echo json_encode(array('st'=>0,'msg'=>'Something Bad Happens.'));
				return;
			}
			$data['diinput_oleh'] = $this->session->userdata('username');
			$data['diinput_tanggal'] = date("Y-m-d h:i:s",time());
			$result = $this->rehabilitasi->add_data($data);
		}elseif($act=='updt') {
			$result = $this->rehabilitasi->update_data($data,$idperkara);
			$data['diperbaharui_oleh'] = $this->session->userdata('username');
			$data['diperbaharui_tanggal'] = date("Y-m-d h:i:s",time());
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error Task, Please Refresh Your Browser.'));
			return;
		}
		
		if($result){
			echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan.'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Data Tidak Berhasil Disimpan.'));
			return;
		}
	}

	function validateDelete(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Please Refresh Your Page'));
			return;
		}
		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara)<0){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}
		$this->load->model('rehabilitasi/list_rehabilitasi', 'rehabilitasi');
		$result = $this->rehabilitasi->del_data($idperkara);
		if($result){
			echo json_encode(array('st'=>1,'msg'=>'Penghapusan Berhasil.'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Penghapusan Tidak Berhasil..'));
			return;
		}

	}
	function searchPage(){
		if(empty($_POST)){
			show_404();
		}
		$keyword = $this->input->post('keyword_pihak',TRUE);
		$column = $this->input->post('search_field',TRUE);
		$this->nativesession->set_flash_session('security', TRUE);
		$this->nativesession->set_flash_session('keyword_pihak', $keyword);
		$this->nativesession->set_flash_session('column', $column);
		echo json_encode(array('st'=>1));
	}

	function viewDetil(){
		$segment = $this->uri->segment_array();
		$idperkara = $this->encrypt->decode(base64_decode($this->uri->segment(3)));
		if(!is_numeric($idperkara) OR intval($idperkara)<0){
			show_404();
		}
		$this->load->model('rehabilitasi/list_rehabilitasi', 'rehabilitasi');
		$data['dataRehab'] = $this->rehabilitasi->getDetilPerkara($idperkara);
		$this->load->vars($data);
		$this->load->view('rehabilitasi/rehabilitasi_view');
	}
}