<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class ManagePutusanAkhirTerdakwa extends CI_Controller {
	function index(){
		if($this->nativesession->get_flash_session('security')==FALSE){ redirect('main'); }
		$sec = $this->nativesession->get_flash_session('security');

		if($this->session->userdata('is_logged_in')===FALSE){ redirect('login'); }

		$idperkara = $this->nativesession->get_flash_session('perkara_id');
		$data['error'] = FALSE;
		$data['error_message'] = '';
		$idpihak = $this->nativesession->get_flash_session('pihak_id');
		if(!is_numeric($idperkara) OR intval($idperkara)<1 OR intval($idpihak)<1){
			$data['error'] = TRUE;
			$data['error_message'] = '404';
		}

		$data['enc_pihak'] = $this->nativesession->get_flash_session('enc_pihak');
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		
		$data['act'] = base64_encode($this->encrypt->encode($this->nativesession->get_flash_session('action')));
		$this->load->model('putusan/data_putusan_akhir','putusan');
		$data['tanggal_putusan'] = $this->tanggalhelper->convertToInputDate($this->tanggalhelper->getTanggalPutusan($idperkara));
		$data['idpihak'] = $idpihak;
		$idalurperkara = $this->tanggalhelper->getIDAlurPerkara($idperkara);
		$data['listJenisPutusan'] = $this->putusan->getDataStatusPutusan($idalurperkara);
		$data['status_putusan'] = $this->putusan->getPutusanTerdakwa($idperkara);
		$this->load->view('putusan/putusan_terdakwa',$data,FALSE);
	}

	function validateInput(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		$this->form_validation->set_rules('tgl_putusan', 'Tanggal Putusan', 'trim|required|xss_clean|exact_length[10]');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}

		$this->load->model('putusan/data_putusan_akhir','putusan');

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		$pihak2_id = $this->encrypt->decode(base64_decode($this->input->post('enc_pihak',TRUE)));
		$act = $this->encrypt->decode(base64_decode($this->input->post('act',TRUE)));

		$date_sidang = $this->putusan->getTanggalSidangPertama($idperkara);
		$last_date_sidang = $this->putusan->getTanggalSidangAkhir($idperkara);
		$curr_date = date('Y-m-d');
		$todayDate = date('m/d/Y');
		foreach ($_POST['datas'] as $key => $value) {
			$data['status_putusan_id'] = $value[0];
		}	

		$tgl_putusan = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_putusan',TRUE));	

		if(($act=='tambah')||($act=='edit')){		
			if($data['status_putusan_id']!=79 && $data['status_putusan_id']!=80 && $data['status_putusan_id']!=81 && $data['status_putusan_id']!=82 && $data['status_putusan_id']!=83){	
				if(empty($date_sidang)){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memasukan Data Putusan. Jadwal Sidang Pertama Masih Kosong.'));
					return;
				}
			}
			$selisih = $this->tanggalhelper->getSelisihHari($tgl_putusan,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Putusan Tidak Boleh Melebihi Hari Ini. Hari ini Tanggal '.$todayDate));
				return;
			}
			$selisih = $this->tanggalhelper->getSelisihHari($date_sidang,$tgl_putusan);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Putusan Tidak Boleh Kurang dari Tanggal Sidang Pertama.'));
				return;
			}
			$selisih = $this->tanggalhelper->getSelisihHari($last_date_sidang,$tgl_putusan);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Putusan Tidak Boleh Kurang dari Tanggal Sidang.'));
				return;
			}
		} 

		$dayname = $this->tanggalhelper->getDayName($tgl_putusan);
		if($dayname=='Saturday' OR $dayname=='Sunday'){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Putusan Dihari Libur, Sabtu dan Minggu.'));
			return;
		}

		
		$data_putusan_terdakwa ='';
		$i=0;
		
		$pihak_id = $this->putusan->getIDPihak($pihak2_id,$idperkara);
		if($pihak_id<1){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Terdakwa Tidak Dapat Ditemukan. Refresh browser Anda.'));
			return;
		}
		$i=0;
		foreach ($_POST['datas'] as $key => $value) {
			$data = array(
				'pihak2_id' => $pihak2_id,
				'perkara_id' => $idperkara,
				'pihak_id' => $pihak_id,
				'tanggal_putusan' => $tgl_putusan, 
				'status_putusan_id' => $value[0],
				'durasi_nominal' => $value[1],
				'satuan' => $value[2],
				'keterangan_putusan' => $this->input->post('keterangan',TRUE)
			);
			if($data['status_putusan_id']==79 OR $data['status_putusan_id']==80 OR $data['status_putusan_id']==81 OR $data['status_putusan_id']==82 OR $data['status_putusan_id']==83){	
				$data['status_putusan_text'] = 'Pengadilan Tidak Berwenang';
			}
			if($act=='tambah'){
				$data['diinput_oleh'] = $this->session->userdata('username');
				$data['diinput_tanggal'] = date("Y-m-d h:i:s",time());
				
			}elseif ($act=='edit') {
				$data['diperbaharui_oleh'] = $this->session->userdata('username');
				$data['diperbaharui_tanggal'] = date("Y-m-d h:i:s",time());
			}
			$data_putusan_terdakwa[$i] = $data;
			$i++;
		}
		if($act=='tambah'){
			$result = $this->putusan->addDataTerdakwa($data_putusan_terdakwa);
		}elseif ($act=='edit'){
			$result = $this->putusan->updateDataTerdakwa($data_putusan_terdakwa);
		}
		if($result==TRUE){
			echo json_encode(array('st'=>1,'msg'=>'DATA Putusan Berhasil Di Simpan.'));
			return FALSE;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'DATA Putusan Gagal Di Simpan.'));
			return FALSE;
		}
		
	}
}