<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class ManageIntervensi extends CI_Controller {
	function index(){
		if($this->nativesession->is_flash_session('security')==FALSE){
			redirect('main');
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}		
		$idperkara = $this->nativesession->get_flash_session('perkara_id');
		if(!is_numeric($idperkara)){
			show_404();
		}		
		$this->show_data($idperkara);
	}

	function show_data($idperkara){
		$data['enc'] =$this->nativesession->get_flash_session('enc',TRUE);
		$this->load->model('pihak/data_intervensi','intervensi');
		$this->load->model('perkara/info_perkara','perkara');
		$idalurperkara=$this->tanggalhelper->getIDAlurPerkara($idperkara);
		$data['para_pihak'] = $this->intervensi->getPihakIntervensi($idperkara);
		$urutanpenggugat = $this->intervensi->maxUrutanPenggugat($idperkara);
		if (!empty($urutanpenggugat)){
			foreach ($urutanpenggugat->result() as $row) {
				$data['penggugatke'] = intval($row->urutan)+1;				
			}
		}
		$urutantergugat = $this->intervensi->maxUrutanTergugat($idperkara);
		if (!empty($urutantergugat)){
			foreach ($urutantergugat->result() as $row) {
				$data['tergugatke'] = intval($row->urutan)+1;				
			}
		}
		$data["pengacara_pihak_ketiga"] = $this->perkara->getInfoPengacara($idperkara,3,$idalurperkara);
		$this->load->vars($data);
		$this->load->view('pihak/pihak_intervensi');
	}
}