<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class manageHartaPailit extends CI_Controller {
	function index(){
		if($this->nativesession->get_flash_session('security')==FALSE){
			redirect('main');
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$enc = $this->nativesession->get_flash_session('enc');
		$idalurperkara = $this->encrypt->decode(base64_decode($enc));

		$functions = $this->nativesession->get_flash_session('function');
		if($functions == 'sort'){
			$col = $this->nativesession->get_flash_session('col');
			$keyword = $this->nativesession->get_flash_session('keyword');
			$this->sort($col,$enc,$keyword);
		}elseif($functions == 'type'){
			$this->session->set_userdata('asc_desc','DESC');
			$this->session->set_userdata('total_rows',-1);
			$this->showData($enc,$idalurperkara);
		}elseif($functions == 'page'){
			$page = $this->nativesession->get_flash_session('page');
			$keyword = $this->nativesession->get_flash_session('keyword');
			$column_sorted = $this->nativesession->get_flash_session('col');
			$this->showData($enc,$idalurperkara,$column_sorted,$page,$keyword);
		}elseif($functions == 'search'){
			$keyword ='';
			$keyword = $this->nativesession->get_flash_session('keyword');
			$this->session->set_userdata('keyword',$keyword);

			$page = $this->nativesession->get_flash_session('page');
			$this->session->set_userdata('total_rows',-1);
			$this->showData($enc,$idalurperkara,3,$page,$keyword);
		}else{
			$this->session->set_userdata('asc_desc','DESC');
			$this->session->set_userdata('total_rows',-1);
			$this->showData($enc);
		}
	}

	private function sort($col=null,$enc=null,$keyword=null){
		if($this->session->userdata('asc_desc')){
			if($this->session->userdata('asc_desc')=="DESC"){
				$this->session->set_userdata('asc_desc','ASC');
			}else{
				$this->session->set_userdata('asc_desc','DESC');
			}
		}else{
			$this->session->set_userdata('asc_desc','ASC');
		}
		$idalurperkara = $this->encrypt->decode(base64_decode($enc));
		$this->showData($enc,$idalurperkara,$col,0,$keyword);
	}

	private function showData($enc='',$idalurperkara='',$col=3,$start_page=0,$keyword=''){
		$asc_desc = $this->session->userdata('asc_desc');
		if($start_page>0){
			$begin_limit = ($start_page-1)*50;
		}else{
			$begin_limit = 0;
			$start_page = 1;
		}
		$data['page_url'] = 'harta_pailit/harta_pailit_list';
		$this->load->model('harta_pailit/list_harta_pailit', 'pailit');
		$data['pailit'] = $this->pailit->getListPailit(9,'DESC',$begin_limit,$idalurperkara,$keyword);
		if($this->session->userdata('total_rows')){
			if($this->session->userdata('total_rows')==-1){
				$data['total_rows'] = $this->pailit->fecth_data_num();
				$this->session->set_userdata('total_rows',$data['total_rows']);
			}else{
				$data['total_rows'] = $this->session->userdata('total_rows');
			}
		}else{
			$data['total_rows'] = $this->pailit->fecth_data_num();
			$this->session->set_userdata('total_rows',$data['total_rows']);
		}
		$data['list_perkara'] = $this->pailit->getNomorPerkara(3);
		$data['hakim'] = $this->pailit->getListHakim();
		$data['kurator'] = $this->pailit->getListKurator();
		$data['panitera'] = $this->pailit->getListPanitera();
		$data['jurusita'] = $this->pailit->getListJurusita();

		$data['page_active'] = $begin_limit;

		$data['page_title'] = 'REGISTER PEMBERESAN HARTA PAILIT';
		$data['main_body'] = 'harta_pailit/harta_pailit_list';
		$data['enc'] = $enc;
		$data['enc_alurperkara'] = base64_encode($this->encrypt->encode(3));
		$data['enc_act'] = base64_encode($this->encrypt->encode('add'));
		$data['curr_date'] = date('d/m/Y');
		$data['page_number'] = $start_page;
		$data['page_url'] = 'harta_pailit/harta_pailit_list';
		$data['keyword'] = $keyword;
		$data['column_sorted'] = $col;
		$data['url_requested'] = $this->nativesession->get_flash_session('url_requested');

		$this->load->library('ckeditor');
		$this->ckeditor->basePath = base_url().'resources/ckeditor/';
		$this->ckeditor->config['toolbar'] = array(
			array('-','Cut','Copy','Paste','PasteText','PasteFromWord',
				'-','Bold', 'Italic', 'Underline','Subscript', 'Superscript',
					'-','RemoveFormat','-', 'Blockquote',
					'-','JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock',
					'-','Undo','Redo','-','NumberedList','BulletedList','/',
					'-','Image'),
			array('-','Format', 'Font', 'FontSize',
				'-','TextColor', 'BGColor','Table',
				'-','Find', 'Replace', '-', 'SelectAll', '-', 'Scayt','-','HorizontalRule',
				'-','Print','Preview'
				));
		$this->ckeditor->config['pasteFromWordNumberedHeadingToList'] = 'true';
		$this->ckeditor->config['pasteFromWordPromptCleanup'] = 'true';
		$this->ckeditor->config['resize'] = 'false';
		$this->ckeditor->config['language'] = 'en';
		$this->ckeditor->config['width'] = '98%';
		$this->ckeditor->config['height'] = '250px';

		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body');
	}

	function fetchData(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Please Refresh Your Page'));
			return;
		}
		$enc = $this->input->post('val',TRUE);
		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('val',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara)<0){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$act = $this->input->post('act',TRUE);

		$this->load->model('harta_pailit/list_harta_pailit', 'pailit');
		$text = '<td style="padding:0px;padding-left:5px;" id="parapihak">';
		if($act=='add'){
			$exsist = $this->pailit->isPerkaraExist($idperkara);
			$exsist=FALSE;
			if($exsist==TRUE){
				echo json_encode(array('st'=>0,'msg'=>'Perkara Sudah Terdaftar.'));
				return;
			}elseif($exsist=='-1'){
				echo json_encode(array('st'=>0,'msg'=>'Something Bad Happen.'));
				return;
			}
			$dataPerkara = $this->pailit->getInfoPerkara($idperkara);
			if($dataPerkara!=''){
				if($dataPerkara->num_rows>0){
					foreach ($dataPerkara->result() as $row) {
						$tglPutusan = $this->tanggalhelper->convertDayDate($row->tanggal_putusan);
						$noPerkara = $row->nomor_perkara;
						$tglPendaftaran = $this->tanggalhelper->convertDayDate($row->tanggal_pendaftaran);
						$tglMinutasi = $this->tanggalhelper->convertDayDate($row->tanggal_minutasi);
						$parapihak = $row->para_pihak;
						$hakim = $row->hakim_pengawas_id;
						$kurator = $row->kurator_id;
						$panitera = $row->panitera_pengganti_id;
						$jurusita = $row->jurusita_id;
						$penHakim = $this->tanggalhelper->convertToInputDate($row->penetapan_hakim_pengawas);
					}
				}else{
					echo json_encode(array('st'=>0,'msg'=> 'Perkara Tidak Ditemukan'));
					return;
				}
			}else{
				echo json_encode(array('st'=>0,'msg'=> 'Perkara Tidak Ditemukan'));
				return;
			}
			if(empty($tglPutusan)){
				echo json_encode(array('st'=>0,'msg'=> 'Perkara Belum Putus'));
				return;
			}
			$text .= $parapihak;
			$text .= '</td>';
			$enc_act = base64_encode($this->encrypt->encode('add'));
			echo json_encode(array(
				'st'=>1,
				'tglPutusan'=> $tglPutusan,
				'tglPendaftaran'=> $tglPendaftaran,
				'tglMinutasi'=> $tglMinutasi,
				'enc' => $enc,
				'enc_act' => $enc_act,
				'noPerkara' => $noPerkara,
				'parapihak' => $text,
				'hakim' => $hakim,
				'kurator' => $kurator,
				'panitera' => $panitera,
				'jurusita' => $jurusita,
				'penHakim' => $penHakim
				));
			return;
		}elseif($act=='updt'){
			$data = $this->pailit->getInfoPailit($idperkara);
			if($data->num_rows>0){
				foreach ($data->result() as $row) {
					$tglPutusan = $this->tanggalhelper->convertDayDate($row->tanggal_putusan);
					$noPerkara = $row->nomor_perkara;
					$tglPendaftaran = $this->tanggalhelper->convertDayDate($row->tanggal_pendaftaran);
					$tglMinutasi = $this->tanggalhelper->convertDayDate($row->tanggal_minutasi);
					$parapihak = $row->para_pihak;
					$hakim = $row->hakim_pengawas_id;
					$kurator = $row->kurator_id;
					$panitera = $row->panitera_id;
					$jurusita = $row->jurusita_id;
					$penHakim = $this->tanggalhelper->convertToInputDate($row->tanggal_penetapan_hakim_pengawas);

					$amar = $row->amar_penetapan_hakim_pengawas;
					$tglInsol = $this->tanggalhelper->convertToInputDate($row->tanggal_insolvensi);
					$tglLelang = $this->tanggalhelper->convertToInputDate($row->tanggal_pelelangan);
					$tglPembagi = $this->tanggalhelper->convertToInputDate($row->tanggal_pembagian);
					$kreditur = $row->nama_kreditur;
					$jmlPembagi = $row->jumlah_pembagian;
					$catatatn = $row->catatan_harta_pailit;
					$tglPendaftaranHarta = $this->tanggalhelper->convertToInputDate($row->tanggal_pendaftaran_harta);
				}
				$enc_act = base64_encode($this->encrypt->encode('updt'));
				$text .= $parapihak;
				$text .= '</td>';
				echo json_encode(array(
					'st'=>1,
					'tglPutusan'=> $tglPutusan,
					'tglPendaftaran'=> $tglPendaftaran,
					'tglMinutasi'=> $tglMinutasi,
					'enc' => $enc,
					'enc_act' => $enc_act,
					'noPerkara' => $noPerkara,
					'parapihak' => $text,
					'hakim' => $hakim,
					'kurator' => $kurator,
					'panitera' => $panitera,
					'jurusita' => $jurusita,
					'penHakim' => $penHakim,
					'amar' => $amar,
					'tglInsol' => $tglInsol,
					'tglLelang' => $tglLelang,
					'tglPembagi' => $tglPembagi,
					'kreditur' => $kreditur,
					'jmlPembagi' => $jmlPembagi,
					'tglPendaftaranHarta' => $tglPendaftaranHarta,
					'catatatn'=> $catatatn
					));
			}else{
				echo json_encode(array(
						'st'=>0,
						'msg'=> 'Perkara Tidak Ditemukan'
					));
				return;
			}
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Something Bad Happen, Please refresh your browser'));
			return;
		}
	}

	function validateInput(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Please Refresh Your Page'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara)<0){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$this->form_validation->set_rules('no_perkara', 'Nomor Perkara', 'trim|required|xss_clean');
		$this->form_validation->set_rules('tgl_pendaftaran', 'Tanggal Pendaftaran Pemberesan Harta Pailit', 'trim|required|exact_length[10]|xss_clean');

		$jml_bagi = $this->input->post('jml_bagi',TRUE);

		if(!empty($jml_bagi)){
			$this->form_validation->set_rules('jml_bagi', 'Nomor Perkara', 'trim|numeric|xss_clean');
		}

		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}

		$noPerkara = $this->input->post('no_perkara',TRUE);
		$this->load->model('harta_pailit/list_harta_pailit', 'pailit');
		$exsist = $this->pailit->isPerkaraExist($idperkara);
		if($exsist==TRUE){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Sudah Terdaftar.'));
			return;
		}elseif($exsist=='-1'){
			echo json_encode(array('st'=>0,'msg'=>'Something Bad Happened.'));
			return;
		}

		$tglPutusan = $this->pailit->getTanggalPutusan($idperkara);
		if(empty($tglPutusan)){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Belum Dapat Didaftarkan. Perkara '.$noPerkara.' Belum Putus.'));
			return;
		}

		$tglPendaftaran = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_pendaftaran',TRUE));

		$selisih = $this->tanggalhelper->getSelisihHari($tglPutusan,$tglPendaftaran);
		if($selisih<0){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pendaftaran Pemberesan Harta Pailit Tidak Boleh Kurang Dari Tanggal Putusan Perkara Kepailitan'));
			return;
		}

		$curr_date = date('Y-m-d');
		$todayDate = date('m/d/Y');
		
		$tglPendaftaranPerkara = $this->pailit->getTglPendaftaranKepailitan($idperkara);
		if(empty($tglPendaftaranPerkara)){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pendaftaran Perkara Kepailitan Tidak Ditemukan'));
			return;
		}

		$selisih = $this->tanggalhelper->getSelisihHari($tglPendaftaran,$curr_date);
		if($selisih<0){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pendaftaran Pemberesan Harta Pailit Tidak Boleh Melebihi Hari Ini. Hari ini Tanggal '.$todayDate));
			return;
		}

		$selisih = $this->tanggalhelper->getSelisihHari($tglPendaftaranPerkara,$tglPendaftaran);
		if($selisih<0){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pendaftaran Pemberesan Harta Pailit Tidak Boleh Kurang Dari Tanggal Pendaftaran Perkara Kepailitan'));
			return;
		}

		$dayname = $this->tanggalhelper->getDayName($tglPendaftaran);
		if($dayname=='Saturday' OR $dayname=='Sunday'){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Pendaftaran Pemberesan Harta Pailit Dihari Libur, Sabtu dan Minggu.'));
			return;
		}


		$data = array(
			'perkara_id' => $idperkara,
			'tanggal_pendaftaran' => $tglPendaftaran,
			'nama_kreditur' => trim($this->input->post('kreditur',TRUE)),
			'jumlah_pembagian' => trim($this->input->post('jml_bagi',TRUE)),
			'amar_penetapan_hakim_pengawas' => trim($this->input->post('amar_text',TRUE)),
			'catatan_harta_pailit' => trim($this->input->post('keterangan',TRUE))
		);

		$kurator = $this->input->post('kurator',TRUE);
		if(!empty($kurator) AND intval($kurator)<1){
			echo json_encode(array('st'=>0,'msg'=>'Mohon Memilih Kurator.'));
			return;
		}else{
			$data['kurator_id'] = $kurator;
		}

		$panitera = $this->input->post('panitera',TRUE);
		if(!empty($panitera) AND intval($panitera)<1){
			echo json_encode(array('st'=>0,'msg'=>'Mohon Memilih Panitera.'));
			return;
		}else{
			$data['panitera_id'] = $panitera;
		}

		$jurusita = $this->input->post('jurusita',TRUE);
		if(!empty($jurusita) AND intval($jurusita)<1){
			echo json_encode(array('st'=>0,'msg'=>'Mohon Memilih Jurusita.'));
			return;
		}else{
			$data['jurusita_id'] = $jurusita;
		}

		

		##
		$tgl_pen_hakim = $this->input->post('tgl_pendaftaran',TRUE);
		$hakim = $this->input->post('hakim',TRUE);
		if(!empty($tgl_pen_hakim)){
			$tgl_pen_hakim = $this->tanggalhelper->convertToMysqlDate($tgl_pen_hakim);
			$selisih = $this->tanggalhelper->getSelisihHari($tgl_pen_hakim,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penetapan Hakim Pengawas Tidak Boleh Melebihi Hari Ini. Hari ini Tanggal '.$todayDate));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tglPendaftaranPerkara,$tgl_pen_hakim);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pendaftaran Pemberesan Harta Pailit Tidak Boleh Kurang Dari Tanggal Pendaftaran Perkara Kepailitan'));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tgl_pen_hakim);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Penetapan Hakim Pengawas Dihari Libur, Sabtu dan Minggu.'));
				return;
			}
			$data['tanggal_penetapan_hakim_pengawas'] = $tgl_pen_hakim;
			if(empty($hakim) AND intval($hakim)<1){
				echo json_encode(array('st'=>0,'msg'=>'Mohon Memilih Hakim Pengawas.'));
				return;
			}else{
				$data['hakim_pengawas_id'] = $hakim;
				
			}
		}
		
		if(!empty($hakim) AND intval($hakim)<1){
			echo json_encode(array('st'=>0,'msg'=>'Mohon Memilih Hakim Pengawas.'));
			return;
		}

		if(!empty($hakim) AND empty($tgl_pen_hakim)){
			echo json_encode(array('st'=>0,'msg'=>'Mohon Memasukan Tanggal Penetapan Hakim Pengawas.'));
			return;
		}

		##
		$tgl_insolvensi = $this->input->post('tgl_insolvensi',TRUE);
		if(!empty($tgl_insolvensi)){
			$tgl_insolvensi = $this->tanggalhelper->convertToMysqlDate($tgl_insolvensi);
			$selisih = $this->tanggalhelper->getSelisihHari($tgl_insolvensi,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Insolvensi Tidak Boleh Melebihi Hari Ini. Hari ini Tanggal '.$todayDate));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tglPendaftaranPerkara,$tgl_insolvensi);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Terjadi Insolvensi Tidak Boleh Kurang Dari Tanggal Pendaftaran Perkara Kepailitan'));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tgl_insolvensi);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Terjadi Insolvensi Dihari Libur, Sabtu dan Minggu.'));
				return;
			}
			$data['tanggal_insolvensi'] = $tgl_insolvensi;
		}

		$tgl_lelang = $this->input->post('tgl_lelang',TRUE);
		if(!empty($tgl_insolvensi)){
			$tgl_lelang = $this->tanggalhelper->convertToMysqlDate($tgl_lelang);

			$selisih = $this->tanggalhelper->getSelisihHari($tglPendaftaranPerkara,$tgl_lelang);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pelelangan Tidak Boleh Kurang Dari Tanggal Pendaftaran Perkara Kepailitan'));
				return;
			}
			$data['tanggal_pelelangan'] = $tgl_lelang;
		}

		$tgl_bagi = $this->input->post('tgl_bagi',TRUE);
		if(!empty($tgl_insolvensi)){
			$tgl_bagi = $this->tanggalhelper->convertToMysqlDate($tgl_bagi);

			$selisih = $this->tanggalhelper->getSelisihHari($tglPendaftaranPerkara,$tgl_bagi);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pelelangan Tidak Boleh Kurang Dari Tanggal Pendaftaran Perkara Kepailitan'));
				return;
			}
			$data['tanggal_pembagian'] = $tgl_bagi;
		}

		if(!empty($jml_bagi)){
			$data['jumlah_pembagian'] = $jml_bagi;
		}
		
		$act = $this->input->post('enc_act',TRUE);
		$act = $this->encrypt->decode(base64_decode($act));

		if($act=='add'){
			$data['diinput_oleh'] = $this->session->userdata('username');
			$data['diinput_tanggal'] = date("Y-m-d h:i:s",time());
			$result = $this->pailit->add_data($data);
		}elseif($act=='updt') {
			$result = $this->pailit->update_data($data,$idperkara);
			$data['diperbaharui_oleh'] = $this->session->userdata('username');
			$data['diperbaharui_tanggal'] = date("Y-m-d h:i:s",time());
			echo json_encode(array('st'=>1,'msg'=>$this->input->post('amar_text',TRUE)));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error Task, Please Refresh Your Browser.'));
			return;
		}
		
		if($result){
			echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan.'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Data Tidak Berhasil Disimpan.'));
			return;
		}
	}

	function validateDelete(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Please Refresh Your Page'));
			return;
		}
		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara)<0){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}
		$this->load->model('harta_pailit/list_harta_pailit', 'pailit');
		$result = $this->pailit->del_data($idperkara);
		if($result){
			echo json_encode(array('st'=>1,'msg'=>'Penghapusan Berhasil.'));
		return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Penghapusan Tidak Berhasil..'));
			return;
		}

	}
	function searchPage(){
		if(empty($_POST)){
			show_404();
		}
		$keyword = $this->input->post('keyword_pihak',TRUE);
		$column = $this->input->post('search_field',TRUE);
		$this->nativesession->set_flash_session('security', TRUE);
		$this->nativesession->set_flash_session('keyword_pihak', $keyword);
		$this->nativesession->set_flash_session('column', $column);
		echo json_encode(array('st'=>1));
		return;
	}

	function viewDetil(){
		$segment = $this->uri->segment_array();
		if(count($segment)!=3){
			show_404();
		}
		$idperkara = $this->encrypt->decode(base64_decode($this->uri->segment(3)));
		if(!is_numeric($idperkara) OR intval($idperkara)<0){
			show_404();
		}
		$this->load->model('harta_pailit/list_harta_pailit', 'pailit');
		$data['hartapailit'] = $this->pailit->getDetilPerkara($idperkara);
		$this->load->vars($data);
		$this->load->view('harta_pailit/harta_pailit_view');
	}
}