<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class ManageAntrian extends CI_Controller {
	public function __construct(){
		parent::__construct();
	}

	function index(){
		$enc=$this->encrypt->decode(base64_decode($this->nativesession->get_flash_session('enc')));
		switch ($enc) {
			case 1:
				$this->input_para_pihak();
			break;
			case 2:
				$this->input_hakim_pp();
			break;
			case 3:
				$this->display_antrian();
			break;
		}
	}

	function link_input_para_pihak(){
		$this->input_para_pihak();
	}

	function link_display_antrian(){
		$this->display_antrian();
	}

	function input_para_pihak(){
		$data['page_title']='ANTRIAN SIDANG '.$this->tanggalhelper->convertDayDate(date('Y-m-d'));
		$data['main_body']='antrian/input_antrian_pihak_v';
		
		$data['history']=$this->nativesession->get_flash_session('url_requested');
		$this->load->vars($data);
		$this->load->view('header_min');
		$this->load->view('body/body_new');
	}

	function iframe_jadwal_list(){
		$this->load->model('antrian/antrian_m','antrian');
		$list_sidang_today=$this->antrian->get_sidang_antrian_today();
		$data['list_sidang_today']=$list_sidang_today;
		$this->load->vars($data);
		$this->load->view('antrian/iframe_jadwal_list_v');
	}

	function input_hakim_pp(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$this->load->model('antrian/antrian_m','antrian');
		$arr_ruang_sidang=array(0=>'Pilih Ruang Sidang');
		$arr_hakim=array(0=>'Pilih Hakim Ketua');

		$list_sidang_today=$this->antrian->get_hakim_list();
		if($list_sidang_today->num_rows()>0){
			foreach ($list_sidang_today->result() as $value) {
				/*$majelis_hakim_id=$value->majelis_hakim_id;
				$majelis_hakim_nama=$value->majelis_hakim_nama;
				$arr_majelis=explode(",", $majelis_hakim_id);
				$arr_nama=explode("</br>", $majelis_hakim_nama);
				$arr_hakim[$arr_majelis[0]]=$arr_nama[0];*/
				$majelis_hakim_id=$value->id;
				$majelis_hakim_nama=$value->nama_gelar;
				$arr_hakim[$majelis_hakim_id]=$majelis_hakim_nama;
			}
		}
		$ruang_sidang_list=$this->antrian->get_ruang_sidang_list();
		if($ruang_sidang_list->num_rows()>0){
			foreach ($ruang_sidang_list->result() as $value) {
				$ruang_id=$value->id;
				$ruangan=$value->nama;
				if ($ruang_id!='')$arr_ruang_sidang[$ruang_id]=$ruangan;
			}
		
		}
		$data['hakim_list']=$arr_hakim;
		$data['ruang_sidang_list']=$arr_ruang_sidang;
		$data['page_title'] = 'INPUT RUANG SIDANG '.$this->tanggalhelper->convertDayDate(date('Y-m-d'));
		$data['main_body'] = 'antrian/input_antrian_hakim_pp';
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body_new');
	}

	function f_validate_input_antrian(){
		if(empty($_POST)){
			show_404();
		}
		$nomor_perkara=$this->input->post('nomor_perkara',true);
		$nomor_perkara=trim($nomor_perkara);
		$this->load->model('antrian/antrian_m','antrian');
		$perkara_id=$this->antrian->get_perkara_id($nomor_perkara);
		if ($perkara_id!=''){
			$info_ruangan=$this->antrian->get_info_ruangan($perkara_id);
			if (empty($info_ruangan) OR empty($info_ruangan->ruangan_id)){
				//echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Tidak Berhasil Membuat Antrian, Ruangan Sidang Belum Ditentukan<br />Petugas Belum Melengkapi Data Ruangan Sidang untuk Perkara '.$nomor_perkara));	
				echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Tidak Berhasil Membuat Antrian <br/>Hari Ini Tidak Ada Jadwal Sidang Untuk Perkara: <strong>'.$nomor_perkara.'</strong>'));	
				return;
			}else{
				if ($info_ruangan->tanggal_sidang!=date('Y-m-d')){
					echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Tidak Berhasil Membuat Antrian <br/>Hari Ini Tidak Ada Jadwal Sidang Untuk Perkara: <strong>'.$nomor_perkara.'</strong>'));	
					return;
				}
				$ruang_id=$info_ruangan->ruangan_id;
				$ruang_kode=$info_ruangan->kode;
				$cek_antrian=$this->antrian->cek_antrian($perkara_id);
				if ($cek_antrian==0){
					$nomor_antrian=$this->antrian->get_nomor_antrian($ruang_id,$perkara_id);
					$nomor_urut=$this->antrian->get_nomor_urut($ruang_id);
					$data=array('nomor_antrian'=>$nomor_antrian,
								'tanggal_sidang'=>date('Y-m-d'),
								'ruang_id'=>$ruang_id,
								'perkara_id'=>$perkara_id,
								'status'=>0,
								'urutan'=>$nomor_urut);
					if ($this->antrian->add_antrian($data)){
						echo json_encode(array('st'=>1,'msg'=>'Antrian Berhasil Dibuat dengan Nomor Antrian: <strong>'.$ruang_kode.'-'.$nomor_antrian.'</strong>'));
						//NGE-PRINT ANTRIAN
						return;
					}else{
						echo json_encode(array('st'=>0,'msg'=>'Error:<br /> Tidak Berhasil Membuat Antrian untuk Perkara: '.$nomor_perkara));
						return;
					}
				}else{
					echo json_encode(array('st'=>1,'msg'=>'Perkara: <strong>'.$nomor_perkara.'</strong> dengan Nomor Antrian: '.$cek_antrian.'<br/> '.$info_ruangan->ruangan));
					return;
				}
			}
		}else{
			echo json_encode(array('st'=>1,'msg'=>'Error:<br /> Tidak Berhasil Membuat Antrian<br /> Tidak Ada Perkara dengan Nomor: <strong>'.$nomor_perkara.'</strong>'));	
			return;
		}
	}

	function f_validate_input_ruang_sidang(){
		if(empty($_POST)){
			show_404();
		}
		$ruang_id=$this->input->post('ruang_id',true);
		$hakim_id=$this->input->post('hakim_id',true);
		$panggil_no_perk=$this->input->post('panggil_no_perk',true);
		$update_ruang=$this->input->post('update_ruang',true);
		$this->tanggal_sidang=$this->tanggalhelper->convertToMysqlDate($this->input->post('tanggal_sidang',true));

		if ($ruang_id!=0 AND $hakim_id!=0){
			$this->show_antrian($ruang_id,$hakim_id,$panggil_no_perk,$update_ruang);
		}else{
			$this->url=($this->nativesession->get_flash_session('url_requested', current_url()));
			echo "<script>alert('Masukkan Data Sidang');window.open('".$this->url."','_self');</script>";
		}
	}

	function show_antrian($ruang_id, $hakim_id,$panggil_no_perk=1,$update_ruang=0){
		$col=2;
		$start_page=0;
		$keyword='';
		$where='';
		if($start_page>0){
			$begin_limit = ($start_page-1)*50;
		}else{
			$begin_limit = 0;
			$start_page = 1;
		}
		$data['total_rows'] = 0;
		$data['ruang_id'] = $ruang_id;
		$data['hakim_id'] = $hakim_id;
		$data['panggil_no_perk'] = $panggil_no_perk;
		
		$this->load->model('antrian/antrian_m','antrian');
		if($update_ruang==1){
			$this->antrian->update_ruang($ruang_id,$hakim_id,$this->tanggal_sidang);
		}
		if ($this->tanggal_sidang==date('Y-m-d')){
			$query=$this->antrian->get_antrian_list($ruang_id,$hakim_id)->result();
			$data['antrian_list'] = $query;
			$data['page_active'] = $begin_limit;
			$data['page_title'] = 'DAFTAR ANTRIAN SIDANG '.$ruang_id;
			$arr_tgl_sidang=explode("-", $this->tanggal_sidang);
			$data['tanggal_sidang'] = $arr_tgl_sidang[2].'/'.$arr_tgl_sidang[1].'/'.$arr_tgl_sidang[0];
		}
		
		$data['main_body'] = 'antrian/antrian_hakim_pp_v';
		 
		$data['page_number'] = $start_page;
		$data['page_url'] = 'perkara_list';
		$data['keyword'] = $keyword;
		$data['column_sorted'] = $col;
		if ($this->tanggal_sidang==date('Y-m-d')){
			$this->load->vars($data);
			$this->load->view('header');
			$this->load->view('body/body_antrian');
		}else{
			
		}
	}

	function panggil_antrian(){
		$segment=$this->uri->segment_array();
		$antrian_id=$this->encrypt->decode(base64_decode($segment[3]));
		$panggil_no_perk=$segment[4];
		$this->load->model('antrian/antrian_m','antrian');
		$info_antrian=$this->antrian->get_info_antrian($antrian_id)->row();
		$nomor_antrian=$info_antrian->nomor_antrian;
		$ruang_id=$info_antrian->ruang_id;
		$perkara_id=$info_antrian->perkara_id;
		$info_perkara=$this->antrian->get_info_perkara($perkara_id);
		$nomor_perkara=$info_perkara->row()->nomor_perkara;
		$path = ('resources/file/ini/antrian_r_'.$ruang_id.'.txt');
		if (file_exists($path)){
	    	$ini_array = parse_ini_file($path, true);
	    }else{
	    	$ini_array=array();
	    }
		$ini_array['antrian_ruang_id_'.$ruang_id]=array('antrian'=>$antrian_id,'panggil_no_perk'=>$panggil_no_perk);
		$this->write_ini_file($ini_array, $path, true);
		echo "<script>window.close()</script>";
	}

	function tunda_antrian(){
		$segment=$this->uri->segment_array();
		$antrian_id=$this->encrypt->decode(base64_decode($segment[3]));
		$panggil_no_perk=$segment[4];
		$this->load->model('antrian/antrian_m','antrian');
		$info_antrian=$this->antrian->get_info_antrian($antrian_id)->row();
		$ruang_id=$info_antrian->ruang_id;
		$nomor_urut=$this->antrian->get_nomor_urut($ruang_id);
		$data=array();
		$data['urutan']=$nomor_urut;
		$data['status']=1;
		$this->antrian->edit_status($data,$antrian_id);
		echo "<script>window.close()</script>";
	}

	function selesai_antrian(){
		$segment=$this->uri->segment_array();
		$this->tanggal_sidang=$this->encrypt->decode(base64_decode($segment[7]));
		$antrian_id=$this->encrypt->decode(base64_decode($segment[3]));
		$this->load->model('antrian/antrian_m','antrian');
		$data=array('status'=>2);
		if ($this->antrian->edit_status($data,$antrian_id)){
			$ruang_id=$segment[4];
			$hakim_id=$segment[5];
			$panggil_no_perk=$segment[6];
			$this->show_antrian($ruang_id, $hakim_id,$panggil_no_perk);
		}
	}

	function write_ini_file($assoc_arr, $path, $has_sections=FALSE) { 
	    $content = ""; 
	    if ($has_sections) { 
	        foreach ($assoc_arr as $key=>$elem) { 
	            $content .= "[".$key."]\n"; 
	            foreach ($elem as $key2=>$elem2) { 
	                if(is_array($elem2)) 
	                { 
	                    for($i=0;$i<count($elem2);$i++) 
	                    { 
	                        $content .= $key2."[] = ".$elem2[$i]."\n"; 
	                    } 
	                } 
	                else if($elem2=="") $content .= $key2." = \n"; 
	                else $content .= $key2." = ".$elem2."\n"; 
	            } 
	        } 
	    } 
	    else { 
	        foreach ($assoc_arr as $key=>$elem) { 
	            if(is_array($elem)) 
	            { 
	                for($i=0;$i<count($elem);$i++) 
	                { 
	                    $content .= $key."[] = \"".$elem[$i]."\"\n"; 
	                } 
	            } 
	            else if($elem=="") $content .= $key." = \n"; 
	            else $content .= $key." = \"".$elem."\"\n"; 
	        } 
	    } 

	    
    	if (!$handle = fopen($path, 'w')) { 
    		fclose($handle); 
	        return false; 
	   	}

	    $success = fwrite($handle, $content);
	    fclose($handle); 

	    return $success; 
	}

	function display_antrian(){
		$data['page_title']='ANTRIAN SIDANG';
		$data['main_body']='antrian/display_antrian_v';
		$this->load->model('antrian/antrian_m','antrian');
		$list_ruang_sidang=$this->antrian->get_ruang_sidang_list();
		$arr_ruang_sidang=array();
		if (!empty($list_ruang_sidang)){
			foreach ($list_ruang_sidang->result() as $row) {
				$arr_ruang_sidang[$row->id]=$row->nama;
			}
		}
		$data['ruang_sidang_list']=$arr_ruang_sidang;
		$data['history']=$this->nativesession->get_flash_session('url_requested');
		$this->load->vars($data);
		$this->load->view('header_min');
		$this->load->view('body/body_new');
	}

	function display_iframe_by_ruang(){
		$this->load->model('antrian/antrian_m','antrian');
		$list=$this->antrian->get_antrian_by_ruang();
		if($list->num_rows()>0){
			$data['list_antrian']=$list->result();
			$this->load->vars($data);
			$this->load->view('antrian/iframe_antrian_by_ruang_v');
		}else{
			return;
		}
	}

	function cek_session_antrian(){
		if(empty($_POST)){
			echo '0';
			exit;
		}
		$ruang_id=$this->input->post('ruang_id');
		$arr_ruang=explode(",", $ruang_id);
		foreach ($arr_ruang as $val) {
			$this->ambil_suara($val);
		}
	}

	function ambil_suara($ruang_id){
		//$path = ('resources/file/ini/antrian.ini');
		$path = ('resources/file/ini/antrian_r_'.$ruang_id.'.txt');
		if (file_exists($path)){
	    	$ini_array = parse_ini_file($path, true);
	    	$res=$ini_array['antrian_ruang_id_'.$ruang_id]['antrian'];
	    	$dengan_no_perk=$ini_array['antrian_ruang_id_'.$ruang_id]['panggil_no_perk'];
	    }else{
	    	$ini_array=array('antrian_ruang_id_'.$ruang_id => array('antrian'=>'','panggil_no_perk'=>''));
	    	$res='';
	    }
	    $ini_array['antrian_ruang_id_'.$ruang_id]['antrian']='';
	    $ini_array['antrian_ruang_id_'.$ruang_id]['panggil_no_perk']='';
		$this->write_ini_file($ini_array, $path, true);
		if ($res!=''){
			$antrian_id=$res;
			$this->load->model('antrian/antrian_m','antrian');
			$result_antrian=$this->antrian->get_info_antrian($antrian_id);
			if ($result_antrian->num_rows()==0){
				echo '';
				return;
			}
			$info_antrian=$result_antrian->row();
			$kode_ruang=$info_antrian->kode;
			$nomor_antrian=$info_antrian->nomor_antrian;
			$ruang_id=$info_antrian->ruang_id;
			$ruangan=$info_antrian->nama;
			$perkara_id=$info_antrian->perkara_id;
			$info_perkara=$this->antrian->get_info_perkara($perkara_id);
			$nomor_perkara=trim($info_perkara->row()->nomor_perkara);
			$kata=array();
			$file=array();
			$kata[]='na';
			if (intval($kode_ruang)<10){
				$arr1 = str_split($kode_ruang);
				foreach ($arr1 as $value) {
					if($value!=0){
						$value=$this->terbilang($value);
					}else{
						$value='kosong';
					}
					$kata[]=str_replace("-", "",$value);
				}
			}else{
				$temp=$this->terbilang($kode_ruang);
				$arr_temp=explode("-", $temp);
				foreach ($arr_temp as $val) {
					if($val!='')$kata[]=$val;
				}
			}
			$kata[]='strip';
			$no_antrian=$this->terbilang($nomor_antrian);
			$arr_no_antrian=explode("-", $no_antrian);
			foreach ($arr_no_antrian as $value) {
				if ($value!='')$kata[]=$value;
			}
			if($dengan_no_perk==1){
				$kata[]='dengan_nomor_perkara';
				$arr_no_perkara=explode("/",$nomor_perkara);
				foreach ($arr_no_perkara as $value) {
					if ($value!=''){
						if(is_numeric($value)){
							$temp=$this->terbilang($value);
							$arr_temp=explode("-", $temp);
							foreach ($arr_temp as $val) {
								if($val!='')$kata[]=$val;
							}
						}elseif($value=='Pdt.G'){
							$kata[]='g';
						}elseif($value=='Pdt.P'){
							$kata[]='p';
						}
					}
				}	
			}
			$kata[]='hmsd';
			$temp=trim($this->terbilang($ruang_id));
			$kata[]=str_replace("-", "", $temp);
			$kata[]='terima_kasih';
			$kata[]='closing';
			$file=array();
			for ($i=0;$i<count($kata);$i++){
				//print_r(base_url('resources/suara/mp3/'.$kata[$i].'.mp3'));
				//exit;
				if(file_exists(('resources/suara/mp3/'.$kata[$i].'.mp3'))){
					$file['ke_'.$i] = base_url('resources/suara/mp3/'.$kata[$i].'.mp3');
				}
			}
			$ruangan=strtolower($ruangan);
			$ruangan=str_replace("ruang", "", $ruangan);
			$ruangan=str_replace("sidang", "", $ruangan);
			$ruangan=trim($ruangan);
			$ruangan=$this->templatehelper->ucname($ruangan);
			$no=$kode_ruang.'-'.$nomor_antrian;
			$json=array('suara'=>$file, 'nomor_antrian'=>$no, 'ruangan'=>$ruangan,'ruang_id'=>$ruang_id, 'nomor_perkara'=>$nomor_perkara);
			echo json_encode($json);
			exit;
		}else{
			echo $res;
		}
	}

	function ambil_jadwal_sidang_hakim(){
		$this->load->library('table');
		$tmpl = array ( 'table_open'  => '<table id="tabel_jadwal">' );
		$this->table->set_template($tmpl);
		$this->table->set_heading(
				    array('data' => 'No', 'style' => 'width:5%'),
				    array('data' => 'Nomor perkara', 'style' => 'width:40%'),
				    array('data' => 'Kode Ruang Sidang', 'style' => 'width:10%'),				    
				    array('data' => 'Ruang Sidang', 'style' => 'width:40%px')
				    );
		if(empty($_POST)){
			echo $this->table->generate();
			exit;
		}
		$this->load->model('antrian/antrian_m','antrian');
		$hakim_id=$this->input->post('hakim_id',true);
		$tanggal_sidang=$this->tanggalhelper->convertToMysqlDate($this->input->post('tgl',true));
		$res=$this->antrian->get_jadwal_sidang_hakim($hakim_id,$tanggal_sidang);
		$data=array();
		if($res->num_rows()>0){
			$i=1;
			$this->table->add_row('','','','');
			foreach ($res->result() as $row) {
				$this->table->add_row($i, $row->nomor_perkara, $row->kode, $row->ruangan);
				$i++;
			}
		}
		echo $this->table->generate();
	}


	function terbilang($x){
		if ($x==''){
			$x=0;
		}
		$abil = array("", "satu", "dua", "tiga", "empat", "lima", "enam", "tujuh", "delapan", "sembilan", "sepuluh", "sebelas");
			if($x < 12)
				return "-" . $abil[$x];
			elseif ($x < 20)
    			return $this->Terbilang($x - 10) . "-belas";
    		elseif ($x < 100)
    			return $this->Terbilang($x / 10) . "-puluh" .$this->Terbilang($x % 10);
    		elseif ($x < 200)
    			return "-seratus" .$this->Terbilang($x - 100);
    		elseif ($x < 1000)
    			return $this->Terbilang($x / 100) . "-ratus" .$this->Terbilang($x % 100);
    		elseif ($x < 2000)
    			return "-seribu" .$this->Terbilang($x - 1000);
    		elseif ($x < 1000000)
    			return $this->Terbilang($x / 1000) . "-ribu" .$this->Terbilang($x % 1000);
    		elseif ($x < 1000000000)
    			return $this->Terbilang($x / 1000000) . "-juta" .$this->Terbilang($x % 1000000);
	}

}