<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Login extends CI_Controller {
	function __construct(){
		parent::__construct();
		$this->load->model('default/validated', 'val');
        //$this->val->setup_language();
	}
	public function index($err=FALSE){
		/*
		if($this->nativesession->isStatusPihak()!=TRUE){
			$this->load->model('default/validated', 'val');
			$this->val->setup();
		}*/
		if($err==FALSE){
			$err = FALSE;
		}else{
			$err =TRUE;
		}
		if($this->session->userdata('is_logged_in')){
			if($this->session->userdata('login_time')){
				if (((time()-strtotime($this->session->userdata('login_time')))/60)>60) {
					$this->load->model('Login/validation_user');
					if(!$this->validation_user->delSession()){
						#load error
					}
					$this->doLogin($err);
				}else{
					#add redirect to url destination
					redirect('main');
				}
			}else{
				$this->doLogin($err);
			}
		}else{
			$this->doLogin($err);
		}
	}

	function doLogin($err=FALSE){
		$data['error'] =$err;
		$this->load->model('default/defaults');
		$query = $this->defaults->getSystemInfo();
		$data['namaPN'] = 'Not Configure';
		foreach ($query->result() as $row) {
			if($row->id == 62){
				if(!empty($row->value)){
					$data['namaPN'] = $row->value;
					$this->session->set_userdata('namaPN',$row->value);
				}
			}
			if($row->id == 80 AND $row->name == 'app_version'){
				if(!empty($row->value)){
					$this->session->set_userdata('app_version',$row->value);
				}
				if(!empty($row->VALUE)){
					$this->session->set_userdata('app_version',$row->VALUE);
				}
			}
			if($row->id == 83){
				if(!empty($row->value)){
					$this->session->set_userdata('jenis_pengadilan',$row->value);
				}else{
					$this->session->set_userdata('jenis_pengadilan',1);
				}
			}
		}
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('Login/login');
		$this->load->view('footer');
	}

	function validation_credential(){
		$this->load->library('form_validation');
		$this->form_validation->set_rules('username','username','trim|required');
		$this->form_validation->set_rules('password','password','trim|required');
		if($this->form_validation->run()===TRUE){
			$this->load->model('Login/validation_user');
			if($this->validation_user->validate()==TRUE){
				$status_update = FALSE;
				if($this->session->userdata('idgroup')==1){
					$this->load->model('default/defaults', 'def');
					$this->runs_queries();
					$app_version = $this->session->userdata('app_version');
					//check update in local database 
					$hasil=$this->def->get_update_status();
					if(!empty($hasil)){
						if($hasil->num_rows()>0){
							if(!empty($app_version)){
								foreach ($hasil->result() as $key) {
									if(version_compare($app_version, $key->patch_ver, '<')){
										$status_update = TRUE;
										break;
									}
								}
							}
						}
					}
					if($status_update)
						redirect('app_update');
					else
						redirect('main');
				}else{
					redirect('main');
				}
			}else{
				redirect('login/index/ERR');
			}
		}else{
			redirect('login/index/ERR');
		}
	}

	function slideshow(){
		$this->load->view('Login/slideshow');
	}

	function runs_queries(){
		$hasil=$this->def->get_update_queries();
		if($hasil!=''){
			if($hasil->num_rows()>0){
				$path = ('resources/file/ini/conf_queries.ini');
				if (file_exists($path)){
			    	$ini_array = parse_ini_file($path, true);
			    }else{
			    	$ini_array=array('queries' => array('id' => array('0')));
			    	$this->write_ini_file($ini_array, $path, true);
			    }
			    foreach ($hasil->result() as $key) {
					if (!in_array($key->id, $ini_array['queries']['id'])) {
						$query=$this->encrypt->decode(base64_decode($key->params));
						//$query=$key->params;
						if($this->def->run_query($query)){
							$ini_array['queries']['id'][]=$key->id;
							$this->write_ini_file($ini_array, $path, true);
							return true;
						}else{
							return false;
						};
					}
				}
			}else{
				return true;
			}
		}else{
			redirect("logout");
		}
	}

	function write_ini_file($assoc_arr, $path, $has_sections=FALSE) { 
	    $content = ""; 
	    if ($has_sections) { 
	        foreach ($assoc_arr as $key=>$elem) { 
	            $content .= "[".$key."]\n"; 
	            foreach ($elem as $key2=>$elem2) { 
	                if(is_array($elem2)) 
	                { 
	                    for($i=0;$i<count($elem2);$i++) 
	                    { 
	                        $content .= $key2."[] = ".$elem2[$i]."\n"; 
	                    } 
	                } 
	                else if($elem2=="") $content .= $key2." = \n"; 
	                else $content .= $key2." = ".$elem2."\n"; 
	            } 
	        } 
	    } 
	    else { 
	        foreach ($assoc_arr as $key=>$elem) { 
	            if(is_array($elem)) 
	            { 
	                for($i=0;$i<count($elem);$i++) 
	                { 
	                    $content .= $key."[] = \"".$elem[$i]."\"\n"; 
	                } 
	            } 
	            else if($elem=="") $content .= $key." = \n"; 
	            else $content .= $key." = \"".$elem."\"\n"; 
	        } 
	    } 

	    
    	if (!$handle = fopen($path, 'w')) { 
    		fclose($handle); 
	        return false; 
	   	}

	    $success = fwrite($handle, $content);
	    fclose($handle); 

	    return $success; 
	}

}