<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Laporan_tun extends CI_Controller {
	function index($enc){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$segment = $this->uri->segment_array();
		if(count($segment)!=4){
			show_404();
		}
		$this->show($segment[3]);
	}


	function show($enc){
		$idalurperkara = $this->encrypt->decode(base64_decode($enc));
		$this->load->model('report/report');
		$title_perkara = '';
		$tmp = explode(",", $idalurperkara);
		$list_perkara = array();
		if(count($tmp)>0){
			for ($i=0; $i < count($tmp); $i++) {
				if($i>0){
					$title_perkara .= " DAN ";
				}
				$perkara_nama = $this->report->getJenisPerkara($tmp[$i]);
				array_push($list_perkara,array('id'=>$tmp[$i],'nama'=>$perkara_nama));
				$title_perkara .= strtoupper($perkara_nama);
			}
		}else{
			$perkara_nama = $this->report->getJenisPerkara($idalurperkara);
			array_push($list_perkara,array('id'=>$idalurperkara,'nama'=>$perkara_nama));
			$title_perkara = strtoupper($perkara_nama);
		}

		$year = array(date("Y",time()));
		$tahun_sekarang = date("Y",time());
		$min_tahun = $tahun_sekarang;
		$query = $this->report->get_tahun($idalurperkara);
		if($query->num_rows==1){
			foreach ($query->result() as $row) {
				$min_tahun = $row->years;
			}
		}
		$tmp = $tahun_sekarang;
		if($min_tahun<$tahun_sekarang AND !empty($min_tahun)){
			while (TRUE) {
				$tmp--;
				if($tmp<$min_tahun){
					break;
				}
				array_push($year, $tmp);
			}
		}
		$data['list_perkara'] = $list_perkara;
		$data['jenis_laporan'] = $this->fetch_jenis_laporan($idalurperkara);
		$data['rekap_laporan'] = $this->fetch_rekap_laporan($idalurperkara);
		$data['tahun'] = $year;
		$data['IDalurPerkara'] = $idalurperkara;
		$data['page_title'] = 'LAPORAN PERKARA '.$title_perkara;
		$data['enc'] = $enc;
		$data['page_url'] = 'proses_alur_perkara_list';
		
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('laporan/laporan_tun');
		$this->load->view('footer');
	}

	function fetch_jenis_laporan($idalurperkara){
		
		$jenis_laporan = array();
		

		if($idalurperkara=='9'){
			array_unshift($jenis_laporan,array(
				'nama'=>'LAPORAN KEADAAN PERKARA TATA USAHA NEGARA',
				'id' => '9',
				'tahapan' => '10'),
				array(
					'nama'=>'LAPORAN JENIS PERKARA',
					'id' => '10',
					'tahapan' => '10'),
				array(
					'nama'=>'LAPORAN KEADAAN PERKARA YANG DIMOHONKAN BANDING',
					'id' => '11',
					'tahapan' => '20'),
				array('nama'=>'LAPORAN PERKARA YANG DIMOHONKAN KASASI',
					'id' => '1',
					'tahapan' => '30'),
				array('nama'=>'LAPORAN PERKARA YANG DIMOHONKAN PENINJAUAN KEMBALI',
					'id' => '1',
					'tahapan' => '40'),
				array('nama'=>'LAPORAN PERKARA YANG DIMOHONKAN EKSEKUSI',
					'id' => '1',
					'tahapan' => '50'),
				array('nama'=>'LAPORAN KEUANGAN PERKARA',
					'id' => '1',
					'tahapan' => '88'),
				
				array(
					'nama'=>'LAPORAN PELAKSANAAN PRODEO',
					'id' => '12',
					'tahapan' => '10'),
				array(
					'nama'=>'LAPORAN KEGIATAN HAKIM',
					'id' => '13',
					'tahapan' => '10'),
				array(
					'nama'=>'LAPORAN KEGIATAN PANITERA DAN PANITERA PENGGANTI',
					'id' => '14',
					'tahapan' => '10')
				);
			}

			return $jenis_laporan;
	}


	function fetch_rekap_laporan($idalurperkara){
		$rekap_laporan = array(
			array('nama'=>'REKAPITULASI PERKARA',
				'id' => '1',
				'tahapan' => '10'),
			array('nama'=>'REKAPITULASI PENYELESAIAN PERKARA',
				'id' => '2',
				'tahapan' => '10'),
			array('nama'=>'REKAPITULASI PUTUSAN TINGKAT PERTAMA',
				'id' => '3',
				'tahapan' => '10'),
			array('nama'=>'REKAPITULASI PUTUSAN BANDING',
				'id' => '1',
				'tahapan' => '20'),
			array('nama'=>'REKAPITULASI PUTUSAN KASASI',
				'id' => '1',
				'tahapan' => '30'),
			array('nama'=>'REKAPITULASI PUTUSAN PENINJAUAN KEMBALI',
				'id' => '1',
				'tahapan' => '40')
			);

		if($idalurperkara=='1,2'){
			unset($rekap_laporan[15]);
		}elseif($idalurperkara>100){
			unset($rekap_laporan[14]);
		}elseif($idalurperkara=='3,4'){
			unset($rekap_laporan[2]);
			unset($rekap_laporan[6]);
			#unset($rekap_laporan[9]);
			unset($rekap_laporan[11]);
			unset($rekap_laporan[15]);
		}elseif($idalurperkara=='5'){
			unset($rekap_laporan[2]);
			unset($rekap_laporan[6]);
			#unset($rekap_laporan[9]);
			unset($rekap_laporan[11]);
			unset($rekap_laporan[15]);
		}
		return $rekap_laporan;
	}
}