<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Jurnal_ht_list extends CI_Controller {
	function parseParam($params){
		$data = array();
		$idalurperkara = '';
		$tahapan_id = '';
		$tmp = explode(";", $params);
		if(count($tmp)>0){
			$tmp_var = explode("=", $tmp[0]);
			if(count($tmp_var)>0){
				$data['idalurperkara'] = $tmp_var[1];
			}
			$tmp_var = explode("=", $tmp[1]);
			if(count($tmp_var)>0){
				$data['tahapan_id'] = $tmp_var[1];
			}
		}
		return $data;
	}
	function index(){
		$this->load->model('default/defaults');
		$segment = $this->uri->segment_array();
		$pagenumber = 0;
		$keyword = "";
		$col ="";
		$this->nativesession->set('main_url_requested', current_url());
		if($this->uri->segment(2)=='page'){
			$pagenumber = $this->uri->segment(3);
			$param = $this->uri->segment(4);
			$this->nativesession->set_flash_session('page', $this->uri->segment(3));
			$this->nativesession->set_flash_session('enc', $this->uri->segment(4));
			$tmp = explode("=", $this->uri->segment(5));
			if($tmp>0 AND $tmp[0]=="col"){
				$col = $tmp[1];
				$this->nativesession->set_flash_session('col', $col);
				$this->nativesession->set_flash_session('keyword','');
			}else{
				$keyword = rawurldecode($this->uri->segment(5));
				$col = $this->uri->segment(6);
				$this->nativesession->set_flash_session('keyword', $keyword);
				$this->nativesession->set_flash_session('col', $col);
			}
		}elseif($this->uri->segment(2)=='search'){
			if($this->input->post('search')){
				$this->nativesession->set_flash_session('keyword', $this->input->post('search'));
				$keyword = $this->input->post('search');
			}else{
				$this->nativesession->set_flash_session('keyword', rawurldecode($this->uri->segment(3)));
				$keyword = ($this->uri->segment(3));
			}
			if($this->input->post('enc')){
				$this->nativesession->set_flash_session('enc', $this->input->post('enc'));
				$param=$this->input->post('enc');
			}else{
				$this->nativesession->set_flash_session('enc', $this->uri->segment(4));
				$param=$this->uri->segment(4);
			}
			$this->nativesession->set_flash_session('page', '');
			$this->session->set_userdata('total_rows',-1);
		}elseif($this->uri->segment(2)=='sort'){
			$col = $this->uri->segment(3);
			$param = $this->uri->segment(4);
			$this->sort($col,$param,$keyword);
			$this->nativesession->set_flash_session('col', $col);
			$this->nativesession->set_flash_session('enc', $param);
			$this->nativesession->set_flash_session('keyword', rawurldecode($this->uri->segment(5)));
			return;
		}else{
			$this->session->set_userdata('asc_desc','DESC');
			$param = $this->uri->segment(4);
			$this->session->set_userdata('total_rows',-1);
		}
		if ($keyword!=''){
			$this->nativesession->set('main_url_requested', base_url(uri_string().'/'.$keyword.'/'.$param));
		}else{
			$this->nativesession->set('main_url_requested', base_url(uri_string()));	
		}

		$this->showData($param,$pagenumber,$keyword,$col);
	}

	function sort($col=null,$enc=null,$keyword=null){
		if($this->session->userdata('asc_desc')){
			if($this->session->userdata('asc_desc')=="DESC"){
				$this->session->set_userdata('asc_desc','ASC');
			}else{
				$this->session->set_userdata('asc_desc','DESC');
			}
		}else{
			$this->session->set_userdata('asc_desc','ASC');
		}
		$this->showData($enc,0,$keyword,$col);
	}

	function showData($param,$pagenumber=0,$keyword='',$col=2){
		$asc_desc = $this->session->userdata('asc_desc');
		if($pagenumber>0){
			$begin_limit = ($pagenumber-1)*50;
		}else{
			$begin_limit = 0;
			$pagenumber = 1;
		}
		$params = $this->encrypt->decode(base64_decode($param));
		$data = $this->parseParam($params);
		
		$enc = base64_encode($this->encrypt->encode($data['idalurperkara']));
		$idalurperkara = $this->encrypt->decode(base64_decode($enc));
		$this->load->model('jurnal/jurnal_ht','jurnal');
		$data['params'] = $params;
		$data['enc'] = $param;
		$data['idalurperkara'] = $idalurperkara;
		$data['list_jurnal_perkara'] = $this->jurnal->getJurnalList($idalurperkara,$data['tahapan_id'],$begin_limit,$keyword,$col,$asc_desc);
		//$this->nativesession->set('main_url_requested',current_url());
		if($this->session->userdata('total_rows')){
			if($this->session->userdata('total_rows')==-1){
				$data['total_rows'] = $this->jurnal->fecth_data_num($idalurperkara,$data['tahapan_id'],$keyword);
				$this->session->set_userdata('total_rows',$data['total_rows']);
			}else{
				$data['total_rows'] = $this->session->userdata('total_rows');
			}
		}else{
			$data['total_rows'] = $this->jurnal->fecth_data_num($idalurperkara,$data['tahapan_id'],$keyword);
			$this->session->set_userdata('total_rows',$data['total_rows']);
		}
		$data['page_active'] = $begin_limit+1;
		$data['page_number'] = $pagenumber;


		$data['page_title'] = 'JURNAL KEUANGAN PERKARA EKSEKUSI TANGGUNGAN';
		$data['main_body'] = 'jurnal_perkara/jurnal_ht';
		$data['page_url'] = 'jurnal_ht_list';
		$data['keyword'] = $keyword;
		$data['column_sorted'] = $col;
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body');
	}

	function add_biaya($idperkara){
		$this->load->view('add_biaya');
	}
}