<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Jaksa_list_diversi extends CI_Controller {
	function index(){
		#add authorization check hak akses di pihak
		#
		if($this->session->userdata('is_logged_in')===FALSE){
			redirect('login');
		}
		$pageNumber = $this->nativesession->get_flash_session('pageNumber_pihak');
		if(empty($pageNumber)){
			$pageNumber = 1;
			$begin = 0;
		}else{
			$begin = ($pageNumber-1)*30;
		}

		$keyword = $this->nativesession->get_flash_session('keyword_pihak');
		$this->load->model('jaksa/list_jaksa', 'jaksa');
		$data['jaksa'] = $this->jaksa->getListJaksa(9,'DESC',$begin,$keyword);
		$data['total_rows'] = $this->jaksa->fecth_data_num();
		$data['page_number'] = $pageNumber;
		$data['current_date'] = date('d/m/Y');
		$data['counter'] = $begin;
		$data['keyword'] = $keyword;
		$data['country'] = $this->jaksa->getListCountry();
		$data['agama'] = $this->jaksa->getListAgama();
		$data['pendidikan'] = $this->jaksa->getListPendidikan();
		$this->load->vars($data);
		$this->load->view('jaksa/jaksa_list');
	}

	function fetchJaksa(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Please Refresh Your Page'));
			return;
		}
		$idPihak = $this->encrypt->decode(base64_decode($this->input->post('val',TRUE)));
		if(is_numeric($idPihak)){
			if($idPihak>0){
				$this->load->model('jaksa/list_jaksa', 'jaksa');
				$result = $this->jaksa->getInfoPihak($idPihak);
				if($result!=''){
					if($result->num_rows()>0){
						foreach ($result->result() as $row) {
							$id = base64_encode($this->encrypt->encode($row->id));
							$nama = $row->nama;
							$alamat = $row->alamat;
							$pekerjaan = $row->pekerjaan;
							$tglLahir = $row->tanggal_lahir;
							$tempatLahir = $row->tempat_lahir;
							$jenisPihak = $row->jenis_pihak;
							$IDJenisPihak = $row->jenis_pihak_id;
							$jenisIdentitas = $row->jenis_indentitas;
							$noIdentitas = $row->nomor_indentitas;
							$golDarah = $row->golongan_darah;
							$agama = $row->agama;
							$IDAgama = $row->agama_id;
							$IDStatusKawin = $row->status_kawin_id;
							if($row->jenis_kelamin=='L'){
								$sex = 'Laki Laki';
								$IDSex = 1;
							}elseif($row->jenis_kelamin=='P'){
								$sex = 'Perempuan';
								$IDSex = 2;
							}else{
								$sex='';
								$IDSex = '';
							}
							$wargaNegara = $row->warga_negara;
							$IDWargaNegara = $row->warga_negara_id;
							$kawin = $row->status_kawin;
							$pendidikan = $row->pendidikan;
							$IDPendidikan = $row->pendidikan_id;
							$keterangan = $row->keterangan;
							if(!empty($tglLahir)){
								$umur = $this->tanggalhelper->getSelisihTahun($tglLahir,date('Y-m-d'));
							}else{
								$umur = "";
							}
							$no_induk = $row->NIP;
							$nama_kejaksaan = $row->kejaksaan;
							$alamat_kantor = $row->alamat_kantor;
							$pangkat = $row->pangkat;
							$jabatan = $row->jabatan;
							$kesatuan = $row->kesatuan;
						}
						$isLengkap = 1;
						$notFill ='-';
						if(empty($id)){
							$isLengkap = 0;
							$notFill ='enc_id';
						}
						if(empty($jenisPihak)){
							$isLengkap = 0;
							$notFill ='Jenis Pihak';
						}
						if(empty($nama)){
							$isLengkap = 0;
							$notFill ='Nama';
						}
						if(empty($tempatLahir)){
							$isLengkap = 0;
							$notFill ='Tempat Lahir';
						}
						if(empty($tglLahir)){
							$isLengkap = 0;
							$notFill ='Tanggal Lahir';
						}
						if(empty($sex)){
							$isLengkap = 0;
							$notFill ='Jenis Kelamin';
						}
						if(empty($wargaNegara)){
							$isLengkap = 0;
							$notFill ='Warga Negara';
						}
						if(empty($alamat)){
							$isLengkap = 0;
							$notFill ='Alamat';
						}
						if(empty($pekerjaan)){
							$isLengkap = 0;
							$notFill ='Pekerjaan';
						}
						
						echo json_encode(array(
							'st'=>1,
							'isLengkap'=>$isLengkap,
							'notFill'=>$notFill,
							'enc_jaksa'=>$id,
							'nama'=>$nama,
							'tempatLahir'=>$tempatLahir,
							'tglLahir'=>$this->tanggalhelper->convertToInputDate($tglLahir),
							'umur'=>$umur,
							'sex'=>$sex,
							'IDSex'=>$IDSex,
							'pekerjaan'=>$pekerjaan,
							'kawin'=>$kawin,
							'statusKawin'=>$kawin,
							'IDStatusKawin'=>$IDStatusKawin,
							'pendidikan'=>$pendidikan,
							'IDPendidikan'=>$IDPendidikan,
							'keterangan'=>$keterangan,
							'jenisIdentitas'=>$jenisIdentitas,
							'noIdentitas'=>$noIdentitas,
							'agama'=>$agama,
							'IDAgama'=>$IDAgama,
							'wargaNegara'=>$wargaNegara,
							'IDWargaNegara'=>$IDWargaNegara,
							'alamat'=>$alamat,
							'golDarah'=>$golDarah,
							'enc_act' =>base64_encode($this->encrypt->encode('add')),
							'no_induk'=>$no_induk,
							'nama_kejaksaan'=>$nama_kejaksaan,
							'alamat_kantor'=>$alamat_kantor,
							'pangkat'=>$pangkat,
							'jabatan'=>$jabatan,
							'kesatuan'=>$kesatuan,
							));
						return;
					}
				}else{
					echo json_encode(array('st'=>0,'msg'=>'Error, Data Tidak Ditemukan.'));
					return;
				}				
			}
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error, Please Refresh Your Page'));
			return;
		}
	}

	function validateInput(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')===FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		$nama = trim($this->input->post('jaksa_fullname',TRUE));
		$_POST['jaksa_fullname'] = str_replace(' ', '', $_POST['jaksa_fullname']);

		$tempatLahir = trim($this->input->post('jaksa_tempat_lahir',TRUE));
		$_POST['jaksatempat_lahir'] = str_replace(' ', '', $_POST['jaksa_tempat_lahir']);

		$nama_kejaksaan = trim($this->input->post('nama_kejaksaan',TRUE));
		$_POST['nama_kejaksaan'] = str_replace(' ', '', $_POST['nama_kejaksaan']);

		if($this->session->userdata('jenis_pengadilan')==2){
			$pangkat = trim($this->input->post('pangkat',TRUE));
			$_POST['pangkat'] = str_replace(' ', '', $_POST['pangkat']);

			$jabatan = trim($this->input->post('jabatan',TRUE));
			$_POST['jabatan'] = str_replace(' ', '', $_POST['jabatan']);

			$kesatuan = trim($this->input->post('kesatuan',TRUE));
			$_POST['kesatuan'] = str_replace(' ', '', $_POST['kesatuan']);
		}

		$this->form_validation->set_rules('jaksa_fullname', 'Nama Lengkap', 'trim|required|xss_clean|valid_naming');
		if($this->session->userdata('jenis_pengadilan')==2){
			$this->form_validation->set_rules('pangkat', 'Pangkat', 'trim|required|min_length[5]|xss_clean');
			$this->form_validation->set_rules('jabatan', 'Jabatan', 'trim|required|min_length[5]|xss_clean');
			$this->form_validation->set_rules('kesatuan', 'Kesatuan', 'trim|required|min_length[5]|xss_clean');
		}
		$this->form_validation->set_rules('jaksa_tempat_lahir', 'Tempat Lahir', 'trim|required|alpha|min_length[2]|xss_clean');
		$this->form_validation->set_rules('jaksa_tgl_lahir', 'Tanggal Lahir', 'trim|required|exact_length[10]|xss_clean');
		$this->form_validation->set_rules('jaksa_umur', 'Umur Pihak', 'trim|numeric|xss_clean');
		$this->form_validation->set_rules('jaksa_jenis_identitas', 'Jenis Identitas', 'trim|numeric|xss_clean');
		$this->form_validation->set_rules('jaksa_no_identitas', 'No Identitas', 'trim|xss_clean');
		$this->form_validation->set_rules('jaksa_jenis_kelamin', 'Jenis Kelamin', 'trim|required|numeric|xss_clean');
		$this->form_validation->set_rules('jaksa_agama', 'Agama', 'trim|required|numeric|xss_clean');
		$this->form_validation->set_rules('jaksa_warga_negara', 'Warga Negara', 'trim|required|numeric|xss_clean');
		$this->form_validation->set_rules('jaksa_alamat', 'Alamat', 'trim|required|min_length[15]|xss_clean');
		#$this->form_validation->set_rules('jaksa_pekerjaan', 'Pekerjaan', 'trim|required|min_length[5]|xss_clean');
		$this->form_validation->set_rules('jaksa_status_kawin', 'Status Kawin', 'trim|required|numeric|xss_clean');
		$this->form_validation->set_rules('jaksa_pendidikan', 'Tingkat Pendidikan', 'trim|required|numeric|xss_clean');
		$this->form_validation->set_rules('jaksa_keterangan', 'jaksa_keterangan', 'trim|xss_clean');
		$this->form_validation->set_rules('jaksa_email', 'Alamat Email', 'trim|valid_email|xss_clean');
		$this->form_validation->set_rules('jaksa_no_tlp', 'No Telepon', 'trim|numeric|min_length[5]|xss_clean');
		if($this->session->userdata('jenis_pengadilan')==2){$kantor="Otmil";}else{$kantor="Kantor";}
		$this->form_validation->set_rules('jaksa_alamat_kantor', 'Alamat '.$kantor, 'trim|required|min_length[15]|xss_clean');
		$this->form_validation->set_rules('nama_kejaksaan', 'Nama '.$kantor, 'trim|required|min_length[15]|xss_clean');
	
		$act = $this->input->post('act',TRUE);
		$no_induk = $this->input->post('jaksa_no_induk',TRUE);
		if($act=='add'){
			$this->form_validation->set_rules('jaksa_no_induk', 'NIP Jaksa', 'trim|required|xss_clean|min_length[5]|is_unique[pihak_jaksa.NIP]');
		}else{
			$this->form_validation->set_rules('jaksa_no_induk', 'NIP Jaksa', 'trim|required|xss_clean|min_length[5]');
		}
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$jenisPihak = $this->input->post('jaksa_jenis_pihak',TRUE);
			if($jenisPihak<1 AND $jenisPihak>3){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Jenis Pihak Tidak Diketahui.'));
				return;
			}

			$sex = $this->input->post('jaksa_jenis_kelamin',TRUE);
			if($sex<1 AND $sex>3){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Jenis Kelamin Tidak Diketahui.'));
				return;
			}

			if($sex==1){
				$sex='L';
			}elseif ($sex==2) {
				$sex='P';
			}

			$agama = $this->input->post('jaksa_agama',TRUE);
			if($agama<1 AND $agama>7){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Agama Tidak Diketahui.'));
				return;
			}

			$statusKawin = $this->input->post('jaksa_status_kawin',TRUE);
			if($statusKawin<1 AND $statusKawin>4){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Status Kawin Tidak Diketahui.'));
				return;
			}

			$pendidikan = $this->input->post('jaksa_pendidikan',TRUE);
			if($pendidikan<1 AND $pendidikan>11){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tingkat Pendidikan Tidak Diketahui.'));
				return;
			}

			$tglLahir = $this->tanggalhelper->convertToMysqlDate($this->input->post('jaksa_tgl_lahir',TRUE));
			$umur=$this->input->post('jaksa_umur',TRUE);
			if($umur>100 OR $umur<5){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Periksa Kembali Umur Pihak.'.$umur));
				return;
			}
			$curr_date = date('Y-m-d');
			$selisih = $this->tanggalhelper->getSelisihHari($tglLahir,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Periksa Kembali Tanggal Lahir.'));
				return;
			}

			$data_jaksa = array(
				'nama' => $nama,
				'jenis_pihak_id' => 1,
				'jenis_indentitas' => $this->input->post('jaksa_jenis_identitas',TRUE),
				'nomor_indentitas' => $this->input->post('jaksa_no_identitas',TRUE),
				'tempat_lahir' => $tempatLahir,
				'tanggal_lahir' => $tglLahir,
				'jenis_kelamin' => $sex,
				'golongan_darah' => $this->input->post('jaksa_gol_darah',TRUE),
				'alamat' => trim($this->input->post('jaksa_alamat',TRUE)),
				'agama_id' => $agama,
				'status_kawin' => $statusKawin,
				'pekerjaan' => ($this->session->userdata('jenis_pengadilan')==2)? 'Oditur':'Jaksa',
				'pendidikan_id' => $pendidikan,
				'telepon' => trim($this->input->post('jaksa_no_tlp',TRUE)),
				'email' => trim($this->input->post('jaksa_email',TRUE)),
				'keterangan' => trim($this->input->post('jaksa_keterangan',TRUE)),
				'warga_negara_id' => $this->input->post('jaksa_warga_negara',TRUE)
			);
			$data = array(
				'nip' => $this->input->post('jaksa_no_induk',TRUE),
				'alamat_kantor' => $this->input->post('jaksa_alamat_kantor',TRUE),
				'kejaksaan' => $nama_kejaksaan,				
			);
			if($this->session->userdata('jenis_pengadilan')==2){
				$data ['pangkat'] = $pangkat;
				$data ['jabatan'] = $jabatan;
				$data ['kesatuan'] = $kesatuan;
			}
			if($act==="add"){
				$data_jaksa['diinput_oleh'] = $this->session->userdata('username');
				$data_jaksa['diinput_tanggal'] = date("Y-m-d h:i:s",time());
				$this->load->model('jaksa/list_jaksa', 'jaksa');
				$query = $this->jaksa->add_data($data_jaksa,$data);
				if($query==TRUE){
					echo json_encode(array('st'=>1,'msg'=>'Berhasil<br /> Data Berhasil Disimpan.'));
					return;
				}else{
					echo json_encode(array('st'=>0,'msg'=>'Error<br /> Coba Ulangi Kembali. Error Code 198'));
					return;
				}
			}elseif ($act==="updt") {
				$idPihak = $this->encrypt->decode(base64_decode($this->input->post('jaksa_id',TRUE)));
				if(!is_numeric($idPihak) OR empty($idPihak)){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> System Error, Please refresh your browser.Error Code 199'));
				}else{
					$data_jaksa['diperbaharui_oleh'] = $this->session->userdata('username');
					$data_jaksa['diperbaharui_tanggal'] = date("Y-m-d h:i:s",time());
					$this->load->model('jaksa/list_jaksa', 'jaksa');
					$query = $this->jaksa->update_data($data_jaksa,$idPihak,$data);
					if($query==TRUE){
						echo json_encode(array('st'=>1,'msg'=>'Berhasil<br /> Data Berhasil Disimpan.'));
						return;
					}else{
						echo json_encode(array('st'=>0,'msg'=>'Error<br /> Coba Ulangi Kembali. Error Code 198'));
						return;
					}
				}
			}else{
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> System Error, Please refresh your browser.Error Code 199'.$act));
			}
		}
	}

	function setPage(){
		if(empty($_POST)){
			show_404();
		}
		$pageNumber = $this->input->post('pageNumber',TRUE);
		$keyword = $this->input->post('keyword',TRUE);
		if(is_numeric($pageNumber) AND $pageNumber>0){
			$this->nativesession->set_flash_session('security', TRUE);
			$this->nativesession->set_flash_session('pageNumber_pihak', $pageNumber);
			$this->nativesession->set_flash_session('keyword_pihak', $keyword);
			echo json_encode(array('st'=>1));
		}else{
			show_404();
		}
	}

	function searchPage(){
		if(empty($_POST)){
			show_404();
		}
		$keyword = $this->input->post('keyword_jaksa',TRUE);
		$column = $this->input->post('search_field',TRUE);
		$this->nativesession->set_flash_session('security', TRUE);
		$this->nativesession->set_flash_session('keyword_pihak', $keyword);
		$this->nativesession->set_flash_session('column', $column);
		echo json_encode(array('st'=>1));
	}
}