<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Jadwal_Diversi_c extends CI_Controller {

	function edit(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}

		$data['curr_date'] = date('d/m/Y');

		$data['enc']=$this->nativesession->get_flash_session('enc');
		$data['encdiversi']=$this->nativesession->get_flash_session('encdiversi');
		$data['encjadwaldiversi']=$this->nativesession->get_flash_session('encjadwaldiversi');

		$idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }

		$iddiversi=$this->encrypt->decode(base64_decode($data['encdiversi']));
        if(!is_numeric($iddiversi) OR !intval($iddiversi)>0){
            show_404();
            exit();
        }

		$idjadwaldiversi=$this->encrypt->decode(base64_decode($data['encjadwaldiversi']));
        if(!is_numeric($idjadwaldiversi) OR !intval($idjadwaldiversi)>0){
            show_404();
            exit();
        }

		$this->load->model('diversi/jadwal_diversi_m');
		if ($query=$this->jadwal_diversi_m->get_detil_jadwal_diversi($idjadwaldiversi)){
			$data['detjdiversi']=$query;
		}

		if ($query=$this->jadwal_diversi_m->get_jadwal_diversi_sebelum($iddiversi)){
			$data['detjdiversisblm']=$query;
		}

		$data['namahalaman']="EDIT DATA JADWAL MUSYAWARAH DIVERSI";
		$this->load->view('perkara_tab/diversi/jadwal_diversi_p_edit',$data);
	}

	function tunda(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}

		$data['curr_date'] = date('d/m/Y');

		$data['enc']=$this->nativesession->get_flash_session('enc');
		$data['encdiversi']=$this->nativesession->get_flash_session('encdiversi');
		$data['encjadwaldiversi']=$this->nativesession->get_flash_session('encjadwaldiversi');
		
		$idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }

		$iddiversi=$this->encrypt->decode(base64_decode($data['encdiversi']));
        if(!is_numeric($iddiversi) OR !intval($iddiversi)>0){
            show_404();
            exit();
        }

		$idjadwaldiversi=$this->encrypt->decode(base64_decode($data['encjadwaldiversi']));
        if(!is_numeric($idjadwaldiversi) OR !intval($idjadwaldiversi)>0){
            show_404();
            exit();
        }

		$this->load->model('diversi/jadwal_diversi_m');
		if ($query=$this->jadwal_diversi_m->get_detil_jadwal_diversi($idjadwaldiversi)){
			$data['detjdiversi']=$query;
		}
		$data['namahalaman']="DATA PENUNDAAN JADWAL MUSYAWARAH DIVERSI";
		$this->load->view('perkara_tab/diversi/jadwal_diversi_p_tunda',$data);
	}


	function validateEdit(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		
		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc')));
		$iddiversi = $this->encrypt->decode(base64_decode($this->input->post('encdiversi')));
		$idjadwaldiversi = $this->encrypt->decode(base64_decode($this->input->post('encjadwaldiversi')));

		if(!is_numeric($idperkara) OR !intval($idperkara)>0){
			echo json_encode(array('st'=>0,'msg'=>'Data Perkara Tidak Ditemukan.'));
			return;
		}
		if(!is_numeric($iddiversi) OR !intval($iddiversi)>0){
			echo json_encode(array('st'=>0,'msg'=>'Data Diversi Tidak Ditemukan.'));
			return;
		}
		if(!is_numeric($idjadwaldiversi) OR !intval($idjadwaldiversi)>0){
			echo json_encode(array('st'=>0,'msg'=>'Data Jadwal Musyawarah Diversi Tidak Ditemukan.'));
			return;
		}
		
		$this->form_validation->set_rules('tempat', 'Tempat Pelaksanaan Diversi', 'required|trim|xss_clean|max_length[500]|min_length[1]');
		$this->form_validation->set_rules('jammulai', 'Jam Mulai Musyawarah Diversi', 'required|trim|xss_clean|max_length[5]|min_length[5]');
		$this->form_validation->set_rules('jamselesai', 'Jam Selesai Musyawarah Diversi', 'required|trim|xss_clean|max_length[5]|min_length[5]');

		if ($this->form_validation->run() == FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{

			$tanggal_musyawarah=$this->input->post('tgl_musyawarah',TRUE); 
			$tanggal_musyawarah=$this->tanggalhelper->convertToMysqlDate($tanggal_musyawarah);
			$tanggal_diversi_sebelum=$this->input->post('tgljadwaldiversisblm',TRUE); 

			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			$selisih = $this->tanggalhelper->getSelisihHari($tanggal_diversi_sebelum,$tanggal_musyawarah);
			if($selisih<=0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Sebelum Atau Tepat Pada Tanggal Musyawarah Diversi Sebelumnya'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tanggal_musyawarah,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Musyawarah Diversi Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}

			if($tanggal_musyawarah==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tanggal_musyawarah);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Musyawarah Diversi Pada Hari Libur, Sabtu dan Minggu.'));
				exit();
			}

			$dihadiri_oleh = $this->input->post('dihadiri_oleh',TRUE);
			$data_ruangan = $this->input->post('tempat',TRUE);

			$data=array(
				'tanggal_musyawarah'=>$tanggal_musyawarah,
				'jam_musyawarah'=>$this->input->post('jammulai',TRUE),				
				'sampai_jam'=>$this->input->post('jamselesai',TRUE),
				'tempat'=>$data_ruangan,
				'dihadiri_oleh'=>$dihadiri_oleh,
				'diperbaharui_oleh' => $this->session->userdata('username'),
				'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
				);

			$namahalaman = $this->input->post('namahalaman',TRUE);
			$this->load->model('diversi/jadwal_diversi_m');
			$this->jadwal_diversi_m->update_jadwal_diversi($idjadwaldiversi,$data,$iddiversi,$namahalaman);
			echo json_encode(array('st'=>1,'msg'=>'Perubahan Data Musyawarah Diversi Berhasil'));
			return;
		}
	}

	function validateTunda(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc')));
		$iddiversi = $this->encrypt->decode(base64_decode($this->input->post('encdiversi')));
		$idjadwaldiversi = $this->encrypt->decode(base64_decode($this->input->post('encjadwaldiversi')));

		if(!is_numeric($idperkara) OR !intval($idperkara)>0){
			echo json_encode(array('st'=>0,'msg'=>'Data Perkara Tidak Ditemukan.'));
			return;
		}
		if(!is_numeric($iddiversi) OR !intval($iddiversi)>0){
			echo json_encode(array('st'=>0,'msg'=>'Data Diversi Tidak Ditemukan.'));
			return;
		}
		if(!is_numeric($idjadwaldiversi) OR !intval($idjadwaldiversi)>0){
			echo json_encode(array('st'=>0,'msg'=>'Data Jadwal Musyawarah Diversi Tidak Ditemukan.'));
			return;
		}

		$this->form_validation->set_rules('tgl_musyawarah', 'Tanggal Musyawarah Diversi', 'required|trim|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('tempat', 'Tempat Pelaksanaan Musyawarah Diversi', 'required|trim|xss_clean|max_length[500]|min_length[1]');
		if ($this->form_validation->run() == FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$tanggalsebelum=$this->input->post('tgldiversisblm',TRUE);
			$tanggaldipilih=$this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_musyawarah',TRUE));
			if($tanggaldipilih==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Musyawarah Diversi Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			$selisih = $this->tanggalhelper->getSelisihHari($tanggalsebelum,$tanggaldipilih);
			if($selisih<=0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Sebelum Atau Tepat Pada Tanggal Musyawarah Diversi Sebelumnya.'));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tanggaldipilih);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Musyawarah Diversi Pada Hari Libur, Sabtu dan Minggu.'));
				return;
			}

			$this->load->model('diversi/jadwal_diversi_m');

			$urutanmaxid=$this->jadwal_diversi_m->get_urutan_jadwal_diversi_terakhir($iddiversi);
			$urutanBaru =  $urutanmaxid->row()->urutan + 1;
			$idmax = $this->jadwal_diversi_m->get_id_jadwal_diversi_terakhir();
			$idjadwalberikutnya=$idmax->row()->id + 1;
			
			$data_ruangan_sebelumnya=$this->input->post('tempatsblm',TRUE);
			$data_ruangan=$this->input->post('tempat',TRUE);

			$data_update = array(
				'tempat'=>$data_ruangan_sebelumnya,
				'ditunda'=>'Y',
				'diperbaharui_oleh' => $this->session->userdata('username'),
				'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
			);

			$data_insert = array(
				'id'=>$idjadwalberikutnya,
				'diversi_id'=>$iddiversi,
				'urutan'=>$urutanBaru,
				'tanggal_musyawarah'=>$tanggaldipilih,
				'tempat'=>$data_ruangan,
				'diinput_oleh' => $this->session->userdata('username'),
				'diinput_tanggal' => date("Y-m-d h:i:s",time())
			);

			$namahalaman = $this->input->post('namahalaman',TRUE);
			$this->jadwal_diversi_m->tunda_diversi($data_insert,$data_update,$iddiversi,$idjadwaldiversi,$namahalaman);

			echo json_encode(array('st'=>1,'msg'=>'Pengisian Data Tundaan Musyawarah Diversi Berhasil'));
			return;
		}
	}

	function hapus_jadwal_diversi(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc')));
		if(!is_numeric($idperkara) OR !intval($idperkara)>0){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$idjadwaldiversi = $this->encrypt->decode(base64_decode($this->input->post('encjadwaldiversi')));
		if(!is_numeric($idjadwaldiversi) OR !intval($idjadwaldiversi)>0){
			echo json_encode(array('st'=>0,'msg'=>'Jadwal Musyawarah Diversi Tidak Ditemukan.'));
			return;
		}
		
		$this->load->model('diversi/jadwal_diversi_m');
		$namahalaman = $this->input->post('namahalaman',TRUE);
		if($this->jadwal_diversi_m->hapus_jadwal_diversi($idjadwaldiversi,$namahalaman)){

			echo json_encode(array('st'=>1,'msg'=>'Penghapusan Data Jadwal Musyawarah Diversi Berhasil'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'));
			return;
		}
	}

}