<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Edit_profile extends CI_Controller {
	function index(){
		#make sure that only admin level that can open the page
		/*if($this->session->userdata('idgroup')>2){
			redirect('login');
		}*/
		
		
		$enc = $this->uri->segment(2);
		$userid = $this->session->userdata('userid');
		if(is_numeric($userid)){
			$this->showPage($userid,$enc);
		}else{
			redirect('login');
		}
	}
 
	function showPage($userid,$enc){
		$this->load->model('users/users');
		$data['page_title'] = 'EDIT USER PROFILE ';
		$data['main_body'] = 'users/user_edit_profile';
		$data['enc'] = $enc;
		$data['page_url'] = 'user_update';
		$data['user_info'] ='';
		if(!empty($userid)){
			$data['user_info'] = $this->users->get_user_info($userid);
			$data['userid'] = $userid;
		}
		$data['history'] = current_url();

		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body_edit');
	}

	function validate_input(){
		if(empty($_POST)){
			show_404();
		}
		
		$this->form_validation->set_rules('fullname', 'Nama Lengkap', 'trim|required|xss_clean');
		$this->form_validation->set_rules('password', 'Password', 'trim|required|matches[password_repeat]|xss_clean');
		$this->form_validation->set_rules('password_repeat', 'Password', 'trim|required|xss_clean');
		$this->form_validation->set_rules('email', 'Email', 'trim|required|valid_email');


		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
		}else{
			$code_activation = md5(uniqid());
			$password = $this->arr2md5(array($code_activation,$this->input->post('password',TRUE)));
			$activation = $this->arr2md5(array($this->input->post('fullname',TRUE), $this->input->post('username',TRUE), $this->input->post('email',TRUE)));
			$data_users = array(
				'fullname' => $this->input->post('fullname',TRUE),
				'password' => $password,
				'email' => $this->input->post('email',TRUE),
				'activation' => $activation,
				'code_activation' => $code_activation,
				'alternative_email' => $this->input->post('alter_email',TRUE)
			);

			if($this->input->post('act',TRUE)=='updt'){
				$data_users['modified_by'] = $this->session->userdata('username');
				$data_users['modified_on'] = date("Y-m-d h:i:s",time());
				$userid = $this->session->userdata('userid');
				$this->load->model('users/users');
				$this->users->update_profile($data_users,$userid);
				echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Invalid Task'));
			}
		}
	}

	function arr2md5($arrinput){
        $hasil='';
        foreach($arrinput as $val){
        	if($hasil==''){
        		$hasil=md5($val);
        	}else {
        		$code=md5($val);
        		for($hit=0;$hit<min(array(strlen($code),strlen($hasil)));$hit++){
        			$hasil[$hit]=chr(ord($hasil[$hit]) ^ ord($code[$hit]));
        		}
        	}
        }
        return(md5($hasil));
    }
}