<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Detil_register_diversi extends CI_Controller {
	function index($id_diversi=null,$act=null){
		
		if($this->nativesession->get_flash_session('security')===FALSE){
			redirect('main');
		}
		if($this->session->userdata('is_logged_in')===FALSE){
			redirect('login');
		}

		$this->show_data($id_diversi,$act);
	}
	function show_data($id_diversi,$act){
		$diversi_id = $this->encrypt->decode(base64_decode($id_diversi));
		$data['page_title'] = 'DETIL REGISTER DIVERSI ';
		$data['main_body'] = 'diversi/detil_register_diversi_v';
		$data['main_history'] =  base_url().'manage_register_diversi';
		$data['previous'] = $this->nativesession->get_flash_session('url_requested');
		$data['tgl_sekarang'] = date('d/m/Y');
		$this->load->model('diversi/register_diversi','register_diversi');		
		$data['diversi_id'] = $diversi_id;
		$data['enc_diversi_id'] = $id_diversi;
		$detil_diversi    = $this->register_diversi->get_detil_diversi($diversi_id);
		if($detil_diversi->num_rows()>0){
			foreach ($detil_diversi->result() as $row) {
				$data['no_urut'] = $row->no_urut;
				$data['tgl_diterima_permohonan'] = $row->tgl_permohonan_diversi;
				$data['no_diversi'] = $row->no_diversi;
				$data['pemohon_diversi'] = $row->pemohon_diversi;
				$data['no_reg_penyidik'] = $row->no_reg_penyidik;
				$data['no_reg_penuntut'] = $row->no_reg_penuntut_umum;
				$data['no_perkara'] 	 = $row->no_perkara;
				$data['perkara_id']      = $row->perkara_id;
				$data['no_berita_acara'] = $row->no_berita_acara;
				$data['tgl_berita_acara'] = $row->tgl_berita_acara;
				$data['pasal_sangkaan_dakwaan'] = $row->pasal_sangkaan_dakwaan;
				$data['tgl_kesepakatan_diversi'] = $row->tgl_kesepakatan_diversi;
				$data['isi_kesepakatan_diversi'] = $row->isi_kesepakatan_diversi;
				$data['tanggal_penetapan_kpn'] = $row->tanggal_penetapan_kpn;
				$data['tgl_pengiriman_penetapan_kpn'] = $row->tgl_pengiriman_penetapan_kpn;
				$data['amar'] = $row->amar;
				$data['tgl_pelaksanaan_isi_diversi'] = $row->tgl_pelaksanaan_isi_diversi;

			}
		}
		
		if($data['pemohon_diversi']==3){
			$iddiversi = $data['perkara_id'];
		}else{
			$iddiversi = $diversi_id;
		}
		#hakim
		$data['pihak_penuntut_hakim'] = $this->register_diversi->pihak_penuntut_hakim($iddiversi);
		$data['pihak_anak_hakim'] = $this->register_diversi->pihak_anak_orang_tua_hakim($iddiversi);
		$data['pihak_korban_hakim'] = $this->register_diversi->pihak_korban_orang_tua_hakim($iddiversi);
		$data['pihak_penasihat_hukum_hakim'] = $this->register_diversi->pihak_penasihat_hukum_hakim($iddiversi);
		$data['pihak_pkbapas_hakim'] = $this->register_diversi->pihak_pkbapas_hakim($iddiversi);
		$ba_hakim = $this->register_diversi->berita_acara_hakim($iddiversi);
		foreach ($ba_hakim->result() as $row) {
			$data['no_berita_acara'] = $row->nomor_perkara;
			$data['tgl_berita_acara'] = $row->tanggal_musyawarah;
		}

		$data['pihak_anak'] = $this->register_diversi->pihak_anak_orang_tua($iddiversi);
		$data['pihak_korban'] = $this->register_diversi->pihak_korban_orang_tua($iddiversi);
		$data['pihak_penuntut'] = $this->register_diversi->pihak_penuntut($iddiversi);
		$data['pihak_penyidik'] = $this->register_diversi->pihak_penyidik($iddiversi);
		$data['pihak_penasihat_hukum'] = $this->register_diversi->pihak_penasihat_hukum($iddiversi);
		$data['pihak_pkbapas'] = $this->register_diversi->pihak_pkbapas($iddiversi);

		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body_new');
	}

	function get_nomor_perkara_diversi(){
		$manual = $this->input->post('val',true);
		if($manual==1){
			$this->load->model('diversi/register_diversi','register_diversi');
			$no_urut_diversi   = $this->register_diversi->get_last_nomor_diversi()+1;
			$format_no_diversi = '/Pen.Div/'.date(Y).'/PN '.$this->register_diversi->getKodePN(); 
			$new_no_diversi    = $no_urut_diversi.$format_no_diversi;
			if(!empty($no_urut_diversi)){
				echo json_encode(array('st'=>1,'no_urut_diversi'=>$no_urut_diversi,'new_no_diversi'=>$new_no_diversi));
				return;
			}			
		}else{
			return;
		}
	}

	function get_info_perkara_sppa(){
		$no_perkara = $this->input->post('no_perkara',true);
		if(!empty($no_perkara)){
			$this->load->model('diversi/register_diversi','register_diversi');
			$info_perkara_sppa   = $this->register_diversi->get_info_sppa($no_perkara);
			if($info_perkara_sppa->num_rows>0){
				foreach ($info_perkara_sppa->result() as $row) {
					$perkara_id 		= $row->perkara_id;
					$tgl_pendaftaran 	= $row->tanggal_pendaftaran;
					$nama_anak 			= $row->nama_anak;
					$jenis_perkara 		= $row->jenis_perkara_nama;
					$tahapan_terakhir 	= $row->tahapan_terakhir_text;
				}
			
				$info_sppa = "<div id='info_perkara'>Tanggal Pendaftaran : ".$this->tanggalhelper->convertDate($tgl_pendaftaran)."<br>
							  Nama Anak        : ".$nama_anak."<br>
							  Jenis perkara    : ".$jenis_perkara."<br>
							  Tahapan Terakhir : ".$tahapan_terakhir."</div>"; 
			}else{
				$info_sppa = "<div id='info_perkara'><font color='red'>Cek kembali nomor perkara ini, data tidak ditemukan</font></div>";
			}
			echo json_encode(array('st'=>1,'perkara_id'=>$perkara_id,'info_sppa'=>$info_sppa));
			return;

		}else{
			echo json_encode(array('st'=>0,'msg'=>'Isi dulu kolom nomor perkara..!'));
			return;
		}
	}

	function auto_complete($keyword){
		$data = $this->db->query('select perkara_id,nomor_perkara from perkara where alur_perkara_id = 118 AND nomor_perkara like \''.$keyword.'%\' limit 20');
		foreach($data->result() as $row)
		{
			$arr['query'] = $keyword;
			$arr['suggestions'][] = array(
				'value'	=>$row->nomor_perkara
			);
		}
		// minimal PHP 5.2
		echo json_encode($arr);
	}	
	function validateInput(){
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		if(empty($_POST)){
			show_404();
		}

		$this->load->model('diversi/register_diversi','register_diversi');
		$tgl_diterima_permohonan 	= $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_diterima_permohonan',TRUE));
		$no_urut_diversi 	= $this->input->post('no_urut_diversi',TRUE);
		$no_diversi 		= $this->input->post('no_diversi',TRUE);
		$dimohononkan_oleh	= $this->input->post('dimohonkan_oleh',TRUE);
		$tahun_nomor 		= substr($tgl_diterima_permohonan, 0,4);
		if($dimohononkan_oleh==1){
			$no_reg_penyidik 	= $this->input->post('no_reg_penyidik',true);			
			$no_reg_penuntut 	= null;
			$no_perkara 		= null;
			$perkara_id 		= null;
		}else if($dimohononkan_oleh==2){
			$no_reg_penyidik 	= null;
			$no_reg_penuntut 	= $this->input->post('no_reg_penuntut',true);			
			$no_perkara 		= null;
			$perkara_id 		= null;		
		}else if($dimohononkan_oleh==3){
			$no_perkara 		= $this->input->post('no_perkara',true);
			$perkara_id = $this->input->post('perkara_id',true);
			$no_reg_penyidik 	= null;
			$no_reg_penuntut 	= null;						
		}

		$cek_diversi=$this->register_diversi->cek_no_diversi($no_diversi,$tahun_nomor);
		$cek_no_urut=$this->register_diversi->cek_no_urut_diversi($no_urut_diversi,$tahun_nomor);
		if($cek_diversi==1){
			echo json_encode(array('st'=>0,'msg'=>'Nomor Diversi sudah ada dalam register'));
			return;
		}
		if($cek_no_urut==1){
			echo json_encode(array('st'=>0,'msg'=>'Nomor Urut Diversi sudah ada dalam register'));
			return;
		}
		
		$this->form_validation->set_rules('no_diversi', 'Nomer Diversi', 'trim|required|xss_clean');
		$this->form_validation->set_rules('tgl_diterima_permohonan', 'Tanggal Diterima Permohonan', 'trim|required|xss_clean|exact_length[10]');

		$curr_date = date('Y-m-d');
		$id_diversi = $this->register_diversi->last_id_diversi();
	
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
		}else{
				$data = array(
						'id' => $id_diversi,
						'no_urut' => $no_urut_diversi,
						'no_diversi' => $no_diversi,
						'tgl_permohonan_diversi' => $tgl_diterima_permohonan,
						'pemohon_diversi' => $dimohononkan_oleh,
						'no_reg_penyidik' => $no_reg_penyidik,
						'no_reg_penuntut_umum' => $no_reg_penuntut,
						'no_perkara' => $no_perkara,
						'perkara_id' => $perkara_id,
						'diinput_oleh' => $this->session->userdata('username'),
						'diinput_tanggal' => date("Y-m-d h:i:s",time())
					);			

			$result = $this->register_diversi->add_diversi($data);

			if($result===FALSE){
				echo json_encode(array('st'=>0,'msg'=>'GAGAL Menyimpan'));
				return;
			}else{
				echo json_encode(array('st'=>1,'msg'=>'Berhasil Menyimpan'));
				return;
			}
		}
	}

	function validateInputEdit(){
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		if(empty($_POST)){
			show_404();
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('idperkara',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$idalurperkara = $this->encrypt->decode(base64_decode($this->input->post('alurperkaraid',TRUE)));
		if(!is_numeric($idalurperkara) OR intval($idalurperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Something Bad Happened, Please Refresh Your Browser.'));
			return;
		}


		$this->form_validation->set_rules('nomor_perkara_pn', 'Nomor Perkara PN', 'trim|required|xss_clean');
		$this->form_validation->set_rules('tgl_putusan_pn', 'Tanggal Putusan PN', 'trim|required|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('nomor_perkara_banding', 'Nomor Perkara Banding', 'trim|xss_clean');
		$this->form_validation->set_rules('tgl_putusan_banding', 'Tanggal Putusan Banding', 'trim|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('nomor_perkara_kasasi', 'Nomor Perkara Kasasi', 'trim|xss_clean');
		$this->form_validation->set_rules('tgl_putusan_kasasi', 'Tanggal Putusan kasasi', 'trim|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('nomor_perkara_pk', 'Nomor Perkara PK', 'trim|xss_clean');
		$this->form_validation->set_rules('tgl_putusan_pk', 'Tanggal Putusan PK', 'trim|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('listdataput', 'Putusan Eksekusi', 'trim|required|xss_clean');		
		$this->form_validation->set_rules('no_perkara_mhn_eksekusi', 'Nomor Perkara di Mohonkan Eksekusi', 'trim|required|xss_clean');				
		
		$this->form_validation->set_rules('tgl_permohonan_eksekusi', 'Tanggal Permohonan Eksekusi', 'trim|required|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('nama_pemohon', 'Nama Pemohon Eksekusi', 'trim|required|xss_clean');		
		$this->form_validation->set_rules('tgl_surat_kuasa', 'Tanggal Surat Kuasa', 'trim|xss_clean');		
		$this->form_validation->set_rules('no_surat_kuasa', 'Nomor Surat Kuasa', 'trim|xss_clean');		

		$pihak_penggugat = $this->input->post('penggugat',TRUE);
		$pihak_tergugat = $this->input->post('tergugat',TRUE);

		if(($pihak_penggugat==0 || $pihak_penggugat=='') && ($pihak_tergugat==0 || $pihak_tergugat=='') ){
			echo json_encode(array('st'=>0,'msg'=>'Pihak belum ada yang dipilih.'));
			return;
		}

		$tgl_putusan_pn = $this->tanggalhelper->getTanggalPutusan($idperkara);
		if(empty($tgl_putusan_pn)){
			echo json_encode(array('st'=>0,'msg'=>'Tidak Dapat Mendaftarkan Permohonan Eksekusi. Perkara Belum Dinyatakan Putus.'));
			return;
		}

		$curr_date = date('Y-m-d');
		$todayDate = date('d/m/Y');
		$tgl_permohonan_eksekusi = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_permohonan_eksekusi',TRUE));
			
		if($tgl_permohonan_eksekusi==false){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
			return;
		}

		$selisih = $this->tanggalhelper->getSelisihHari($tgl_permohonan_eksekusi,$curr_date);
		if($selisih<0){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Permohonan Eksekusi Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
			return;
		}

		$dayname = $this->tanggalhelper->getDayName($tgl_permohonan_eksekusi);
		if($dayname=='Saturday' OR $dayname=='Sunday'){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Permohonan Eksekusi Dihari Libur, Sabtu dan Minggu.'));
			return;
		}

		$selisih = $this->tanggalhelper->getSelisihHari($tgl_putusan_pn,$tgl_permohonan_eksekusi);
		if($selisih<0){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Permohonan Eksekusi Tidak Boleh Kurang Dari Tanggal Putusan PN'));
			return;
		}

		$tgl_putusan_banding = $this->input->post('tgl_putusan_banding',TRUE);
		if(!empty($tgl_putusan_banding)){
			$tgl_putusan_banding = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_putusan_banding',TRUE));
			if($tgl_putusan_banding==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tgl_putusan_banding,$tgl_permohonan_eksekusi);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Permohonan Eksekusi Tidak Boleh Kurang Dari Tanggal Putusan Banding'));
				return;
			}
		}

		$tgl_putusan_kasasi = $this->input->post('tgl_putusan_kasasi',TRUE);
		if(!empty($tgl_putusan_kasasi)){
			$tgl_putusan_kasasi = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_putusan_kasasi',TRUE));
			if($tgl_putusan_kasasi==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tgl_putusan_kasasi,$tgl_permohonan_eksekusi);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Permohonan Eksekusi Tidak Boleh Kurang Dari Tanggal Putusan Kasasi'));
				return;
			}
		}

		$tgl_putusan_pk = $this->input->post('tgl_putusan_pk',TRUE);
		if(!empty($tgl_putusan_pk)){
			$tgl_putusan_pk = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_putusan_pk',TRUE));
			if($tgl_putusan_pk==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tgl_putusan_pk,$tgl_permohonan_eksekusi);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Permohonan Eksekusi Tidak Boleh Kurang Dari Tanggal Putusan Peninjauan Kembali'));
				return;
			}
		}


		$id_tergugat='';$nama_tergugat='';

		if($pihak_tergugat!='' || $pihak_tergugat!=0){
		 	$aa_tergugat=implode(';', $pihak_tergugat);
		 	$ax_tergugat=explode(';', $aa_tergugat);
		 	$ac_tergugat=count($ax_tergugat);
		 	
		 	for ($i=0;$i<$ac_tergugat;$i++){
		 		if ($i!=0){
		 			if($i % 2 ==0){
		 				$id_tergugat .= ','.$ax_tergugat[$i];		
			 		}else{
			 			if ($i!=1){
			 				$nama_tergugat .= ',';
			 			}
			 			$nama_tergugat .= $ax_tergugat[$i];
			 		}	
		 		}else{
		 			$id_tergugat .= $ax_tergugat[$i];	
		 		}

		 	}
	 	}
		$id_penggugat='';$nama_penggugat='';
		if($pihak_penggugat!='' || $pihak_penggugat!=0){
		 	$aa_penggugat=implode(';', $pihak_penggugat);
		 	$ax_penggugat=explode(';', $aa_penggugat);
		 	$ac_penggugat=count($ax_penggugat);
		 	
		 	for ($i=0;$i<$ac_penggugat;$i++){
		 		if ($i!=0){
		 			if($i % 2 ==0){
		 				$id_penggugat .= ','.$ax_penggugat[$i];		
			 		}else{
			 			if ($i!=1){
			 				$nama_penggugat .= ',';
			 			}
			 			$nama_penggugat .= $ax_penggugat[$i];
			 		}	
		 		}else{
		 			$id_penggugat .= $ax_penggugat[$i];	
		 		}

		 	}
	 	}

		if(($pihak_penggugat!=0 or $pihak_penggugat!='')){
			$pihak_pemohon_eksekusi='1';
			$kuasadari='Kuasa dari Penggugat :';
			$yangikuasakan=$nama_penggugat;
		}else{
			$pihak_pemohon_eksekusi='2';
			$kuasadari='Kuasa dari Tergugat :';
			$yangikuasakan=$nama_tergugat;
		}

		$idpemohon=$this->encrypt->decode(base64_decode($this->input->post('enc_pemohon',TRUE)));

		$pemohon = $this->input->post('nama_pemohon',TRUE);
		if(!empty($pemohon)){
			if($idpemohon==$id_penggugat){
				$pemohon_eksekusi=$pemohon.' (Penggugat)';	
			}else if($idpemohon==$id_tergugat){
				$pemohon_eksekusi=$pemohon.' (Tergugat)';	
			}else{
				$pemohon_eksekusi=$pemohon.' ('.$kuasadari.' '.$yangikuasakan.')';	
			}
		}


	
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
		}else{
			$this->load->model('perkara/new_eksekusi','eksekusi');
			
			$datapihak = '';
			$i=0;

			$listpihakpenggugat = $this->eksekusi->data_penggugat($idperkara);		
			if($listpihakpenggugat!=''){
				if($listpihakpenggugat->num_rows>0){

					$pihak_list = $this->input->post('penggugat',TRUE);
					if(empty($pihak_list)){
						$diwakili='T';
						$idpemohon='';
						$nama_pemohon='';
						$pekerjaan_pemohon='';
						$alamat_pemohon='';
						$pemohoneksekusi='';
						$statuspihakid=2;
						$statuspihaktext='Termohon';
						$tglpermohonan=NULL;
					}else{
						$diwakili='Y';
						$idpemohon=$this->encrypt->decode(base64_decode($this->input->post('enc_pemohon',TRUE)));
						$nama_pemohon=$this->input->post('nama_pemohon',TRUE);
						$pekerjaan_pemohon=$this->input->post('pekerjaan_pemohon',TRUE);
						$alamat_pemohon=$this->input->post('alamat_pemohon',TRUE);
						$pemohoneksekusi=$pemohon_eksekusi;
						$statuspihakid=1;
						$statuspihaktext='Pemohon';
						$tglpermohonan=$this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_permohonan_eksekusi',TRUE));
					}

					
					foreach ($listpihakpenggugat->result() as $row) {
							if(preg_match('/'.$row->pihak_id.'/',$id_penggugat)){
							$pihak = array(
									'perkara_id' => $idperkara,
									'alur_perkara_id' => $idalurperkara,
									'status_pihak_id' => $statuspihakid,
									'status_pihak_text' => $statuspihaktext,
									'permohonan_eksekusi' => $tglpermohonan,
									'pihak_asal' => 1,
									'pihak_asal_text' => 'Penggugat',
									'pihak_id' => $row->pihak_id,
									'pihak_nama' => $row->nama,
									'pihak_diwakili' => $diwakili,
									'pemohon_id' => $idpemohon,
									'pemohon_nama' => $nama_pemohon,
									'pemohon_pekerjaan' => $pekerjaan_pemohon,
									'pemohon_alamat' => $alamat_pemohon,
									'pemohon_tanggal_surat' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_surat_kuasa',TRUE)),
									'pemohon_nomor_surat' => $this->input->post('no_surat_kuasa',TRUE),
									'pemohon_eksekusi' => $pemohoneksekusi,
									'diperbaharui_oleh' => $this->session->userdata('username'),
									'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
							);
							}else{
							$pihak = array(
									'perkara_id' => $idperkara,
									'alur_perkara_id' => $idalurperkara,
									'status_pihak_id' => 2,
									'status_pihak_text' => 'Termohon',
									'permohonan_eksekusi' => NULL,
									'pihak_asal' => 1,
									'pihak_asal_text' => 'Penggugat',
									'pihak_id' => $row->pihak_id,
									'pihak_nama' => $row->nama,
									'pihak_diwakili' => 'T',
									'pemohon_id' => NULL,
									'pemohon_nama' => '',
									'pemohon_pekerjaan' => '',
									'pemohon_alamat' => '',
									'pemohon_tanggal_surat' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_surat_kuasa',TRUE)),
									'pemohon_nomor_surat' => $this->input->post('no_surat_kuasa',TRUE),									
									'pemohon_eksekusi' => '',
									'diperbaharui_oleh' => $this->session->userdata('username'),
									'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
							);

							}
							$datapihak[$i] = $pihak;
							$i++;

					}
				}
			}

			$listpihaktergugat = $this->eksekusi->data_tergugat($idperkara);		
			if($listpihaktergugat!=''){
				if($listpihaktergugat->num_rows>0){

					$pihak_list = $this->input->post('tergugat',TRUE);
					if(empty($pihak_list)){
						$diwakili='T';
						$idpemohon='';
						$nama_pemohon='';
						$pekerjaan_pemohon='';
						$alamat_pemohon='';
						$pemohoneksekusi='';
						$statuspihakid=2;
						$statuspihaktext='Termohon';
						$tglpermohonan=NULL;
					}else{
						$diwakili='Y';
						$idpemohon=$this->encrypt->decode(base64_decode($this->input->post('enc_pemohon',TRUE)));
						$nama_pemohon=$this->input->post('nama_pemohon',TRUE);
						$pekerjaan_pemohon=$this->input->post('pekerjaan_pemohon',TRUE);
						$alamat_pemohon=$this->input->post('alamat_pemohon',TRUE);
						$pemohoneksekusi=$pemohon_eksekusi;
						$statuspihakid=1;
						$statuspihaktext='Pemohon';
						$tglpermohonan=$this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_permohonan_eksekusi',TRUE));
					}

					
					foreach ($listpihaktergugat->result() as $row) {
							if(preg_match('/'.$row->pihak_id.'/',$id_tergugat)){
							$pihak = array(
									'perkara_id' => $idperkara,
									'alur_perkara_id' => $idalurperkara,
									'status_pihak_id' => $statuspihakid,
									'status_pihak_text' => $statuspihaktext,
									'permohonan_eksekusi' => $tglpermohonan,
									'pihak_asal' => 2,
									'pihak_asal_text' => 'Tergugat',
									'pihak_id' => $row->pihak_id,
									'pihak_nama' => $row->nama,
									'pihak_diwakili' => $diwakili,
									'pemohon_id' => $idpemohon,
									'pemohon_nama' => $nama_pemohon,
									'pemohon_pekerjaan' => $pekerjaan_pemohon,
									'pemohon_alamat' => $alamat_pemohon,
									'pemohon_tanggal_surat' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_surat_kuasa',TRUE)),
									'pemohon_nomor_surat' => $this->input->post('no_surat_kuasa',TRUE),									
									'pemohon_eksekusi' => $pemohoneksekusi,
									'diperbaharui_oleh' => $this->session->userdata('username'),
									'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
							);
							}else{
							$pihak = array(
									'perkara_id' => $idperkara,
									'alur_perkara_id' => $idalurperkara,
									'status_pihak_id' => 2,
									'status_pihak_text' => 'Termohon',
									'permohonan_eksekusi' => NULL,
									'pihak_asal' => 2,
									'pihak_asal_text' => 'Tergugat',
									'pihak_id' => $row->pihak_id,
									'pihak_nama' => $row->nama,
									'pihak_diwakili' => 'T',
									'pemohon_id' => NULL,
									'pemohon_nama' => '',
									'pemohon_pekerjaan' => '',
									'pemohon_alamat' => '',
									'pemohon_tanggal_surat' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_surat_kuasa',TRUE)),
									'pemohon_nomor_surat' => $this->input->post('no_surat_kuasa',TRUE),									
									'pemohon_eksekusi' => '',
									'diperbaharui_oleh' => $this->session->userdata('username'),
									'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
							);

							}
							$datapihak[$i] = $pihak;
							$i++;

					}
				}
			}

				$eksekusi_put_id=$this->input->post('listdataput',TRUE);
				if($eksekusi_put_id==10){
					$amardieksekusi=$this->input->post('amarpn',TRUE);
				}else if($eksekusi_put_id==20){
					$amardieksekusi=$this->input->post('amarbanding',TRUE);
				}else if($eksekusi_put_id==30){
					$amardieksekusi=$this->input->post('amarkasasi',TRUE);
				}else if($eksekusi_put_id==40){
					$amardieksekusi=$this->input->post('amarpn',TRUE);
				}

				$data = array(
						'eksekusi_putusan' => $this->input->post('listdataput',TRUE),
						'eksekusi_nomor_perkara' => $this->input->post('no_perkara_mhn_eksekusi',TRUE),
						'eksekusi_amar_putusan' => $amardieksekusi,
						'pihak_pemohon_eksekusi' => $pihak_pemohon_eksekusi,
						'permohonan_eksekusi' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_permohonan_eksekusi',TRUE)),						
						'pemohon_eksekusi' => $pemohon_eksekusi,
						'diperbaharui_oleh' => $this->session->userdata('username'),
						'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
					);			
			$result = $this->eksekusi->update_perkara_eksekusi($data,$idperkara);
			$result = $this->eksekusi->dele_perkara_eksekusi_detil($idperkara);
			$result = $this->eksekusi->add_perkara_eksekusi_detil($datapihak);
			if($result===FALSE){
				echo json_encode(array('st'=>0,'msg'=>'GAGAL Menyimpan'));
				return;
			}else{
				echo json_encode(array('st'=>1,'msg'=>'Berhasil Menyimpan'));
				return;
			}
		}
	}


	function parsePihak($listpihak,$idpihak){
		foreach ($listpihak as $key) {
			$idpihakpemohon = $this->encrypt->decode(base64_decode($key));
			if($idpihak==$idpihakpemohon){
				return TRUE;
			}
		}
		return FALSE;
	}

}