<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Detil_kasasi extends CI_Controller {
	function index(){
		#prevent direct access to page
		#the user should only access the page through menu
		if($this->nativesession->get_flash_session('security')==FALSE){
			redirect('main');
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}

		$idperkara = $this->nativesession->get_flash_session('perkara_id');		
		if(!is_numeric($idperkara)){				
			show_404();
		}
		$view = $this->nativesession->get_flash_session('view');
		if($view==TRUE){
			$this->show_data_detil($idperkara);
		}else{
			
			$this->show_data($idperkara);
		}
	}

	function show_data_detil($idperkara){
		$data['page_title'] = 'INFORMASI DETIL - PERMOHONAN KASASI';
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$data['main_history'] = $this->nativesession->get('main_url_requested');
		$data['history'] = $this->nativesession->get_flash_session('url_requested');
		$this->load->model('perkara/kasasi','kasasi');
		$data['infokasasi'] = $this->kasasi->fetchkasasi($idperkara);
		$data['infokasasidetil'] = $this->kasasi->fetchkasasiDetil($idperkara);
		$data['infomediasi'] = $this->kasasi->getDataMediasiKasasi($idperkara);		
		$data['alur_perkara_id']=$this->tanggalhelper->getIDAlurPerkara($idperkara);
		$data['idjenisperkara'] = $this->tanggalhelper->getIDJenisPerkara($idperkara);		
		$this->load->vars($data);
		$this->load->view('perkara_tab/kasasi');
	}

	function show_data($idperkara){		
		$data['page_title'] = 'INFORMASI DETIL - PERMOHONAN KASASI';
		$data['enc'] = $this->nativesession->get_flash_session('enc');
		$data['main_body'] = 'perkara/detil_kasasi';
		$data['main_history'] = $this->nativesession->get('main_url_requested');
		$data['history'] = $this->nativesession->get_flash_session('url_requested');
		$this->load->model('perkara/kasasi','kasasi');        
		$data['infokasasi'] = $this->kasasi->fetchkasasi($idperkara);
		$data['infokasasidetil'] = $this->kasasi->fetchkasasiDetil($idperkara);		
		$data['infomediasi'] = $this->kasasi->getDataMediasiKasasi($idperkara);
                
		#integrasi 22/04/2017
		$this->load->model('api/dirput_model','dirput');
                $put_dirput = $this->dirput->putusan_dirput($idperkara,'perkara_kasasi','amar_putusan_kasasi_dok');
                $alurperdatakhusus=array(3,4,5,6,7,8);		
	        if (in_array($this->tanggalhelper->getIDAlurPerkara($idperkara), $alurperdatakhusus))
			  {
			  $data['alur_perkara_id']=3;
			  } else {
			  $data['alur_perkara_id']=$this->tanggalhelper->getIDAlurPerkara($idperkara);
			  }
		$data['perkaraid']=$idperkara;	
		$this->session->set_userdata('perkaraid',$idperkara);
		$data['dirput'] = $this->dirput->create_dirput($idperkara);	
		$data['doc_referensi'] = $this->dirput->doc_ref($this->session->userdata('jenis_pengadilan'),3,$data['alur_perkara_id']);			
		$data['surat_pengantar'] = $this->dirput->ambil_pengantar($idperkara,3);
                $data['pengajuan'] = $this->dirput->ambil_pengajuan($idperkara,3);
		$data['perkaraid_kas']=$idperkara;
		$data['jenispengadilan_kas']=$this->session->userdata('jenis_pengadilan');
                $data['putusankasasi'] = $put_dirput[0]['file_id'];
		$this->load->library('ckeditor');
		$this->ckeditor->basePath = base_url().'resources/ckeditor/';
		$this->ckeditor->config['toolbar'] = array(
			array('-','Cut','Copy','Paste','PasteText','PasteFromWord',
				'-','Bold', 'Italic', 'Underline','Subscript', 'Superscript',
					'-', 'RemoveFormat','-', 'Blockquote',
					'-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock',
					'-','Undo','Redo','-','NumberedList','BulletedList','/',
					'-','Image'),
			array('-','Format', 'Font', 'FontSize',
				'-','TextColor', 'BGColor','Table',
				'-','Find', 'Replace', '-', 'SelectAll', '-', 'Scayt','-','HorizontalRule',
				'-','Print','Preview'
				));
		$this->ckeditor->config['pasteFromWordNumberedHeadingToList'] = 'true';
		$this->ckeditor->config['pasteFromWordPromptCleanup'] = 'true';
		$this->ckeditor->config['resize'] = 'false';
		$this->ckeditor->config['language'] = 'en';
		$this->ckeditor->config['width'] = '850px';
		$this->ckeditor->config['height'] = '150px';	
        $this->ckeditor->config['readOnly'] ='true';		
		//$data['edoc_upayahukum'] = $this->dirput->ambil_dokumen($idperkara,$this->session->userdata('jenis_pengadilan'),3);
        #		
		$this->load->vars($data);	
		$this->load->view('header');		
		$this->load->view('body/body_new');
	}	

	function parapihak(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$segment = $this->uri->segment_array();
		$data['enc_id'] = $segment[3];
		$data['id'] = $this->encrypt->decode(base64_decode($segment[3]));
		if(empty($data['id']) OR intval($data['id'])<1){
			show_404();
		}
		$data['current_date'] = date('d/m/Y');
		$data['history'] = base_url(uri_string());
		$this->load->model('perkara/kasasi','kasasi');
		$data['infopihak'] = $this->kasasi->getPihakkasasi($data['id']);
		$this->load->vars($data);
		$this->load->view('perkara/kasasi/edit_para_pihak');
	}

	function saveparapihak(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Waktu Login Anda telah Berakhir, Silahkan Login Kembali.'));
			return;
		}
		$id = $this->encrypt->decode(base64_decode($this->input->post('enc_id',TRUE)));
		if(empty($id) OR intval($id)<1){
			echo json_encode(array('st'=>0,'msg'=>'Permohonan Kasasi Tidak Ditemukan.'));
			return;
		}

		$diwakilkan = $this->input->post('diwakilkan',TRUE);
		if(empty($diwakilkan) OR !is_numeric($diwakilkan)){
			echo json_encode(array('st'=>0,'msg'=>'Something Not Right With The Data.'));
			return;
		}
		if($diwakilkan==1){
			$diwakilkan = 'Y';
			$this->form_validation->set_rules('fullname', 'Nama Pemohon', 'trim|required|xss_clean');
		}else{
			$diwakilkan = 'T';
		}
		$this->form_validation->set_rules('diwakilkan', 'Status Diwakilkan', 'trim|xss_clean');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$datapihak = array(
				'id' => $id,
				'pihak_diwakili' => $diwakilkan,
				'diperbaharui_oleh' => $this->session->userdata('username'),
				'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
			);
			$idpihak = $this->encrypt->decode(base64_decode($this->input->post('enc_pihak',TRUE)));
			
			if(empty($idpihak) OR intval($idpihak)<1){
				echo json_encode(array('st'=>0,'msg'=>'Something Not Right With Your Data.'));
				return;
			}
			$this->load->model('perkara/kasasi','kasasi');
			$pihak = $this->kasasi->getDataPihak($idpihak);
			if($pihak!=''){
				if($pihak->num_rows>0){
					foreach ($pihak->result() as $row) {
						$datapihak['pemohon_id'] = $row->id;
						$datapihak['pemohon_nama'] = $row->nama;
						$datapihak['pemohon_alamat'] = $row->alamat;
						$datapihak['pemohon_pekerjaan'] = $row->pekerjaan;
					}
				}
			}

			if($diwakilkan=='Y'){
				$infopihak = $this->kasasi->getPihakkasasi($id);
				if($infopihak!=''){
					if($infopihak->num_rows>0){
						foreach ($infopihak->result() as $row) {
							$namapihak = $row->pihak_nama;
							$statusasal = $row->pihak_asal_text;
						}
					}
					$tglsuratkuasa = $this->input->post('tgl_surat_kuasa',TRUE);
					if(!empty($tglsuratkuasa)){
						$datapihak['pemohon_tanggal_surat'] = $this->tanggalhelper->convertToMysqlDate($tglsuratkuasa);
					}
					if($this->input->post('no_kuasa',TRUE))
						$datapihak['pemohon_nomor_surat'] = $this->input->post('no_kuasa',TRUE);
					$datapihak['pemohon_kasasi'] = $datapihak['pemohon_nama'].' Kuasa Dari '.$statusasal.':<br>'.$namapihak;
				}
			}
			$result = $this->kasasi->update_data($datapihak,$id);
			if($result==TRUE){
				echo json_encode(array('st'=>1,'msg'=>'DATA BERHASIL DISIMPAN.'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'GAGAL Melakukan Penyimpanan.'));
				return;
			}
		}
	}

	function permohonan(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$segment = $this->uri->segment_array();
		$data['enc_id'] = $segment[3];
		$data['id'] = $this->encrypt->decode(base64_decode($segment[3]));
		$data['enc'] = $segment[2];
		$idperkara = $this->encrypt->decode(base64_decode($segment[2]));
		if(empty($data['id']) OR intval($data['id'])<1){
			show_404();
		}
		if(empty($idperkara) OR intval($idperkara)<1){
			show_404();
		}

		$data['history'] = base_url(uri_string());
		$data['current_date'] =date('d/m/Y'); 
		$this->load->model('perkara/kasasi','kasasi');

		$data['infopihak'] = $this->kasasi->getPihakkasasi($data['id']);
		$idalurperkara = $this->kasasi->getAlurPerkara($idperkara);
		$data['enc_alur']=base64_encode($this->encrypt->encode($idalurperkara));
		
		$stpihak = $this->kasasi->getStatusPihak($idalurperkara);
		if($stpihak!=''){
			if($stpihak->num_rows>0){
				foreach ($stpihak->result() as $row) {
					$statuspihak[$row->pihak_ke] = $row->nama;
				}
			}
		}
		$data['statuspihak'] = $statuspihak;
		$data['idalurperkara'] = $idalurperkara;
		$this->load->vars($data);
		$this->load->view('perkara/kasasi/edit_permohonan_kasasi');
	}

	function savepermohonan(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Waktu Login Anda telah Berakhir, Silahkan Login Kembali.'));
			return;
		}
		$id = $this->encrypt->decode(base64_decode($this->input->post('enc_id',TRUE)));
		if(empty($id) OR intval($id)<1){
			echo json_encode(array('st'=>0,'msg'=>'Permohonan Kasasi Tidak Ditemukan.'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$this->form_validation->set_rules('tgl_pendaftaran', 'Tanggal Pendaftaran', 'trim|required|xss_clean|exact_length[10]');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$tglPendaftaran = $this->input->post('tgl_pendaftaran',TRUE);
			$dateOpt = strtotime($tglPendaftaran);
			$curr_date = strtotime(date('d/m/Y'));
			$todayDate = date('d/m/Y');
			if($dateOpt>$curr_date){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pendaftaran Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}
			$tglPendaftaran = $this->tanggalhelper->convertToMysqlDate($tglPendaftaran);
			if($tglPendaftaran==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tglPendaftaran);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Pendaftaran Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$tglcabut = '';
			$tglPutusanPN = '';
			$this->load->model('perkara/kasasi','kasasi');
			$dataputusan = $this->kasasi->getTanggalPutusan($idperkara);
			if($dataputusan->num_rows>0){
				foreach ($dataputusan->result() as $row) {
					$tglPutusanPN = $row->tanggal_putusan;
					$tglcabut = $row->tanggal_cabut;
				}
			}
			if(!empty($tglcabut)){
				echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Dapat Dimohonkan Kasasi Karena Telah Dicabut.'));
				return;
			}

			if(empty($tglPutusanPN)){
				echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Dapat Dimohonkan Kasasi Karena Belum Putus.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tglPutusanPN,$tglPendaftaran);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pendaftaran Tidak Boleh Kurang Dari Tanggal Putusan'));
				return;
			}

			
			$datapihak = array(
				'permohonan_kasasi' => $tglPendaftaran,
				'diperbaharui_oleh' => $this->session->userdata('username'),
				'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
			);
			$result = $this->kasasi->update_data($datapihak,$id);

			$datakasasi = $this->kasasi->getPihakkasasi($id);
			$idstatus = '';
			$urutan ='';
			if($datakasasi->num_rows>0){
				foreach ($datakasasi->result() as $row) {
					$idstatus = $row->status_pihak_id;
					$urutan = $row->urutan_kasasi;
				}
			}
			if(!empty($idstatus) AND !empty($urutan)){
				if($idstatus==1 AND $urutan==1){
					$datapihak = array(
						'permohonan_kasasi' => $tglPendaftaran,
						'diperbaharui_oleh' => $this->session->userdata('username'),
						'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
					);
					$result = $this->kasasi->update_data_kasasi($datapihak,$idperkara);
				}
			}
			if($result==TRUE){
				echo json_encode(array('st'=>1,'msg'=>'DATA BERHASIL DISIMPAN.'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'GAGAL MELAKUKAN PENYIMPANAN.'));
				return;
			}
		}
	}

	function cabut(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$segment = $this->uri->segment_array();
		$data['enc_id'] = $segment[3];
		$data['id'] = $this->encrypt->decode(base64_decode($segment[3]));
		$data['enc'] = $segment[2];
		$idperkara = $this->encrypt->decode(base64_decode($segment[2]));
		if(empty($data['id']) OR intval($data['id'])<1){
			show_404();
		}
		if(empty($idperkara) OR intval($idperkara)<1){
			show_404();
		}

		$data['history'] = base_url(uri_string());
		$data['current_date'] =date('d/m/Y'); 
		$this->load->model('perkara/kasasi','kasasi');
		$data['infopihak'] = $this->kasasi->getPihakkasasi($data['id']);
		$this->load->vars($data);
		$this->load->view('perkara/kasasi/cabut_permohonan_kasasi');
	}

	function savecabut(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Waktu Login Anda telah Berakhir, Silahkan Login Kembali.'));
			return;
		}

		$id = $this->encrypt->decode(base64_decode($this->input->post('enc_id',TRUE)));
		if(empty($id) OR intval($id)<1){
			echo json_encode(array('st'=>0,'msg'=>'Permohonan Kasasi Tidak Ditemukan.'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$this->form_validation->set_rules('tgl_cabut', 'Tanggal Pencabutan Perkara', 'trim|required|xss_clean|exact_length[10]');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$tglCabut = $this->input->post('tgl_cabut',TRUE);
			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			$tglCabut = $this->tanggalhelper->convertToMysqlDate($tglCabut);

			if($tglCabut==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}
			
			$selisih = $this->tanggalhelper->getSelisihHari($tglCabut,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pencabutan Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tglCabut);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Pencabutan Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$tglPutusanPN = '';
			$this->load->model('perkara/kasasi','kasasi');
			$dataputusan = $this->kasasi->getTanggalPutusan($idperkara);
			if($dataputusan->num_rows>0){
				foreach ($dataputusan->result() as $row) {
					$tglPutusanPN = $row->tanggal_putusan;
				}
			}
			

			$selisih = $this->tanggalhelper->getSelisihHari($tglPutusanPN,$tglCabut);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pencabutan Tidak Boleh Kurang Dari Tanggal Putusan PN'));
				return;
			}

			
			$datapihak = array(
				'tanggal_cabut' => $tglCabut,
				'catatan_putusan_kasasi' => $this->input->post('keterangan',TRUE),
				'diperbaharui_oleh' => $this->session->userdata('username'),
				'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
			);
			$result = $this->kasasi->update_data($datapihak,$id);

			$datakasasi = $this->kasasi->getPihakkasasi($id);
			$idstatus = '';
			$urutan ='';
			if($datakasasi->num_rows>0){
				foreach ($datakasasi->result() as $row) {
					$idstatus = $row->status_pihak_id;
					$urutan = $row->urutan_kasasi;
				}
			}
			if(!empty($idstatus) AND !empty($urutan)){
				if($idstatus==1 AND $urutan==1){
					$datapihak = array(
						'tanggal_cabut' => $tglCabut,
						'status_kasasi_id' => 491,
						'minutasi_kasasi' => $tglCabut,
						'status_kasasi_text' => 'Pencabutan Perkara Kasasi',
						'diperbaharui_oleh' => $this->session->userdata('username'),
						'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
					);
					$result = $this->kasasi->update_data_kasasi($datapihak,$idperkara);
					$this->kasasi->addPerkaraProses($idperkara,491,'Pencabutan Perkara Kasasi',$tglCabut);
					$this->kasasi->updatePerkaraProses($idperkara);
				}
			}
			if($result==TRUE){
				echo json_encode(array('st'=>1,'msg'=>'DATA BERHASIL DISIMPAN.'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'GAGAL MELAKUKAN PENYIMPANAN.'));
				return;
			}
		}
	}

	function edittanggal(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$segment = $this->uri->segment_array();
		$data['enc_id'] = $segment[3];
		$data['id'] = $this->encrypt->decode(base64_decode($segment[3]));
		$data['enc'] = $segment[2];
		$idperkara = $this->encrypt->decode(base64_decode($segment[3]));
		if(empty($data['id']) OR intval($data['id'])<1){
			show_404();
		}
		if(empty($idperkara) OR intval($idperkara)<1){
			show_404();
		}
		$func = $segment[4];
		if(empty($func) OR intval($func)<1){
			show_404();
		}
		$data['enc_func'] = base64_encode($this->encrypt->encode($segment[4]));
		$data['openinput'] = 2;
		$this->load->model('perkara/kasasi','kasasi');
		$infopihaks = $this->kasasi->getPihakkasasi($data['id']);
		if($infopihaks!=''){
			if($infopihaks->num_rows>0){
				foreach ($infopihaks->result() as $row) {
					$data['namapihak'] = $row->pihak_nama;
					$data['statuskasasi'] = $row->status_pihak_text.' Ke-'.$row->urutan_kasasi;
					$data['noperkarapn'] = $row->nomor_perkara_pn;
					$data['tglpermohonan'] = $this->tanggalhelper->convertToInputDate($row->permohonan_kasasi);
					$data['idpihak'] = base64_encode($this->encrypt->encode($row->pihak_id));
					$data['idperkara'] = base64_encode($this->encrypt->encode($row->perkara_id));
				}
			}
		}else{
			show_404();
		}
		if($func==1){
			$data['title'] = "Edit - Tanggal Pemberitahuan Permohonan Kasasi";
			$data['subtitle'] = 'Tanggal Pemberitahuan Permohonan';
			$data['tanggal'] = $this->tanggalhelper->convertToInputDate($infopihaks->row()->pemberitahuan);
		}elseif($func==2){
			$data['title'] = "Edit - Tanggal Penerimaan Memori Kasasi";
			$data['subtitle'] = 'Tanggal Penerimaan Memori';
			$data['tanggal'] = $this->tanggalhelper->convertToInputDate($infopihaks->row()->pen_memori);
		}elseif($func==3){
			$data['title'] = "Edit - Tanggal Penyerahan Memori Kasasi";
			$data['subtitle'] = 'Tanggal Penyerahan Memori';
			$data['tanggal'] = $this->tanggalhelper->convertToInputDate($infopihaks->row()->peny_memori);
		}elseif($func==4){
			$data['title'] = "Edit - Tanggal Penerimaan Kontra Memori Kasasi";
			$data['subtitle'] = 'Tanggal Penerimaan Kontra';
			$data['tanggal'] = $this->tanggalhelper->convertToInputDate($infopihaks->row()->pen_kontra);
		}elseif($func==5){
			$data['title'] = "Edit - Tanggal Penyerahan Kontra Memori Kasasi";
			$data['subtitle'] = 'Tanggal Penyerahan Kontra';
			$data['tanggal'] = $this->tanggalhelper->convertToInputDate($infopihaks->row()->peny_kontra);
		}elseif($func==6){
			$data['title'] = "Edit - Tanggal Pemberitahuan Inzage";
			$data['subtitle'] = 'Tanggal Pemberitahuan Inzage';
			$data['tanggal'] = $this->tanggalhelper->convertToInputDate($infopihaks->row()->pen_inzage);
		}elseif($func==8){
			$data['title'] = "Edit - Tanggal Pemberitahuan Putusan Kasasi";
			$data['subtitle'] = 'Tanggal Pemberitahuan Putusan';
			$data['tanggal'] = $this->tanggalhelper->convertToInputDate($infopihaks->row()->pen_putus);
		}elseif($func==7){
			$result = $this->kasasi->getDatakasasi($idperkara);
			if($result!=''){
				if($result->num_rows>0){
					foreach ($result->result() as $row) {
						$data['idperkara'] = base64_encode($this->encrypt->encode($row->perkara_id));
						$data['tanggal'] = $this->tanggalhelper->convertToInputDate($row->pengiriman_berkas_kasasi);
						$data['input_area'] = $row->nomor_surat_pengiriman_berkas_kasasi;
					}
				}else{
					show_404();
				}
			}else{
				show_404();
			}
			$data['title'] = "Edit - Tanggal Pengiriman Berkas Kasasi";
			$data['subtitle'] = 'Tanggal Pengiriman Berkas';
			$data['openinput'] = 1;
			$data['inputsubtitle'] = 'Nomor Surat Pengiriman Berkas Kasasi';
		}
		$data['history'] = base_url(uri_string());
		$data['current_date'] =date('d/m/Y'); 
		
		$this->load->vars($data);
		$this->load->view('perkara/kasasi/edit_tanggal');
	}

	function savetanggal(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Waktu Login Anda telah Berakhir, Silahkan Login Kembali.'));
			return;
		}

		$id = $this->encrypt->decode(base64_decode($this->input->post('enc_id',TRUE)));
		if(empty($id) OR intval($id)<1){
			echo json_encode(array('st'=>0,'msg'=>'Permohonan Kasasi Tidak Ditemukan.'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$func = $this->encrypt->decode(base64_decode($this->input->post('enc_func',TRUE)));
		if(empty($func) OR intval($func)<1){
			echo json_encode(array('st'=>0,'msg'=>'Something Wrong With Your Data.'));
			return;
		}

		$this->form_validation->set_rules('tanggal', 'Tanggal', 'trim|required|xss_clean|exact_length[10]');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$tanggal = $this->input->post('tanggal',TRUE);
			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');
			
			$tanggal = $this->tanggalhelper->convertToMysqlDate($tanggal);
			
			if($tanggal==FALSE){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tanggal,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Tidak Boleh Melebihi Hari ini. Hari ini Tanggal, '.$todayDate));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tanggal);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$this->load->model('perkara/kasasi','kasasi');
			$tglpermohonan = $this->kasasi->getPermohonanKasasi($idperkara);
			$selisih = $this->tanggalhelper->getSelisihHari($tglpermohonan,$tanggal);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Tidak Boleh Kurang Dari Tanggal Permohonan'));
				return;
			}

			$tglPutusanPN = '';
			
			$dataputusan = $this->kasasi->getTanggalPutusan($idperkara);
			if($dataputusan->num_rows>0){
				foreach ($dataputusan->result() as $row) {
					$tglPutusanPN = $row->tanggal_putusan;
				}
			}
		
			if(empty($tglPutusanPN)){
				echo json_encode(array('st'=>0,'msg'=>'Tanggal Putusan Tingkat Pertama Tidak Diketemukan.'));
				return;
			}
			$selisih = $this->tanggalhelper->getSelisihHari($tglPutusanPN,$tanggal);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Tidak Boleh Kurang Dari Tanggal Putusan PN'));
				return;
			}

			$datapihak = array(
				'diperbaharui_oleh' => $this->session->userdata('username'),
				'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
			);
			$datakasasi = $datapihak;
			$tglputusankasasi = $this->kasasi->getTanggalPutusanKasasi($idperkara);
			if($func==1){
				if(!empty($tglputusankasasi)){
					$selisih = $this->tanggalhelper->getSelisihHari($tglputusankasasi,$tanggal);
					if($selisih<0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pemberitahuan Permohonan Kasasi Tidak Boleh Kurang Dari Tanggal Putusan Kasasi'));
						return;
					}
				}
				$datapihak['pemberitahuan_kasasi'] = $tanggal;
				$datakasasi['pemberitahuan_kasasi'] = $tanggal;
				$dataproses['status_kasasi_id'] = 420;
				$dataproses['status_kasasi_text'] = 'Pemberitahuan Permohonan Kasasi';
			}elseif($func==2){
				$tglkirimberkas = $this->kasasi->getTglKirimBerkas($idperkara);
				if(!empty($tglkirimberkas)){
					$selisih = $this->tanggalhelper->getSelisihHari($tanggal,$tglkirimberkas);
					if($selisih<0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penerimaan Memori Kasasi Tidak Boleh Lebih Dari Tanggal Kirim Berkas Kasasi'));
						return;
					}
				}
				$datapihak['penerimaan_memori_kasasi'] = $tanggal;
				$datakasasi['penerimaan_memori_kasasi'] = $tanggal;
				$dataproses['status_kasasi_id'] = 430;
				$dataproses['status_kasasi_text'] = 'Penerimaan Memori Kasasi';
			}elseif($func==3){
				if(!empty($tglputusankasasi)){
					$selisih = $this->tanggalhelper->getSelisihHari($tglputusankasasi,$tanggal);
					if($selisih<0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penyerahan Memori Memori Kasasi Tidak Boleh Kurang Dari Tanggal Putusan Kasasi'));
						return;
					}
				}
				$datapihak['penyerahan_memori_kasasi'] = $tanggal;
				$datakasasi['penyerahan_memori_kasasi'] = $tanggal;
				$dataproses['status_kasasi_id'] = 440;
				$dataproses['status_kasasi_text'] = 'Penyerahan Memori Kasasi';
			}elseif($func==4){
				if(!empty($tglputusankasasi)){
					$selisih = $this->tanggalhelper->getSelisihHari($tglputusankasasi,$tanggal);
					if($selisih<0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penerimaan Kontra Memori Kasasi Tidak Boleh Kurang Dari Tanggal Putusan Kasasi'));
						return;
					}
				}
				$datapihak['penerimaan_kontra_kasasi'] = $tanggal;
				$datakasasi['penerimaan_kontra_kasasi'] = $tanggal;
				$dataproses['status_kasasi_id'] = 450;
				$dataproses['status_kasasi_text'] = 'Penerimaan Kontra Memori Kasasi';
			}elseif($func==5){
				if(!empty($tglputusankasasi)){
					$selisih = $this->tanggalhelper->getSelisihHari($tglputusankasasi,$tanggal);
					if($selisih<0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penyerahan Kontra Memori Kasasi Tidak Boleh Kurang Dari Tanggal Putusan Kasasi'));
						return;
					}
				}
				$datapihak['penyerahan_kontra_kasasi'] = $tanggal;
				$datakasasi['penyerahan_kontra_kasasi'] = $tanggal;
				$dataproses['status_kasasi_id'] = 460;
				$dataproses['status_kasasi_text'] = 'Penyerahan Kontra Memori Kasasi';
			}elseif($func==6){
				if(!empty($tglputusankasasi)){
					$selisih = $this->tanggalhelper->getSelisihHari($tglputusankasasi,$tanggal);
					if($selisih<0){
						echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Permberitahuan Untuk Memeriksa Berkas(Inzage) Kasasi Tidak Boleh Kurang Dari Tanggal Putusan Kasasi'));
						return;
					}
				}
				$datapihak['pemberitahuan_inzage_kasasi'] = $tanggal;
				$datapihak['pemberitahuan_inzage_kasasi'] = $tanggal;
				$dataproses['status_kasasi_id'] = 461;
				$dataproses['status_kasasi_text'] = 'Permberitahuan Untuk Memeriksa Berkas(Inzage)';
			}elseif($func==8){
				if(empty($tglputusankasasi)){
					echo json_encode(array('st'=>0,'msg'=>'Perkara Belum dinyatakan Putus.'));
					return;
				}
				$selisih = $this->tanggalhelper->getSelisihHari($tglputusankasasi,$tanggal);
				if($selisih<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pemberitahuan Putusan Kasasi Tidak Boleh Kurang Dari Tanggal Putusan Kasasi'));
					return;
				}
				$datapihak['pemberitahuan_putusan_kasasi'] = $tanggal;
				$datakasasi['pemberitahuan_putusan_kasasi'] = $tanggal;
				$dataproses['status_kasasi_id'] = 500;
				$dataproses['status_kasasi_text'] = 'Pemberitahuan Putusan Kasasi';
			}
			$result = $this->kasasi->update_data($datapihak,$id);
			$result = $this->kasasi->update_data_kasasi($datakasasi,$idperkara);
			if($result==TRUE){
				$this->kasasi->update_proses($idperkara,$dataproses['status_kasasi_id'],$dataproses['status_kasasi_text']);
				$this->kasasi->addPerkaraProses($idperkara,$dataproses['status_kasasi_id'],$dataproses['status_kasasi_text'],$tanggal);
				$this->kasasi->updatePerkaraProses($idperkara);
				echo json_encode(array('st'=>1,'msg'=>'DATA BERHASIL DISIMPAN.'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'GAGAL MELAKUKAN PENYIMPANAN.'));
				return;
			}
		}
	}

	function hapus_tanggal_kasasi(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$id = $this->encrypt->decode(base64_decode($this->input->post('enc_id',TRUE)));
		if(empty($id) OR intval($id)<1){
			echo json_encode(array('st'=>0,'msg'=>'Permohonan Kasasi Tidak Ditemukan.'));
			return;
		}				

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$func = $this->encrypt->decode(base64_decode($this->input->post('enc_func',TRUE)));
		if(empty($func) OR intval($func)<1){
			echo json_encode(array('st'=>0,'msg'=>'Something Wrong With Your Data.'));
			return;
		}
		
		if($func==1){
				$yang_dihapus = 'Pemberitahuan Permohonan Kasasi';						
				$dataproses['status_kasasi_id'] = 420;
				$kolom = 'pemberitahuan_kasasi';
			}elseif($func==2){
				$yang_dihapus = 'Penerimaan Memori Kasasi';							
				$dataproses['status_kasasi_id'] = 430;
				$kolom = 'penerimaan_memori_kasasi';
			}elseif($func==3){
				$yang_dihapus = 'Penyerahan Memori Kasasi';								
				$dataproses['status_kasasi_id'] = 440;
				$kolom = 'penyerahan_memori_kasasi';
			}elseif($func==4){
				$yang_dihapus = 'Penerimaan Kontra Kasasi';								
				$dataproses['status_kasasi_id'] = 450;
				$kolom = 'penerimaan_kontra_kasasi';
			}elseif($func==5){
				$yang_dihapus = 'Penyerahan Kontra Kasasi';								
				$dataproses['status_kasasi_id'] = 460;
				$kolom = 'penyerahan_kontra_kasasi';
			}elseif($func==6){
				$yang_dihapus = 'Pemberitahuan Inzage';								
				$dataproses['status_kasasi_id'] = 461;
				$kolom = 'pemberitahuan_inzage_kasasi';
			}elseif($func==7){
				$yang_dihapus = 'Pengiriman Berkas Kasasi';								
				$dataproses['status_kasasi_id'] = 470;
				$kolom = 'pengiriman_berkas_kasasi';
			}elseif($func==8){
				$yang_dihapus = 'Pemberitahuan Putusan Kasasi';								
				$dataproses['status_kasasi_id'] = 500;
				$kolom = 'pemberitahuan_putusan_kasasi';
			}else{
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Permintaan Tidak Diketahui.'));
				return;
			}		
		
		$diperbaharui = array(
				'diperbaharui_oleh' => $this->session->userdata('username'),
				'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())	
			);		

		$this->load->model('perkara/kasasi','kasasi');
		if($this->kasasi->hapus_tgl_kasasi($id,$idperkara,$kolom,$dataproses,$diperbaharui,$func)){			
			echo json_encode(array('st'=>1,'msg'=>'Penghapusan Tanggal '.$yang_dihapus.'  Berhasil'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'));
			return;
		}
	}

	function saveberkas(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Waktu Login Anda telah Berakhir, Silahkan Login Kembali.'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$func = $this->encrypt->decode(base64_decode($this->input->post('enc_func',TRUE)));
		if(empty($func) OR intval($func)<1){
			echo json_encode(array('st'=>0,'msg'=>'Something Wrong With Your Data.'));
			return;
		}

		$this->form_validation->set_rules('tanggal', 'Tanggal', 'trim|required|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('input_area', 'Nomor Pengiriman Berkas Kasasi', 'trim|required|xss_clean|min_length[5]');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$tanggal = $this->input->post('tanggal',TRUE);
			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			$tanggal = $this->tanggalhelper->convertToMysqlDate($tanggal);
			if($tanggal==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tanggal,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pengiriman Berkas Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tanggal);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$this->load->model('perkara/kasasi','kasasi');
			$tglpermohonan = $this->kasasi->getPermohonanKasasi($idperkara);
			$selisih = $this->tanggalhelper->getSelisihHari($tglpermohonan,$tanggal);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Tidak Boleh Kurang Dari Tanggal Permohonan'));
				return;
			}

			$tglPutusanPN = '';
			
			$dataputusan = $this->kasasi->getTanggalPutusan($idperkara);
			if($dataputusan->num_rows>0){
				foreach ($dataputusan->result() as $row) {
					$tglPutusanPN = $row->tanggal_putusan;
				}
			}

			if(empty($tglPutusanPN)){
				echo json_encode(array('st'=>0,'msg'=>'Tanggal Putusan Tingkat Pertama Tidak Diketemukan.'));
				return;
			}
			$selisih = $this->tanggalhelper->getSelisihHari($tglPutusanPN,$tanggal);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pengiriman Berkas Tidak Boleh Kurang Dari Tanggal Putusan PN'));
				return;
			}

			$tglmemori = $this->kasasi->getTglMemoriKasasi($idperkara);
			if(empty($tglmemori)){
				echo json_encode(array('st'=>0,'msg'=>'Tanggal Memori Kasasi Belum Diinputkan.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tglmemori,$tanggal);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Tidak Boleh Kurang Dari Tanggal Penerimaan Memori Kasasi'));
				return;
			}

			$datapihak = array(
				'pengiriman_berkas_kasasi' => $tanggal,
				'nomor_surat_pengiriman_berkas_kasasi' => $this->input->post('input_area',TRUE),
				'diperbaharui_oleh' => $this->session->userdata('username'),
				'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
			);

			$result = $this->kasasi->update_data_kasasi($datapihak,$idperkara);
			
			if($result==TRUE){
				$this->kasasi->update_proses($idperkara,470,'Pengiriman Berkas Kasasi');
				$this->kasasi->addPerkaraProses($idperkara,470,'Pengiriman Berkas Kasasi',$tanggal);
				$this->kasasi->updatePerkaraProses($idperkara);
				echo json_encode(array('st'=>1,'msg'=>'DATA BERHASIL DISIMPAN.'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'GAGAL MELAKUKAN PENYIMPANAN.'));
				return;
			}
		}
	}

	function putusan(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$segment = $this->uri->segment_array();
		$data['enc'] = $segment[2];
		$idperkara = $this->encrypt->decode(base64_decode($segment[2]));
		if(empty($idperkara) OR intval($idperkara)<1){
			show_404();
		}

		$data['history'] = base_url(uri_string());
		$data['current_date'] =date('d/m/Y'); 
		$data['amar'] = '';

		$this->load->model('perkara/kasasi','kasasi');
		$data['listHakim'] = $this->kasasi->getDataHakimMA();
		$data['listPanitera'] = $this->kasasi->getDataPaniteraMA();
		$datakasasi = $this->kasasi->getDatakasasi($idperkara);
		if($datakasasi!=''){
			if($datakasasi->num_rows>0){
				foreach ($datakasasi->result() as $row) {
					$data['idperkara'] = base64_encode($this->encrypt->encode($row->perkara_id));
					$data['noperkarapn'] = $row->nomor_perkara_pn;
					$data['input_area'] = $row->nomor_putusan_kasasi;
					$data['tglpermohonan'] = $this->tanggalhelper->convertDayDate($row->permohonan_kasasi);
					$data['amar'] = $row->amar_putusan_kasasi;
					$data['tanggal'] = $this->tanggalhelper->convertToInputDate($row->putusan_kasasi);
					$data['tgl_arsip'] = $this->tanggalhelper->convertToInputDate($row->minutasi_kasasi);
					$data['tgl_berkas'] = $this->tanggalhelper->convertToInputDate($row->penerimaan_berkas_kasasi);
					$data['tglputusan'] = $this->tanggalhelper->convertToInputDate($row->putusan_pn);
					$data['hakim1'] =$row->hakim1_kasasi_id;
					$data['hakim2'] =$row->hakim2_kasasi_id;
					$data['hakim3'] =$row->hakim3_kasasi_id;
					$data['hakim4'] =$row->hakim4_kasasi_id;
					$data['hakim5'] =$row->hakim5_kasasi_id;
					$data['panitera'] =$row->panitera_pengganti_kasasi_id;
					$data['statusputusan'] =$row->status_putusan_kasasi_id;
				}
			}else{
				show_404();
			}
		}else{
			show_404();
		}
		
		$this->load->library('ckeditor');
		$this->ckeditor->basePath = base_url().'resources/ckeditor/';
		$this->ckeditor->config['toolbar'] = array(
			array('-','Cut','Copy','Paste','PasteText','PasteFromWord',
				'-','Bold', 'Italic', 'Underline','Subscript', 'Superscript',
					'-', 'RemoveFormat','-', 'Blockquote',
					'-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock',
					'-','Undo','Redo','-','NumberedList','BulletedList','/',
					'-','Image'),
			array('-','Format', 'Font', 'FontSize',
				'-','TextColor', 'BGColor','Table',
				'-','Find', 'Replace', '-', 'SelectAll', '-', 'Scayt','-','HorizontalRule',
				'-','Print','Preview'
				));
		$this->ckeditor->config['pasteFromWordNumberedHeadingToList'] = 'true';
		$this->ckeditor->config['pasteFromWordPromptCleanup'] = 'true';
		$this->ckeditor->config['resize'] = 'false';
		$this->ckeditor->config['language'] = 'en';
		$this->ckeditor->config['width'] = '850px';
		$this->ckeditor->config['height'] = '250px';
		$this->load->vars($data);
		$this->load->view('perkara/kasasi/edit_putusan');
	}

	function saveputusan(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Waktu Login Anda telah Berakhir, Silahkan Login Kembali.'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$this->form_validation->set_rules('tanggal', 'Tanggal Putusan Kasasi', 'trim|required|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('input_area', 'Nomor Pengiriman Berkas Kasasi', 'trim|required|xss_clean|min_length[5]');
		#$this->form_validation->set_rules('tgl_arsip', 'Tanggal Pengarsipan Berkas kasasi', 'trim|required|xss_clean|exact_length[10]');
		#$this->form_validation->set_rules('tgl_berkas', 'Tanggal Penerimaan Kembali Berkas kasasi', 'trim|required|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('amar_text', 'Amar Putusan', 'trim|required|xss_clean|min_length[50]');
		$this->form_validation->set_rules('st_putusan', 'Status Putusan', 'trim|required|numeric|xss_clean|');
		
		$idalurperkara = $this->tanggalhelper->getIDAlurPerkara($idperkara);
		if($idalurperkara==118){
			$this->form_validation->set_rules('hakim_tunggal', 'Hakim Tunggal', 'trim|required|xss_clean|');
		}else{
			$this->form_validation->set_rules('hakim_ketua', 'Hakim Ketua', 'trim|required|xss_clean|');
		}

		$this->form_validation->set_rules('panitera', 'Panitera Pengganti', 'trim|required|xss_clean|');
		
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$tanggal = $this->input->post('tanggal',TRUE);
			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			$tanggal = $this->tanggalhelper->convertToMysqlDate($tanggal);
			if($tanggal==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}

			$selisih = $this->tanggalhelper->getSelisihHari($tanggal,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tanggal);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Putusan Kasasi Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$tglPutusanPN = '';
			$this->load->model('perkara/kasasi','kasasi');
			$dataputusan = $this->kasasi->getTanggalPutusan($idperkara);
			if($dataputusan->num_rows>0){
				foreach ($dataputusan->result() as $row) {
					$tglPutusanPN = $row->tanggal_putusan;
				}
			}
		
			if(empty($tglPutusanPN)){
				echo json_encode(array('st'=>0,'msg'=>'Tanggal Putusan Tingkat Pertama Tidak Diketemukan.'));
				return;
			}
			$selisih = $this->tanggalhelper->getSelisihHari($tglPutusanPN,$tanggal);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Putusan Kasasi Tidak Boleh Kurang Dari Tanggal Putusan PN'));
				return;
			}


			$amar = trim($this->input->post('amar_text',TRUE));
			$amar = strip_tags($amar);
			if(strlen($amar)<50){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Amar Putusan Tidak Boleh kurang dari 50 Karakter'));
				return;
			}

			$st_putusan = trim($this->input->post('st_putusan',TRUE));
			if(!is_numeric($st_putusan) OR intval($st_putusan)<1){
				if($st_putusan>4){
					echo json_encode(array('st'=>0,'msg'=>'Status Putusan Tidak Ditemukan.'));
					return;
				}
				echo json_encode(array('st'=>0,'msg'=>'Status Putusan Tidak Ditemukan.'));
				return;
			}
			if($st_putusan==1)
				$st_putusan_text = 'Diperbaiki';
			elseif($st_putusan==2)
				$st_putusan_text = 'Dikuatkan';
			elseif($st_putusan==3)
				$st_putusan_text = 'Dibatalkan';
			elseif($st_putusan==4)
				$st_putusan_text = 'Tidak Diterima';
			elseif($st_putusan==5)
				$st_putusan_text = 'Ditolak';
			
			$datakasasi = array(
				'amar_putusan_kasasi' => $amar,
				'putusan_kasasi' => $tanggal,
				'status_putusan_kasasi_id' => $st_putusan,
				'status_putusan_kasasi_text' => $st_putusan_text,
				'status_kasasi_id' => 490,
				'status_kasasi_text' => 'Putusan Kasasi',
				'nomor_putusan_kasasi' => $this->input->post('input_area',TRUE),
				'nomor_perkara_kasasi' => $this->input->post('input_area',TRUE),
				'diperbaharui_oleh' => $this->session->userdata('username'),
				'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
			);

			$tglArsip = $this->input->post('tgl_arsip',TRUE);
			if(!empty($tglArsip)){
				$tglArsip = $this->tanggalhelper->convertToMysqlDate($tglArsip);
				if($tglArsip==false){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
					return;
				}

				$dayname = $this->tanggalhelper->getDayName($tglArsip);
				if($dayname=='Saturday' OR $dayname=='Sunday'){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Pengarsipan Berkas Kasasi Dihari Libur, Sabtu dan Minggu.'));
					return;
				}

				$selisih = $this->tanggalhelper->getSelisihHari($tanggal,$tglArsip);
				if($selisih<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pengarsipan Berkas Kasasi Tidak Boleh Kurang Dari Tanggal Putusan Kasasi'));
					return;
				}
				$datakasasi['minutasi_kasasi'] = $tglArsip;
			}
			$tglTerimaBerkas = $this->input->post('tgl_berkas',TRUE);
			if(!empty($tglTerimaBerkas)){
				$tglTerimaBerkas = $this->tanggalhelper->convertToMysqlDate($tglTerimaBerkas);
				if($tglTerimaBerkas==false){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
					return;
				}

				$dayname = $this->tanggalhelper->getDayName($tglTerimaBerkas);
				if($dayname=='Saturday' OR $dayname=='Sunday'){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Penerimaan Kembali Berkas Kasasi Dihari Libur, Sabtu dan Minggu.'));
					return;
				}

				$selisih = $this->tanggalhelper->getSelisihHari($tanggal,$tglTerimaBerkas);
				if($selisih<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Penerimaan Kembali Berkas Kasasi Tidak Boleh Kurang Dari Tanggal Putusan Kasasi'));
					return;
				}
				$datakasasi['penerimaan_berkas_kasasi'] = $tglTerimaBerkas;
			}

			$tmpid = '';
			$listHakim = $this->kasasi->getDataHakimMA();
			$hakimtunggal = $this->input->post('hakim_tunggal',TRUE);
			if(!empty($hakimtunggal)){
				$idhakimketua = $this->encrypt->decode(base64_decode($hakimtunggal));
				if(!is_numeric($idhakimketua) OR intval($idhakimketua)<1){
					echo json_encode(array('st'=>0,'msg'=>'Hakim Tunggal Tidak Ditemukan.'));
					return;
				}
				$databanding['hakim1_banding_id'] = $idhakimketua;
				$nama = $this->parseName($listHakim,$idhakimketua);
				if(empty($nama)){
					echo json_encode(array('st'=>0,'msg'=>'Hakim Tunggal Tidak Ditemukan.'));
					return;
				}
				$databanding['hakim1_banding'] = $nama;
				$databanding['majelis_hakim_banding'] = 'Hakim Tunggal : '.$nama;
				$tmpid[0] = $idhakimketua;
			}else{

				$hakim = $this->input->post('hakim_ketua',TRUE);
				if(!empty($hakim)){
					$idhakimketua = $this->encrypt->decode(base64_decode($hakim));
					if(!is_numeric($idhakimketua) OR intval($idhakimketua)<1){
						echo json_encode(array('st'=>0,'msg'=>'Hakim Ketua Tidak Ditemukan.'));
						return;
					}
					$datakasasi['hakim1_kasasi_id'] = $idhakimketua;
					$nama = $this->parseName($listHakim,$idhakimketua);
					if(empty($nama)){
						echo json_encode(array('st'=>0,'msg'=>'Hakim Ketua Tidak Ditemukan.'));
						return;
					}
					$datakasasi['hakim1_kasasi'] = $nama;
					$datakasasi['majelis_hakim_kasasi'] = 'Hakim Ketua : '.$nama;
					$tmpid[0] = $idhakimketua;
				}

				$hakim = $this->input->post('hakim_anggota_1',TRUE);
				if(!empty($hakim)){
					$idhakim1 = $this->encrypt->decode(base64_decode($hakim));
					if(!is_numeric($idhakim1) OR intval($idhakim1)<1){
						echo json_encode(array('st'=>0,'msg'=>'Hakim Anggota 1 Tidak Ditemukan.'));
						return;
					}
					if(empty($idhakimketua)){
						echo json_encode(array('st'=>0,'msg'=>'Hakim Ketua Belum Dipilih.'));
						return;
					}
					$datakasasi['hakim2_kasasi_id'] = $idhakim1;
					$nama = $this->parseName($listHakim,$idhakim1);
					if(empty($nama)){
						echo json_encode(array('st'=>0,'msg'=>'Hakim Anggota 1 Tidak Ditemukan.'));
						return;
					}
					if(in_array($idhakim1, $tmpid)){
						echo json_encode(array('st'=>0,'msg'=>'Duplikasi Data Hakim. Mohon Memilih Hakim Yang Sesuai'));
						return;
					}
					$tmpid[1] = $idhakim1;
					$datakasasi['hakim2_kasasi'] = $nama;
					$datakasasi['majelis_hakim_kasasi'] .= '<br>'.'Hakim Anggota 1 : '.$nama;
				}

				$hakim = $this->input->post('hakim_anggota_2',TRUE);
				if(!empty($hakim)){
					$idhakim2 = $this->encrypt->decode(base64_decode($hakim));
					if(!is_numeric($idhakim2) OR intval($idhakim2)<1){
						echo json_encode(array('st'=>0,'msg'=>'Hakim Anggota 2 Tidak Ditemukan.'));
						return;
					}
					if(empty($idhakimketua)){
						echo json_encode(array('st'=>0,'msg'=>'Hakim Ketua Belum Dipilih.'));
						return;
					}
					if(empty($idhakim1)){
						echo json_encode(array('st'=>0,'msg'=>'Hakim Anggota 1 Belum Dipilih.'));
						return;
					}
					$datakasasi['hakim3_kasasi_id'] = $idhakim2;
					$nama = $this->parseName($listHakim,$idhakim2);
					if(empty($nama)){
						echo json_encode(array('st'=>0,'msg'=>'Hakim Anggota 2 Tidak Ditemukan.'));
						return;
					}
					if(in_array($idhakim2, $tmpid)){
						echo json_encode(array('st'=>0,'msg'=>'Duplikasi Data Hakim. Mohon Memilih Hakim Yang Sesuai'));
						return;
					}
					$tmpid[2] = $idhakim2;
					$datakasasi['hakim3_kasasi'] = $nama;
					$datakasasi['majelis_hakim_kasasi'] .= '<br>'.'Hakim Anggota 2 : '.$nama;
				}

				$hakim = $this->input->post('hakim_anggota_3',TRUE);
				if(!empty($hakim)){
					$idhakim3 = $this->encrypt->decode(base64_decode($hakim));
					if(!is_numeric($idhakim3) OR intval($idhakim3)<1){
						echo json_encode(array('st'=>0,'msg'=>'Hakim Anggota 3 Tidak Ditemukan.'));
						return;
					}
					if(empty($idhakimketua)){
						echo json_encode(array('st'=>0,'msg'=>'Hakim Ketua Belum Dipilih.'));
						return;
					}
					if(empty($idhakim1)){
						echo json_encode(array('st'=>0,'msg'=>'Hakim Anggota 1 Belum Dipilih.'));
						return;
					}
					if(empty($idhakim2)){
						echo json_encode(array('st'=>0,'msg'=>'Hakim Anggota 2 Belum Dipilih.'));
						return;
					}
					$datakasasi['hakim4_kasasi_id'] = $idhakim3;
					$nama = $this->parseName($listHakim,$idhakim3);
					if(empty($nama)){
						echo json_encode(array('st'=>0,'msg'=>'Hakim Anggota 3 Tidak Ditemukan.'));
						return;
					}
					if(in_array($idhakim3, $tmpid)){
						echo json_encode(array('st'=>0,'msg'=>'Duplikasi Data Hakim. Mohon Memilih Hakim Yang Sesuai'));
						return;
					}
					$tmpid[3] = $idhakim3;

					$datakasasi['hakim4_kasasi'] = $nama;
					$datakasasi['majelis_hakim_kasasi'] .= '<br>'.'Hakim Anggota 3 : '.$nama;
				}

				$hakim = $this->input->post('hakim_anggota_5',TRUE);
				if(!empty($hakim)){
					$idhakim4 = $this->encrypt->decode(base64_decode($hakim));
					if(!is_numeric($idhakim4) OR intval($idhakim4)<1){
						echo json_encode(array('st'=>0,'msg'=>'Hakim Anggota 4 Tidak Ditemukan.'));
						return;
					}
					if(empty($idhakimketua)){
						echo json_encode(array('st'=>0,'msg'=>'Hakim Ketua Belum Dipilih.'));
						return;
					}
					if(empty($idhakim1)){
						echo json_encode(array('st'=>0,'msg'=>'Hakim Anggota 1 Belum Dipilih.'));
						return;
					}
					if(empty($idhakim2)){
						echo json_encode(array('st'=>0,'msg'=>'Hakim Anggota 2 Belum Dipilih.'));
						return;
					}
					if(empty($idhakim3)){
						echo json_encode(array('st'=>0,'msg'=>'Hakim Anggota 3 Belum Dipilih.'));
						return;
					}
					$datakasasi['hakim5_kasasi_id'] = $idhakim4;
					$nama = $this->parseName($listHakim,$idhakim4);
					if(empty($nama)){
						echo json_encode(array('st'=>0,'msg'=>'Hakim Anggota 4 Tidak Ditemukan.'));
						return;
					}
					if(in_array($idhakim4, $tmpid)){
						echo json_encode(array('st'=>0,'msg'=>'Duplikasi Data Hakim. Mohon Memilih Hakim Yang Sesuai'));
						return;
					}
					$tmpid[4] = $idhakim4;
					$datakasasi['hakim5_kasasi'] = $nama;
					$datakasasi['majelis_hakim_kasasi'] .= '<br>'.'Hakim Anggota 4 : '.$nama;
				}
			}
			
			$listPanitera = $this->kasasi->getDataPaniteraMA();
			$panitera = $this->input->post('panitera',TRUE);
			if(!empty($panitera)){
				$idpanitera = $this->encrypt->decode(base64_decode($panitera));
				if(!is_numeric($idpanitera) OR intval($idpanitera)<1){
					echo json_encode(array('st'=>0,'msg'=>'Panitera Pengganti Tidak Ditemukan.'));
					return;
				}
				$datakasasi['panitera_pengganti_kasasi_id'] = $idpanitera;
				$nama = $this->parseName($listPanitera,$idpanitera);
				if(empty($nama)){
					echo json_encode(array('st'=>0,'msg'=>'Panitera Pengganti Tidak Ditemukan.'));
					return;
				}
				$datakasasi['panitera_pengganti_kasasi'] = $nama;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Panitera Pengganti Belum Dipilih.'));
				return;
			}

			$result = $this->kasasi->update_data_kasasi($datakasasi,$idperkara);
			if($result==TRUE){
				$this->kasasi->update_proses($idperkara,490,'Putusan Kasasi');
				$this->kasasi->addPerkaraProses($idperkara,490,'Putusan Kasasi',$tanggal);
				$this->kasasi->updatePerkaraProses($idperkara);
				echo json_encode(array('st'=>1,'msg'=>'DATA BERHASIL DISIMPAN.'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'GAGAL MELAKUKAN PENYIMPANAN.'));
				return;
			}
		}
	}

	function parseName($list,$idpihak){
		if($list!=''){
			if($list->num_rows>0){
				foreach ($list->result() as $val) {
					if($val->id==$idpihak){
						return $val->nama_gelar;
					}
				}
			}
		}
		return '';
	}

	function tidakmemenuhisyarat(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$segment = $this->uri->segment_array();
		$data['enc_id'] = $segment[3];
		$data['id'] = $this->encrypt->decode(base64_decode($segment[3]));
		$data['enc'] = $segment[2];
		$idperkara = $this->encrypt->decode(base64_decode($segment[2]));
		if(empty($data['id']) OR intval($data['id'])<1){
			show_404();
		}
		if(empty($idperkara) OR intval($idperkara)<1){
			show_404();
		}

		$data['history'] = base_url(uri_string());
		$data['current_date'] =date('d/m/Y'); 
		$this->load->model('perkara/kasasi','kasasi');
		$data['infopihak'] = $this->kasasi->getPihakkasasi($data['id']);
		$this->load->vars($data);
		$this->load->view('perkara/kasasi/tms_permohonan_kasasi');
	}

	function savetms(){
		if(empty($_POST)){
			show_404();
		}

		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Waktu Login Anda telah Berakhir, Silahkan Login Kembali.'));
			return;
		}

		$id = $this->encrypt->decode(base64_decode($this->input->post('enc_id',TRUE)));
		if(empty($id) OR intval($id)<1){
			echo json_encode(array('st'=>0,'msg'=>'Permohonan Kasasi Tidak Ditemukan.'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}

		$this->form_validation->set_rules('tgl_tms', 'Tanggal Perkara Dinyatakan Tidak Memenuhi Syarat', 'trim|required|xss_clean|exact_length[10]');
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$tglTMS = $this->input->post('tgl_tms',TRUE);
			$curr_date = date('Y-m-d');
			$todayDate = date('d/m/Y');

			$tglTMS = $this->tanggalhelper->convertToMysqlDate($tglTMS);
			if($tglTMS==false){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Format Tanggal Tidak Benar. Format tanggal hari/bulan/tahun. Contoh 20/01/2015.'));
				return;
			}
			
			$selisih = $this->tanggalhelper->getSelisihHari($tglTMS,$curr_date);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Tidak Boleh Melebihi Hari ini. Hari ini Tanggal,'.$todayDate));
				return;
			}

			$dayname = $this->tanggalhelper->getDayName($tglTMS);
			if($dayname=='Saturday' OR $dayname=='Sunday'){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Pencabutan Dihari Libur, Sabtu dan Minggu.'));
				return;
			}

			$tglPutusanPN = '';
			$this->load->model('perkara/kasasi','kasasi');
			$dataputusan = $this->kasasi->getTanggalPutusan($idperkara);
			if($dataputusan->num_rows>0){
				foreach ($dataputusan->result() as $row) {
					$tglPutusanPN = $row->tanggal_putusan;
				}
			}
			

			$selisih = $this->tanggalhelper->getSelisihHari($tglPutusanPN,$tglTMS);
			if($selisih<0){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Pencabutan Tidak Boleh Kurang Dari Tanggal Putusan PN'));
				return;
			}

			
			$datapihak = array(
				'tidak_memenuhi_syarat' => $tglTMS,
				'catatan_putusan_kasasi' => $this->input->post('keterangan',TRUE),
				'diperbaharui_oleh' => $this->session->userdata('username'),
				'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
			);
			$result = $this->kasasi->update_data($datapihak,$id);

			$datakasasi = $this->kasasi->getPihakkasasi($id);
			$idstatus = '';
			$urutan ='';
			if($datakasasi->num_rows>0){
				foreach ($datakasasi->result() as $row) {
					$idstatus = $row->status_pihak_id;
					$urutan = $row->urutan_kasasi;
				}
			}
			if(!empty($idstatus) AND !empty($urutan)){
				if($idstatus==1 AND $urutan==1){
					$datapihak = array(
						'tidak_memenuhi_syarat' => $tglTMS,
						'status_kasasi_id' => 492,
						'minutasi_kasasi' => $tglTMS,
						'status_kasasi_text' => 'Perkara Tidak Memenuhi Syarat Formil',
						'diperbaharui_oleh' => $this->session->userdata('username'),
						'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
					);
					$result = $this->kasasi->update_data_kasasi($datapihak,$idperkara);
				}
			}
			if($result==TRUE){
				$this->kasasi->update_proses($idperkara,492,'Perkara Tidak Memenuhi Syarat Formil');
				$this->kasasi->addPerkaraProses($idperkara,492,'Perkara Tidak Memenuhi Syarat Formil',$tglTMS);
				$this->kasasi->updatePerkaraProses($idperkara);
				echo json_encode(array('st'=>1,'msg'=>'DATA BERHASIL DISIMPAN.'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'GAGAL MELAKUKAN PENYIMPANAN.'));
				return;
			}
		}
	}

	function confirmationhapusperkara(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$segment = $this->uri->segment_array();		
		$data['enc'] = $segment[2];
		$idperkara = $this->encrypt->decode(base64_decode($segment[2]));
		if(empty($idperkara) OR intval($idperkara)<1){
			show_404();
		}

		$this->load->model('perkara/kasasi','kasasi');
		$data['infomediasi'] = $this->kasasi->dataJadwalMediasi($idperkara);
		$this->load->vars($data);
		$this->load->view('perkara/kasasi/hapus_permohonan_kasasi');
	}

	function hapuspermohonan(){
		try {
			if(empty($_POST)){
				show_404();
			}

			if($this->session->userdata('is_logged_in')==FALSE){
				echo json_encode(array('st'=>0,'msg'=>'Waktu Login Anda telah Berakhir, Silahkan Login Kembali.'));
				return;
			}

			$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
			if(!is_numeric($idperkara) OR intval($idperkara)<1){
				echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
				return;
			}
			$idmediasi = $this->encrypt->decode(base64_decode($this->input->post('idmediasi',TRUE)));
			if(!empty($idmediasi)){
				if(!is_numeric($idmediasi) OR intval($idmediasi)<1){
					echo json_encode(array('st'=>0,'msg'=>'Jadwal Mediasi Tidak Ditemukan.'));
					return;
				}			
			}
			$this->load->model('perkara/kasasi','kasasi');
			$result = $this->kasasi->deletePermohonan($idperkara,$idmediasi);			
			#$this->kasasi->deletePerkaraProses($idperkara,410);
			if($result==TRUE){
				echo json_encode(array('st'=>1,'msg'=>'DATA BERHASIL DIHAPUS.'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'GAGAL MELAKUKAN PENGHAPUSAN.'));
				return;
			}
		} catch (Exception $e) {
			
		}
	}
	/*06-12-2016*/
	function hapus_putusan_kasasi(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		if(!is_numeric($idperkara) OR intval($idperkara)<1){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}
		$this->load->model('perkara/kasasi','kasasi');
		$tgl_pemberitahuan = $this->kasasi->getInfoTglPemberitahuanPts($idperkara);
		if(!empty($tgl_pemberitahuan)){
			echo json_encode(array('st'=>0,'msg'=>'Data Putusan Tidak Bisa Dihapus, Tanggal Pemberitahuan Putusan Kasasi Sudah Diisi. Hapus dulu tanggal pemberitahuan putusan kasasi'));
			return;			
		}

		$datakasasi = array(
				'putusan_kasasi' => NULL,
				'nomor_perkara_kasasi' => NULL,
				'nomor_putusan_kasasi' => NULL,
				'status_putusan_kasasi_id' => NULL,
				'status_putusan_kasasi_text' => NULL,
				'amar_putusan_kasasi' => NULL,
				'hakim1_kasasi_id' => NULL,
				'hakim1_kasasi' => NULL,
				'hakim2_kasasi_id' => NULL,
				'hakim2_kasasi' => NULL,
				'hakim3_kasasi_id' => NULL,
				'hakim3_kasasi' => NULL,
				'hakim4_kasasi_id' => NULL,
				'hakim4_kasasi' => NULL,
				'hakim5_kasasi_id' => NULL,
				'hakim5_kasasi' => NULL,
				'majelis_hakim_kasasi' => NULL,
				'panitera_pengganti_kasasi_id' => NULL,
				'panitera_pengganti_kasasi' => NULL,
				'minutasi_kasasi' => NULL,
				'penerimaan_berkas_kasasi' => NULL,
				'diperbaharui_oleh' => $this->session->userdata('username'),
				'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())				
			);
		
		if($this->kasasi->hapus_putusan($idperkara,$datakasasi)){			
			echo json_encode(array('st'=>1,'msg'=>'Penghapusan Data Putusan Kasasi Berhasil'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'));
			return;
		}
	}
	
	
	
	 function editpengantar(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}
		$segment = $this->uri->segment_array();
		$data['enc_id'] = $segment[3];
		$data['id'] = $this->encrypt->decode(base64_decode($segment[3]));
		$data['enc'] = $segment[2];
		$data['history'] = base_url(uri_string());
		$idperkara = $this->encrypt->decode(base64_decode($segment[3]));
		if(empty($data['id']) OR intval($data['id'])<1){
			show_404();
		}
		if(empty($idperkara) OR intval($idperkara)<1){
			show_404();
		}
		$func = $segment[4];
		if(empty($func) OR intval($func)<1){
			show_404();
		}
		$data['enc_func'] = base64_encode($this->encrypt->encode($segment[4]));
		//$this->load->model('perkara/dirput','dirput');
		//Sdata['pengantar'] = $this->dirput->ambil_pengantar($perkara_id,2);
		$data['history'] = base_url(uri_string());
		$data['current_date'] =date('d/m/Y'); 
		$this->load->vars($data);
		$this->load->view('perkara/kasasi/edit_pengantar');
	}
	
	
	
	
	function simpan_katapengantar() {
		
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Waktu Login Anda telah Berakhir, Silahkan Login Kembali.'));
			return;
		}

		$perkara_id = $this->session->userdata('perkaraid');
		//echo "data :".$perkara_id;exit;
		//$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
		// if(!is_numeric($this=>session->userdata('perkaraid')) OR intval($this=>session->userdata('perkaraid'))<1){
			// echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			// return;
		// }

		// $func = $this->encrypt->decode(base64_decode($this->input->post('enc_func',TRUE)));
		// if(empty($func) OR intval($func)<1){
			// echo json_encode(array('st'=>0,'msg'=>'Something Wrong With Your Data.'));
			// return;
		//}

       		
		$this->form_validation->set_rules('tanggal_surat', 'Tanggal surat pengantar', 'trim|required|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('nomor_surat', 'Nomor surat pengantar', 'trim|required|xss_clean|min_length[5]');
    	$this->form_validation->set_rules('nomer_resi', 'Nomor resi PT.Pos', 'trim|required|xss_clean');
       	
		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		} else {
			
			$nomor_surat=$this->input->post('nomor_surat');
			$tanggal_surat=$this->input->post('tanggal_surat');
			$no_resi=$this->input->post('nomer_resi');
			//$this->load->model('perkara/dirput','dirput');		      			
			$this->load->model('api/dirput_model','dirput');
			
			//get nomor perkara		
			//$noperk=$this->dirput->ambil_nomor_perkara($perkara_id)->row();
			$noperk=$this->dirput->ambil_nomor_perkara($perkara_id)->row();
			$nomor_perkara=$noperk->nomor_perkara;
			$id =$this->dirput->ambil_maxid_pengantar()->row();
			$id=$id+1;
			//insert data	
			$data_pengantar = array(
						'id' => $id,
						'perkara_id' => $perkara_id,
						'nomor_perkara' => $nomor_perkara,
						'nomor_surat_pengantar' => $nomor_surat,
						'tgl_surat_pengantar' => $this->tanggalhelper->convertToMysqlDate($tanggal_surat),
						'no_resi_pos' => $no_resi,
						'pengajuan_id'=> 3
					);		
			
					
			$result=$this->dirput->simpan_pengantar($data_pengantar);
			
			if ($result==TRUE) {
					echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
					}else{
						echo json_encode(array('st'=>0,'msg'=>'Data Tidak Tersimpan'));
					}	
			
		return;	
			
			
		}
	
	
	
	}
	
	
	/*
	function upload_pengantar () {
			
			if(empty($_POST)){
			show_404();
		}

		
		$perkara_id = $this->session->userdata('perkaraid'); 
		//$this->load->model('perkara/dirput','dirput');
          $this->load->model('api/dirput_model','dirput'); 		
		//upload file_surat_pengantar
			$perkara_id = $this->session->userdata('perkaraid');	
			//$noperk=$this->dirput->ambildata_dirput($perkara_id)->row();
			$noperk = $this->dirput->create_dirput($perkara_id);
			$nomor_perkara	= trim($noperk[0]['nomor_perkara']);
			$nomor_perkara	= str_replace("/", "_", $nomor_perkara);
			$nomor_perkara	= str_replace(" ", "_", $nomor_perkara);
			$nomor_perkara	= str_replace(".", "_", $nomor_perkara);
			$direktori      ="resources/direktori_putusan/kasasi/".$nomor_perkara."/surat_pengantar/";			
		   	$nama_file_ori  = $_FILES['edoc_pengantar']['name'];
			$extension	    = pathinfo($nama_file_ori);
			$ektensi_file	= $extension['extension'];	
			$namafile	    = "surat_pengantar".'_'.'kasasi_'.$nomor_perkara.'.'.$ektensi_file;
			$path_namafile	= $direktori.$namafile; 
		
			try {			
			chmod($direktori, 0777);
			@mkdir($direktori,0777,true);	
			
			} catch (Exception $e) {
				echo json_encode(array('st'=>0,'msg'=>'E-Doc TIDAK Berhasil Disimpan.'));
				return;
			}
			
						
			$upload_config = array(
			'upload_path' => $direktori,
			'allowed_types' => 'pdf|zip|rar',
			'max_size' => '10240',
			'overwrite' => true,
			'file_name' =>$namafile);
			
			$this->upload->initialize($upload_config);
			$this->load->library('upload', $upload_config);			

			if (!$this->upload->do_upload('edoc_pengantar')){		
				
				echo json_encode(array('st'=>0,'msg'=>'E-Doc Tidak Berhasil Disimpan. '.$this->upload->display_errors('<span>', '</span>')));
				return;
			 }else{
				
			   //ambil pihakid
			   $idpihak=$this->dirput->ambil_pihak_kasasi_detil($perkara_id)->row();
			   $pihakid=$idpihak->id;
			  
			   //ambil_id
			   $ids = $this->dirput->ambil_maxid()->row();
			   $id = $ids->max_id+1;
				
				//update path file ke database
				 
				 $data_dokumen = array(
						'id' => $id,
						'perkara_id' => $perkara_id,
						'dokumen_ref_id' => 113, //doc_ref surat pengatar kaasasi
						'filename' => $namafile,
						'path_filename' => $path_namafile,
						'created_by' => $this->session->userdata('username'),
						'created_date' => date("Y-m-d h:i:s",time()),
						'pihak_detil_id' => $pihakid
					);	
				
					
                $this->dirput->simpan_doc($data_dokumen);
				echo json_encode(array('st'=>1,'msg'=>'DATA Berhasil Disimpan.'));
				return;
			}
				
					
		
	}
	 */
 	
	
	
	
}