<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Detil_biaya_ht extends CI_Controller {
	function index(){
		$data['ht_id'] = $this->nativesession->get_flash_session('ht_id');
		if(empty($data['ht_id']) OR intval($data['ht_id'])<0){
			show_404();
		}

		$this->load->model('biaya_perkara/biaya_perkara_m_ht','biaya_perkara_m');
		$tahapanidperkara=51;
		$alurperkaraid=0;
		$data['biaya_perkara']=$this->biaya_perkara_m->get_jurnal_biaya_perkara($data['ht_id'],$tahapanidperkara);
		
		$data['page_title'] = 'BUKU JURNAL KEUANGAN PERKARA EKSEKUSI HAK TANGGUNGAN';	

		$data['data_perkara'] = $this->biaya_perkara_m->data_perkara($data['ht_id']);
		$data['back']=$this->nativesession->get('main_url_requested');
		$data['main_body'] = 'jurnal_perkara/jurnal_biaya_ht';
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body_new');
	}

	function form_add_biaya(){
		$segment = $this->uri->segment_array();
		$enc = $this->uri->segment(2);
		$htid = $this->encrypt->decode(base64_decode($enc));
		$api = $this->uri->segment(3);
		$alur_perkara = $this->encrypt->decode(base64_decode($api));
		$idbiayatmp = $this->uri->segment(4);
		$idbiayaperkara = $this->encrypt->decode(base64_decode($idbiayatmp));
		$aksitmp = $this->uri->segment(5);
		$aksi = $this->encrypt->decode(base64_decode($aksitmp));
		
		$this->tampil_form_add_biaya($htid,$alur_perkara,$idbiayaperkara,$aksi);
		


	}

	function tampil_form_add_biaya($htid,$alur_perkara,$idbiayaperkara,$aksi){
		$data['ht_id']=base64_encode($this->encrypt->encode($htid));
		$data['alur_perkara']=base64_encode($this->encrypt->encode($alur_perkara));
		$data['tahapan']=51;
		$data['aksi']='';
		$data['idbiayaperkara']='';
		$data['id_kategori_biaya']='';
		$data['id_jenis_biaya']='';
		$data['tgl_sekarang'] = date('d/m/Y');
		$tahapan=50;
		
		// $data['previous'] = $this->nativesession->get_flash_session('url_requested');
		
		$this->load->model('biaya_perkara/biaya_perkara_m_ht','biaya');
		$data['data_perkara'] = $this->biaya->data_perkara($data['ht_id']);
		$data['data_kategori_biaya'] = $this->biaya->get_kategori_biaya();
		$data['data_jenis_biaya'] = $this->biaya->get_jenis_biaya($tahapan);

		if($idbiayaperkara!=''){
			$result_data_biaya = $this->biaya->get_data_edit_biaya($idbiayaperkara);
			if($result_data_biaya!=''){
				if($result_data_biaya->num_rows()>0){
					foreach ($result_data_biaya->result() as $row) {
						$data['idbiayaperkara'] = base64_encode($this->encrypt->encode($row->id));
						$data['tgl_transaksi'] = $row->tanggal_transaksi;
						$data['id_kategori_biaya'] = $row->kategori_id;
						$data['id_jenis_biaya'] = $row->jenis_biaya_id;
						$data['jumlah'] = $row->jumlah;
						$data['uraian'] = $row->uraian;
						$data['keterangan'] = $row->keterangan;
						$data['aksi'] = base64_encode($this->encrypt->encode($aksi));
					}
				}else{
					$this->error_page->show_error_msg('Error Found','Tidak ada ID Biaya');
					exit();
				}
			}else{
				$this->error_page->show_error_msg('Error Found','Something the right happen. ID pada Perkara Biaya Not Found');
				exit();
			}
		}

		if($htid!=''){
		$result_data_perkara = $this->biaya->data_perkara($htid);
		if($result_data_perkara!=''){
			if($result_data_perkara->num_rows()>0){
				foreach ($result_data_perkara->result() as $row) {
					$data['eksekusi_nomor_perkara'] = $row->eksekusi_nomor_perkara;
					$data['permohonan_eksekusi'] = $row->permohonan_eksekusi;
					$data['pemohon_eksekusi'] = $row->pemohon_eksekusi;
					$data['prodeo'] = $row->prodeo_eksekusi;
					$data['alur_perkara_id'] = $row->alur_perkara_id;
					
				}
			}else{
				$this->error_page->show_error_msg('Error Found','Tidak ada Perkara');
				exit();
			}
		}else{
			$this->error_page->show_error_msg('Error Found','Something the right happen. Perkada ID Not Found');
			exit();
		}
		}


		$this->load->vars($data);
		$this->load->view('jurnal_perkara/add_biaya_form_ht');
	}

	function validateInput(){
		if(empty($_POST)){
			show_404();
		}


		$this->form_validation->set_rules('tgl_transaksi', 'Tanggal Transaksi', 'trim|required|xss_clean|exact_length[10]');
		$this->form_validation->set_rules('kategori_biaya', 'Kategori Biaya', 'trim|required|xss_clean');
		$this->form_validation->set_rules('jenis_biaya', 'Jenis Biaya', 'trim|required|xss_clean');		
		$this->form_validation->set_rules('uraian', 'Uraian', 'trim|required|xss_clean');
		$this->form_validation->set_rules('jumlah', 'Jumlah', 'trim|required|xss_clean');
		$this->form_validation->set_rules('keterangan', 'Keterangan', 'trim|xss_clean');
		$this->form_validation->set_rules('idbiayaperkara', 'ID Biaya Perkara', 'trim|xss_clean');
		$this->form_validation->set_rules('aksi', 'Aksi', 'trim|xss_clean');

		if ($this->form_validation->run() === FALSE){
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'.validation_errors()));
			return;
		}else{
			$htid = $this->encrypt->decode(base64_decode($this->input->post('ht_id',TRUE)));
			$alur_perkara = $this->encrypt->decode(base64_decode($this->input->post('alur_perkara_id',TRUE)));
			$tahapan = $this->encrypt->decode(base64_decode($this->input->post('tahapan_terakhir_id',TRUE)));
			
			$idbiayaperkara=$this->encrypt->decode(base64_decode($this->input->post('idbiayaperkara',TRUE)));
			$aksi= $this->encrypt->decode(base64_decode($this->input->post('aksi',TRUE)));


			if(!is_numeric($htid)){
				echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil Perkara Tidak ditemukan. Code Error = 194.'));
				return;
			}else{

				
				$this->load->model('biaya_perkara/biaya_perkara_m_ht','biaya');

				$detil_pembiayaan=$this->biaya->get_detil_biaya($htid);
				foreach ($detil_pembiayaan->result() as $row) {
					$id_pembiayaan=$row->id_pembiayaan;
				}
				$idpembiayaan=$id_pembiayaan;

				$id_jenis_biaya=$this->input->post('jenis_biaya',TRUE);

				$detil_jenis_biaya=$this->biaya->get_detil_jenis_biaya($id_jenis_biaya);
				foreach ($detil_jenis_biaya->result() as $row) {
					$jenis_transaksi=$row->jenis_transaksi;
				}
				$jenistransaksi=$jenis_transaksi;

				$maxid=$this->biaya->get_maxid_perkara_biaya();
				foreach ($maxid->result() as $row) {
					$maxid_perkara_biaya=$row->maxid;
				}
				$id_perkara_biaya=$maxid_perkara_biaya;

				$curr_date = date('Y-m-d');
				$todayDate = date('m/d/Y');
				
				$tgl_transaksi = $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_transaksi',TRUE));
				
				$selisih = $this->tanggalhelper->getSelisihHari($tgl_transaksi,$curr_date);
				if($selisih<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal Transaksi Tidak Boleh Melebihi Hari Ini. Hari ini Tanggal '.$todayDate));
					return;
				}

				$dayname = $this->tanggalhelper->getDayName($tgl_transaksi);
				if($dayname=='Saturday' OR $dayname=='Sunday'){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Dapat Memilih Tanggal Transaksi Dihari Libur, Sabtu dan Minggu.'));
					return;
				}

				$tgl_pendaftaran = $this->input->post('tanggal_pendaftaran',TRUE);
				$selisih = $this->tanggalhelper->getSelisihHari($tgl_pendaftaran,$tgl_transaksi);
				if($selisih<0){
					echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tanggal transaksi tidak boleh kurang dari tanggal permohonan '));
					return;
				}


				$jumlah_biaya = str_replace('.','',$this->input->post('jumlah',TRUE));
				$data = array(
						'id' => $id_perkara_biaya,
						'id_pembiayaan' => $idpembiayaan,
						'ht_id' => $htid,
						'tahapan_id' => 51,
						'kategori_id' => $this->input->post('kategori_biaya',TRUE),
						'jenis_biaya_id' => $id_jenis_biaya,
						'jenis_transaksi' => $jenistransaksi,
						'urutan' => 0,
						'sisa' => 0,
						'tanggal_transaksi' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_transaksi',TRUE)),
						'uraian' => $this->input->post('uraian',TRUE),
						'jumlah' => $jumlah_biaya,
						'keterangan' => $this->input->post('keterangan',TRUE),
						'diinput_oleh' => $this->session->userdata('username'),
						'diinput_tanggal' => date("Y-m-d h:i:s",time())
					);

				$data_edit = array(
						'kategori_id' => $this->input->post('kategori_biaya',TRUE),
						'jenis_biaya_id' => $id_jenis_biaya,
						'jenis_transaksi' => $jenistransaksi,
						'urutan' => 0,
						'sisa' => 0,
						'tanggal_transaksi' => $this->tanggalhelper->convertToMysqlDate($this->input->post('tgl_transaksi',TRUE)),
						'uraian' => $this->input->post('uraian',TRUE),
						'jumlah' => $jumlah_biaya,
						'keterangan' => $this->input->post('keterangan',TRUE),
						'diperbaharui_oleh' => $this->session->userdata('username'),
						'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
					);

				
				if($aksi==''){
						$result = $this->biaya->add_perkara_biaya($data);
				}elseif($aksi=='edit'){
						$result = $this->biaya->edit_perkara_biaya($data_edit,$idbiayaperkara);
				}

				if($result===FALSE){
					echo json_encode(array('st'=>0,'msg'=>'GAGAL Menyimpan'));
					return;
				}
				echo json_encode(array('st'=>1,'msg'=>'sukses'));
				return;
			}
		}
	}

	function hapus_perkara_biaya_ht(){
		if(empty($_POST)){
			show_404();
		}
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}

		$idbiayaperkara = $this->encrypt->decode(base64_decode($this->input->post('idbiayaperkara')));
		if(!is_numeric($idbiayaperkara) OR !intval($idbiayaperkara)>0){
			echo json_encode(array('st'=>0,'msg'=>'Tidak ditemukan biaya yang dihapus.'));
			return;
		}
		
		$this->load->model('biaya_perkara/biaya_perkara_m_ht','biaya');
		if($this->biaya->hapus_perkara_biaya_ht($idbiayaperkara)){
			echo json_encode(array('st'=>1,'msg'=>'Biaya telah dihapus'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br /> Tidak Berhasil'));
			return;
		}
	}	

}