<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class db_configuration extends CI_Controller {
	function index($error=''){
		if ( ! file_exists($file_path = APPPATH.'config/config.ini')){
			show_error('The configuration file does not exist, Contact SIPP Team.');
		}
		$data['error'] = $error;
		$this->nativesession->set_flash_session('is_login_config', FALSE);
		$this->load->view('sistem/logindbconfig',$data,false);
	}

	function validateLogin(){
		if(empty($_POST)){
			show_404();
		}

		$passwd = $this->input->post('password',TRUE);
		if(empty($passwd)){
			show_404();
		}
		$params = parse_login_pass();

		$givenpass = hash("sha512", $passwd);

		is_config_file_exist();
		$data['showmsg'] =0;
		if(!validateFilePermission()){
			$data['showmsg'] = 1;
		}
		if(trim($givenpass)===trim($params['passwd'])){
			if(trim($givenpass)==="859740ba7c8a711a7e4c24f0e39aefe55dbcff688fef5e222f0f6a7e175a8543dda7a600e4ea0cf38b74b8a4f40128a5b2a25318516f326f7f3b2c19ccb49971"){
				$this->nativesession->set_flash_session('is_login_config', TRUE);
				$this->load->view('sistem/changelogin',$data,false);
			}else{
				$this->nativesession->set_flash_session('is_login_config', TRUE);
				$this->load->view('sistem/dbconfig',$data,false);
			}
		}else{
			$this->index('Password Yang Anda Masukan Salah');
		}
	}

	function changePasswordConfig(){
		$is_login_config = $this->nativesession->get_flash_session('is_login_config');
		if($is_login_config){
			is_config_file_exist();
			$data['showmsg'] =0;
			if(!validateFilePermission()){
				$data['showmsg'] = 1;
			}
			$this->load->view('sistem/changelogin',$data,false);
		}else{
			show_404();
		}
	}
	function saveLogin(){
		if(empty($_POST)){
			show_404();
		}
		$oldpass = $this->input->post('old_password',TRUE);
		$oldpass = hash("sha512", $oldpass);
		
		$newpass = $this->input->post('new_password',TRUE);
		$repeatpass = $this->input->post('retype_password',TRUE);
		$params = parse_login_pass();
		if($oldpass===$params['passwd']){
			if($newpass===$repeatpass){
				$newpass = hash("sha512", $newpass);
				$result = save_passwd($newpass);
				if($result==true){
					echo json_encode(array('st'=>1,'msg'=>'New Password Berhasil Disimpan.'));
					return;
				}else{
					echo json_encode(array('st'=>0,'msg'=>'<font color="red">Error, Password Gagal Disimpan. Check File Permission, Please Contact IT PT OR SIPP Team.</font>'));
					return;
				}
			}else{
				echo json_encode(array('st'=>0,'msg'=>'Tolong, Ketik Password yang sama untuk validasi.'));
				return;
			}
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Password Lama Anda Salah. Silahkan Coba Kembali'));
			return;
		}
	}

	function saveDBConfig(){
		if(empty($_POST)){
			show_404();
		}

		$host = $this->input->post('server_utama',TRUE);
		if(empty($host)){
			echo json_encode(array('st'=>0,'msg'=>'Error. Alamat Server Tidak Boleh Kosong. Silahkan isi localhost untuk settingan default'));
			return;
		}
		$username = $this->input->post('user_utama',TRUE);
		if(empty($username)){
			echo json_encode(array('st'=>0,'msg'=>'Error. Username Tidak Boleh Kosong.'));
			return;
		}
		$pass = $this->input->post('passwd_utama',TRUE);
		
		if(empty($pass)){
			echo json_encode(array('st'=>0,'msg'=>'Error. Password Tidak Boleh Kosong. Tidak dibenarkan menginstall MySQL Database Tanpa Password'));
			return;
		}
		$dbname = $this->input->post('db_utama',TRUE);
		
		if(empty($dbname)){
			echo json_encode(array('st'=>0,'msg'=>'Error. Database Tidak Boleh Kosong.'));
			return;
		}
		$conn = connecting_test($host,$username,$pass,$dbname);
		if($conn!=TRUE){
			echo json_encode(array('st'=>0,'msg'=>'Error. Tidak Dapat Terhubung dengan Database. '.$conn));
			return;
		}else{
			$host = encryp($this->input->post('server_utama',TRUE));
			$username = encryp($this->input->post('user_utama',TRUE));
			$pass = encryp($this->input->post('passwd_utama',TRUE));
			$dbname = encryp($this->input->post('db_utama',TRUE));
			$save = update_conf($host,$username,$pass,$dbname);
			if($save==true){
				echo json_encode(array('st'=>1,'msg'=>'Database Configuration Berhasil Disimpan.'));
				return;
			}else{
				echo json_encode(array('st'=>0,'msg'=>'<font color="red">Error, Database Configuration Gagal Disimpan. Check File Permission, Please Contact IT PT OR SIPP Team.</font>'));
				return;
			}
		}
	}

	function testconnection(){
		if(empty($_POST)){
			show_404();
		}

		$host = $this->input->post('server_utama',TRUE);
		if(empty($host)){
			echo json_encode(array('st'=>0,'msg'=>'Error. Alamat Server Tidak Boleh Kosong. Silahkan isi localhost untuk settingan default'));
			return;
		}
		$username = $this->input->post('user_utama',TRUE);
		if(empty($username)){
			echo json_encode(array('st'=>0,'msg'=>'Error. Username Tidak Boleh Kosong.'));
			return;
		}
		$pass = $this->input->post('passwd_utama',TRUE);
		
		if(empty($pass)){
			echo json_encode(array('st'=>0,'msg'=>'Error. Password Tidak Boleh Kosong. Tidak dibenarkan menginstall MySQL Database Tanpa Password'));
			return;
		}
		$dbname = $this->input->post('db_utama',TRUE);
		
		if(empty($dbname)){
			echo json_encode(array('st'=>0,'msg'=>'Error. Database Tidak Boleh Kosong.'));
			return;
		}
		$conn = connecting_test($host,$username,$pass,$dbname);
		if($conn===TRUE){
			echo json_encode(array('st'=>1,'msg'=>'Test Koneksi Berhasil'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Error. Tidak Dapat Terhubung dengan Database. '.$conn));
			return;
		}
	}
}