<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class data_persidangan_c extends CI_Controller {
//==== section : pemanggilan view ====
	//dipake : redirect_popup.php
	function menu_persidangan(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}

		$data['curr_date'] = date('d/m/Y');
		$data['idjadwal']=$this->nativesession->get_flash_session('encjadwalsidang');
		$data['enc']=$this->nativesession->get_flash_session('enc');
		$data['act']='';//dipakai di menu_persidangan_diversi

		$idjadwal=$this->encrypt->decode(base64_decode($data['idjadwal']));
        if(!is_numeric($idjadwal) OR !intval($idjadwal)>0){
            show_404();
            exit();
        }

		$idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }
        $data['alur_perkara_id']=$this->tanggalhelper->getIDAlurPerkara($idperkara);
        $data['previous']=base64_encode($this->encrypt->encode(current_url()));
		$this->load->view('data_persidangan/menu_persidangan_v',$data);
	}

	function menu_persidangan_diversi(){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}

		$data['curr_date'] = date('d/m/Y');
		$data['idjadwal']=$this->nativesession->get_flash_session('encjadwaldiversi');
		$data['enc']=$this->nativesession->get_flash_session('enc');
		$data['act']=$this->nativesession->get_flash_session('action');		

		$idjadwal=$this->encrypt->decode(base64_decode($data['idjadwal']));
        if(!is_numeric($idjadwal) OR !intval($idjadwal)>0){
            show_404();
            exit();
        }

		$idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }
        $data['alur_perkara_id']=$this->tanggalhelper->getIDAlurPerkara($idperkara);
        $data['previous']=base64_encode($this->encrypt->encode(current_url()));
		$this->load->view('data_persidangan/menu_persidangan_v',$data);
	}
	
	//dipake : menu_persidangan_v.php
	function keterangan_saksi($enc=null,$idjadwal=null,$previous=null){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}

		$data['curr_date'] = date('d/m/Y');
		$data['idjadwal']=$idjadwal;
		$data['enc']=$enc;
		$this->load->model('jadwalsidang/jadwal_sidang_m');

		$idjadwal=$this->encrypt->decode(base64_decode($idjadwal));
        if(!is_numeric($idjadwal) OR !intval($idjadwal)>0){
            show_404();
            exit();
        }

		$idperkara=$this->encrypt->decode(base64_decode($enc));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }
        $data['alur_perkara_id'] = $this->tanggalhelper->getIDAlurPerkara($idperkara);
        $data['list_amar'] = $this->jadwal_sidang_m->getTemplateAmar(); 
        $data['prev']=$this->encrypt->decode(base64_decode($previous));
        $data['jml_hakim']=$this->jadwal_sidang_m->jumlah_hakim($idperkara);
        $data['saksi']=$this->jadwal_sidang_m->data_saksi($idperkara);
		$data['namahalaman']="KETERANGAN SAKSI";
		$this->load->view('data_persidangan/keterangan_saksi_v',$data);
	}

	//dipake : menu_persidangan_v.php
	function pendapat_terdakwa($enc=null,$idjadwal=null,$previous=null){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}

		$data['curr_date'] = date('d/m/Y');
		$data['idjadwal']=$idjadwal;
		$data['enc']=$enc;
		$this->load->model('jadwalsidang/jadwal_sidang_m');

		$idjadwal=$this->encrypt->decode(base64_decode($idjadwal));
        if(!is_numeric($idjadwal) OR !intval($idjadwal)>0){
            show_404();
            exit();
        }

		$idperkara=$this->encrypt->decode(base64_decode($enc));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }

        $data['prev']=$this->encrypt->decode(base64_decode($previous));
        // $data['jml_hakim']=$this->jadwal_sidang_m->jumlah_hakim($idperkara);
        $data['saksi']=$this->jadwal_sidang_m->data_saksi($idperkara);
        $data['terdakwa']=$this->jadwal_sidang_m->data_terdakwa($idperkara);
		$data['namahalaman']="PENDAPAT TERDAKWA";
		$this->load->view('data_persidangan/pendapat_terdakwa_v',$data);
	}

	//dipake : menu_persidangan_v.php
	function pemeriksaan_terdakwa($enc=null,$idjadwal=null,$previous=null){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}

		$data['curr_date'] = date('d/m/Y');
		$data['idjadwal']=$idjadwal;
		$data['enc']=$enc;
		$this->load->model('jadwalsidang/jadwal_sidang_m');

		$idjadwal=$this->encrypt->decode(base64_decode($idjadwal));
        if(!is_numeric($idjadwal) OR !intval($idjadwal)>0){
            show_404();
            exit();
        }

		$idperkara=$this->encrypt->decode(base64_decode($enc));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }

        $data['prev']=$this->encrypt->decode(base64_decode($previous));
        $data['jml_hakim']=$this->jadwal_sidang_m->jumlah_hakim($idperkara);
        $data['terdakwa']=$this->jadwal_sidang_m->data_terdakwa($idperkara);
		$data['namahalaman']="PEMERIKSAAN TERDAKWA";
		$this->load->view('data_persidangan/pemeriksaan_terdakwa_v',$data);
	}


	//dipake : menu_persidangan_v.php
	function data_persidangan_template($enc=null,$idjadwal=null,$jenis_data){
		if($this->session->userdata('is_logged_in')==FALSE){
			redirect('login');
		}

		$data['idjadwal']=$idjadwal;
		$data['enc']=$enc;
		$this->load->model('jadwalsidang/jadwal_sidang_m');

		$idjadwal=$this->encrypt->decode(base64_decode($idjadwal));
        if(!is_numeric($idjadwal) OR !intval($idjadwal)>0){
            show_404();
            exit();
        }

		$idperkara=$this->encrypt->decode(base64_decode($enc));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }
		$this->load->library('ckeditor');
		$this->ckeditor->basePath = base_url().'resources/ckeditor/';
		$this->ckeditor->config['toolbar'] = array(
			array('-','Cut','Copy','Paste','PasteText','PasteFromWord',
				'-','Bold', 'Italic', 'Underline','Subscript', 'Superscript',
					'-', 'RemoveFormat','-', 'Blockquote',
					'-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock',
					'-','Undo','Redo','-','NumberedList','BulletedList','/',
					'-','Image'),
			array('-','Format', 'Font', 'FontSize',
				'-','TextColor', 'BGColor','Table',
				'-','Find', 'Replace', '-', 'SelectAll', '-', 'Scayt','-','HorizontalRule',
				'-','Print','Preview'
				));
		$this->ckeditor->config['pasteFromWordNumberedHeadingToList'] = 'true';
		$this->ckeditor->config['pasteFromWordPromptCleanup'] = 'true';
		$this->ckeditor->config['resize'] = 'false';
		$this->ckeditor->config['language'] = 'en';
		$this->ckeditor->config['width'] = '100%';
		$this->ckeditor->config['height'] = '300px';

		$cek_data = $this->jadwal_sidang_m->cek_data_template($idperkara,$idjadwal,$jenis_data);
		$data_pn = $this->jadwal_sidang_m->getDataPN()->result();
		$data_perkara = $this->jadwal_sidang_m->getDataBasSitaRevindicatoir($idperkara)->result();
		
		if($cek_data>0){
			$data['uraian_data_template']=$this->jadwal_sidang_m->show_data_template_s($idperkara,$idjadwal,$jenis_data);
		}else{
			if($jenis_data==15){
				$data['uraian_data_template']='Pada hari ini ...., tanggal ...., saya '.$this->templatehelper->standradnaming($data_pn[0]->PansekPNNama).', Panitera '.$this->templatehelper->standradnaming($data_pn[0]->NamaPN).',
				 							berdasarkan Penetapan Majelis Hakim  tersebut Nomor '.$data_perkara[0]->nomor_perkara.', tanggal '.$this->templatehelper->convertKeTglIndo($data_perkara[0]->penetapan_majelis_hakim).', 
				 							dibantu oleh 2 (dua) orang saksi yang telah dewasa, yaitu ....., bertempat tinggal di ...... dan ......, bertempat tinggal di ........, 
				 							telah pergi ke rumah Tergugat '.$this->templatehelper->standradnaming($data_perkara[0]->nama_tergugat).', bertempat tinggal di '.$this->templatehelper->standradnaming($data_perkara[0]->alamat_tergugat).' 
				 							dan berbicara dengan dia sendiri dengan memperlihatkan Penetapan tersebut dan 
				 							surat gugatan Penggugat '.$this->templatehelper->standradnaming($data_perkara[0]->nama_penggugat).', bertempat tinggal di '.$this->templatehelper->standradnaming($data_perkara[0]->alamat_penggugat).' 
				 							yang tersebut dalam Penetapan tersebut, memberitahukan maksud saya hendak melakukan penyitaan barang berupa ........ yang ada di tangannya, yang adalah barang bergerak milik Penggugat yang ada dalam kekuasaan Tergugat, dihadapan kedua saksi';
			}
		}

        $act="";
        $data['kolom_id']=$jenis_data;
        if($jenis_data==1){
        	$data['title'] = "INPUT DATA PEMBELAAN";
        }else if($jenis_data==2){
        	$data['title'] = "INPUT REPLIK";
        }else if($jenis_data==3){
        	$data['title'] = "INPUT DATA DUPLIK";
        }else if($jenis_data==4){
        	$data['title'] = "INPUT DATA PERTIMBANGAN HUKUM";
        }else if($jenis_data==5){
        	$data['title'] = "INPUT DATA RE-REPLIK";
        }else if($jenis_data==6){
        	$data['title'] = "INPUT DATA RE-DUPLIK";
        }else if($jenis_data==7){
        	$data['title'] = "INPUT DATA PENDAPAT PENUNTUT UMUM";
        }

        //$data['data_template']=$this->jadwal_sidang_m->jumlah_hakim($idperkara,$idjadwal,$jenis_data);
		$this->load->view('data_persidangan/data_template_sidang',$data);
	}

	
//==== end of pemanggilan view ====

	//dipake : keterangan_saksi_v.php
	function set_keterangan_saksi(){
		$id_template = $this->input->post('selected', true);
		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc')));
		if(!is_numeric($idperkara) OR !intval($idperkara)>0){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}
		$idjadwal = $this->encrypt->decode(base64_decode($this->input->post('sidang_id')));
		if(!is_numeric($idjadwal) OR !intval($idjadwal)>0){
			echo json_encode(array('st'=>0,'msg'=>'Sidang Tidak Ditemukan.'));
			return;
		}

		$penanya=$this->input->post('penanya',TRUE);
		$hakim=$this->input->post('hakim',TRUE);
		$saksi=$this->input->post('saksi',TRUE);
		$namahalaman=$this->input->post('namahalaman',TRUE);

		if(intval($id_template)>0){
			//ambil dan simpan keterangan saksi
			if($penanya==1){
				$penanya_id=$hakim;
			}else if($penanya==6 || $penanya==7 || $penanya==8 || $penanya==9){
				$penanya_id=$penanya;
			}
			$this->load->model('jadwalsidang/jadwal_sidang_m');
			$res = $this->jadwal_sidang_m->getContentTemplateAmar($id_template);
			if(!empty($res)){
				if($res->num_rows()>0){
					$this->jadwal_sidang_m->hapus_ket_saksi_noid($penanya_id,$saksi,$idperkara,$idjadwal,$namahalaman);	
					foreach ($res->result() as $value) {
						$data_insert = array(
							'perkara_id'=>$idperkara,
							'sidang_id'=>$idjadwal,
							'penanya_id'=>$penanya_id,
							'saksi_id'=>$saksi,
							'pertanyaan'=>$value->pertanyaan,
							'jawaban'=>$value->jawaban,
							'diinput_oleh' => $this->session->userdata('username'),
							'diinput_tanggal' => date("Y-m-d h:i:s",time())
						);
							$hasil = $this->jadwal_sidang_m->insert_ket_saksi($data_insert,$namahalaman);	
					}
					echo $hasil;
				}
			}
		}else{
			echo 0;
		}
	}

	//dipake : data_template_sidang.php
	function input_data_template_sidang(){
		if(empty($_POST)){
			show_404();
		}

		$this->load->model('jadwalsidang/jadwal_sidang_m');
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		
		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc')));
		if(!is_numeric($idperkara) OR !intval($idperkara)>0){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}
		$idjadwal = $this->encrypt->decode(base64_decode($this->input->post('idjadwal')));
		if(!is_numeric($idjadwal) OR !intval($idjadwal)>0){
			echo json_encode(array('st'=>0,'msg'=>'Sidang Tidak Ditemukan.'));
			return;
		}

		$uraian=$this->input->post('uraian_data_template_text',TRUE);
		$kolom_id=$this->input->post('kolom_id',TRUE);

		$cek_data = $this->jadwal_sidang_m->cek_data_template($idperkara,$idjadwal,$kolom_id);

		$data_insert = array(
			'perkara_id'=>$idperkara,
			'sidang_id'=>$idjadwal,
			'kolom_id'=>$kolom_id,
			'uraian'=>$uraian,
			'diinput_oleh' => $this->session->userdata('username'),
			'diinput_tanggal' => date("Y-m-d h:i:s",time())
		);

		$data_update = array(
			'uraian'=>$uraian,
			'diperbaharui_oleh' => $this->session->userdata('username'),
			'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
		);

		$namahalaman=$this->input->post('namahalaman',TRUE);
		if($cek_data>0){
			$result = $this->jadwal_sidang_m->update_data_template_s($data_update,$idperkara,$idjadwal,$kolom_id,$namahalaman);		
		}else{
			$result = $this->jadwal_sidang_m->insert_data_template_persidangan($data_insert,$namahalaman);		
		}
		
		if($result){
			echo json_encode(array('st'=>1,'msg'=>'Data Berhasil Disimpan'));
			return;
		}else{
			echo json_encode(array('st'=>0,'msg'=>'<strong>Peringatan:</strong><br/> Proses Simpan Gagal'));
			return;				
		}			
	}

	//dipake : keterangan_saksi_v.php
	function input_data(){
		if(empty($_POST)){
			show_404();
		}

		$this->load->model('jadwalsidang/jadwal_sidang_m');
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		
		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc')));
		if(!is_numeric($idperkara) OR !intval($idperkara)>0){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}
		$idjadwal = $this->encrypt->decode(base64_decode($this->input->post('sidang_id')));
		if(!is_numeric($idjadwal) OR !intval($idjadwal)>0){
			echo json_encode(array('st'=>0,'msg'=>'Sidang Tidak Ditemukan.'));
			return;
		}

		$tanya=$this->input->post('tanya',TRUE);
		$jawab=$this->input->post('jawab',TRUE);
		$penanya=$this->input->post('penanya',TRUE);
		$hakim=$this->input->post('hakim',TRUE);
		$saksi=$this->input->post('saksi',TRUE);
		$data_id=$this->input->post('data_id',TRUE);
		$namahalaman=$this->input->post('namahalaman',TRUE);

		if($penanya==1){
			$penanya_id=$hakim;
		}else if($penanya==6 || $penanya==7 || $penanya==8 || $penanya==9){
			$penanya_id=$penanya;
		}

		$data_insert = array(
			'perkara_id'=>$idperkara,
			'sidang_id'=>$idjadwal,
			'penanya_id'=>$penanya_id,
			'saksi_id'=>$saksi,
			'pertanyaan'=>$tanya,
			'jawaban'=>$jawab,
			'diinput_oleh' => $this->session->userdata('username'),
			'diinput_tanggal' => date("Y-m-d h:i:s",time())
		);

		$data_update = array(
			'pertanyaan'=>$tanya,
			'jawaban'=>$jawab,
			'diperbaharui_oleh' => $this->session->userdata('username'),
			'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
		);

		if($data_id>0){
			$this->jadwal_sidang_m->update_ket_saksi($data_update,$data_id,$namahalaman);	
		}else{
			$this->jadwal_sidang_m->insert_ket_saksi($data_insert,$namahalaman);	
		}
	}

	//dipake : pendapat_terdakwa_v.php
	function input_data_pendapat_terdakwa(){
		if(empty($_POST)){
			show_404();
		}

		$this->load->model('jadwalsidang/jadwal_sidang_m');
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		
		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc')));
		if(!is_numeric($idperkara) OR !intval($idperkara)>0){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}
		$idjadwal = $this->encrypt->decode(base64_decode($this->input->post('sidang_id')));
		if(!is_numeric($idjadwal) OR !intval($idjadwal)>0){
			echo json_encode(array('st'=>0,'msg'=>'Sidang Tidak Ditemukan.'));
			return;
		}

		$pendapat=$this->input->post('pendapat',TRUE);
		$terdakwa=$this->input->post('terdakwa',TRUE);
		$saksi=$this->input->post('saksi',TRUE);
		$data_id=$this->input->post('data_id',TRUE);		

		$data_insert = array(
			'perkara_id'=>$idperkara,
			'sidang_id'=>$idjadwal,
			'pihak_id'=>$terdakwa,
			'saksi_id'=>$saksi,
			'pendapat'=>$pendapat,
			'diinput_oleh' => $this->session->userdata('username'),
			'diinput_tanggal' => date("Y-m-d h:i:s",time())
		);

		$data_update = array(
			'pendapat'=>$pendapat,
			'diperbaharui_oleh' => $this->session->userdata('username'),
			'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
		);
		$namahalaman=$this->input->post('namahalaman',TRUE);		
		if($pendapat!=''){
			if($data_id>0){
			$this->jadwal_sidang_m->update_pendapat_terdakwa($data_update,$data_id,$namahalaman);	
			}else{
				$this->jadwal_sidang_m->insert_pendapat_terdakwa($data_insert,$namahalaman);	
			}
		}else{
			return;
		}
	}
	
	//dipake : keterangan_saksi_v.php
	function input_data_terdakwa(){
		if(empty($_POST)){
			show_404();
		}

		$this->load->model('jadwalsidang/jadwal_sidang_m');
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		
		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc')));
		if(!is_numeric($idperkara) OR !intval($idperkara)>0){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}
		$idjadwal = $this->encrypt->decode(base64_decode($this->input->post('sidang_id')));
		if(!is_numeric($idjadwal) OR !intval($idjadwal)>0){
			echo json_encode(array('st'=>0,'msg'=>'Sidang Tidak Ditemukan.'));
			return;
		}

		$tanya=$this->input->post('tanya',TRUE);
		$jawab=$this->input->post('jawab',TRUE);
		$penanya=$this->input->post('penanya',TRUE);
		$hakim=$this->input->post('hakim',TRUE);
		$terdakwa=$this->input->post('terdakwa',TRUE);
		$data_id=$this->input->post('data_id',TRUE);
		$namahalaman=$this->input->post('namahalaman',TRUE);

		if($penanya==1){
			$penanya_id=$hakim;
		}else if($penanya==6 || $penanya==7 || $penanya==8 || $penanya==9){
			$penanya_id=$penanya;
		}

		$data_insert = array(
			'perkara_id'=>$idperkara,
			'sidang_id'=>$idjadwal,
			'penanya_id'=>$penanya_id,
			'pihak_id'=>$terdakwa,
			'pertanyaan'=>$tanya,
			'jawaban'=>$jawab,
			'diinput_oleh' => $this->session->userdata('username'),
			'diinput_tanggal' => date("Y-m-d h:i:s",time())
		);

		$data_update = array(
			'pertanyaan'=>$tanya,
			'jawaban'=>$jawab,
			'diperbaharui_oleh' => $this->session->userdata('username'),
			'diperbaharui_tanggal' => date("Y-m-d h:i:s",time())
		);

		if($data_id>0){
			$this->jadwal_sidang_m->update_ket_terdakwa($data_update,$data_id,$namahalaman);	
		}else{
			$this->jadwal_sidang_m->insert_ket_terdakwa($data_insert,$namahalaman);	
		}
	}

	//dipake : keterangan_saksi_v.php
	function hapus_data_ket_saksi(){
		if(empty($_POST)){
			show_404();
		}

		$this->load->model('jadwalsidang/jadwal_sidang_m');
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc')));
		if(!is_numeric($idperkara) OR !intval($idperkara)>0){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}
		$idjadwal = $this->encrypt->decode(base64_decode($this->input->post('sidang_id')));
		if(!is_numeric($idjadwal) OR !intval($idjadwal)>0){
			echo json_encode(array('st'=>0,'msg'=>'Sidang Tidak Ditemukan.'));
			return;
		}

		$tanya=$this->input->post('tanya',TRUE);
		$jawab=$this->input->post('jawab',TRUE);
		$penanya=$this->input->post('penanya',TRUE);
		$hakim=$this->input->post('hakim',TRUE);
		$saksi=$this->input->post('saksi',TRUE);
		$data_id=$this->input->post('data_id',TRUE);
		$namahalaman=$this->input->post('namahalaman',TRUE);

		if($penanya==1){
			$penanya_id=$hakim;
		}else if($penanya==6 || $penanya==7 || $penanya==8 || $penanya==9){
			$penanya_id=$penanya;
		}		

		if($data_id>0){
			$this->jadwal_sidang_m->hapus_ket_saksi($data_id,$namahalaman);	
			echo json_encode(array('st'=>1));
			return;
		}else{
			$this->jadwal_sidang_m->hapus_ket_saksi_noid($penanya_id,$saksi,$idperkara,$idjadwal,$namahalaman,$tanya,$jawab);	
			echo json_encode(array('st'=>1));
			return;
		}
	}

	//dipake : pendapat_terdakwa_v.php
	function hapus_data_pend_terdakwa(){
		if(empty($_POST)){
			show_404();
		}

		$this->load->model('jadwalsidang/jadwal_sidang_m');
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc')));
		if(!is_numeric($idperkara) OR !intval($idperkara)>0){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}
		$idjadwal = $this->encrypt->decode(base64_decode($this->input->post('sidang_id')));
		if(!is_numeric($idjadwal) OR !intval($idjadwal)>0){
			echo json_encode(array('st'=>0,'msg'=>'Sidang Tidak Ditemukan.'));
			return;
		}

		$pendapat=$this->input->post('pendapat',TRUE);
		$terdakwa=$this->input->post('terdakwa',TRUE);
		$saksi=$this->input->post('saksi',TRUE);
		$data_id=$this->input->post('data_id',TRUE);
		$namahalaman=$this->input->post('namahalaman',TRUE);

		if($data_id>0){
			$this->jadwal_sidang_m->hapus_pend_terdakwa($data_id,$namahalaman);	
			echo json_encode(array('st'=>1));
			return;
		}else{
			$this->jadwal_sidang_m->hapus_pend_terdakwa_noid($terdakwa,$saksi,$idperkara,$idjadwal,$pendapat,$namahalaman);	
			echo json_encode(array('st'=>1));
			return;
		}
	}

	//dipake : pemeriksaan_terdakwa_v.php
	function hapus_data_ket_terdakwa(){
		if(empty($_POST)){
			show_404();
		}

		$this->load->model('jadwalsidang/jadwal_sidang_m');
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		
		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc')));
		if(!is_numeric($idperkara) OR !intval($idperkara)>0){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}
		$idjadwal = $this->encrypt->decode(base64_decode($this->input->post('sidang_id')));
		if(!is_numeric($idjadwal) OR !intval($idjadwal)>0){
			echo json_encode(array('st'=>0,'msg'=>'Sidang Tidak Ditemukan.'));
			return;
		}

		$tanya=$this->input->post('tanya',TRUE);
		$jawab=$this->input->post('jawab',TRUE);
		$penanya=$this->input->post('penanya',TRUE);
		$hakim=$this->input->post('hakim',TRUE);
		$terdakwa=$this->input->post('terdakwa',TRUE);
		$data_id=$this->input->post('data_id',TRUE);
		$namahalaman=$this->input->post('namahalaman',TRUE);

		if($penanya==1){
			$penanya_id=$hakim;
		}else if($penanya==6 || $penanya==7 || $penanya==8 || $penanya==9){
			$penanya_id=$penanya;
		}		

		if($data_id>0){
			$this->jadwal_sidang_m->hapus_ket_terdakwa($data_id,$namahalaman);	
			echo json_encode(array('st'=>1));
			return;
		}else{
			$this->jadwal_sidang_m->hapus_ket_terdakwa_noid($penanya_id,$terdakwa,$idperkara,$idjadwal,$namahalaman,$tanya,$jawab);	
			echo json_encode(array('st'=>1));
			return;
		}
	}

//==== section : json response ====

	//dipake : keterangan_saksi_v.php
	function show_tanya_jawab(){
		if(empty($_POST)){
			show_404();
		}

		$this->load->model('jadwalsidang/jadwal_sidang_m');
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		
		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc')));
		if(!is_numeric($idperkara) OR !intval($idperkara)>0){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}
		$idjadwal = $this->encrypt->decode(base64_decode($this->input->post('sidang_id')));
		if(!is_numeric($idjadwal) OR !intval($idjadwal)>0){
			echo json_encode(array('st'=>0,'msg'=>'Sidang Tidak Ditemukan.'));
			return;
		}

		$penanya=$this->input->post('penanya',TRUE);
		$hakim=$this->input->post('hakim',TRUE);
		$saksi=$this->input->post('saksi',TRUE);

		if($penanya==1){
			$penanya_id=$hakim;
		}else if($penanya==6 || $penanya==7 || $penanya==8 || $penanya==9){
			$penanya_id=$penanya;
		}
		if($saksi=="" || $saksi<0){
			$tnyjwb = "<table id='tanyajawab' width='100%'' style='overflow:auto;' class='table' border='1' cellpadding='0' cellspacing='0'>
						<tr >
						<th width='5%'>No.</th><th width='4%'>Aksi</th><th width='45%'>Pertanyaan</th><th width='45%'>Jawaban</th>
						</tr>
				    ";
				    	$tnyjwb.= "<tr>";
				    	$tnyjwb.= "<td height='30'><div id='data_id1' data-id=''>1</div></td>";
				    	$tnyjwb.= "<td height='30'><div id='q_hapus1' ></div><a href='#' id='hapus' style='color:red'>Hapus</a></td>";
				    	$tnyjwb.= "<td height='30'><div id='q_tanya1' contenteditable class='tanya'></div></td>";
				    	$tnyjwb.= "<td height='30'><div id='q_jawab1' contenteditable class='jawab'></div></td>";
				    	$tnyjwb.= "</tr>";
				    

			$tnyjwb.= "</table>";
			$tnyjwb.="<div style='font-size:12px;color:red;'>Pilih Saksi dan tekan Tombol TAB untuk memulai mengisi Tanya Jawab Saksi</div>";
			echo json_encode(array('st'=>0,'datatnyjawab'=>$tnyjwb));
			return;			
		}else{
		$data_tanya_jawab=$this->jadwal_sidang_m->show_data_tnyjawab($idperkara,$idjadwal,$penanya_id,$saksi);
		
		if($data_tanya_jawab->num_rows()>0){
		$tnyjwb = "<table id='tanyajawab' width='100%'' style='overflow:auto;' class='table' border='1' cellpadding='0' cellspacing='0'>
					<tr >
					<th width='5%'>No.</th><th width='4%'>Aksi</th><th width='45%'>Pertanyaan</th><th width='45%'>Jawaban</th>
					</tr>
			    ";
			    $i=1;
			    foreach ($data_tanya_jawab->result() as $row) {
			    	$tnyjwb.= "<tr>";
			    	$tnyjwb.= "<td height='30'><div id='data_id".$i."' ketid".$i."=".$row->id." >".$i."</div></td>";
			    	$tnyjwb.= "<td height='30'><div id='q_hapus".$i."' ></div><a href='#' id='hapus' style='color:red'>Hapus</a></td>";
			    	$tnyjwb.= "<td height='30'><div id='q_tanya".$i."' contenteditable class='tanya'>".$row->pertanyaan."</div></td>";
			    	$tnyjwb.= "<td height='30'><div id='q_jawab".$i."' contenteditable class='jawab'>".$row->jawaban."</div></td>";
			    	$tnyjwb.= "</tr>";
			    	$i++;
			    };

		$tnyjwb.= "</table>";
		$tnyjwb.="<div style='font-size:11px;color:red;'>Pilih Saksi dan tekan Tombol TAB untuk memulai mengisi Tanya Jawab Saksi</div>";
		echo json_encode(array('st'=>1,'datatnyjawab'=>$tnyjwb));
		return;
		}else{
		$tnyjwb = "<table id='tanyajawab' width='100%'' style='overflow:auto;' class='table' border='1' cellpadding='0' cellspacing='0'>
					<tr >
					<th width='5%'>No.</th><th width='4%'>Aksi</th><th width='45%'>Pertanyaan</th><th width='45%'>Jawaban</th>
					</tr>
			    ";
			    	$tnyjwb.= "<tr>";
			    	$tnyjwb.= "<td height='30'><div id='data_id1' data-id=''>1</div></td>";
			    	$tnyjwb.= "<td height='30'><div id='q_hapus1' ></div><a href='#' id='hapus' style='color:red'>Hapus</a></td>";
			    	$tnyjwb.= "<td height='30'><div id='q_tanya1' contenteditable class='tanya'></div></td>";
			    	$tnyjwb.= "<td height='30'><div id='q_jawab1' contenteditable class='jawab'></div></td>";
			    	$tnyjwb.= "</tr>";
			    

		$tnyjwb.= "</table>";
		$tnyjwb.="<div style='font-size:12px;color:red;'>Pilih Saksi dan tekan Tombol TAB untuk memulai mengisi Tanya Jawab Saksi</div>";
		echo json_encode(array('st'=>0,'datatnyjawab'=>$tnyjwb));
		return;
		}
		}
	}
	
	//dipake : pemeriksaan_terdakwa_v.php
	function show_tanya_jawab_terdakwa(){
		if(empty($_POST)){
			show_404();
		}

		$this->load->model('jadwalsidang/jadwal_sidang_m');
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		
		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc')));
		if(!is_numeric($idperkara) OR !intval($idperkara)>0){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}
		$idjadwal = $this->encrypt->decode(base64_decode($this->input->post('sidang_id')));
		if(!is_numeric($idjadwal) OR !intval($idjadwal)>0){
			echo json_encode(array('st'=>0,'msg'=>'Sidang Tidak Ditemukan.'));
			return;
		}

		$penanya=$this->input->post('penanya',TRUE);
		$hakim=$this->input->post('hakim',TRUE);
		$terdakwa=$this->input->post('terdakwa',TRUE);

		if($penanya==1){
			$penanya_id=$hakim;
		}else if($penanya==6 || $penanya==7 || $penanya==8 || $penanya==9){
			$penanya_id=$penanya;
		}
		if($terdakwa=="" || $terdakwa<0){
			$tnyjwb = "<table id='tanyajawab' width='100%'' style='overflow:auto;' class='table' border='1' cellpadding='0' cellspacing='0'>
						<tr >
						<th width='5%'>No.</th><th width='4%'>Aksi</th><th width='45%'>Pertanyaan</th><th width='45%'>Jawaban</th>
						</tr>
				    ";
				    	$tnyjwb.= "<tr>";
				    	$tnyjwb.= "<td height='30'><div id='data_id1' data-id=''>1</div></td>";
				    	$tnyjwb.= "<td height='30'><div id='q_hapus1' ></div><a href='#' id='hapus' style='color:red'>Hapus</a></td>";
				    	$tnyjwb.= "<td height='30'><div id='q_tanya1' contenteditable class='tanya'></div></td>";
				    	$tnyjwb.= "<td height='30'><div id='q_jawab1' contenteditable class='jawab'></div></td>";
				    	$tnyjwb.= "</tr>";
				    

			$tnyjwb.= "</table>";
			$tnyjwb.="<div style='font-size:12px;color:red;'>Pilih Terdakwa dan tekan Tombol TAB untuk memulai mengisi Tanya Jawab Terdakwa</div>";
			echo json_encode(array('st'=>0,'datatnyjawab'=>$tnyjwb));
			return;			
		}else{
			$data_tanya_jawab=$this->jadwal_sidang_m->show_data_tnyjawab_terdakwa($idperkara,$idjadwal,$penanya_id,$terdakwa);
			
			if($data_tanya_jawab->num_rows()>0){
			$tnyjwb = "<table id='tanyajawab' width='100%'' style='overflow:auto;' class='table' border='1' cellpadding='0' cellspacing='0'>
						<tr >
						<th width='5%'>No.</th><th width='4%'>Aksi</th><th width='45%'>Pertanyaan</th><th width='45%'>Jawaban</th>
						</tr>
				    ";
				    $i=1;
				    foreach ($data_tanya_jawab->result() as $row) {
				    	$tnyjwb.= "<tr>";
				    	$tnyjwb.= "<td height='30'><div id='data_id".$i."' ketid".$i."=".$row->id." >".$i."</div></td>";
				    	$tnyjwb.= "<td height='30'><div id='q_hapus".$i."' ></div><a href='#' id='hapus' style='color:red'>Hapus</a></td>";
				    	$tnyjwb.= "<td height='30'><div id='q_tanya".$i."' contenteditable class='tanya'>".$row->pertanyaan."</div></td>";
				    	$tnyjwb.= "<td height='30'><div id='q_jawab".$i."' contenteditable class='jawab'>".$row->jawaban."</div></td>";
				    	$tnyjwb.= "</tr>";
				    	$i++;
				    };

			$tnyjwb.= "</table>";
			$tnyjwb.="<div style='font-size:11px;color:red;'>Pilih Terdakwa dan tekan Tombol TAB untuk memulai mengisi Tanya Jawab Terdakwa</div>";
			echo json_encode(array('st'=>1,'datatnyjawab'=>$tnyjwb));
			return;
			}else{
			$tnyjwb = "<table id='tanyajawab' width='100%'' style='overflow:auto;' class='table' border='1' cellpadding='0' cellspacing='0'>
						<tr >
						<th width='5%'>No.</th><th width='4%'>Aksi</th><th width='45%'>Pertanyaan</th><th width='45%'>Jawaban</th>
						</tr>
				    ";
				    	$tnyjwb.= "<tr>";
				    	$tnyjwb.= "<td height='30'><div id='data_id1' data-id=''>1</div></td>";
				    	$tnyjwb.= "<td height='30'><div id='q_hapus1' ></div><a href='#' id='hapus' style='color:red'>Hapus</a></td>";
				    	$tnyjwb.= "<td height='30'><div id='q_tanya1' contenteditable class='tanya'></div></td>";
				    	$tnyjwb.= "<td height='30'><div id='q_jawab1' contenteditable class='jawab'></div></td>";
				    	$tnyjwb.= "</tr>";
				    

			$tnyjwb.= "</table>";
			$tnyjwb.="<div style='font-size:12px;color:red;'>Pilih Terdakwa dan tekan Tombol TAB untuk memulai mengisi Tanya Jawab Terdakwa</div>";
			echo json_encode(array('st'=>0,'datatnyjawab'=>$tnyjwb));
			return;
			}
		}
	}

	//dipake : pendapat_terdakwa_v.php
	function show_pendapat(){
		if(empty($_POST)){
			show_404();
		}

		$this->load->model('jadwalsidang/jadwal_sidang_m');
		if($this->session->userdata('is_logged_in')==FALSE){
			echo json_encode(array('st'=>0,'msg'=>'Anda Belum Login, Silahkan Login Terlebih Dahulu.'));
			return;
		}
		
		$idperkara = $this->encrypt->decode(base64_decode($this->input->post('enc')));
		if(!is_numeric($idperkara) OR !intval($idperkara)>0){
			echo json_encode(array('st'=>0,'msg'=>'Perkara Tidak Ditemukan.'));
			return;
		}
		$idjadwal = $this->encrypt->decode(base64_decode($this->input->post('sidang_id')));
		if(!is_numeric($idjadwal) OR !intval($idjadwal)>0){
			echo json_encode(array('st'=>0,'msg'=>'Sidang Tidak Ditemukan.'));
			return;
		}

		$terdakwa=$this->input->post('terdakwa',TRUE);
		$saksi=$this->input->post('saksi',TRUE);
		
		if($saksi=="" || $saksi<0){
			$tnyjwb = "<table id='tanyajawab' width='100%'' style='overflow:auto;' class='table' border='1' cellpadding='0' cellspacing='0'>
						<tr >
						<th width='2%'>No.</th><th width='4%'>Aksi</th><th width='45%'>Pendapat Terdakwa</th>
						</tr>
				    ";
				    	$tnyjwb.= "<tr>";
				    	$tnyjwb.= "<td height='30' align='center'><div id='data_id1' data-id=''>1</div></td>";
				    	$tnyjwb.= "<td height='30'><div id='q_hapus1' ></div><a href='#' id='hapus' style='color:red'>Hapus</a></td>";
				    	$tnyjwb.= "<td height='30'><div id='q_jawab1' contenteditable class='jawab'></div></td>";
				    	$tnyjwb.= "</tr>";
				    

			$tnyjwb.= "</table>";
			$tnyjwb.="<div style='font-size:12px;color:red;'>Pilih Terdakwa serta Saksi dan tekan Tombol TAB untuk memulai mengisi Pendapat Terdakwa</div>";
			echo json_encode(array('st'=>0,'datatnyjawab'=>$tnyjwb));
			return;			
		}else{
		$data_tanya_jawab=$this->jadwal_sidang_m->show_data_pendapat($idperkara,$idjadwal,$terdakwa,$saksi);
		
		if($data_tanya_jawab->num_rows()>0){
		$tnyjwb = "<table id='tanyajawab' width='100%'' style='overflow:auto;' class='table' border='1' cellpadding='0' cellspacing='0'>
					<tr >
					<th width='2%'>No.</th><th width='4%'>Aksi</th><th width='45%'>Pendapat Terdakwa</th>
					</tr>
			    ";
			    $i=1;
			    foreach ($data_tanya_jawab->result() as $row) {
			    	$tnyjwb.= "<tr>";
			    	$tnyjwb.= "<td height='30' align='center'><div id='data_id".$i."' ketid".$i."=".$row->id." >".$i."</div></td>";
			    	$tnyjwb.= "<td height='30'><div id='q_hapus".$i."' ></div><a href='#' id='hapus' style='color:red'>Hapus</a></td>";
			    	$tnyjwb.= "<td height='30'><div id='q_jawab".$i."' contenteditable class='jawab'>".$row->pendapat."</div></td>";
			    	$tnyjwb.= "</tr>";
			    	$i++;
			    };

		$tnyjwb.= "</table>";
		$tnyjwb.="<div style='font-size:11px;color:red;'>Pilih Terdakwa serta Saksi dan tekan Tombol TAB untuk memulai mengisi Pendapat Terdakwa</div>";
		echo json_encode(array('st'=>1,'datatnyjawab'=>$tnyjwb));
		return;
		}else{
		$tnyjwb = "<table id='tanyajawab' width='100%'' style='overflow:auto;' class='table' border='1' cellpadding='0' cellspacing='0'>
					<tr >
					<th width='2%'>No.</th><th width='4%'>Aksi</th><th width='45%'>Pendapat Terdakwa</th>
					</tr>
			    ";
			    	$tnyjwb.= "<tr>";
			    	$tnyjwb.= "<td height='30' align='center'><div id='data_id1' data-id=''>1</div></td>";
			    	$tnyjwb.= "<td height='30'><div id='q_hapus1' ></div><a href='#' id='hapus' style='color:red'>Hapus</a></td>";
			    	$tnyjwb.= "<td height='30'><div id='q_jawab1' contenteditable class='jawab'></div></td>";
			    	$tnyjwb.= "</tr>";
			    

		$tnyjwb.= "</table>";
		$tnyjwb.="<div style='font-size:12px;color:red;'>Pilih Terdakwa serta Saksi dan tekan Tombol TAB untuk memulai mengisi Pendapat Terdakwa</div>";
		echo json_encode(array('st'=>0,'datatnyjawab'=>$tnyjwb));
		return;
		}
		}
	}

//==== end of json response ====
}
?>
