<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Cetak_register extends CI_Controller {

	public function __construct() {
        		parent::__construct();
        		$this->load->model('register_perkara/cetak_register_m','model');
    	}

	public function  popup(){
		if($this->session->userdata('is_logged_in')==FALSE){  redirect('login'); }
		$idalurperkara = $this->uri->segment(3);
		$queryAlurPerkara=  $this->model->get_alur_perkara($idalurperkara);
		$nama_alur_perkara= $queryAlurPerkara->row()->nama;
		$data['judul'] = "Cetak Register ".$nama_alur_perkara; 

		$data['tahun_sekarang'] = date("Y",time());
		$data['bulan_sekarang'] = (int) date("m",time());

		$data['bulan'] = array("-1"=>'Pilih' ,"01"=>'Januari' ,"02"=>'Februari',"03"=>'Maret' ,"04"=>'April' ,"05"=>'Mei' ,"06"=> 'Juni',"07"=> 'Juli',"08"=>'Agustus' ,"09"=>'September' ,"10"=>'Oktober' ,"11"=> 'November',"12"=>'Desember'); 

		$queryTahun = $this->model->get_tahun();
		$thn =array( );
		$thn['-1'] = "Pilih";
		foreach ($queryTahun->result() as $row) {
			$thn[''.$row->tahun.''] = $row->tahun;
		}

		$data['tahun'] = $thn;
		$data['idalurperkara'] = base64_encode($this->encrypt->encode($idalurperkara));
		$this->load->vars($data);
		$this->load->view('register/popup_cetak_register');	
	}

	public function  popup_banding(){
		if($this->session->userdata('is_logged_in')==FALSE){  redirect('login'); }
		$idalurperkara = $this->uri->segment(2);
		$queryAlurPerkara=  $this->model->get_alur_perkara($idalurperkara);
		$nama_alur_perkara= $queryAlurPerkara->row()->nama;
		$data['judul'] = "Cetak Register ".$nama_alur_perkara; 

		$data['tahun_sekarang'] = date("Y",time());
		$data['bulan_sekarang'] = (int) date("m",time());

		$data['bulan'] = array("-1"=>'Pilih' ,"01"=>'Januari' ,"02"=>'Februari',"03"=>'Maret' ,"04"=>'April' ,"05"=>'Mei' ,"06"=> 'Juni',"07"=> 'Juli',"08"=>'Agustus' ,"09"=>'September' ,"10"=>'Oktober' ,"11"=> 'November',"12"=>'Desember'); 

		$queryTahun = $this->model->get_tahun_banding();
		$thn =array( );
		$thn['-1'] = "Pilih";
		foreach ($queryTahun->result() as $row) {
			$thn[''.$row->tahun.''] = $row->tahun;
		}

		$data['tahun'] = $thn;
		$data['idalurperkara'] = base64_encode($this->encrypt->encode($idalurperkara));
		$this->load->vars($data);
		$this->load->view('register/popup_cetak_register_banding');	
	}


	public function  popup_kasasi(){
		if($this->session->userdata('is_logged_in')==FALSE){  redirect('login'); }
		$idalurperkara = $this->uri->segment(2);
		$queryAlurPerkara=  $this->model->get_alur_perkara($idalurperkara);
		$nama_alur_perkara= $queryAlurPerkara->row()->nama;
		$data['judul'] = "Cetak Register Permohonan Kasasi Perkara  ".$nama_alur_perkara; 

		$data['tahun_sekarang'] = date("Y",time());
		$data['bulan_sekarang'] = (int) date("m",time());

		$data['bulan'] = array("-1"=>'Pilih' ,"01"=>'Januari' ,"02"=>'Februari',"03"=>'Maret' ,"04"=>'April' ,"05"=>'Mei' ,"06"=> 'Juni',"07"=> 'Juli',"08"=>'Agustus' ,"09"=>'September' ,"10"=>'Oktober' ,"11"=> 'November',"12"=>'Desember'); 

		$queryTahun = $this->model->get_tahun_kasasi();
		$thn =array( );
		$thn['-1'] = "Pilih";
		foreach ($queryTahun->result() as $row) {
			$thn[''.$row->tahun.''] = $row->tahun;
		}

		$data['tahun'] = $thn;
		$data['idalurperkara'] = base64_encode($this->encrypt->encode($idalurperkara));
		$this->load->vars($data);
		$this->load->view('register/popup_cetak_register_kasasi');	
	}


	public function  popup_pk(){
		if($this->session->userdata('is_logged_in')==FALSE){  redirect('login'); }
		$idalurperkara = $this->uri->segment(2);
		$queryAlurPerkara=  $this->model->get_alur_perkara($idalurperkara);
		$nama_alur_perkara= $queryAlurPerkara->row()->nama;
		$data['judul'] = "Cetak Register Permohonan Peninjauan Kembali Perkara  ".$nama_alur_perkara; 

		$data['tahun_sekarang'] = date("Y",time());
		$data['bulan_sekarang'] = (int) date("m",time());

		$data['bulan'] = array("-1"=>'Pilih' ,"01"=>'Januari' ,"02"=>'Februari',"03"=>'Maret' ,"04"=>'April' ,"05"=>'Mei' ,"06"=> 'Juni',"07"=> 'Juli',"08"=>'Agustus' ,"09"=>'September' ,"10"=>'Oktober' ,"11"=> 'November',"12"=>'Desember'); 

		$queryTahun = $this->model->get_tahun_kasasi();
		$thn =array( );
		$thn['-1'] = "Pilih";
		foreach ($queryTahun->result() as $row) {
			$thn[''.$row->tahun.''] = $row->tahun;
		}

		$data['tahun'] = $thn;
		$data['idalurperkara'] = base64_encode($this->encrypt->encode($idalurperkara));
		$this->load->vars($data);
		$this->load->view('register/popup_cetak_register_pk');	
	}


	public function  popup_penahanan(){
		if($this->session->userdata('is_logged_in')==FALSE){  redirect('login'); }
		$idalurperkara = $this->uri->segment(2);
		$queryAlurPerkara=  $this->model->get_alur_perkara($idalurperkara);
		$nama_alur_perkara= $queryAlurPerkara->row()->nama;
		$data['judul'] = "Cetak Register Penahanan ".$nama_alur_perkara; 


		$data['tahun_sekarang'] = date("Y",time());
		$data['bulan_sekarang'] = (int) date("m",time());

		$data['bulan'] = array("-1"=>'Pilih' ,"01"=>'Januari' ,"02"=>'Februari',"03"=>'Maret' ,"04"=>'April' ,"05"=>'Mei' ,"06"=> 'Juni',"07"=> 'Juli',"08"=>'Agustus' ,"09"=>'September' ,"10"=>'Oktober' ,"11"=> 'November',"12"=>'Desember'); 

		$queryTahun = $this->model->get_tahun();
		$thn =array( );
		$thn['-1'] = "Pilih";
		foreach ($queryTahun->result() as $row) {
			$thn[''.$row->tahun.''] = $row->tahun;
		}

		$data['tahun'] = $thn;
		$data['idalurperkara'] = base64_encode($this->encrypt->encode($idalurperkara));
		$this->load->vars($data);
		$this->load->view('register/popup_cetak_register_penahanan');	
	}


	public function  popup_diversi(){
		if($this->session->userdata('is_logged_in')==FALSE){  redirect('login'); }
		$idalurperkara = $this->uri->segment(2);
		$data['judul'] = "Cetak Register Kesepakatan Diversi "; 


		$data['tahun_sekarang'] = date("Y",time());
		$data['bulan_sekarang'] = (int) date("m",time());

		$data['bulan'] = array("-1"=>'Pilih' ,"01"=>'Januari' ,"02"=>'Februari',"03"=>'Maret' ,"04"=>'April' ,"05"=>'Mei' ,"06"=> 'Juni',"07"=> 'Juli',"08"=>'Agustus' ,"09"=>'September' ,"10"=>'Oktober' ,"11"=> 'November',"12"=>'Desember'); 

		$queryTahun = $this->model->get_tahun();
		$thn =array( );
		$thn['-1'] = "Pilih";
		foreach ($queryTahun->result() as $row) {
			$thn[''.$row->tahun.''] = $row->tahun;
		}

		$data['tahun'] = $thn;
		$data['idalurperkara'] = base64_encode($this->encrypt->encode($idalurperkara));
		$this->load->vars($data);
		$this->load->view('register/popup_cetak_register_diversi');	
	}

	public function  popup_anak_saksi(){
		if($this->session->userdata('is_logged_in')==FALSE){  redirect('login'); }
		$idalurperkara = $this->uri->segment(2);
		$data['judul'] = "Cetak Register Perkara Pidana Anak Korban dan Anak Saksi"; 

		$data['tahun_sekarang'] = date("Y",time());
		$data['bulan_sekarang'] = (int) date("m",time());

		$data['bulan'] = array("-1"=>'Pilih' ,"01"=>'Januari' ,"02"=>'Februari',"03"=>'Maret' ,"04"=>'April' ,"05"=>'Mei' ,"06"=> 'Juni',"07"=> 'Juli',"08"=>'Agustus' ,"09"=>'September' ,"10"=>'Oktober' ,"11"=> 'November',"12"=>'Desember'); 

		$queryTahun = $this->model->get_tahun();
		$thn =array( );
		$thn['-1'] = "Pilih";
		foreach ($queryTahun->result() as $row) {
			$thn[''.$row->tahun.''] = $row->tahun;
		}

		$data['tahun'] = $thn;
		$data['idalurperkara'] = base64_encode($this->encrypt->encode($idalurperkara));
		$this->load->vars($data);
		$this->load->view('register/popup_cetak_register_anak_saksi');	
	}

	public function  popup_anak_12tahun(){
		if($this->session->userdata('is_logged_in')==FALSE){  redirect('login'); }
		$idalurperkara = $this->uri->segment(2);
		$data['judul'] = "Cetak Register Anak Belum 12 Tahun"; 

		$data['tahun_sekarang'] = date("Y",time());
		$data['bulan_sekarang'] = (int) date("m",time());

		$data['bulan'] = array("-1"=>'Pilih' ,"01"=>'Januari' ,"02"=>'Februari',"03"=>'Maret' ,"04"=>'April' ,"05"=>'Mei' ,"06"=> 'Juni',"07"=> 'Juli',"08"=>'Agustus' ,"09"=>'September' ,"10"=>'Oktober' ,"11"=> 'November',"12"=>'Desember'); 

		$queryTahun = $this->model->get_tahun_anakanak();
		$thn =array( );
		$thn['-1'] = "Pilih";
		foreach ($queryTahun->result() as $row) {
			$thn[''.$row->tahun.''] = $row->tahun;
		}

		$data['tahun'] = $thn;
		$data['idalurperkara'] = base64_encode($this->encrypt->encode($idalurperkara));
		$this->load->vars($data);
		$this->load->view('register/popup_cetak_register_anak_anak');	
	}



	
	public function cetak(){
		$bulan = $this->input->post('bulan',TRUE);
		$tahun = $this->input->post('tahun',TRUE);
		$idalurperkara = $this->input->post('idalurperkara');
		$xls   = $this->input->post('xls',TRUE);
		if(!empty($bulan) and !empty($tahun) and !empty($idalurperkara)){
			$this->nativesession->set_flash_session('bulan',$bulan);
			$this->nativesession->set_flash_session('tahun',$tahun);
			$this->nativesession->set_flash_session('idalurperkara',$idalurperkara);
			$this->nativesession->set_flash_session('xls',$xls);
			echo json_encode(array('st'=>1,'msg'=>'Silahkan Membuka Laporan Pada Tab'));
		}else{
			echo json_encode(array('st'=>0,'msg'=>'Parameter Kurang Lengkap'));
		}
	}

	public function tampil(){
		$data['bulan'] = $this->nativesession->get_flash_session('bulan');
		$data['tahun'] = $this->nativesession->get_flash_session('tahun');
		$idalurperkara = $this->encrypt->decode(base64_decode($this->nativesession->get_flash_session('idalurperkara')));
		$xls = $this->nativesession->get_flash_session('xls');
		$data['periode'] = $data['tahun']."-".$data['bulan'];

		switch ($data['bulan']) {
			case '01':
		        		$data['nama_bulan'] = 'Januari';
		        	break;
		      	case '02':
		        		$data['nama_bulan'] = 'Februari';
		        	break;
		      	case '03':
		        		$data['nama_bulan'] = 'Maret';
		        	break;
		      	case '04':
		        		$data['nama_bulan'] = 'April';
		        	break;
		      	case '05':
		        		$data['nama_bulan'] = 'Mei';
		        	break;
		      	case '06':
		        		$data['nama_bulan'] = 'Juni';
		        	break;
		      	case '07':
		        		$data['nama_bulan'] = 'Juli';
		        	break;
		      	case '08':
		        		$data['nama_bulan'] = 'Agustus';
		        	break;
		      	case '09':
		        		$data['nama_bulan'] = 'September';
		        	break;
		      	case '10':
		        		$data['nama_bulan'] = 'Oktober';
		        	break;
		      	case '11':
		        		$data['nama_bulan'] = 'Nopember';
		        	break;
		      	case '12':
		        		$data['nama_bulan'] = 'Desember';
		        	break;
		      	default:
		        		$data['nama_bulan'] = 'Wrong parameter';
		       	 break;
		}

		$data['idalurperkara'] = base64_encode($this->encrypt->encode($idalurperkara));
		if($idalurperkara=='118'){
			$data['queryRegister']= $this->model->get_register_utama($idalurperkara,$data['periode'] );
			if($xls==1){
				$data['nama_file'] = "register_anak_bulan_".$data['nama_bulan'].".xls";
			} else {
				$data['nama_file'] = "register_anak_bulan_".$data['nama_bulan'].".doc";
			}

			$data['fileview']= "register_anak.php";
			$data['xls']=$xls;
			$this->load->vars($data);
			$this->load->view('register/head_register');
		}
	}


	public function tampil_banding(){
		$data['bulan'] = $this->nativesession->get_flash_session('bulan');
		$data['tahun'] = $this->nativesession->get_flash_session('tahun');
		$idalurperkara = $this->encrypt->decode(base64_decode($this->nativesession->get_flash_session('idalurperkara')));
		$xls = $this->nativesession->get_flash_session('xls');
		$data['periode'] = $data['tahun']."-".$data['bulan'];

		switch ($data['bulan']) {
			case '01':
		        		$data['nama_bulan'] = 'Januari';
		        	break;
		      	case '02':
		        		$data['nama_bulan'] = 'Februari';
		        	break;
		      	case '03':
		        		$data['nama_bulan'] = 'Maret';
		        	break;
		      	case '04':
		        		$data['nama_bulan'] = 'April';
		        	break;
		      	case '05':
		        		$data['nama_bulan'] = 'Mei';
		        	break;
		      	case '06':
		        		$data['nama_bulan'] = 'Juni';
		        	break;
		      	case '07':
		        		$data['nama_bulan'] = 'Juli';
		        	break;
		      	case '08':
		        		$data['nama_bulan'] = 'Agustus';
		        	break;
		      	case '09':
		        		$data['nama_bulan'] = 'September';
		        	break;
		      	case '10':
		        		$data['nama_bulan'] = 'Oktober';
		        	break;
		      	case '11':
		        		$data['nama_bulan'] = 'Nopember';
		        	break;
		      	case '12':
		        		$data['nama_bulan'] = 'Desember';
		        	break;
		      	default:
		        		$data['nama_bulan'] = 'Wrong parameter';
		       	 break;
		}

		$data['idalurperkara'] = base64_encode($this->encrypt->encode($idalurperkara));
		if($idalurperkara=='118'){
		
			$data['queryRegister']= $this->model->get_register_banding_anak($data['periode'] );
			if($xls==1){
				$data['nama_file'] = "register_banding_anak_bulan_".$data['nama_bulan'].".xls";
			} else {
				$data['nama_file'] = "register_banding_anak_bulan_".$data['nama_bulan'].".doc";
			}

			$data['fileview']= "register_banding_anak.php";
			$data['xls']=$xls;
			$this->load->vars($data);
			$this->load->view('register/head_register_banding');
		} 
	}


	public function tampil_kasasi(){
		$data['bulan'] = $this->nativesession->get_flash_session('bulan');
		$data['tahun'] = $this->nativesession->get_flash_session('tahun');
		$idalurperkara = $this->encrypt->decode(base64_decode($this->nativesession->get_flash_session('idalurperkara')));
		$xls = $this->nativesession->get_flash_session('xls');
		$data['periode'] = $data['tahun']."-".$data['bulan'];

		switch ($data['bulan']) {
			case '01':
		        		$data['nama_bulan'] = 'Januari';
		        	break;
		      	case '02':
		        		$data['nama_bulan'] = 'Februari';
		        	break;
		      	case '03':
		        		$data['nama_bulan'] = 'Maret';
		        	break;
		      	case '04':
		        		$data['nama_bulan'] = 'April';
		        	break;
		      	case '05':
		        		$data['nama_bulan'] = 'Mei';
		        	break;
		      	case '06':
		        		$data['nama_bulan'] = 'Juni';
		        	break;
		      	case '07':
		        		$data['nama_bulan'] = 'Juli';
		        	break;
		      	case '08':
		        		$data['nama_bulan'] = 'Agustus';
		        	break;
		      	case '09':
		        		$data['nama_bulan'] = 'September';
		        	break;
		      	case '10':
		        		$data['nama_bulan'] = 'Oktober';
		        	break;
		      	case '11':
		        		$data['nama_bulan'] = 'Nopember';
		        	break;
		      	case '12':
		        		$data['nama_bulan'] = 'Desember';
		        	break;
		      	default:
		        		$data['nama_bulan'] = 'Wrong parameter';
		       	 break;
		}

		$data['idalurperkara'] = base64_encode($this->encrypt->encode($idalurperkara));
		if($idalurperkara=='118'){
		
			$data['queryRegister']= $this->model->get_register_kasasi_anak($data['periode'] );
			if($xls==1){
				$data['nama_file'] = "register_kasasi_anak_bulan_".$data['nama_bulan'].".xls";
			} else {
				$data['nama_file'] = "register_kasasi_anak_bulan_".$data['nama_bulan'].".doc";
			}

			$data['fileview']= "register_kasasi_anak.php";
			$data['xls']=$xls;
			$this->load->vars($data);
			$this->load->view('register/head_register_kasasi');
		} 
	}


	public function tampil_pk(){
		$data['bulan'] = $this->nativesession->get_flash_session('bulan');
		$data['tahun'] = $this->nativesession->get_flash_session('tahun');
		$idalurperkara = $this->encrypt->decode(base64_decode($this->nativesession->get_flash_session('idalurperkara')));
		$xls = $this->nativesession->get_flash_session('xls');
		$data['periode'] = $data['tahun']."-".$data['bulan'];

		switch ($data['bulan']) {
			case '01':
		        		$data['nama_bulan'] = 'Januari';
		        	break;
		      	case '02':
		        		$data['nama_bulan'] = 'Februari';
		        	break;
		      	case '03':
		        		$data['nama_bulan'] = 'Maret';
		        	break;
		      	case '04':
		        		$data['nama_bulan'] = 'April';
		        	break;
		      	case '05':
		        		$data['nama_bulan'] = 'Mei';
		        	break;
		      	case '06':
		        		$data['nama_bulan'] = 'Juni';
		        	break;
		      	case '07':
		        		$data['nama_bulan'] = 'Juli';
		        	break;
		      	case '08':
		        		$data['nama_bulan'] = 'Agustus';
		        	break;
		      	case '09':
		        		$data['nama_bulan'] = 'September';
		        	break;
		      	case '10':
		        		$data['nama_bulan'] = 'Oktober';
		        	break;
		      	case '11':
		        		$data['nama_bulan'] = 'Nopember';
		        	break;
		      	case '12':
		        		$data['nama_bulan'] = 'Desember';
		        	break;
		      	default:
		        		$data['nama_bulan'] = 'Wrong parameter';
		       	 break;
		}

		$data['idalurperkara'] = base64_encode($this->encrypt->encode($idalurperkara));
		if($idalurperkara=='118'){
		
			$data['queryRegister']= $this->model->get_register_pk_anak($data['periode'] );
			if($xls==1){
				$data['nama_file'] = "register_pk_anak_bulan_".$data['nama_bulan'].".xls";
			} else {
				$data['nama_file'] = "register_pk_anak_bulan_".$data['nama_bulan'].".doc";
			}

			$data['fileview']= "register_pk_anak.php";
			$data['xls']=$xls;
			$this->load->vars($data);
			$this->load->view('register/head_register_pk');
		} 
	}

	public function tampil_penahanan(){
		$data['bulan'] = $this->nativesession->get_flash_session('bulan');
		$data['tahun'] = $this->nativesession->get_flash_session('tahun');
		$idalurperkara = $this->encrypt->decode(base64_decode($this->nativesession->get_flash_session('idalurperkara')));
		$xls = $this->nativesession->get_flash_session('xls');
		$data['periode'] = $data['tahun']."-".$data['bulan'];

		switch ($data['bulan']) {
			case '01':
		        		$data['nama_bulan'] = 'Januari';
		        	break;
		      	case '02':
		        		$data['nama_bulan'] = 'Februari';
		        	break;
		      	case '03':
		        		$data['nama_bulan'] = 'Maret';
		        	break;
		      	case '04':
		        		$data['nama_bulan'] = 'April';
		        	break;
		      	case '05':
		        		$data['nama_bulan'] = 'Mei';
		        	break;
		      	case '06':
		        		$data['nama_bulan'] = 'Juni';
		        	break;
		      	case '07':
		        		$data['nama_bulan'] = 'Juli';
		        	break;
		      	case '08':
		        		$data['nama_bulan'] = 'Agustus';
		        	break;
		      	case '09':
		        		$data['nama_bulan'] = 'September';
		        	break;
		      	case '10':
		        		$data['nama_bulan'] = 'Oktober';
		        	break;
		      	case '11':
		        		$data['nama_bulan'] = 'Nopember';
		        	break;
		      	case '12':
		        		$data['nama_bulan'] = 'Desember';
		        	break;
		      	default:
		        		$data['nama_bulan'] = 'Wrong parameter';
		       	 break;
		}

		$data['idalurperkara'] = base64_encode($this->encrypt->encode($idalurperkara));
		if($idalurperkara=='118'){
		
			$data['queryRegister']= $this->model->get_register_penahanan_anak($data['periode'] );
			if($xls==1){
				$data['nama_file'] = "register_penahanan_anak_bulan_".$data['nama_bulan'].".xls";
			} else {
				$data['nama_file'] = "register_penahanan_anak_bulan_".$data['nama_bulan'].".doc";
			}

			$data['fileview']= "register_penahanan_anak.php";
			$data['xls']=$xls;
			$this->load->vars($data);
			$this->load->view('register/head_register_penahanan_anak');
		}  else {
			print_r("DODON HERE"); exit();
		}
	}

	public function tampil_diversi(){
		$data['bulan'] = $this->nativesession->get_flash_session('bulan');
		$data['tahun'] = $this->nativesession->get_flash_session('tahun');
		$xls = $this->nativesession->get_flash_session('xls');
		$data['periode'] = $data['tahun']."-".$data['bulan'];

		switch ($data['bulan']) {
			case '01':
		        		$data['nama_bulan'] = 'Januari';
		        	break;
		      	case '02':
		        		$data['nama_bulan'] = 'Februari';
		        	break;
		      	case '03':
		        		$data['nama_bulan'] = 'Maret';
		        	break;
		      	case '04':
		        		$data['nama_bulan'] = 'April';
		        	break;
		      	case '05':
		        		$data['nama_bulan'] = 'Mei';
		        	break;
		      	case '06':
		        		$data['nama_bulan'] = 'Juni';
		        	break;
		      	case '07':
		        		$data['nama_bulan'] = 'Juli';
		        	break;
		      	case '08':
		        		$data['nama_bulan'] = 'Agustus';
		        	break;
		      	case '09':
		        		$data['nama_bulan'] = 'September';
		        	break;
		      	case '10':
		        		$data['nama_bulan'] = 'Oktober';
		        	break;
		      	case '11':
		        		$data['nama_bulan'] = 'Nopember';
		        	break;
		      	case '12':
		        		$data['nama_bulan'] = 'Desember';
		        	break;
		      	default:
		        		$data['nama_bulan'] = 'Wrong parameter';
		       	 break;
		}

		$data['queryRegister']= $this->model->get_register_diversi($data['periode'] );
		if($xls==1){
			$data['nama_file'] = "register_kesepakatan_diversi_bulan_".$data['nama_bulan'].".xls";
		} else {
			$data['nama_file'] = "register_kesepakatan_diversi_bulan_".$data['nama_bulan'].".doc";
		}

		$data['fileview']= "register_diversi.php";
		$data['xls']=$xls;
		$this->load->vars($data);
		$this->load->view('register/head_register_diversi');
		
	}

	public function tampil_anak_saksi(){
		$data['bulan'] = $this->nativesession->get_flash_session('bulan');
		$data['tahun'] = $this->nativesession->get_flash_session('tahun');
		$xls = $this->nativesession->get_flash_session('xls');
		$data['periode'] = $data['tahun']."-".$data['bulan'];

		switch ($data['bulan']) {
			case '01':
		        		$data['nama_bulan'] = 'Januari';
		        	break;
		      	case '02':
		        		$data['nama_bulan'] = 'Februari';
		        	break;
		      	case '03':
		        		$data['nama_bulan'] = 'Maret';
		        	break;
		      	case '04':
		        		$data['nama_bulan'] = 'April';
		        	break;
		      	case '05':
		        		$data['nama_bulan'] = 'Mei';
		        	break;
		      	case '06':
		        		$data['nama_bulan'] = 'Juni';
		        	break;
		      	case '07':
		        		$data['nama_bulan'] = 'Juli';
		        	break;
		      	case '08':
		        		$data['nama_bulan'] = 'Agustus';
		        	break;
		      	case '09':
		        		$data['nama_bulan'] = 'September';
		        	break;
		      	case '10':
		        		$data['nama_bulan'] = 'Oktober';
		        	break;
		      	case '11':
		        		$data['nama_bulan'] = 'Nopember';
		        	break;
		      	case '12':
		        		$data['nama_bulan'] = 'Desember';
		        	break;
		      	default:
		        		$data['nama_bulan'] = 'Wrong parameter';
		       	 break;
		}

		$data['queryRegister']= $this->model->get_register_anak_korban_anak_saksi($data['periode'] );
		if($xls==1){
			$data['nama_file'] = "register_anak_korban_anak_saksi_bulan_".$data['nama_bulan'].".xls";
		} else {
			$data['nama_file'] = "register_anak_korban_anak_saksi_bulan_".$data['nama_bulan'].".doc";
		}

		$data['fileview']= "register_anak_saksi.php";
		$data['xls']=$xls;
		$this->load->vars($data);
		$this->load->view('register/head_register_anak_saksi');
		
	}

	public function tampil_anak_anak(){
		$data['bulan'] = $this->nativesession->get_flash_session('bulan');
		$data['tahun'] = $this->nativesession->get_flash_session('tahun');
		$xls = $this->nativesession->get_flash_session('xls');
		$data['periode'] = $data['tahun']."-".$data['bulan'];

		switch ($data['bulan']) {
			case '01':
		        		$data['nama_bulan'] = 'Januari';
		        	break;
		      	case '02':
		        		$data['nama_bulan'] = 'Februari';
		        	break;
		      	case '03':
		        		$data['nama_bulan'] = 'Maret';
		        	break;
		      	case '04':
		        		$data['nama_bulan'] = 'April';
		        	break;
		      	case '05':
		        		$data['nama_bulan'] = 'Mei';
		        	break;
		      	case '06':
		        		$data['nama_bulan'] = 'Juni';
		        	break;
		      	case '07':
		        		$data['nama_bulan'] = 'Juli';
		        	break;
		      	case '08':
		        		$data['nama_bulan'] = 'Agustus';
		        	break;
		      	case '09':
		        		$data['nama_bulan'] = 'September';
		        	break;
		      	case '10':
		        		$data['nama_bulan'] = 'Oktober';
		        	break;
		      	case '11':
		        		$data['nama_bulan'] = 'Nopember';
		        	break;
		      	case '12':
		        		$data['nama_bulan'] = 'Desember';
		        	break;
		      	default:
		        		$data['nama_bulan'] = 'Wrong parameter';
		       	 break;
		}

		$data['queryRegister']= $this->model->get_register_anak_anak($data['periode'] );
		if($xls==1){
			$data['nama_file'] = "register_anak_belum_duabelas_tahun_bulan_".$data['nama_bulan'].".xls";
		} else {
			$data['nama_file'] = "register_anak_belum_duabelas_tahun_bulan_".$data['nama_bulan'].".doc";
		}

		$data['fileview']= "register_anak_anak.php";
		$data['xls']=$xls;
		$this->load->vars($data);
		$this->load->view('register/head_register_anak_anak');
		
	}


	
}

?>
