<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class c_template_relaas_perdata extends CI_Controller {
    function index() {
         if($this->session->userdata('is_logged_in')==FALSE){
            redirect('login');
        }  
    }

    #25042017
    function popup_relaas_perdata_umum(){
        if($this->session->userdata('is_logged_in')==FALSE){
            redirect('login');
        }  
        $data['enc']    = $this->uri->segment('3');
        $idperkara      = $this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }
        $data['encjadwalsidang']=$this->uri->segment('4');
        $idjadwal=$this->encrypt->decode(base64_decode($data['encjadwalsidang']));        
        if(!is_numeric($idjadwal) OR !intval($idjadwal)>0){
            show_404();
            exit();
        }

        $pihak_ke = $this->uri->segment('5');
        if($pihak_ke==6)
            {$pihak_ke=5;}
        elseif($pihak_ke==7)
            {$pihak_ke=2;}
        elseif($pihak_ke==8)
            {$pihak_ke=4;}

        $data['jadwal_sidang_ke'] = $this->uri->segment('6');
        $this->load->model('generate_template/m_template_perdata_relaas','template');                       
        $data['listPihak'] = $this->template->getListPihak($idperkara,$pihak_ke);
        $data['listJsp'] = $this->template->getListJurusita($idperkara);                
        $alur_perkara_id = $this->tanggalhelper->getIDAlurPerkara($idperkara);
        if($alur_perkara_id==1){
            $jnsperkara = 'GUGATAN';
        }elseif($alur_perkara_id==7){
            $jnsperkara = 'DERDEN VERZET';
        }elseif($alur_perkara_id==8){
            $jnsperkara = 'GUGATAN SEDERHANA';
        }elseif($alur_perkara_id==2){
            $jnsperkara = 'PERMOHONAN';
        }

        if($pihak_ke==1 && ($alur_perkara_id==1 || $alur_perkara_id==7 || $alur_perkara_id==8)){
            $sebutan='PENGGUGAT';
            $data['jenisPihakText'] = 'Penggugat';
        }elseif($pihak_ke==2 && ($alur_perkara_id==1 || $alur_perkara_id==7 || $alur_perkara_id==8)){
            $sebutan='TERGUGAT';
            $data['jenisPihakText'] = 'Tergugat';
        }elseif($pihak_ke==4 && ($alur_perkara_id==1 || $alur_perkara_id==7 || $alur_perkara_id==8)){
            $sebutan='TURUT TERGUGAT';
            $data['jenisPihakText'] = 'Turut Tergugat';
        }elseif(($pihak_ke==5 || $pihak_ke==6) && ($alur_perkara_id==1 || $alur_perkara_id==7 || $alur_perkara_id==8)){
            $sebutan='SAKSI/AHLI/PENERJEMAH';
            $data['jenisPihakText'] = 'Saksi/Ahli';
        }elseif($pihak_ke==1 && $alur_perkara_id==2){
            $sebutan='PEMOHON';
            $data['jenisPihakText'] = 'Pemohon';
        }
        $data['judul']="RELAAS PANGGILAN KEPADA ".$sebutan; //override
        $data['jnsperkara']=$jnsperkara;
        $data['pihak'] = $this->uri->segment('5');
        $this->load->view('generate_template/umum/relaas/popup_relaas_perdata',$data,FALSE);
    }

    
    function cetak_risalah_relaas() {      
        if($this->session->userdata('is_logged_in')==FALSE){
        redirect('login'); }                       
       
        $data_id=array(
                    'source_file'=>'peradilan_umum/perdata/relaas/REDAKSI_RISALAH_RELAAS.rtf');               
        $this->load->model('generate_template/var_template','var_template');
        $this->var_template->kirim_variabel($data_id);        
    }

    function cetak_relaas_perdata_umum() {      
        if($this->session->userdata('is_logged_in')==FALSE){
        redirect('login'); }
             
        $idperkara=$this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }       
        $id_jadwal_sidang =$this->encrypt->decode(base64_decode($this->input->post('encjadwalsidang',TRUE)));
        $jurusita_id = $this->encrypt->decode(base64_decode($this->input->post('idjurusita',TRUE))); 
        $pihak_id = $this->encrypt->decode(base64_decode($this->input->post('idpihak',TRUE)));       
        $jadwal_sidang_ke = $this->input->post('jadwal_sidang_ke',TRUE);
        $pihak_ke = $this->input->post('pihak_ke',TRUE);
        $alur_perkara_id = $this->tanggalhelper->getIDAlurPerkara($idperkara);

        if($alur_perkara_id==1 || $alur_perkara_id==7 || $alur_perkara_id==8){
            if($jadwal_sidang_ke==1 && $pihak_ke==1){
            	$filenya = 'peradilan_umum/perdata/relaas/PGL_1_GUGATAN_P_SIDANG_PERTAMA.rtf';
            }elseif($jadwal_sidang_ke==1 && $pihak_ke==2) {
            	$filenya = 'peradilan_umum/perdata/relaas/PGL_2_GUGATAN_T_SIDANG_PERTAMA.rtf';
            }elseif($jadwal_sidang_ke==1 && $pihak_ke==4) {
            	$filenya = 'peradilan_umum/perdata/relaas/PGL_2_GUGATAN_TT_SIDANG_PERTAMA.rtf';
            }elseif($jadwal_sidang_ke>1 && $pihak_ke==1) {
            	$filenya = 'peradilan_umum/perdata/relaas/PGL_1_GUGATAN_P_SIDANG_LANJUTAN.rtf';
            }elseif($jadwal_sidang_ke>1 && $pihak_ke==2) {
            	$filenya = 'peradilan_umum/perdata/relaas/PGL_2_GUGATAN_T_SIDANG_LANJUTAN.rtf';
            }elseif($jadwal_sidang_ke>1 && $pihak_ke==4) {
            	$filenya = 'peradilan_umum/perdata/relaas/PGL_2_GUGATAN_TT_SIDANG_LANJUTAN.rtf';
            }elseif($jadwal_sidang_ke>1 && $pihak_ke==5) {
            	$filenya = 'peradilan_umum/perdata/relaas/PGL_3_GUGATAN_SAKSI.rtf';
            }elseif($jadwal_sidang_ke>1 && $pihak_ke==6) {
            	$filenya = 'peradilan_umum/perdata/relaas/PGL_3_GUGATAN_AHLI.rtf';
            }elseif($jadwal_sidang_ke>1 && $pihak_ke==7) {
                $filenya = 'peradilan_umum/perdata/relaas/PGL_2_GUGATAN_T_GHOIB.rtf';
            }elseif($jadwal_sidang_ke>1 && $pihak_ke==8) {
                $filenya = 'peradilan_umum/perdata/relaas/PGL_2_GUGATAN_TT_GHOIB.rtf';
            }
        }elseif($alur_perkara_id==2){
            if($jadwal_sidang_ke==1 && $pihak_ke==1){
                $filenya = 'peradilan_umum/perdata/relaas/PGL_1_PERMOHONAN_P_SIDANG_PERTAMA.rtf';
            }elseif($jadwal_sidang_ke>1 && $pihak_ke==1) {
                $filenya = 'peradilan_umum/perdata/relaas/PGL_1_PERMOHONAN_P_SIDANG_LANJUTAN.rtf';
            }
        }
        
        $data_id=array(
                    'source_file'=>$filenya,
                    'perkara_id'=>$idperkara,
                    'jadwal_sidang_id'=>$id_jadwal_sidang,
                    'jurusita_id'=>$jurusita_id,
                    'pihak_id'=>$pihak_id);               
        $this->load->model('generate_template/var_template','var_template');
        $this->var_template->kirim_variabel($data_id);        
    }

    function popup_relaas_pbt_pts(){
        if($this->session->userdata('is_logged_in')==FALSE){
            redirect('login');
        }  
        $data['enc']    = $this->uri->segment('3');
        $idperkara      = $this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }
        $data['enc_pihak_id']=$this->uri->segment('4');
        $pihak_ke = $this->uri->segment('5');        
        $data['verstek'] = $this->uri->segment('6');
        
        $this->load->model('generate_template/m_template_perdata_relaas','template');
        $data['listJsp'] = $this->template->getListJurusita($idperkara);                
        $alur_perkara_id = $this->tanggalhelper->getIDAlurPerkara($idperkara);
        if($alur_perkara_id==1){
            $jnsperkara = 'GUGATAN';
        }elseif($alur_perkara_id==7){
            $jnsperkara = 'DERDEN VERZET';
        }elseif($alur_perkara_id==8){
            $jnsperkara = 'GUGATAN SEDERHANA';
        }elseif($alur_perkara_id==2){
            $jnsperkara = 'PERMOHONAN';
        }

        if($pihak_ke==1 && ($alur_perkara_id==1 || $alur_perkara_id==7 || $alur_perkara_id==8)){
            $sebutan='PENGGUGAT';
            $data['jenisPihakText'] = 'Penggugat';
        }elseif($pihak_ke==2 && ($alur_perkara_id==1 || $alur_perkara_id==7 || $alur_perkara_id==8)){
            $sebutan='TERGUGAT';
            $data['jenisPihakText'] = 'Tergugat';
        }elseif($pihak_ke==4 && ($alur_perkara_id==1 || $alur_perkara_id==7 || $alur_perkara_id==8)){
            $sebutan='TURUT TERGUGAT';
            $data['jenisPihakText'] = 'Turut Tergugat';
        }elseif($pihak_ke==1 && $alur_perkara_id==2){
            $sebutan='PEMOHON';
            $data['jenisPihakText'] = 'Pemohon';
        }elseif($pihak_ke==2 && $alur_perkara_id==2){
            $sebutan='TERMOHON';
            $data['jenisPihakText'] = 'Termohon';
        }
        $data['judul']="RELAAS PEMBERITAHUAN PUTUSAN <br> KEPADA ".$sebutan; //override
        $data['jnsperkara']=$jnsperkara;
        $data['pihak'] = $this->uri->segment('5');
        $this->load->view('generate_template/umum/relaas/popup_relaas_pbt_perdata',$data,FALSE);
    }

    function cetak_pemberitahuan_pts() {      
        if($this->session->userdata('is_logged_in')==FALSE){
        redirect('login'); }                       
        
        $enc_perkara_id = $this->input->post('enc',TRUE);
        $idperkara      = $this->encrypt->decode(base64_decode($enc_perkara_id));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }
        $jurusita_id = $this->encrypt->decode(base64_decode($this->input->post('idjurusita',TRUE)));
        $pihak_id = $this->encrypt->decode(base64_decode($this->input->post('enc_pihak_id',TRUE)));
        $pihak_ke = $this->input->post('pihak_ke',TRUE);
        $verstek = $this->input->post('verstek',TRUE);
        $alamat_pihak = $this->input->post('alamat',TRUE);

        if($pihak_ke==1){
            $filenya = 'peradilan_umum/perdata/relaas/PBT_1_GUGATAN_P_PTS.rtf';
        }elseif($pihak_ke==2 && $verstek!='Y') {
            $filenya = 'peradilan_umum/perdata/relaas/PBT_1_GUGATAN_T_PTS.rtf';
        }elseif($pihak_ke==2 && $verstek=='Y' && $alamat_pihak==1) {
            $filenya = 'peradilan_umum/perdata/relaas/PBT_1_GUGATAN_T_PTS_VERSTEK.rtf';
        }elseif($pihak_ke==2 && $verstek=='Y' &&$alamat_pihak==2) {
            $filenya = 'peradilan_umum/perdata/relaas/PBT_1_GUGATAN_T_GHOIB_PTS_VERSTEK.rtf';
        }elseif($pihak_ke==4 && $verstek!='Y') {
            $filenya = 'peradilan_umum/perdata/relaas/PBT_1_GUGATAN_TT_PTS.rtf';
        }elseif($pihak_ke==4 && $verstek=='Y' && $alamat_pihak==1) {
            $filenya = 'peradilan_umum/perdata/relaas/PBT_1_GUGATAN_TT_PTS_VERSTEK.rtf';
        }elseif($pihak_ke==4 && $verstek=='Y' && $alamat_pihak==2) {
            $filenya = 'peradilan_umum/perdata/relaas/PBT_1_GUGATAN_TT_GHOIB_PTS_VERSTEK.rtf';
        }

        $data_id=array(
                    'source_file'=>$filenya,
                    'perkara_id'=>$idperkara,
                    'pihak_id'=>$pihak_id,
                    'jurusita_id'=>$jurusita_id);               
        $this->load->model('generate_template/var_template','var_template');
        $this->var_template->kirim_variabel($data_id);        
    }
    #end
	
    function popup_relaas(){
        if($this->session->userdata('is_logged_in')==FALSE){
            redirect('login');
        }  
        $data['enc']=$this->uri->segment('3');
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }
        $data['encjadwalsidang']=$this->uri->segment('4');
        $idjadwal=$this->encrypt->decode(base64_decode($data['encjadwalsidang']));        
        if(!is_numeric($idjadwal) OR !intval($idjadwal)>0){
            show_404();
            exit();
        }

		$this->load->model('generate_template/m_template_perdata_relaas','template');				
		$data['jenisPihakText'] = 'Penggugat';
		$data['listPihak'] = $this->template->getListPihak($idperkara,1);
		$data['listJsp'] = $this->template->getListJurusita($idperkara);		
		$data['listKuasaHukum'] = $this->template->getKuasaHukum($idperkara,1);
		$data['listBiaya'] = $this->template->getBiayaPerkara($idperkara,12);
		$data['listPnbp'] = $this->template->getBiayaPerkara($idperkara,236);
        $data['listSidang'] = $this->template->getTanggalPersidangan($idjadwal);
        foreach ($data['listSidang']->result() as $row) {
            $data['tglsidang'] = $this->tanggalhelper->convertToInputDate($row->tanggal_sidang);
        }

        $this->load->model('generate_template/m_template_ambil_identitas_template','template2');		
        $template=$this->template2->getDataDocumentTemplate('1','14','200','101','');
		$i=0;
        foreach ($template->result() as $template)
        {
        	if ($i=='0')
        	{
            	$judul=$template->namatemplate;
                $judul=explode("Kepada",$judul);
                $jnsperkara=$template->jnsperkara;
			}
		}

		$data['judul']="RELAAS PANGGILAN KEPADA PENGGUGAT"; //override
		$data['jnsperkara']=$jnsperkara;

		$this->load->view('generate_template/popup_relaas_perdata',$data,FALSE);
	}

    function cetak_relaas_penggugat(){
        if($this->session->userdata('is_logged_in')==FALSE){
            redirect('login');
        } 
        $data['enc'] = $this->input->post('enc',TRUE);
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
             show_404();
             exit();
        }

        $data['encjadwalsidang'] = $this->input->post('encjadwalsidang',TRUE);
        $idjadwal=$this->encrypt->decode(base64_decode($data['encjadwalsidang']));
        if(!is_numeric($idjadwal) OR !intval($idjadwal)>0){
             show_404();
             exit();
        }
        
        $data['idJurusita'] = $this->input->post('idjurusita',TRUE);
        $idJurusita=$this->encrypt->decode(base64_decode($data['idJurusita']));
        if(!is_numeric($idJurusita) OR !intval($idJurusita)>0){
            show_404();
            exit();
        }

        $data['idpihak'] = $this->input->post('idpihak',TRUE);
        $idpihak=$this->encrypt->decode(base64_decode($data['idpihak']));
         if(!is_numeric($idpihak) OR !intval($idpihak)>0){
             show_404();
             exit();
        }

        $data['jenisRelaas'] = $this->input->post('jenisRelaas',TRUE);
         if(!is_numeric($data['jenisRelaas']) OR !intval($data['jenisRelaas'])>0){
             show_404();
             exit();
        }
        $data['jabatanJS'] = $this->input->post('jabatanJS',TRUE);      
        $data['tglpanggil'] = $this->input->post('tglPanggil',TRUE);
        $data['tglPanggil'] = $this->tanggalhelper->convertToMysqlDate($data['tglpanggil']);
        $data['idPengacara'] = $this->input->post('idkuasaHukum',TRUE);
        $idPengacara=$this->encrypt->decode(base64_decode($data['idPengacara']));

        $data['idBiaya'] = $this->input->post('biayaPerkara',TRUE);
        $data['idPnbp'] = $this->input->post('pnbpPerkara',TRUE);
        $data['namaWaris'] = $this->input->post('namaSaksi',TRUE);
        $data['pekerjaanWaris'] = $this->input->post('pekerjaanSaksi',TRUE);
        $data['alamatWaris'] = $this->input->post('alamatSaksi',TRUE);  
        $data['tglPersidangan'] = $this->input->post('tglPersidangan',TRUE);
        
        $this->load->model('generate_template/m_template_perdata_relaas','template');
        $data['data_perkara'] = $this->template->getDataPerkara($idperkara);
        $data['data_pn'] = $this->template->getDataPN($idperkara);        
        $data['data_penggugat'] = $this->template->getPihakPenggugat($idperkara);  
        $data['data_tergugat'] = $this->template->getDataPihakTergugat($idperkara);                
        $data['cetak_data_penggugat'] = $this->template->getCetakPihakPenggugat($idpihak);
        $data['data_pengacara_penggugat'] = $this->template->getKuasaHukumP($idperkara);        
        $data['cetak_pengacara_penggugat'] = $this->template->getKuasaHukumCetak($idPengacara);
        $data['listSidang'] = $this->template->getTanggalPersidangan($idjadwal);
        $data['listBiaya'] = $this->template->getBiayaPerkara($idperkara,12);
        $data['listPnbp'] = $this->template->getBiayaPerkara($idperkara,236);
        $data['dataPihak'] = $this->template->getPihakInfo($idpihak);
        $data['listJsp'] = $this->template->getListJurusita($idperkara);

        $this->load->model('generate_template/m_template_ambil_identitas_template','template2');        
        if($data['jenisRelaas']==1){
            $data['template']=$this->template2->getDataDocumentTemplate('1','14','200','101','');
        }elseif($data['jenisRelaas']==2){
            $data['template']=$this->template2->getDataDocumentTemplate('1','14','200','102','');
        }elseif($data['jenisRelaas']==3){
            $data['template']=$this->template2->getDataDocumentTemplate('1','14','200','105','');
        }elseif($data['jenisRelaas']==4){
            $data['template']=$this->template2->getDataDocumentTemplate('1','14','200','106','');
        }elseif($data['jenisRelaas']==5){
            $data['template']=$this->template2->getDataDocumentTemplate('1','14','200','103','');
        }elseif($data['jenisRelaas']==6){
            $data['template']=$this->template2->getDataDocumentTemplate('1','14','200','104','');
        }elseif($data['jenisRelaas']==7){
            $data['template']=$this->template2->getDataDocumentTemplate('1','14','200','107','');
        }elseif($data['jenisRelaas']==8){
            $data['template']=$this->template2->getDataDocumentTemplate('1','14','200','108','');
        }elseif($data['jenisRelaas']==9){
            $data['template']=$this->template2->getDataDocumentTemplate('1','14','200','109','');
        }elseif($data['jenisRelaas']==10){
            $data['template']=$this->template2->getDataDocumentTemplate('1','14','200','110','');
        }elseif($data['jenisRelaas']==11){
            $data['template']=$this->template2->getDataDocumentTemplate('1','14','200','111','');
        }elseif($data['jenisRelaas']==12){
            $data['template']=$this->template2->getDataDocumentTemplate('1','14','200','112','');
        }elseif($data['jenisRelaas']==13){
            $data['template']=$this->template2->getDataDocumentTemplate('1','14','200','113','');
        }elseif($data['jenisRelaas']==14){
            $data['template']=$this->template2->getDataDocumentTemplate('1','14','200','114','');
        }else{
            echo "string4";
            show_404();
        }        
        $this->load->view('generate_template/cetak_relaas_perdata',$data,FALSE);
    }	

	function popup_relaas_tergugat(){
        if($this->session->userdata('is_logged_in')==FALSE){
            redirect('login');
        }  

		$segment = $this->uri->segment_array();
        $data['enc']=$this->uri->segment('3');
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }
        $data['encjadwalsidang']=$this->uri->segment('4');
        $idjadwal=$this->encrypt->decode(base64_decode($data['encjadwalsidang']));        
        if(!is_numeric($idjadwal) OR !intval($idjadwal)>0){
            show_404();
            exit();
        }

		$this->load->model('generate_template/m_template_perdata_relaas','template');		
		$data['jenisPihakText'] = 'Tergugat';
		$data['listPihak'] = $this->template->getListPihak($idperkara,2);
		$data['listJsp'] = $this->template->getListJurusita($idperkara);		
		$data['listKuasaHukum'] = $this->template->getKuasaHukum($idperkara,2);
		$data['listBiaya'] = $this->template->getBiayaPerkara($idperkara,14);
		$data['listPnbp'] = $this->template->getBiayaPerkara($idperkara,237);
        $data['listSidang'] = $this->template->getTanggalPersidangan($idjadwal);
        foreach ($data['listSidang']->result() as $row) {
            $data['tglsidang'] = $this->tanggalhelper->convertToInputDate($row->tanggal_sidang);
        }

        $this->load->model('generate_template/m_template_ambil_identitas_template','template2');		
        $template=$this->template2->getDataDocumentTemplate('1','14','200','115','');
		$i=0;
        foreach ($template->result() as $template)
        {
        	if ($i=='0')
        	{
            	$judul=$template->namatemplate;
                $judul=explode("Kepada",$judul);
                $jnsperkara=$template->jnsperkara;
			}
		}

		$data['judul']="RELAAS PANGGILAN KEPADA TERGUGAT"; //override
		$data['jnsperkara']=$jnsperkara;
		$this->load->view('generate_template/popup_relaas_perdata_tergugat',$data,FALSE);		
	}

	function cetak_relaas_tergugat(){
        if($this->session->userdata('is_logged_in')==FALSE){
            redirect('login');
        } 
        $data['enc'] = $this->input->post('enc',TRUE);
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));       
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
             show_404();
             exit();
        }

        $data['encjadwalsidang'] = $this->input->post('encjadwalsidang',TRUE);
        $idjadwal=$this->encrypt->decode(base64_decode($data['encjadwalsidang']));       
        if(!is_numeric($idjadwal) OR !intval($idjadwal)>0){
             show_404();
             exit();
        }
        
        $data['idJurusita'] = $this->input->post('idjurusita',TRUE);
        $idJurusita=$this->encrypt->decode(base64_decode($data['idJurusita']));        
        if(!is_numeric($idJurusita) OR !intval($idJurusita)>0){
            show_404();
            exit();
        }

        $data['idpihak'] = $this->input->post('idpihak',TRUE);
        $idpihak=$this->encrypt->decode(base64_decode($data['idpihak']));        
        if(!is_numeric($idpihak) OR !intval($idpihak)>0){
             show_404();
             exit();
        }

        $data['jenisRelaas'] = $this->input->post('jenisRelaas',TRUE);
        if(!is_numeric($data['jenisRelaas']) OR !intval($data['jenisRelaas'])>0){
             show_404();
             exit();
        }
        $data['jabatanJS'] = $this->input->post('jabatanJS',TRUE);      
        $data['tglpanggil'] = $this->input->post('tglPanggil',TRUE);
        $data['tglPanggil'] = $this->tanggalhelper->convertToMysqlDate($data['tglpanggil']);
        $data['idPengacara'] = $this->input->post('idkuasaHukum',TRUE);
        $idPengacara=$this->encrypt->decode(base64_decode($data['idPengacara']));
        
        $data['idBiaya'] = $this->input->post('biayaPerkara',TRUE);
        $data['idPnbp'] = $this->input->post('pnbpPerkara',TRUE);
        $data['idPengumuman'] = $this->input->post('pengumuman',TRUE);
        $data['namaWaris'] = $this->input->post('namaSaksi',TRUE);
        $data['pekerjaanWaris'] = $this->input->post('pekerjaanSaksi',TRUE);
        $data['alamatWaris'] = $this->input->post('alamatSaksi',TRUE);  
        $data['tglPersidangan'] = $this->input->post('tglPersidangan',TRUE);
        
        $this->load->model('generate_template/m_template_perdata_relaas','template');        
        $data['data_perkara'] = $this->template->getDataPerkara($idperkara);
        $data['data_pn'] = $this->template->getDataPN($idperkara);
        $data['data_penggugat'] = $this->template->getPihakPenggugat($idperkara);  
        $data['data_tergugat'] = $this->template->getDataPihakTergugat($idperkara);      
        $data['data_pengacara_penggugat'] = $this->template->getKuasaHukumP($idperkara); 
        $data['cetak_data_tergugat'] = $this->template->getCetakPihakTergugat($idpihak);       
        $data['cetak_pengacara_penggugat'] = $this->template->getKuasaHukumCetak($idPengacara);
        $data['listSidang'] = $this->template->getTanggalPersidangan($idjadwal);
        $data['listBiaya'] = $this->template->getCetakBiayaPerkara($data['idBiaya']);
        $data['listPengumuman'] = $this->template->getCetakBiayaPerkara($data['idPengumuman']);
        $data['listPnbp'] = $this->template->getCetakBiayaPerkara($data['idPnbp']);
        $data['dataPihak'] = $this->template->getPihakInfo($idpihak);
        $data['listJsp'] = $this->template->getListJurusita($idperkara);        

        $this->load->model('generate_template/m_template_ambil_identitas_template','template2');        
        if($data['jenisRelaas']==1){
            $data['template']=$this->template2->getDataDocumentTemplate('1','14','200','115','');
        }elseif($data['jenisRelaas']==2){
            $data['template']=$this->template2->getDataDocumentTemplate('1','14','200','119','');
        }elseif($data['jenisRelaas']==3){
            $data['template']=$this->template2->getDataDocumentTemplate('1','14','200','116','');
        }elseif($data['jenisRelaas']==4){
            $data['template']=$this->template2->getDataDocumentTemplate('1','14','200','120','');
        }elseif($data['jenisRelaas']==5){
            $data['template']=$this->template2->getDataDocumentTemplate('1','14','200','117','');
        }elseif($data['jenisRelaas']==6){
            $data['template']=$this->template2->getDataDocumentTemplate('1','14','200','121','');
        }elseif($data['jenisRelaas']==7){
            $data['template']=$this->template2->getDataDocumentTemplate('1','14','200','118','');
        }elseif($data['jenisRelaas']==8){
            $data['template']=$this->template2->getDataDocumentTemplate('1','14','200','122','');
        }elseif($data['jenisRelaas']==9){
            $data['template']=$this->template2->getDataDocumentTemplate('1','14','200','131','');
        }elseif($data['jenisRelaas']==10){
            $data['template']=$this->template2->getDataDocumentTemplate('1','14','200','132','');
        }elseif($data['jenisRelaas']==11){
            $data['template']=$this->template2->getDataDocumentTemplate('1','14','200','135','');
        }elseif($data['jenisRelaas']==12){
            $data['template']=$this->template2->getDataDocumentTemplate('1','14','200','136','');
        }elseif($data['jenisRelaas']==13){
            $data['template']=$this->template2->getDataDocumentTemplate('1','14','200','137','');
        }elseif($data['jenisRelaas']==14){
            $data['template']=$this->template2->getDataDocumentTemplate('1','14','200','138','');
        }elseif($data['jenisRelaas']==15){
            $data['template']=$this->template2->getDataDocumentTemplate('1','14','200','143','');
        }elseif($data['jenisRelaas']==16){
            $data['template']=$this->template2->getDataDocumentTemplate('1','14','200','144','');
        }else{
            show_404();
            exit();
        }
        $this->load->view('generate_template/cetak_relaas_perdata_tergugat',$data,FALSE);
    }

	function popup_relaas_saksi(){
        if($this->session->userdata('is_logged_in')==FALSE){
            redirect('login');
        }  
        $segment = $this->uri->segment_array();
        $data['enc']=$this->uri->segment('3');
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }

        $data['encjadwalsidang']=$this->uri->segment('4');
        $idjadwal=$this->encrypt->decode(base64_decode($data['encjadwalsidang']));        
        if(!is_numeric($idjadwal) OR !intval($idjadwal)>0){
            show_404();
            exit();
        }

        $data['idsaksi'] = $segment['5']; 
        $this->load->model('generate_template/m_template_perdata_relaas','template');
        $data['listJsp'] = $this->template->getListJurusita($idperkara);        
        $data['listBiaya'] = $this->template->getBiayaPerkaraSaksi($idperkara);
        $data['listPnbp'] = $this->template->getBiayaPerkaraSaksiPnbp($idperkara);
        $data['listSidang'] = $this->template->getTanggalPersidangan($idjadwal);
        foreach ($data['listSidang']->result() as $row) {
            $data['tglsidang'] = $this->tanggalhelper->convertToInputDate($row->tanggal_sidang);
        }
        
        $this->load->model('generate_template/m_template_ambil_identitas_template','template2');        
        $template=$this->template2->getDataDocumentTemplate('1','14','200','150','');
        $i=0;
        foreach ($template->result() as $template)
        {
            if ($i=='0')
            {
                $judul=$template->namatemplate;
                $judul=explode("Kepada",$judul);
                $jnsperkara=$template->jnsperkara;
            }
        }

        $data['jnsperkara']=$jnsperkara;

        if ($data['idsaksi']==1){
            $data['judul'] = 'CETAK RELAAS PANGGILAN SAKSI';        
        }elseif($data['idsaksi']==2){
            $data['judul'] = 'CETAK RELAAS PANGGILAN SAKSI AHLI';       
        }elseif($data['idsaksi']==3){
            $data['judul'] = 'CETAK RELAAS PANGGILAN JURU BAHASA';      
        }elseif($data['idsaksi']==4){
            $data['judul'] = 'CETAK RELAAS PANGGILAN PENERJEMAH';       
        }

        $this->load->view('generate_template/popup_relaas_perdata_saksi',$data,FALSE);
        
    }
	
    function cetak_relaas_saksi(){
        if($this->session->userdata('is_logged_in')==FALSE){
            redirect('login');
        }                 
        $data['enc'] = $this->input->post('enc',TRUE);
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));       
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
             show_404();
             exit();
        }

        $data['encjadwalsidang'] = $this->input->post('encjadwalsidang',TRUE);
        $idjadwal=$this->encrypt->decode(base64_decode($data['encjadwalsidang']));       
        if(!is_numeric($idjadwal) OR !intval($idjadwal)>0){
             show_404();
             exit();
        }
        
        $data['idJurusita'] = $this->input->post('idjurusita',TRUE);
        $idJurusita=$this->encrypt->decode(base64_decode($data['idJurusita']));        
        if(!is_numeric($idJurusita) OR !intval($idJurusita)>0){
            show_404();
            exit();
        }
        $data['atasPermin'] = $this->input->post('atasPermin',TRUE);
        if(!is_numeric($data['atasPermin']) OR !intval($data['atasPermin'])>0){
             show_404();
             exit();
        } 
        $data['idsaksi'] = $this->input->post('idsaksi',TRUE);
        if(!is_numeric($data['idsaksi']) OR !intval($data['idsaksi'])>0){
             show_404();
             exit();
        }       

        $data['jabatanJS'] = $this->input->post('jabatanJS',TRUE);      
        $data['tglpanggil'] = $this->input->post('tglPanggil',TRUE);
        $data['tglPanggil'] = $this->tanggalhelper->convertToMysqlDate($data['tglpanggil']);

        $data['idBiaya'] = $this->input->post('biayaPerkara',TRUE);
        $data['idPnbp'] = $this->input->post('pnbpPerkara',TRUE);
        $data['namasaksi'] = $this->input->post('namaSaksi',TRUE);
        $data['pekerjaansaksi'] = $this->input->post('pekerjaanSaksi',TRUE);
        $data['alamatsaksi'] = $this->input->post('alamatSaksi',TRUE);  
        $data['tglPersidangan'] = $this->input->post('tglPersidangan',TRUE);

        $this->load->model('generate_template/m_template_perdata_relaas','template');      
        $data['data_perkara'] = $this->template->getDataPerkara($idperkara);
        $data['data_pn'] = $this->template->getDataPN($idperkara);
        $data['data_penggugat'] = $this->template->getPihakPenggugat($idperkara);  
        $data['data_tergugat'] = $this->template->getDataPihakTergugat($idperkara);      
        $data['data_pengacara_penggugat'] = $this->template->getKuasaHukumP($idperkara);       
        $data['cetak_pengacara_penggugat'] = $this->template->getKuasaHukumCetak($idperkara);
        $data['listSidang'] = $this->template->getTanggalPersidangan($idjadwal);
        $data['listBiaya'] = $this->template->getCetakBiayaPerkara($data['idBiaya']);
        $data['listPnbp'] = $this->template->getCetakBiayaPerkara($data['idPnbp']);
        $data['listJsp'] = $this->template->getListJurusita($idperkara);

        $this->load->model('generate_template/m_template_ambil_identitas_template','template2');        
        if($data['idsaksi']==1){
            $data['template']=$this->template2->getDataDocumentTemplate('1','14','200','150','');
        }elseif ($data['idsaksi']==2) {
            $data['template']=$this->template2->getDataDocumentTemplate('1','14','200','151','');
        }elseif ($data['idsaksi']==3) {
            $data['template']=$this->template2->getDataDocumentTemplate('1','14','200','152','');
        }elseif ($data['idsaksi']==4) {
            $data['template']=$this->template2->getDataDocumentTemplate('1','14','200','153','');
        }else{
            show_404();
            exit();
        }
        $this->load->view('generate_template/cetak_relaas_perdata_saksi',$data,FALSE);
    }
function popup_bas_pertama(){
        if($this->session->userdata('is_logged_in')==FALSE){
            redirect('login');
        }  
        $data['enc']=$this->uri->segment('3');
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }
        $data['encjadwalsidang']=$this->uri->segment('4');
        $idjadwal=$this->encrypt->decode(base64_decode($data['encjadwalsidang']));        
        if(!is_numeric($idjadwal) OR !intval($idjadwal)>0){
            show_404();
            exit();
        }

		$this->load->model('generate_template/m_template_perdata_relaas','template');				
		$data['jenisPihakText'] = 'Penggugat';
        $data['blangko_bas_pertama_agama']=$this->template->blangko_bas_pertama_agama();
		$data['listPihak'] = $this->template->getListPihak($idperkara,1);
		$data['listJsp'] = $this->template->getListJurusita($idperkara);		
		$data['listKuasaHukum'] = $this->template->getKuasaHukum($idperkara,1);
		$data['listBiaya'] = $this->template->getBiayaPerkara($idperkara,12);
		$data['listPnbp'] = $this->template->getBiayaPerkara($idperkara,236);
        $data['listSidang'] = $this->template->getTanggalPersidangan($idjadwal);
        foreach ($data['listSidang']->result() as $row) {
            $data['tglsidang'] = $this->tanggalhelper->convertToInputDate($row->tanggal_sidang);
        }

        $this->load->model('generate_template/m_template_ambil_identitas_template','template2');		
        $template=$this->template2->getDataDocumentTemplate('1','14','200','101','');
		$i=0;
        foreach ($template->result() as $template)
        {
        	if ($i=='0')
        	{
            	$judul=$template->namatemplate;
                $judul=explode("Kepada",$judul);
                $jnsperkara=$template->jnsperkara;
			}
		}

		$data['judul']="BERITA ACARA SIDANG PERTAMA"; //override
		$data['jnsperkara']=$jnsperkara;

		$this->load->view('generate_template/popup_berita_acara_pertama_agama',$data,FALSE);
	}
    function cetak_bas_pertama_agama(){  
        if($this->session->userdata('is_logged_in')==FALSE){
        redirect('login'); }

        $data['enc']=$this->input->post('enc',TRUE);
		$idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }  
        $data['encjadwalsidang'] = $this->input->post('encjadwalsidang',TRUE);
        $idjadwal=$this->encrypt->decode(base64_decode($data['encjadwalsidang']));
        if(!is_numeric($idjadwal) OR !intval($idjadwal)>0){
             show_404();
             exit();
        }
        
        $data['blangko_bas_pertama_agama'] = $this->input->post('blangko_bas_pertama_agama',TRUE);

        $this->load->model('jadwalsidang/jadwal_sidang_m','template');
		$data['dataPihak1']=$this->template->get_data_pihak_loop($idperkara,1);
        $data['dataPihak2']=$this->template->get_data_pihak_loop($idperkara,2);
		
        $data['dataperkara'] = $this->template->getDataPerkara($idperkara);
        $data['datapengadilan'] = $this->template->getDataPA();
        $data['datapenetapanpanitera']=$this->template->getDataPenetapanPanitera($idperkara);
        $data['datapenetapanhakim']=$this->template->getDataPenetapanHakim($idperkara);
        $data['datapaniterapengganti']=$this->template->getDataPP($idperkara);
		 $data['dataamar']=$this->template->getAmar($idperkara);
		 $data['datapersidangan']=$this->template->getSidangTerakhir($idperkara);
		 $data['tglPersidangan'] = $this->input->post('tglPersidangan',TRUE);
        $this->load->model('generate_template/m_template_ambil_identitas_template','template2');        
        $data['template']=$this->template2->getDataDocumentTemplate('15','14','200','1',''); 
        $this->load->view('generate_template/peradilan_agama/cetak_bas_pertama_agama',$data,FALSE);
    }
    function cetak_bas_lanjutan_agama(){  
        if($this->session->userdata('is_logged_in')==FALSE){
        redirect('login'); }

        $data['enc']=$this->input->post('enc',TRUE);
		$idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }    
        $data['encjadwalsidang'] = $this->input->post('encjadwalsidang',TRUE);
        $idjadwal=$this->encrypt->decode(base64_decode($data['encjadwalsidang']));
        if(!is_numeric($idjadwal) OR !intval($idjadwal)>0){
             show_404();
             exit();
        }
        $data['tglPersidangan'] = $this->input->post('tglPersidangan',TRUE);
        $data['blangko_bas_lanjutan_agama'] = $this->input->post('blangko_bas_lanjutan_agama',TRUE);
        
        $this->load->model('jadwalsidang/jadwal_sidang_m','template');
		$data['dataPihak1']=$this->template->get_data_pihak_loop($idperkara,1);
        $data['dataPihak2']=$this->template->get_data_pihak_loop($idperkara,2);
		
        $data['dataperkara'] = $this->template->getDataPerkara($idperkara);
        $data['datapengadilan'] = $this->template->getDataPA();
        $data['datapenetapanpanitera']=$this->template->getDataPenetapanPanitera($idperkara);
        $data['datapenetapanhakim']=$this->template->getDataPenetapanHakim($idperkara);
        $data['datapaniterapengganti']=$this->template->getDataPP($idperkara);
         $data['listSidang'] = $this->template->getTanggalPersidangan($idjadwal);
		 $data['dataamar']=$this->template->getAmar($idperkara);
		 $data['datapersidangan']=$this->template->getSidangTerakhir($idperkara);
		 $data['tanggalmediasi']=$this->template->getMediasiTerakhir($idperkara);
         $data['datamediator']=$this->template->getMeditor($idperkara);
        $this->load->model('generate_template/m_template_ambil_identitas_template','template2');        
        $data['template']=$this->template2->getDataDocumentTemplate('15','14','200','1',''); 
        $this->load->view('generate_template/peradilan_agama/cetak_bas_lanjutan_agama',$data,FALSE);
    }
function popup_bas_lanjutan(){
        if($this->session->userdata('is_logged_in')==FALSE){
            redirect('login');
        }  
        $data['enc']=$this->uri->segment('3');
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }
        $data['encjadwalsidang']=$this->uri->segment('4');
        $idjadwal=$this->encrypt->decode(base64_decode($data['encjadwalsidang']));        
        if(!is_numeric($idjadwal) OR !intval($idjadwal)>0){
            show_404();
            exit();
        }
    

		$this->load->model('generate_template/m_template_perdata_relaas','template');				
		$data['jenisPihakText'] = 'Penggugat';
        $data['blangko_bas_lanjutan_agama']=$this->template->blangko_bas_lanjutan_agama();
		$data['listPihak'] = $this->template->getListPihak($idperkara,1);
		$data['listJsp'] = $this->template->getListJurusita($idperkara);		
		$data['listKuasaHukum'] = $this->template->getKuasaHukum($idperkara,1);
		$data['listBiaya'] = $this->template->getBiayaPerkara($idperkara,12);
		$data['listPnbp'] = $this->template->getBiayaPerkara($idperkara,236);
        $data['listSidang'] = $this->template->getTanggalPersidangan($idjadwal);
        foreach ($data['listSidang']->result() as $row) {
            $data['tglsidang'] = $this->tanggalhelper->convertToInputDate($row->tanggal_sidang);
        }

        $this->load->model('generate_template/m_template_ambil_identitas_template','template2');		
        $template=$this->template2->getDataDocumentTemplate('1','14','200','101','');
		$i=0;
        foreach ($template->result() as $template)
        {
        	if ($i=='0')
        	{
            	$judul=$template->namatemplate;
                $judul=explode("Kepada",$judul);
                $jnsperkara=$template->jnsperkara;
			}
		}

		$data['judul']="BERITA ACARA SIDANG LANJUTAN"; //override
		$data['jnsperkara']=$jnsperkara;

		$this->load->view('generate_template/popup_berita_acara_lanjutan_agama',$data,FALSE);
	}
}