<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class c_template_putusan_pidana extends CI_Controller {

    function index() {
        if($this->session->userdata('is_logged_in')==FALSE){
            redirect('login');
        }  
     }

    function popup_putusan_pidana_format_biasa_bebas() {
        if($this->session->userdata('is_logged_in')==FALSE){
            redirect('login');
        }  
        $data['enc']=$this->uri->segment('3');
        $this->load->model('generate_template/m_template_ambil_identitas_template','template2');
        $data['template']=$this->template2->getDataDocumentTemplate('111','15','210','1','');
        $this->load->view('generate_template/popup_putusan_pidana_format_biasa_bebas', $data, FALSE);          
    }

	function cetak_putusan_pidana_format_biasa_bebas() {
        if($this->session->userdata('is_logged_in')==FALSE){
            redirect('login');
        }  
        $data['enc'] = $this->input->post('enc',TRUE);
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }   
		$data['jenisdakwaan']=$this->input->post('jenisDakwaan',TRUE);
        if(!is_numeric($data['jenisdakwaan']) OR !intval($data['jenisdakwaan'])>0){
            show_404();
            exit();
        }
		
		$this->load->model('generate_template/m_template_putusan_pidana','template');
        $data['jenisperkara']= $this->template->getJenisPerkara($idperkara);
        $data['datapengadilan']=$this->template->getDataPN();
        $data['dataperkara']=$this->template->getDataPerkara($idperkara);
        $data['datapenetapan']=$this->template->getDataPenetapan($idperkara);
        $data['datapenuntut']=$this->template->getDataPihakPenuntut($idperkara);
        $data['dataterdakwa']=$this->template->getDataTerdakwa($idperkara);
        $data['datapengacarapihak2']=$this->template->getDataPengacara($idperkara,2);
        $data['data_panitera'] = $this->template->getDataPanitera($idperkara);
        $data['data_hakim']=$this->template->getDataHakim($idperkara);
        $data['data_putusan'] = $this->template->getDataPutusan($idperkara);
        $data['data_putusan_sela'] = $this->template->getDataPutusanSela($idperkara);
        $data['datapenahanan'] = $this->template->getDataPenahananTerdakwa($idperkara);
        $data['data_pihak'] =$this->template->getDataPihak($idperkara);
        $data['data_tuntutan'] =$this->template->getDataTuntutan($idperkara)->row()->isi_penuntutan;
        $jenis_barang_bukti =$this->template->getDataBarangBukti($idperkara);

        if ($jenis_barang_bukti->num_rows > 0 ) {
	        foreach ($jenis_barang_bukti->result() as $row) {
	        	$data['data_jenis_barang_bukti']=$row->jenis_barang_bukti;
	        }
	    }else{
	    		$data['data_jenis_barang_bukti']='';
	    }
        
		
        $this->load->model('generate_template/m_template_ambil_identitas_template','template2');
		$data['template']=$this->template2->getDataDocumentTemplate('111','15','210','1','');
        $this->load->view('generate_template/cetak_putusan_pidana_format_biasa_bebas',$data,FALSE);
    }

    function popup_putusan_pidana_format_biasa_terbukti() {
        if($this->session->userdata('is_logged_in')==FALSE){
            redirect('login');
        }  

        $data['enc']=$this->uri->segment('3');
        $this->load->model('generate_template/m_template_ambil_identitas_template','template2');
        $data['template']=$this->template2->getDataDocumentTemplate('111','15','210','3','');
        $this->load->view('generate_template/popup_putusan_pidana_format_biasa_terbukti', $data, FALSE);          
    }

	function cetak_putusan_pidana_format_biasa_terbukti() {
        if($this->session->userdata('is_logged_in')==FALSE){
            redirect('login');
        }  
        $data['enc'] = $this->input->post('enc',TRUE);
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }
		$data['jenisdakwaan']=$this->input->post('jenisDakwaan',TRUE);
        if(!is_numeric($data['jenisdakwaan']) OR !intval($data['jenisdakwaan'])>0){
            show_404();
            exit();
        }

        $this->load->model('generate_template/m_template_putusan_pidana','template');
        $data['jenisperkara']= $this->template->getJenisPerkara($idperkara);
        $data['datapengadilan']=$this->template->getDataPN();
        $data['dataperkara']=$this->template->getDataPerkara($idperkara);
        $data['datapenetapan']=$this->template->getDataPenetapan($idperkara);
        $data['datapenuntut']=$this->template->getDataPihakPenuntut($idperkara);
        $data['dataterdakwa']=$this->template->getDataTerdakwa($idperkara);
        $data['datapengacarapihak2']=$this->template->getDataPengacara($idperkara,2);
        $data['data_panitera'] = $this->template->getDataPanitera($idperkara);
        $data['data_hakim']=$this->template->getDataHakim($idperkara);
        $data['data_putusan'] = $this->template->getDataPutusan($idperkara);
        $data['data_putusan_sela'] = $this->template->getDataPutusanSela($idperkara);
        $data['data_pihak'] =$this->template->getDataPihak($idperkara);
        $data['datapenahanan'] = $this->template->getDataPenahananTerdakwa($idperkara);

        $this->load->model('generate_template/m_template_ambil_identitas_template','template2');
        $data['template']=$this->template2->getDataDocumentTemplate('111','15','210','3','');
        $this->load->view('generate_template/cetak_putusan_pidana_format_biasa_terbukti',$data,FALSE);
    }     

    function popup_putusan_pidana_format_biasa_lepas() {
        if($this->session->userdata('is_logged_in')==FALSE){
            redirect('login');
        }  
        $data['enc']=$this->uri->segment('3');
        $this->load->model('generate_template/m_template_ambil_identitas_template','template2');
        $data['template']=$this->template2->getDataDocumentTemplate('111','15','210','5','');
        $this->load->view('generate_template/popup_putusan_pidana_format_biasa_lepas', $data, FALSE);          

    }

	function cetak_putusan_pidana_format_biasa_lepas() {
        if($this->session->userdata('is_logged_in')==FALSE){
            redirect('login');
        }  

        $data['enc'] = $this->input->post('enc',TRUE);
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }   
		$data['jenisdakwaan']=$this->input->post('jenisDakwaan',TRUE);
        if(!is_numeric($data['jenisdakwaan']) OR !intval($data['jenisdakwaan'])>0){
            show_404();
            exit();
        }

        $this->load->model('generate_template/m_template_putusan_pidana','template');
        $data['jenisperkara']= $this->template->getJenisPerkara($idperkara);
        $data['datapengadilan']=$this->template->getDataPN();
        $data['dataperkara']=$this->template->getDataPerkara($idperkara);
        $data['datapenetapan']=$this->template->getDataPenetapan($idperkara);
        $data['datapenuntut']=$this->template->getDataPihakPenuntut($idperkara);
        $data['dataterdakwa']=$this->template->getDataTerdakwa($idperkara);
        $data['datapengacarapihak2']=$this->template->getDataPengacara($idperkara,2);
        $data['data_panitera'] = $this->template->getDataPanitera($idperkara);
        $data['data_hakim']=$this->template->getDataHakim($idperkara);
        $data['data_putusan'] = $this->template->getDataPutusan($idperkara);
        $data['data_putusan_sela'] = $this->template->getDataPutusanSela($idperkara);
        $data['data_pihak'] =$this->template->getDataPihak($idperkara);
        $data['datapenahanan'] = $this->template->getDataPenahananTerdakwa($idperkara);

        $this->load->model('generate_template/m_template_ambil_identitas_template','template2');
        $data['template']=$this->template2->getDataDocumentTemplate('111','15','210','5','');
        $this->load->view('generate_template/cetak_putusan_pidana_format_biasa_lepas',$data,FALSE);
    } 

    function cetak_putusan_pidana_penuntutan_tidak_diterima(){
        if($this->session->userdata('is_logged_in')==FALSE){
            redirect('login');
        }  
        $data['enc']=$this->uri->segment('3');
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }   
        $this->load->model('generate_template/m_template_putusan_pidana','template');
        $data['data_panitera']=$this->template->getDataPanitera($idperkara);
        $data['data_hakim']=$this->template->getDataHakim($idperkara);
        $data['data_putusan']=$this->template->getDataPutusan($idperkara);
        $data['data_perkara'] = $this->template->getDataPerkara($idperkara);
        $data['jenis_perkara'] = $this->template->getJenisPerkara($idperkara);
        $data['data_pengadilan'] = $this->template->getDataPN();
        $data['data_penetapan'] = $this->template->getDataPenetapan($idperkara);
        $data['data_penuntut'] = $this->template->getDataPihakPenuntut($idperkara);
        $data['data_pengacarapihak2'] = $this->template->getDataPengacara($idperkara,'2');
        $data['data_jadwal_sidang'] = $this->template->getDataJadwalSidang($idperkara);
        $data['data_terdakwa'] = $this->template->getDataTerdakwa($idperkara);
        $data['data_penahanan'] = $this->template->getDataPenahananTerdakwa($idperkara);
        $data['data_panitera'] = $this->template->getDataPanitera($idperkara);
        $data['data_pihak'] = $this->template->getDataPihak($idperkara);

        $this->load->model('generate_template/m_template_ambil_identitas_template','template2');
        $data['template']=$this->template2->getDataDocumentTemplate('111','15','210','10','');
        $this->load->view('generate_template/cetak_putusan_pidana_format_penuntutan_penuntut_umum_tidak_dapat_diterima',$data,FALSE);
    }

    function popup_putusan_pidana_anak_format_biasa_terbukti() {
        if($this->session->userdata('is_logged_in')==FALSE){
            redirect('login');
        }  
        $data['enc']=$this->uri->segment('3');
        $this->load->model('generate_template/m_template_ambil_identitas_template','template2');
        $data['template']=$this->template2->getDataDocumentTemplate('118','15','210','4','');
        $this->load->view('generate_template/popup_putusan_pidana_anak_format_biasa_terbukti', $data, FALSE);          

    }

   function cetak_putusan_pidana_anak_format_biasa_terbukti() {
        if($this->session->userdata('is_logged_in')==FALSE){
            redirect('login');
        }  

        $data['enc'] = $this->input->post('enc',TRUE);
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }   
		$data['jenisdakwaan']=$this->input->post('jenisDakwaan',TRUE);
        if(!is_numeric($data['jenisdakwaan']) OR !intval($data['jenisdakwaan'])>0){
            show_404();
            exit();
        }
        
        $this->load->model('generate_template/m_template_putusan_pidana','template');
        $data['jenisperkara']= $this->template->getJenisPerkara($idperkara);
        $data['datapengadilan']=$this->template->getDataPN();
        $data['dataperkara']=$this->template->getDataPerkara($idperkara);
        $data['datapenetapan']=$this->template->getDataPenetapan($idperkara);
        $data['datapenuntut']=$this->template->getDataPihakPenuntut($idperkara);
        $data['dataterdakwa']=$this->template->getDataTerdakwa($idperkara);
        $data['datapengacarapihak2']=$this->template->getDataPengacara($idperkara,2);
        $data['data_panitera'] = $this->template->getDataPanitera($idperkara);
        $data['data_hakim']=$this->template->getDataHakim($idperkara);
        $data['data_putusan'] = $this->template->getDataPutusan($idperkara);
        $data['data_putusan_sela'] = $this->template->getDataPutusanSela($idperkara);
        $data['datapenahanan'] = $this->template->getDataPenahananTerdakwa($idperkara);

        $this->load->model('generate_template/m_template_ambil_identitas_template','template2');
        $data['template']=$this->template2->getDataDocumentTemplate('118','15','210','4','');
        $this->load->view('generate_template/cetak_putusan_pidana_anak_format_biasa_terbukti',$data,FALSE);
    } 

    function cetak_putusan_sela_keberatan_bersama_putusan_akhir() {
        if($this->session->userdata('is_logged_in')==FALSE){
            redirect('login');
        }  
        $data['enc']=$this->uri->segment('3');
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }   
        $this->load->model('generate_template/m_template_putusan_pidana','template');
        $data['jenisperkara']= $this->template->getJenisPerkara($idperkara);
        $data['datapengadilan']=$this->template->getDataPN();
        $data['dataperkara']=$this->template->getDataPerkara($idperkara);
        $data['datapenetapan']=$this->template->getDataPenetapan($idperkara);
        $data['datapenuntut']=$this->template->getDataPihakPenuntut($idperkara);
        $data['dataterdakwa']=$this->template->getDataTerdakwa($idperkara);
        $data['datapengacarapihak2']=$this->template->getDataPengacara($idperkara,2);
        $data['data_panitera'] = $this->template->getDataPanitera($idperkara);
        $data['data_hakim']=$this->template->getDataHakim($idperkara);
        $data['data_putusan'] = $this->template->getDataPutusan($idperkara);
        $data['data_putusan_sela'] = $this->template->getDataPutusanSela($idperkara);
        $data['data_pihak'] =$this->template->getDataPihak($idperkara);
        $data['datapenahanan'] = $this->template->getDataPenahananTerdakwa($idperkara);

        $this->load->model('generate_template/m_template_ambil_identitas_template','template2');
        $data['template']=$this->template2->getDataDocumentTemplate('111','15','210','7','');
        $this->load->view('generate_template/cetak_putusan_sela_keberatan_bersama_putusan_akhir',$data,FALSE);
    }  

    function cetak_putusan_sela_keberatan_diterima(){
        if($this->session->userdata('is_logged_in')==FALSE){
            redirect('login');
        }  
        $data['enc']=$this->uri->segment('3');
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }   

        $this->load->model('generate_template/m_template_putusan_pidana','template');
        $data['jenisperkara']= $this->template->getJenisPerkara($idperkara);
        $data['datapengadilan']=$this->template->getDataPN();
        $data['dataperkara']=$this->template->getDataPerkara($idperkara);
        $data['datapenetapan']=$this->template->getDataPenetapan($idperkara);
        $data['datapenuntut']=$this->template->getDataPihakPenuntut($idperkara);
        $data['dataterdakwa']=$this->template->getDataTerdakwa($idperkara);
        $data['datapengacarapihak2']=$this->template->getDataPengacara($idperkara,2);
        $data['data_panitera'] = $this->template->getDataPanitera($idperkara);
        $data['data_hakim']=$this->template->getDataHakim($idperkara);
        $data['data_putusan'] = $this->template->getDataPutusan($idperkara);
        $data['data_putusan_sela'] = $this->template->getDataPutusanSela($idperkara);
        $data['data_pihak'] =$this->template->getDataPihak($idperkara);
        $data['datapenahanan'] = $this->template->getDataPenahananTerdakwa($idperkara);

        $this->load->model('generate_template/m_template_ambil_identitas_template','template2');
        $data['template']=$this->template2->getDataDocumentTemplate('111','15','210','8','');
        $this->load->view('generate_template/cetak_putusan_sela_keberatan_diterima',$data,FALSE);
    }

    function cetak_putusan_sela_keberatan_tidak_diterima(){
        if($this->session->userdata('is_logged_in')==FALSE){
            redirect('login');
        }  
        $data['enc']=$this->uri->segment('3');
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }
        $this->load->model('generate_template/m_template_putusan_pidana','template');
        $data['jenisperkara']= $this->template->getJenisPerkara($idperkara);
        $data['datapengadilan']=$this->template->getDataPN();
        $data['dataperkara']=$this->template->getDataPerkara($idperkara);
        $data['datapenetapan']=$this->template->getDataPenetapan($idperkara);
        $data['datapenuntut']=$this->template->getDataPihakPenuntut($idperkara);
        $data['dataterdakwa']=$this->template->getDataTerdakwa($idperkara);
        $data['datapengacarapihak2']=$this->template->getDataPengacara($idperkara,2);
        $data['data_panitera'] = $this->template->getDataPanitera($idperkara);
        $data['data_hakim']=$this->template->getDataHakim($idperkara);
        $data['data_putusan'] = $this->template->getDataPutusan($idperkara);
        $data['data_putusan_sela'] = $this->template->getDataPutusanSela($idperkara);
        $data['data_pihak'] =$this->template->getDataPihak($idperkara);
        $data['datapenahanan'] = $this->template->getDataPenahananTerdakwa($idperkara);
        $this->load->model('generate_template/m_template_ambil_identitas_template','template2');
        $data['template']=$this->template2->getDataDocumentTemplate('111','15','210','9','');
        $this->load->view('generate_template/cetak_putusan_sela_keberatan_tidak_diterima',$data,FALSE);
    }

    function popup_penetapan_penghentian_pemeriksaan_pengalihan_acara() {
        if($this->session->userdata('is_logged_in')==FALSE){  redirect('login'); }  
        $enc = $this->uri->segment('3');
        $idalurperkara = $this->tanggalhelper->getIDAlurPerkara($this->encrypt->decode(base64_decode($enc)));
        $perkara_id = $this->encrypt->decode(base64_decode($enc));
        
        $this->load->model('putusan/data_putusan','putusan');
        $query_jadwal_sidang = $this->putusan->get_jadwal_sidang_perkara($perkara_id);
        $tanggal = array();
        $tanggal['']= "Pilih";
        foreach ($query_jadwal_sidang->result() as $row){ 
            $tanggal[$row->tanggal_sidang] = $row->tanggal_sidang; 
        } 

        if($idalurperkara=='118'){
            $data['judul'] = "PENETAPAN PENGHENTIAN PEMERIKSAAN PENGALIHAN KE PERKARA BIASA";
        } else {
            $data['judul'] = "PENETAPAN PENGHENTIAN PEMERIKSAAN PENGALIHAN KE PERKARA ANAK";
        }

        $data['enc'] = $enc;
        $data['jadwal_sidang'] = $tanggal;

        $this->load->view('generate_template/popup_penetapan_penghentian_pemeriksaan_pengalihan_acara',$data);          
    }

    function cetak_penetapan_pengalihan_pemeriksaan() {      
        if($this->session->userdata('is_logged_in')==FALSE){ redirect('login'); }

        $segment = $this->uri->segment_array();
        $enc = $this->input->post('enc');
        $jadwal_sidang_bas = $this->input->post('jadwal_sidang');
        $idperkara=$this->encrypt->decode(base64_decode($enc));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }        

        $alur_perkara_id = $this->tanggalhelper->getIDAlurPerkara($idperkara);

        if($alur_perkara_id=='118'){
            $filenya = 'peradilan_umum/pidana/putusan_pidana/PENETAPAN_PENGALIHAN_PEMERIKSAAN_ANAK_KE_DEWASA.rtf';
        } else {
            $filenya = 'peradilan_umum/pidana/putusan_pidana/PENETAPAN_PENGALIHAN_PEMERIKSAAN_DEWASA_KE_ANAK.rtf';
        }

        $data_id=array(
                    'source_file'=>$filenya,
                    'perkara_id'=>$idperkara,
                    'jadwal_sidang_bas'=>$jadwal_sidang_bas);   
                            
        $this->load->model('generate_template/var_template','var_template');
        $this->var_template->kirim_variabel($data_id);  
    }

    function cetak_penetapan_penghentian_pemeriksaan(){
        if($this->session->userdata('is_logged_in')==FALSE){
            redirect('login');
        }  

        $data['enc']=$this->uri->segment('3');
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }   

        $filenya = 'peradilan_umum/pidana/putusan_pidana/PUT_PEN_PENGHENTIAN_PEMERIKSAAN_PERKARA.rtf';
        $data_id= array(
                    'source_file'=>$filenya,
                    'perkara_id'=>$idperkara
                    );   
                            
        $this->load->model('generate_template/var_template','var_template');
        $this->var_template->kirim_variabel($data_id);

    }
}
?>