<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class c_template_diversi extends CI_Controller {

    function index() {
        if($this->session->userdata('is_logged_in')==FALSE){
        redirect('login'); 
        }
    }           

    function cetak_kesepakatan_diversi(){
        if($this->session->userdata('is_logged_in')==FALSE){
        redirect('login'); }

        $data['enc']=$this->uri->segment('3');
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }
       
        $filenya = 'peradilan_umum/pidana/diversi/KESEPAKATAN_DIVERSI.rtf';       

        $data_id=array(
                    'source_file'=>$filenya,
                    'perkara_id'=>$idperkara);   
                            
        $this->load->model('generate_template/var_template','var_template');
        $this->var_template->kirim_variabel($data_id);
    }    

    function cetak_ba_diversi(){
        if($this->session->userdata('is_logged_in')==FALSE){
        redirect('login'); }
                
        $idperkara=$this->encrypt->decode(base64_decode($this->uri->segment('3')));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }               
        $jenis_bas = $this->uri->segment('4');      
        $alur_perkara_id = $this->tanggalhelper->getIDAlurPerkara($idperkara);
                
        if($jenis_bas==3){            
            $filenya = 'peradilan_umum/pidana/berita_acara/BA_PIHAK_TIDAK_SEPAKAT_DIVERSI.rtf';
        }
        $data_id=array(
                    'source_file'=>$filenya,
                    'perkara_id'=>$idperkara); 
                           
        $this->load->model('generate_template/var_template');                           
        $this->var_template->kirim_variabel($data_id);

    }

    function popup_jenis_ba_diversi(){
        if($this->session->userdata('is_logged_in')==FALSE){
        redirect('login'); }
        
        $data['enc']=$this->uri->segment('3');
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }
        $this->load->model('generate_template/m_template_berita_acara','template');        
        $perkara = $this->template->data_perkara($idperkara)->result();        
        $data['nomor_perkara'] = $perkara[0]->nomor_perkara;
        
        $data['judul']="Berita Acara Diversi";        
        $this->load->view('generate_template/umum/berita_acara/popup_berita_acara_diversi',$data);
    }

    function cetak_ba_diversi_lanjutan(){
        if($this->session->userdata('is_logged_in')==FALSE){
        redirect('login'); }
                
        $idperkara=$this->encrypt->decode(base64_decode($this->input->post('enc',TRUE)));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }               
        $jenis_bas = $this->input->post('jenis_ba',TRUE);                      
        if($jenis_bas==1){            
            $filenya = 'peradilan_umum/pidana/berita_acara/BA_DIVERSI_MENCAPAI_KESEPAKATAN.rtf';
        }
        elseif($jenis_bas==2){            
            $filenya = 'peradilan_umum/pidana/berita_acara/BA_DIVERSI_TIDAK_MENCAPAI_KESEPAKATAN.rtf';
        }
       
        $data_id=array(
                    'source_file'=>$filenya,
                    'perkara_id'=>$idperkara); 
                           
        $this->load->model('generate_template/var_template');                           
        $this->var_template->kirim_variabel($data_id);

    }

    function popup_penetapan_kpn(){
        if($this->session->userdata('is_logged_in')==FALSE){
            redirect('login'); 
        }        
        $data['enc_register'] = $this->uri->segment('3'); 
        $data['judul']= 'PENETAPAN KPN <br>TERHADAP KEPUTUSAN PENYIDIK';
        $this->load->model('diversi/register_diversi_blm_12tahun_m','template');
        $register = $this->template->get_data_register($this->encrypt->decode(base64_decode($data['enc_register'])))->result();       
        $data['nomor_penetapan'] = !empty($register)?$register[0]->nomor_penetapan:''; 
        $this->load->model('generate_template/m_template_penetapan','template1');
        $data['penandatangan']=$this->template1->getDataPN();
        $data['enc_pemohon'] = base64_encode($this->encrypt->encode(4));//digunakan sama function  popup_penetapan_ketua()         
        $data['asal'] = 1;//pembeda dgn function popup_penetapan_ketua()        
        $this->load->view('generate_template/umum/penetapan/popup_penetapan_kpn_12', $data, FALSE);       
        
    }

    function cetak_penetapan_kpn_penyidik_12(){          
        if($this->session->userdata('is_logged_in')==FALSE){
        redirect('login'); }

        $id_register = $this->encrypt->decode(base64_decode($this->input->post('enc_register',TRUE)));
        if(!is_numeric($id_register) OR !intval($id_register)>0){
            show_404();
            exit();
        }
               
        $data['ditetapkanoleh'] = $this->input->post('ditetapkanoleh',TRUE);
        if(!is_numeric($data['ditetapkanoleh']) OR !intval($data['ditetapkanoleh'])>0){
            show_404();
            exit();
        }           
        if($data['ditetapkanoleh']==-1){
            echo json_encode(array('st'=>0,'msg'=>'Error:<br />Pembuat Penetapan Belum Terpilih.'));
            return;
        }

        $this->load->model('diversi/register_diversi_blm_12tahun_m','template');
        $data['data_anak'] = $this->template->get_data_anak($id_register);
        $data['data_register'] = $this->template->get_data_register($id_register); 
        $this->load->model('generate_template/m_template_penetapan','template1');
        $data['datapengadilan'] = $this->template1->getDataPN();       
        
        $this->load->view('generate_template/umum/penetapan/cetak_penetapan_kpn_12_tahun',$data,FALSE);
    }

    function popup_penetapan_ketua(){
        if($this->session->userdata('is_logged_in')==FALSE){
            redirect('login'); 
        }

        $data['enc_register'] = $this->uri->segment('3'); 
        $data['enc_pemohon'] = $this->uri->segment('4'); 
        $data['enc_perkara'] = $this->uri->segment('5');
        $id_pemohon = $this->encrypt->decode(base64_decode($this->uri->segment('4')));
        if($id_pemohon==1){
            $data['judul']= 'PENETAPAN KPN DIVERSI BERHASIL<br>DI TINGKAT PENYIDIK';
        }elseif($id_pemohon==2){
            $data['judul']= 'PENETAPAN KPN DIVERSI BERHASIL<br>DI TINGKAT PENUNTUT';
        }elseif($id_pemohon==3){
            $data['judul']= 'PENETAPAN DIVERSI KPN  <br>DI TINGKAT PENGADILAN';
        }        
        $this->load->model('diversi/register_diversi','template');
        $register = $this->template->get_detil_diversi($this->encrypt->decode(base64_decode($data['enc_register'])))->result();       
        $data['nomor_penetapan'] = !empty($register)?$register[0]->no_diversi:''; 
        $this->load->model('generate_template/m_template_penetapan','template1');
        $data['penandatangan']=$this->template1->getDataPN();          
        $data['asal'] = 2;        
        $this->load->view('generate_template/umum/penetapan/popup_penetapan_kpn_12', $data, FALSE);       
        
    }

    function cetak_penetapan_kpn_diversi(){          
        if($this->session->userdata('is_logged_in')==FALSE){
        redirect('login'); }

        $id_register = $this->encrypt->decode(base64_decode($this->input->post('enc_register',TRUE)));
        if(!is_numeric($id_register) OR !intval($id_register)>0){
            show_404();
            exit();
        }
               
        $data['id_pemohon'] = $this->encrypt->decode(base64_decode($this->input->post('enc_pemohon',TRUE)));
        if(!is_numeric($data['id_pemohon']) OR !intval($data['id_pemohon'])>0){
            show_404();
            exit();
        }                 
        $data['ditetapkanoleh'] = $this->input->post('ditetapkanoleh',TRUE);
        if(!is_numeric($data['ditetapkanoleh']) OR !intval($data['ditetapkanoleh'])>0){
            show_404();
            exit();
        }
        if($data['ditetapkanoleh']==-1){
            echo json_encode(array('st'=>0,'msg'=>'Error:<br />Pembuat Penetapan Belum Terpilih.'));
            return;
        }

        $this->load->model('diversi/register_diversi','template');
        $data['detil_diversi'] = $this->template->get_detil_diversi($id_register);
        if($data['id_pemohon']==1 OR $data['id_pemohon']==2){
        	$data['data_anak'] = $this->template->pihak_anak_orang_tua($id_register); 
        }elseif($data['id_pemohon']==3){
            $perkara_id = $this->encrypt->decode(base64_decode($this->input->post('enc_perkara',TRUE)));
            if(!is_numeric($perkara_id) OR !intval($perkara_id)>0){
                show_404();
                exit();
            }
        	$data['data_anak'] = $this->template->anak_berhadapan_dgn_hukum($perkara_id);            
        }
        // print_r($data['data_anak']->result());exit();        
        $this->load->model('generate_template/m_template_penetapan','template1');
        $data['datapengadilan'] = $this->template1->getDataPN();       
        
        $this->load->view('generate_template/umum/penetapan/cetak_penetapan_diversi_kpn',$data,FALSE);
    }

    function cetak_laporan_diversi(){
        if($this->session->userdata('is_logged_in')==FALSE){
        redirect('login'); }

        $data['enc']=$this->uri->segment('3');
        $idperkara=$this->encrypt->decode(base64_decode($data['enc']));
        if(!is_numeric($idperkara) OR !intval($idperkara)>0){
            show_404();
            exit();
        }
       
        $filenya = 'peradilan_umum/pidana/diversi/LAP_DIVERSI_TDK_MENCAPAI_KESEPAKATAN.rtf';       

        $data_id=array(
                    'source_file'=>$filenya,
                    'perkara_id'=>$idperkara);   
                            
        $this->load->model('generate_template/var_template','var_template');
        $this->var_template->kirim_variabel($data_id);
    }
        

}
?>